package clinical.storage.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

import clinical.storage.IPlugin;
import clinical.storage.StorageUtils;
import clinical.storage.plugins.gridftp.GridFtpClient;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.download.FileInfo;
import clinical.web.download.PathWrapper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: GridFTPPlugin.java 591 2012-04-28 20:54:39Z jinranc $
 */
public class GridFTPPlugin implements IPlugin {
	String cacheDir;
	GridFtpClient gfc;
	GSSCredential credential;
	private Log log = LogFactory.getLog(GridFTPPlugin.class);

	public GridFTPPlugin(Map<String, Object> paramMap) {
		cacheDir = (String) paramMap.get("cacheDir");
		Assertion.assertNotNull(cacheDir);
		Assertion.assertTrue(new File(cacheDir).exists());
		String myproxyHost = (String) paramMap.get("myproxy.host");
		String masterSiteGridFtpHost = (String) paramMap
				.get("master.site.gridftp.host");
		String rlsURL = (String) paramMap.get("rls.url");
		int gridFtpPort = GenUtils.toInt((String) paramMap.get("gridftp.port"),
				2811);
		int myproxyPort = GenUtils.toInt((String) paramMap.get("myproxy.port"),
				7512);
		credential = (GSSCredential) paramMap.get("credential");
		
		try {
			System.out.println("********* credential remaining lifetime:" + credential.getRemainingLifetime());
		} catch (GSSException e) {
			//TODO
			e.printStackTrace();
		}

		gfc = new GridFtpClient(masterSiteGridFtpHost, myproxyHost, rlsURL,
				myproxyPort, gridFtpPort);
	}

	@Override
	public List<PathWrapper> load(FileInfo fi) throws Exception {
		List<PathWrapper> gftpFiles = new ArrayList<PathWrapper>();
		if (fi.isDir()) {
			File dir = FileInfo.getFullPathFile(fi, fi.getSourceRootDir());
			String dirPath = dir.getAbsolutePath();

			FileInfo nfi = new FileInfo(dirPath, fi.getFileType(), fi
					.getStorageType(), fi.getSourceRootDir(), false);

			String relDirPath = nfi.getRelativePath();
			String localPath = FileUtils.createFullPath(cacheDir, relDirPath);
			new File(localPath).mkdirs();

			log.info("**** from GridFTP '" + fi.getPath() + "' \nto '" + localPath + "'");
			log.info("DYW* from GridFTP getGridFtpHosit=" + fi.getGridFtpHost());
			this.gfc.downloadFolder(fi.getGridFtpHost() + dir.getAbsolutePath(), new File(localPath),
					true);
			File localDir = new File(FileUtils
					.createFullPath(cacheDir, relDirPath));
			File[] localFilePaths = localDir.listFiles();
			for (int i = 0; i < localFilePaths.length; i++) {
				if (localFilePaths[i].isFile()) {
					String filePath = localFilePaths[i].getAbsolutePath();
					if (filePath.startsWith(cacheDir)) {
						filePath = filePath.substring(cacheDir.length());
						filePath = filePath.replaceFirst("^\\/+", "");
					}
					gftpFiles.add(new PathWrapper(filePath, nfi.getSourceRootDir()));
				} else {
					StorageUtils.recurseDir(gftpFiles, localFilePaths[i], cacheDir,
							nfi.getSourceRootDir());
				}
			}

		} else {
			String relPath = fi.getRelativePath();
			if (FileUtils.buildLocalPath(cacheDir, relPath)) {
				String localPath = FileUtils.createFullPath(cacheDir, relPath);
				log.info("**** from GridFTP '" + fi.getPath() + "' \nto '"
						+ localPath + "'");
				this.gfc.downloadFile(fi.getGridFtpHost() + fi.getPath(), new File(localPath), true);
				gftpFiles.add(new PathWrapper(relPath, cacheDir));
			}

		}
		return gftpFiles;
	}

	@Override
	public void shutdown() {
		if (gfc != null)
			gfc.shutdown();
	}

	@Override
	public void startup() throws Exception {
		gfc.connect(credential);
	}

	public static String getSupportedType() {
		return "gridftp";
	}

	@Override
	public boolean isSupported(String storageType) {
		if (storageType == null)
			return false;
		return storageType.equalsIgnoreCase("gridftp");
	}

	@Override
	public void put(FileInfo localFi, FileInfo remoteFi) throws Exception {
		if (!remoteFi.isDir()) {
			File rf = new File(remoteFi.getPath());
			this.gfc.putFile(new File(localFi.getPath()), rf.getParent(), gfc
					.getMasterSiteGridFTPHost());
		} else {
			throw new Exception("target is not a file!:" + remoteFi.getPath());
		}
	}

}
