package clinical.tools.dbadmin;

import guilib.common.BaseDialog;
import guilib.common.FileNameValueField;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

import clinical.tools.dbadmin.GridFtpClient.FileInfoWrapper;
import clinical.utils.FileUtils;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DOAdminPanel.java 152 2010-01-26 00:27:26Z bozyurt $
 */
public class DOAdminPanel extends JPanel implements ActionListener,
		PropertyChangeListener {
	private static final long serialVersionUID = 1L;
	JList uniqFileNameList;
	FileNameValueField localRootDirField;
	// data object types to assign
	JComboBox dotCB;
	AdminController ac;
	PropertyChangeSupport pcs;
	JButton activateButton = new JButton("Find Unique File/Directory Names");
	JButton applyButton = new JButton("Register");
	JButton helpButton = new JButton("Help");
	DefaultComboBoxModel cbModel;
	DefaultListModel listModel;
	Frame owner;
	Map<String, Map<String, Object>> objectTypeMap = new HashMap<String, Map<String, Object>>(
			37);
	Map<String, Long> rawDataMap = new HashMap<String, Long>();
	List<Map<String, Object>> addedDORows = new ArrayList<Map<String, Object>>();

	public DOAdminPanel(AdminController ac, Frame owner) {
		this.ac = ac;
		this.owner = owner;
		pcs = new PropertyChangeSupport(this);
		setLayout(new BorderLayout(5, 5));
		setBorder(BorderFactory
				.createTitledBorder("Assign Data Types to Raw Data"));
		activateButton.addActionListener(this);
		applyButton.addActionListener(this);
		helpButton.addActionListener(this);
		applyButton.setEnabled(false);
		cbModel = new DefaultComboBoxModel();
		dotCB = new JComboBox(cbModel);
		listModel = new DefaultListModel();
		uniqFileNameList = new JList(listModel);
		uniqFileNameList.setVisibleRowCount(5);
		localRootDirField = new FileNameValueField(
				"Local Experiment Root Directory: ", 40,
				FileNameValueField.DIR_ONLY);
		JScrollPane listScroller = new JScrollPane(uniqFileNameList);
		listScroller.setPreferredSize(new Dimension(150, 80));

		JPanel controlPanel = new JPanel();
		BoxLayout bl = new BoxLayout(controlPanel, BoxLayout.X_AXIS);
		controlPanel.setLayout(bl);
		controlPanel.add(Box.createHorizontalGlue());
		controlPanel.add(activateButton);
		controlPanel.add(Box.createHorizontalStrut(5));
		controlPanel.add(applyButton);
		controlPanel.add(Box.createHorizontalStrut(5));
		controlPanel.add(helpButton);
		controlPanel.add(Box.createHorizontalStrut(5));

		JPanel p = new JPanel();
		bl = new BoxLayout(p, BoxLayout.Y_AXIS);
		p.setLayout(bl);
		p.add(prepFieldPanel("Object Type:", dotCB));
		p.add(Box.createVerticalStrut(15));
		p.add(prepFieldPanel("File types:", listScroller));
		p.add(Box.createVerticalGlue());

		add(p, BorderLayout.NORTH);
		add(controlPanel, BorderLayout.SOUTH);
	}

	JPanel prepFieldPanel(String label, JComponent comp) {
		JPanel p = new JPanel(new GridLayout(1, 2, 5, 5));
		p.add(new JLabel(label, JLabel.RIGHT));
		p.add(comp);
		return p;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		if (e.getSource() == activateButton) {
			List<Map<String, Object>> list = ac.find("Rawdata");
			Set<String> uniqFileSet = new HashSet<String>();
			for (Map<String, Object> row : list) {
				String datauri = (String) row.get("datauri");
				if (datauri != null) {
					String[] toks = datauri.split("\\/+");
					uniqFileSet.add(toks[toks.length - 1]);
					rawDataMap.put(datauri, (Long) row.get("uniqueid"));
				}
			}
			listModel.clear();
			List<String> ufl = new ArrayList<String>(uniqFileSet);
			Collections.sort(ufl, new Comparator<String>() {
				public int compare(String o1, String o2) {
					boolean upper1 = Character.isUpperCase(o1.charAt(0))
							&& o1.indexOf('.') == -1;
					boolean upper2 = Character.isUpperCase(o2.charAt(0))
							&& o2.indexOf('.') == -1;
					if (upper1 && upper2) {
						return o1.compareTo(o2);
					} else if (!upper1 && !upper2) {
						return o1.compareTo(o2);
					} else if (upper1 && !upper2) {
						return -1;
					} else {
						return 1;
					}
				}

			});
			for (String fn : ufl) {
				listModel.addElement(fn);
			}

			cbModel.removeAllElements();
			list = ac.find("DataObjectType");
			for (Map<String, Object> row : list) {
				String dot = (String) row.get("objecttype");
				if (dot != null && dot.startsWith("3_")) {					
					cbModel.addElement(dot);
					objectTypeMap.put(dot, row);
				}
			}
			applyButton.setEnabled(true);
		}

		if (e.getSource() == applyButton) {
			Object[] selectedValues = uniqFileNameList.getSelectedValues();
			String selObjectType = (String) this.dotCB.getSelectedItem();
			Map<String, Object> dotRow = objectTypeMap.get(selObjectType);
			try {
				handleApply(selectedValues, dotRow);
			} catch (Exception e1) {

				e1.printStackTrace();
			}
		}

		if (e.getSource() == helpButton) {
			HelpDialog dlg = new HelpDialog(owner, "Help", helpText);
			dlg.showDialog();
			dlg.dispose();
		}
	}

	void handleApply(Object[] selectedUniqFilenames, Map<String, Object> dotRow)
			throws Exception {
		String storageType = getStorageType((String) dotRow.get("objecttype"));

		GridFtpClient client = null;
		if (storageType.equals("gridftp")) {
			GridFtpLoginDialog dlg = new GridFtpLoginDialog(this.owner,
					"GridFTP Login", ac.getState().getGridFtpStateMap());
			int rc = dlg.showDialog();
			if (rc == BaseDialog.OK_PRESSED) {
				client = new GridFtpClient(dlg.getGridFtpHost(), dlg
						.getMyProxyHost());
				client.connect(dlg.getUsername(), dlg.getPwd());
			} else {
				return;
			}
		} else if (storageType.equals("local")) {
			askForLocalRootDir();
			return;
		}
		Set<Long> dataIdSet = new HashSet<Long>();
		try {
			for (String dataUri : rawDataMap.keySet()) {
				for (Object o : selectedUniqFilenames) {
					String sufn = (String) o;
					if (dataUri.endsWith(sufn)) {
						List<Map<String, Object>> doRow = ac.find("DataObject",
								"where dataid = " + rawDataMap.get(dataUri));
						if (doRow == null || doRow.isEmpty()) {
							dataIdSet.add(rawDataMap.get(dataUri));
							Map<String, Object> argMap = new HashMap<String, Object>(
									17);
							argMap.put("dataid", rawDataMap.get(dataUri));
							argMap.put("objecttypeid", dotRow.get("uniqueid"));
							// long fileSize = ac.getSizeFromSRB(dataUri);

							long fileSize = getSize(storageType, client, dataUri);
							if (fileSize < 0) {
								System.err.println("Skipping " + dataUri);
								continue;
							}
							argMap.put("objectsize", new Long(fileSize));

							argMap = Utils.prepArgMap(argMap, true);
							System.out.println("datauri:" + dataUri);
							System.out.println("dataobject:" + argMap);
							System.out.println("===========================");
							ac.addUpdate("DataObject", argMap);
						}
					}
				}
			}
		} finally {
			if (client != null)
				client.shutdown();
		}
		addedDORows.clear();
		List<Map<String, Object>> doRows = ac.find("DataObject");
		for (Map<String, Object> row : doRows) {
			if (dataIdSet.contains(row.get("dataid"))) {
				addedDORows.add(row);
			}
		}
		pcs.firePropertyChange("updateDO", false, true);
	}

	protected boolean askForLocalRootDir() {
		int rc = JOptionPane.showConfirmDialog(this, localRootDirField,
				"Provide Local Project/Experiment Root Directory",
				JOptionPane.OK_CANCEL_OPTION);
		return rc == JOptionPane.OK_OPTION;
	}

	public long getSize(String storageType, GridFtpClient client, String dataUri)
			throws Exception {
		if (storageType.equals("srb")) {
			ac.getSizeFromSRB(dataUri);
		} else if (storageType.equals("gridftp")) {
			try {
				List<FileInfoWrapper> fiwList = client.getFiles(dataUri);
				long totSize = 0;
				for (FileInfoWrapper fiw : fiwList) {
					if (fiw.getFi().isFile()) {
						totSize += fiw.getFi().getSize();
					}
				}
				return totSize;
			} catch (Exception x) {
				return -1;
			}
		} else if (storageType.equals("local")) {
			String localRootDir = this.localRootDirField.getValue();
			return FileUtils.getTotalSizeUnderDir(dataUri, localRootDir);
		}
		throw new RuntimeException("Unsupported storage type:" + storageType);
	}

	protected String getStorageType(String objectType) {
		String[] toks = objectType.split("\\s+");
		int idx = toks[0].indexOf('_');
		String value = toks[0].substring(idx + 1);
		if (value.equalsIgnoreCase("srb")) {
			return "srb";
		} else if (value.equalsIgnoreCase("gftp")) {
			return "gridftp";
		} else if (value.equalsIgnoreCase("loc")) {
			return "local";
		}
		return null;
	}

	@Override
	public void propertyChange(PropertyChangeEvent evt) {

	}

	public void addPropertyChangeListener(PropertyChangeListener listener) {
		pcs.addPropertyChangeListener(listener);
	}

	public List<Map<String, Object>> getAddedDORows() {
		return addedDORows;
	}

	public static String helpText = "<html>"
			+ "Here, you can assign data types to raw data logical names in your HID.<p>"
			+ "This assigment is necessary to use HID web app download functionality.</p>"
			+ "First, you need to identify all unique filenames and directory names as<p>"
			+ "identified from logical names (pointers) in your HID.<p>"
			+ "This can be accomplished by clicking <b>Find Unique File/Directory Names</b> button.<p>"
			+ "This will take a while to complete and afterwards <b>Register</b> button will be activated.<p>"
			+ "To assign a data type to a file type or file types;<p>"
			+ "<ul><li>Select a file type or file types from <b>File Type</b> list. A range of file types<p>"
			+ " can be selected by pressing and holding <b>Shift</b> key while selecting.<p>"
			+ "Non-contiguous file types can be selected by pressing and holding"
			+ "<p><b>Control</b> key while selecting."
			+ "<li>Select the appropriate data type from the <b>Object Type</b> dropdown."
			+ "<p>Object type label syntax is;"
			+ "<pre> 3_&lt;STORAGE TYPE&gt; &lt;FILE/DIR INDICATOR&gt; &lt;FILE/DIR TYPE&gt;</pre>"
			+ "<p>The available storage types are;"
			+ "<ul><li>LOC - local file system based storage"
			+ "<li>GFTP - GRIDFTP storage"
			+ "<li>SRB - SRB storage</ul>"
			+ "Valid values for &lt;FILE/DIR INDICATOR&gt are;"
			+ "<ul><li>FILE - for individual file"
			+ "<li>COL - for a directory containing an assortment of files and/or "
			+ "<p>subdirectories of single file type</ul>"
			+ "<li>Press the <b>Register</b> button." + "</ul>"
			+ "After a succesfull registration the added database records "
			+ "will be shown in the table <p>at the bottom of the screen."
			+ "</html>";

}
