package clinical.tools.dbadmin;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class DOAdminView extends JPanel {
	private static final long serialVersionUID = 1L;
	AdminController ac;
	ListPanel lp;
	DOAdminPanel adminPanel;
	List<String> colNames;

	public DOAdminView(AdminController ac, Frame owner) {
		this.ac = ac;
		setLayout(new BorderLayout(5, 5));
		colNames = new ArrayList<String>(10);
		colNames.add("uniqueid");
		colNames.add("extensionname");
		colNames.add("dataid");
		colNames.add("objecttypeid");
		colNames.add("objectsize");
		List<Map<String, Object>> list = new ArrayList<Map<String, Object>>(0);
		lp = new ListPanel(colNames, list);
		adminPanel = new DOAdminPanel(ac, owner);
		lp.addPropertyChangeListener(adminPanel);
		// adminPanel.addPropertyChangeListener(this);
		JSplitPane sp = new JSplitPane(JSplitPane.VERTICAL_SPLIT, lp, adminPanel);
		sp.setOneTouchExpandable(true);
		sp.setDividerLocation(400);
		add(sp, BorderLayout.CENTER);
	}

}
