package clinical.tools.install;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.jdom.Comment;
import org.jdom.Element;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UsersFileInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class UsersFileInfo {
	List<DatabaseInfo> databases = new LinkedList<DatabaseInfo>();
	List<PrivilegeInfo> privileges = new LinkedList<PrivilegeInfo>();
	List<DBUserInfo> dbUsers = new LinkedList<DBUserInfo>();
	List<WebUserInfo> webUsers = new LinkedList<WebUserInfo>();

	public void addDatabase(DatabaseInfo dbInfo) {
		databases.add(dbInfo);
	}

	public void addDBUser(DBUserInfo dbUserInfo) {
		dbUsers.add(dbUserInfo);
	}

	public void addWebUser(WebUserInfo wuInfo) {
		webUsers.add(wuInfo);
	}

	public void addPrivilege(PrivilegeInfo pi) {
		privileges.add(pi);
	}

	public DatabaseInfo findDatabase(String dbID) {
		for (Iterator<DatabaseInfo> iter = databases.iterator(); iter
				.hasNext();) {
			DatabaseInfo dbi = iter.next();
			if (dbi.dbID.equals(dbID)) {
				return dbi;
			}
		}
		return null;
	}

	public WebUserInfo findWebUser(String webUserName, String dbID,
			String dbUser) {
		for (WebUserInfo wui : webUsers) {
			if (wui.name.equals(webUserName) && wui.dbID.equals(dbID)
					&& wui.dbID.equals(dbUser)) {
				return wui;
			}
		}
		return null;
	}

	public DBUserInfo findDBUser(String dbUserName, String dbID) {
		for (DBUserInfo dui : dbUsers) {
			if (dui.name.equals(dbUserName) && dui.dbID.equals(dbID)) {
				return dui;
			}
		}
		return null;
	}

	public Element toXML() {
		Element parent = new Element("user-info");
		parent
				.addContent(new Comment(
						"Define the set of available databases the web application can connect\n" +
						"One of them needs to have default=true."));
		Element de = new Element("databases");
		parent.addContent(de);
		for (Iterator<DatabaseInfo> iter = databases.iterator(); iter
				.hasNext();) {
			DatabaseInfo dbi = iter.next();
			dbi.toXML(de);
		}
		Element pe = new Element("privileges");
		parent.addContent(pe);
		for (Iterator<PrivilegeInfo> iter = privileges.iterator(); iter
				.hasNext();) {
			PrivilegeInfo pi = iter.next();
			pi.toXML(pe);
		}
		parent.addContent(new Comment(
						"the list of named database users for each database instance"));
		Element due = new Element("dbusers");
		parent.addContent(due);
		for (Iterator<DBUserInfo> iter = dbUsers.iterator(); iter.hasNext();) {
			DBUserInfo dui = iter.next();
			dui.toXML(due);
		}

		parent.addContent(new Comment(
						"the list of web application users mapped to the named database users\n" +
						"The web application does its own authentication."));
		Element wue = new Element("users");
		parent.addContent(wue);
		for (Iterator<WebUserInfo> iter = webUsers.iterator(); iter
				.hasNext();) {
			WebUserInfo wui = iter.next();
			wui.toXML(wue);
		}

		return parent;

	}

}