package clinical.tools.maintenance;

import java.math.BigDecimal;
import java.util.Map;

import clinical.server.vo.Databaseuser;
import clinical.server.vo.Tableid;
import clinical.web.Constants;
import clinical.web.ISequenceHelper;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.common.security.User;
import clinical.web.exception.BaseException;
import clinical.web.exception.DBCacheException;

public class DBHelper {
	String dbID;
	UserInfo ui;
	User user;
	IDBCache dbCache;
	Databaseuser databaseUser;
	ISequenceHelper seqHelper;

	public DBHelper(String dbID, UserInfo ui) throws DBCacheException,
			BaseException {
		this.dbID = dbID;
		this.ui = ui;
		ISecurityService securityService = ServiceFactory.getSecurityService();
		Map<String,User> userMap = securityService.getAllUsers(this.dbID);
		this.user = (User) userMap.get(ui.getName());
		User dbUser = user.getDbUser();

		this.dbCache = ServiceFactory.getDBCache(this.dbID);
		this.databaseUser = dbCache.getDatabaseUser(ui, dbUser.getName(),
				Constants.USERCLASS_ADMIN);
		this.seqHelper = ServiceFactory.getSequenceHelper(this.dbID);
	}

	public BigDecimal getTableID(String tableName) throws DBCacheException {
		Tableid tid = dbCache.getTableID(ui, tableName);
		return tid.getTableid();
	}

	public BigDecimal getDatabaseUserID() {
		return databaseUser.getUniqueid();
	}

	public BigDecimal getUniqueID(String tableName, String columnName) throws BaseException {
		return seqHelper.getNextUID(ui, tableName, columnName);
	}
}
