package clinical.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import clinical.xml.xcede2.XCEDE;

/**
 * @author I. Burak Ozyurt
 * @version $Id: XCEDEUtils.java 88 2009-08-17 23:02:38Z bozyurt $
 */
public class XCEDEUtils {

	public static XCEDE unmarshalFromString(String xcedeXmlContent)
			throws JAXBException {
		JAXBContext jc = JAXBContext.newInstance(XCEDE.class);

		Unmarshaller um = jc.createUnmarshaller();
		StringReader sr = new StringReader(xcedeXmlContent);
		XCEDE xcede = (XCEDE) um.unmarshal(sr);
		return xcede;
	}

	public static XCEDE unmarshal(String xcedeFilePath) throws JAXBException,
			IOException {
		return unmarshal(new File(xcedeFilePath));
	}

	public static XCEDE unmarshal(File xcedeFile) throws JAXBException,
			IOException {
		JAXBContext jc = JAXBContext.newInstance(XCEDE.class);

		Unmarshaller um = jc.createUnmarshaller();
		BufferedReader in = null;
		try {
			in = new BufferedReader(new FileReader(xcedeFile));
			XCEDE xcede = (XCEDE) um.unmarshal(in);
			return xcede;
		} finally {
			close(in);
		}
	}

	public static void close(Reader in) {
		if (in != null) {
			try {
				in.close();
			} catch (Exception x) {
			}
		}
	}
}
