package clinical.web;

import java.sql.ResultSet;
import java.util.ArrayList;


import clinical.web.forms.AsQueryBuilderForm;;

public class GeneQueryResults {	
	private ArrayList<GeneticQueryOut> geneResults;
	private String sessionName; 
	private boolean bGetResults[];
	private String chipName;
	private String genomName; 
	private String snpListName;
	private String geneListName;
	private String refSequence;
	private double gcScore;
	private String strPosition;
	private boolean bChromAll;
	private boolean chroms[];
	private String snpListValue;
	private String geneListValue;
	
	public GeneQueryResults(){
		
	}
	
	public GeneQueryResults(int m){
		geneResults = new ArrayList<GeneticQueryOut>();
		
		geneResults.add(new GeneticQueryOut("Prod1", (Object)(10*m)));

		geneResults.add(new GeneticQueryOut("Prod2",(Object)(20*m)));

		geneResults.add(new GeneticQueryOut("Prod3",(Object)(30*m)));
	}

	public void setGeneResults(ArrayList<GeneticQueryOut> geneResults) {
		this.geneResults = geneResults;
	}

	public ArrayList<GeneticQueryOut> getGeneResults() {
		return geneResults;
	}
	
	public String buildGeneticQueryString(AsQueryBuilderForm asForm, ArrayList<String>subjectIds, boolean limit, String fileType){
		GeneticObjs go = asForm.getGeneticObj();
		sessionName = go.getSelSessionName();
		chipName = go.getSelChipName();
		genomName = go.getSelGenomeRel();
		/*snpListName = go.getSelSnpListName();
		snpListValue = go.getSelSnpListValue();
		geneListName = go.getSelGeneListName();
		geneListValue = go.getSelGeneListValue();*/
		snpListName = go.getSelAllSnpListName();
		snpListValue = go.getSelAllSnpListValue();
		geneListName = go.getSelAllGeneListName();
		geneListValue = go.getSelAllGeneListValue();
		bChromAll = asForm.isChromAll();
		chroms = asForm.getChromArr();
		refSequence = asForm.getRefSeq();
		gcScore = asForm.getGcScore();
		strPosition = asForm.getPosition();
	
		String ChipAndOr = asForm.getChipIdAND();
		String GenomeAndOr = asForm.getGenomeAND();
		String SnpAndOr = asForm.getSnpAND();
		String GeneAndOr = asForm.getGeneAND();
		String ChromAndOr = asForm.getChromAND();
		String RefAndOr = asForm.getRefseqAND();
		String GCScoreAndOr = asForm.getGcScoreAND();
		String PosAndOr = asForm.getPositionAND();	

		String refSeqOp = asForm.getSelectedRefSeqOp(); 
		String refSeqOpText = asForm.getSelectedRefSeqOpLabel();
		String gcscoreOp = asForm.getSelectedGcscoreOp();
		String gcscoreOpText = asForm.getSelectedGcscoreOpLabel();
		String posOp = asForm.getSelectedPosOp();
		String posOpText = asForm.getSelectedPosOpLabel();
		
		double gcLB = asForm.getGcScoreLB();
		double gcUB = asForm.getGcScoreUB();
		String posLB = asForm.getPositionLB();
		String posUB = asForm.getPositionUB();
		
		bGetResults = asForm.getResults();
		boolean bGetResult = false;
		for(boolean b : bGetResults){
			if(b==true){
				bGetResult = true;
				break;
			}
		}
		if(bGetResult==false ){ //no Get fields is checked
			if(!fileType.equals(Constants.MAP_FILE) && !fileType.equals(Constants.PED_FILE)){
				return null;
			}
		}
		
		String subIds = "";
		StringBuilder sb = new StringBuilder();
		for(String s : subjectIds){
			sb.append("'");
			sb.append(s);
			sb.append("'");
			sb.append(",");
		}
		subIds = sb.toString();
		subIds = subIds.substring(0, subIds.length()-1);
		
		String sql = "";
		if(fileType.equals(Constants.MAP_FILE)){
			//sql = "select chr, snpname, position from nc_geneticfinalreport where ";
			sql = "select distinct chr, snpname, position, cast(position as Int) as intPos from nc_geneticfinalreport where ";
	
		}else if(fileType.equals(Constants.PED_FILE)){
			sql = "select chr, snpname, position, gr.subjectid, cast(gr.subjectid as Int) as intSub, allele1, allele2, familyid, fatherid, motherid " +
			      " from nc_geneticfinalreport gr inner join " +
				  " nc_geneticfamily gf on gr.subjectid=gf.subjectid " +
				  " where gr.subjectid in(" + subIds + ") ";				  
				  
		}else{
			sql = " select * from nc_geneticfinalreport " +			   
					" where subjectid in(" + subIds + ")";
		}
		
		sql = buildFilter(fileType, SnpAndOr, ChromAndOr, RefAndOr,
				GCScoreAndOr, PosAndOr, refSeqOpText, gcscoreOpText, posOpText,
				gcLB, gcUB, posLB, posUB, sql);
		
		sb = new StringBuilder();
		sb.append(sql);
		if(fileType.equals(Constants.MAP_FILE)){
			//sb.append(" group by snpname, chr, position "); 
			sb.append(" order by intPos ");
		}else if(fileType.equals(Constants.PED_FILE)){
			//sb.append(" group by snpname, chr, position, gr.subjectid, allele1, allele2, familyid, fatherid, motherid ");
			sb.append(" order by intSub " );
		}
		if(limit){
			if(fileType.equals(Constants.MAP_FILE) || fileType.equals(Constants.PED_FILE)){
				sb.append(" LIMIT " + String.valueOf(Constants.QUERY_OFFSET));
			}else{
				sb.append(" LIMIT 10000 ");  //set output record size as 100000 which can be displayed.
			}
		}	
		sql = sb.toString();
		return sql;		
	}

	public String buildQueryGetRecordCount(AsQueryBuilderForm asForm, ArrayList<String>subjectIds, String fileType){
		GeneticObjs go = asForm.getGeneticObj();
		sessionName = go.getSelSessionName();
		chipName = go.getSelChipName();
		genomName = go.getSelGenomeRel();
		/*snpListName = go.getSelSnpListName();
		snpListValue = go.getSelSnpListValue();
		geneListName = go.getSelGeneListName();
		geneListValue = go.getSelGeneListValue();*/
		snpListName = go.getSelAllSnpListName();
		snpListValue = go.getSelAllSnpListValue();
		geneListName = go.getSelAllGeneListName();
		geneListValue = go.getSelAllGeneListValue();
		bChromAll = asForm.isChromAll();
		chroms = asForm.getChromArr();
		refSequence = asForm.getRefSeq();
		gcScore = asForm.getGcScore();
		strPosition = asForm.getPosition();
	
		String ChipAndOr = asForm.getChipIdAND();
		String GenomeAndOr = asForm.getGenomeAND();
		String SnpAndOr = asForm.getSnpAND();
		String GeneAndOr = asForm.getGeneAND();
		String ChromAndOr = asForm.getChromAND();
		String RefAndOr = asForm.getRefseqAND();
		String GCScoreAndOr = asForm.getGcScoreAND();
		String PosAndOr = asForm.getPositionAND();
		String refSeqOp = asForm.getSelectedRefSeqOp(); 
		String refSeqOpText = asForm.getSelectedRefSeqOpLabel();
		String gcscoreOp = asForm.getSelectedGcscoreOp();
		String gcscoreOpText = asForm.getSelectedGcscoreOpLabel();
		String posOp = asForm.getSelectedPosOp();
		String posOpText = asForm.getSelectedPosOpLabel();		
		double gcLB = asForm.getGcScoreLB();
		double gcUB = asForm.getGcScoreUB();
		String posLB = asForm.getPositionLB();
		String posUB = asForm.getPositionUB();
		
		bGetResults = asForm.getResults();

		String subIds = "";
		StringBuilder sb = new StringBuilder();
		for(String s : subjectIds){
			sb.append("'");
			sb.append(s);
			sb.append("'");
			sb.append(",");
		}
		subIds = sb.toString();
		subIds = subIds.substring(0, subIds.length()-1);
		
		String sql = "";
		if(fileType==Constants.MAP_FILE){
			sql = " select count(distinct snpname) from nc_geneticfinalreport where ";
		}else if(fileType==Constants.PED_FILE){
			sql = " select count(*) " +
				  " from nc_geneticfinalreport gr inner join " +
				  " nc_geneticfamily gf on gr.subjectid=gf.subjectid " +
				  " where gr.subjectid in(" + subIds + ") ";
		}
		
		sql = buildFilter(fileType, SnpAndOr, ChromAndOr, RefAndOr,
				GCScoreAndOr, PosAndOr, refSeqOpText, gcscoreOpText, posOpText,
				gcLB, gcUB, posLB, posUB, sql);

		sb = new StringBuilder();
		sb.append(sql);
//		if(fileType == Constants.PED_FILE){
//			sb.append(" group by snpname, chr, position, gr.subjectid, allele1, allele2, familyid, fatherid, motherid ");
//		}
		
		sql = sb.toString();
		
		return sql;		
	}
	
	private String buildFilter(String fileType, String SnpAndOr,
			String ChromAndOr, String RefAndOr, String GCScoreAndOr,
			String PosAndOr, String refSeqOpText, String gcscoreOpText,
			String posOpText, double gcLB, double gcUB, String posLB,
			String posUB, String sql) {
		StringBuilder sb;
		//if(bGetResults[2]==true){ //snp value is chosen to AND/OR
		if(!SnpAndOr.equals("none")){ //snp value is chosen to AND/OR
			sb = new StringBuilder();
			if(snpListValue=="*"){
				sb.append(" snpname = '*'");
			}else{
				String snps[] = snpListValue.split(",");
				if(snps.length>1){
					sb.append(" snpname in ("); 
					for(String sId : snps){
						sb.append("'");
						sb.append(sId.trim());
						sb.append("',");
					}
					sb.deleteCharAt(sb.length()-1);
					sb.append(")");
				}else{
					snps = snpListValue.split("-");
					if(snps.length==2){
						sb.append(" snpname between '" + snps[0] + "' AND '" + snps[1] + "'");
					}else if(snps.length==1){
						if(snpListValue.lastIndexOf("rs") == snpListValue.indexOf("rs")){
							sb.append(" snpname = '" + snpListValue + "'");
						}
					}
				}
			}
			
			StringBuilder sbSql = new StringBuilder();
			sbSql.append(sql);
			if(!sql.trim().endsWith("where")){
				if(SnpAndOr.equals("and")){
					sbSql.append(" AND ");
				}else if(SnpAndOr.equals("or")){
					sbSql.append(" OR ");
				}
			}
			sbSql.append(sb.toString());
			sql = sbSql.toString();
		}
		
		//if(bGetResults[4]==true){ //chromosome is chosen to AND/OR
		if(!ChromAndOr.equals("none")){ //chromosome is chosen to AND/OR
			StringBuilder sbchr = new StringBuilder();
			for(int i=0; i<chroms.length; i++){
				if(chroms[i]==true){
					if(i<22){
						sbchr.append("'");
						sbchr.append(i+1);
						sbchr.append("'");
						sbchr.append(",");	
					}else{
						if(i==22){
							sbchr.append("'M'");
							sbchr.append(",");
						}else if(i==23){
							sbchr.append("'X'");
							sbchr.append(",");
						}else if(i==24){
							sbchr.append("'XY'");
							sbchr.append(",");
						}else if(i==25){
							sbchr.append("'Y'");
							sbchr.append(",");
						}
					}					
				}
			}
			if(sbchr.length()>0){
				sbchr.deleteCharAt(sbchr.length()-1);
				
				StringBuilder sbsql = new StringBuilder();
				sbsql.append(sql);
				if(!sql.trim().endsWith("where")){
					if(ChromAndOr.equals("and")){
						sbsql.append(" AND ");
					}else if(ChromAndOr.equals("or")){
						sbsql.append(" OR ");
					}
				}
				sbsql.append(" chr in (");
				sbsql.append(sbchr.toString());
				sbsql.append(")");
				sql = sbsql.toString();
			}
		}
		
		//if(bGetResults[5]==true){ //refseq is chosen to AND/OR
		if(!RefAndOr.equals("none")){//refseq is chosen to AND/OR 
			StringBuilder sbr = new StringBuilder();
			if(refSequence.length()>0){
				sbr.append(" refseq ");
				sbr.append(refSeqOpText);
				sbr.append(" '");
				sbr.append(refSequence);
				sbr.append("'");
			}			
			if(sbr.length()>0){
				StringBuilder sbsql = new StringBuilder();
				sbsql.append(sql);
				if(!sql.trim().endsWith("where")){
					if(RefAndOr.equals("and")){
						sbsql.append(" AND ");	
					}else if(RefAndOr.equals("or")){
						sbsql.append(" OR ");
					}	
				}				
				sbsql.append(sbr.toString());
				sql = sbsql.toString();
			}
			
		}
		
		//if(bGetResults[6]==true){ //gcscore is chosen to AND/OR
		if(!GCScoreAndOr.equals("none")){ //gcscore is chosen to AND/OR
			StringBuilder sbgc = new StringBuilder();
			if(gcUB>0.0){
				sbgc.append(" gcscore between ");
				sbgc.append(gcLB);
				sbgc.append(" and ");
				sbgc.append(gcUB);
			}else{
				sbgc.append(" gcscore ");
				sbgc.append(gcscoreOpText);
				sbgc.append(gcScore);
			}
			
			if(sbgc.length()>0){
				StringBuilder sbsql = new StringBuilder();
				sbsql.append(sql);
				if(!sql.trim().endsWith("where")){				
					if(GCScoreAndOr.equals("and")){
						sbsql.append(" AND ");	
					}else if(GCScoreAndOr.equals("or")){
						sbsql.append(" OR ");
					}
				}
				sbsql.append(sbgc.toString());
				sql = sbsql.toString();
			}
		}
		
		//if(bGetResults[7]==true){ //position is chosen to AND/OR
		if(!PosAndOr.equals("none")){ //position is chosen to AND/OR
			StringBuilder sbp = new StringBuilder();
			if(strPosition.length()>0){
				if(!strPosition.equals("*")){
					sbp.append(" position ");
					sbp.append(posOpText);
					sbp.append(" '");
					sbp.append(strPosition);
					sbp.append("'");					
				}
			}else{
				sbp.append(" position between '");
				sbp.append(posLB);
				sbp.append("' and '");
				sbp.append(posUB);
				sbp.append("'");
			}
			
			if(sbp.length()>0){
				StringBuilder sbsql = new StringBuilder();
				sbsql.append(sql);
				if(!sql.trim().endsWith("where")){
					if(PosAndOr.equals("and")){
						sbsql.append(" AND ");	
					}else if(PosAndOr.equals("or")){
						sbsql.append(" OR ");
					}
				}
				sbsql.append(sbp.toString());
				sql = sbsql.toString();
			}
		}
		return sql;
	}

	public ArrayList<GeneQueryResults> retrieveGeneticQueryResults(String queryString, ResultSet rs) {
		ArrayList<GeneQueryResults> alGene = new ArrayList<GeneQueryResults>();
		
		try{			
			//save record set to geneResults object
			if(rs!=null){				
				
				while(rs.next()){				
					GeneQueryResults gqr = new GeneQueryResults(); 
					ArrayList<GeneticQueryOut> gResults = new ArrayList<GeneticQueryOut>();
					
					gResults.add(new GeneticQueryOut("Subject ID", (Object)(rs.getObject("SubjectId"))));
					
					if(bGetResults[0]){
						gResults.add(new GeneticQueryOut("Chip", (Object)(chipName)));
						//gResults.add(new GeneticQueryOut("Chip", (Object)(rs.getObject("chipname"))));
					}
					if(bGetResults[1]){
						gResults.add(new GeneticQueryOut("Genome Release", (Object)(genomName)));
						//gResults.add(new GeneticQueryOut("Genome Release", (Object)(rs.getObject("genomebuild"))));
					}
					if(bGetResults[2]){
						//gResults.add(new GeneticQueryOut("SNP", (Object)(snpListName)));
						gResults.add(new GeneticQueryOut("SNP", (Object)(rs.getObject("snpname"))));
					}
					if(bGetResults[3]){
						gResults.add(new GeneticQueryOut("Gene", (Object)(geneListName)));
						//gResults.add(new GeneticQueryOut("Gene", (Object)(rs.getObject("genelist"))));
					}
					if(bGetResults[4]){
//						String sChroms = "";
//						for(int i = 0; i<chroms.length; i++){
//							if(chroms[i]){
//								if(i<22){
//									sChroms = sChroms + "Chr " + String.valueOf(i+1) + ", ";
//								}else if(i==22){
//									sChroms = sChroms + "Chr M, ";
//								}else if(i==23){
//									sChroms = sChroms + "Chr X, ";
//								}else if(i==24){
//									sChroms = sChroms + "Chr XY, ";
//								}else if(i==25){
//									sChroms = sChroms + "Chr Y, ";
//								}
//							}					
//						}
//						gResults.add(new GeneticQueryOut("Chromosome", (Object)(sChroms)));
						gResults.add(new GeneticQueryOut("Chromosome", (Object)(rs.getObject("chr"))));
					}
					if(bGetResults[5]){
						gResults.add(new GeneticQueryOut("Ref Seq", (Object)(refSequence)));
						//gResults.add(new GeneticQueryOut("Ref Seq", (Object)(rs.getObject("refseq"))));
					}
					if(bGetResults[6]){
						//gResults.add(new GeneticQueryOut("GC Score", (Object)(gcScore)));
						gResults.add(new GeneticQueryOut("GC Score", (Object)(rs.getObject("gcscore"))));
					}
					if(bGetResults[7]){
						//gResults.add(new GeneticQueryOut("Position", (Object)(strPosition)));
						gResults.add(new GeneticQueryOut("Position", (Object)(rs.getObject("position"))));
					}
	
					gqr.setGeneResults(gResults);
					alGene.add(gqr);					
				}
			}
			
		}catch(Exception e){
			
		}
		return alGene;		
		
	}
}
