package clinical.web;

import java.util.List;

import clinical.server.vo.Jobs;
import clinical.web.common.UserInfo;
import clinical.web.exception.JobManServiceException;
import clinical.web.scheduler.JobRecord;

/**
 * Session facade interface for batch job management.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: IJobManagementService.java,v 1.3 2007/11/22 02:10:12 bozyurt
 *          Exp $
 */
public interface IJobManagementService {
	/**
	 * 
	 * @param ui
	 * @param jobUser
	 * @return
	 * @throws JobManServiceException
	 */
	public List<JobRecord> getJobsForUser(UserInfo ui, String jobUser)
			throws JobManServiceException;

	/**
	 * 
	 * @param ui
	 * @param jobRec
	 * @throws JobManServiceException
	 */
	public void updateJob(UserInfo ui, JobRecord jobRec)
			throws JobManServiceException;

	/**
	 * 
	 * @param ui
	 * @param jobRec
	 * @throws JobManServiceException
	 */
	public void addJob(UserInfo ui, JobRecord jobRec)
			throws JobManServiceException;

	public JobRecord findJob(UserInfo ui, String jobUser, String jobID)
			throws JobManServiceException;

	public List<Jobs> getAllJobs(UserInfo ui) throws JobManServiceException;

	public void removeJob(UserInfo ui, String jobID)
			throws JobManServiceException;

	public void expireJob(UserInfo ui, String jobID)
			throws JobManServiceException;
}
