package clinical.web;

import java.util.Date;
import java.util.List;
import java.util.Map;

import clinical.server.vo.Assessment;
import clinical.server.vo.Dataobjecttype;
import clinical.server.vo.Experiment;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Extendedtuple;
import clinical.server.vo.Protocol;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.vo.VisitDateQuery;

/**
 * @author I. Burak Ozyurt
 * @version $Id: IRemoteDBServices.java,v 1.4.2.1 2008/07/29 00:42:32 bozyurt
 *          Exp $
 */
public interface IRemoteDBServices {

	public Expsegment getSegmentInfo(UserInfo ui, String siteID,
			String expName, String subjectID, Integer visitID,
			String segmentName) throws Exception;

	public Map<String, Experiment> getAllExperiments(String siteID)
			throws Exception;

	public Map<String, Dataobjecttype> getAllDataObjectTypes(String siteID)
			throws Exception;

	public List<Assessment> getAllAssessments(String siteID) throws Exception;

	/**
	 *
	 * @param siteID
	 * @param vdqList
	 * @param forceRecache
	 * @return keyed by subjectid '_' expID '_' visitID
	 * @throws Exception
	 */
	public Map<String, Date> getVisitDates(String siteID,
			List<VisitDateQuery> vdqList, boolean forceRecache)
			throws Exception;

	public List<Extendedtuple> getExtendedTuples(String siteID)
			throws Exception;

	/**
	 *
	 * @param siteID
	 * @return return a sorted by assessment name list of
	 *         {@link AssessmentSelectionInfo} objects populated with scores.
	 *         The results are cached and a deep copy of the cached results are
	 *         returned.
	 * @throws Exception
	 */
	public List<AssessmentSelectionInfo> getAllAssessmentsWithScores(
			String siteID) throws Exception;

	public  Dataobjecttype findObjectType(String objectType,
			boolean forceRecache) throws Exception;
	
	/**
	 * Jinran added
	 * @param siteID
	 * @return return all the assessment with scores which are in the subject data.  
	 */
	public List<AssessmentSelectionInfo> getAllValidAssessmentsWithScores(
			String siteID) throws Exception;

	/**
	 * Jinran added
	 * @param siteID
	 * @param expID
	 * @return return all the assessment with scores which are in the specified experiment
	 * @throws Exception
	 */
	public List<AssessmentSelectionInfo> getAssessmentsWithScoresOnExp(
			String siteID, String expName) throws Exception;
	
//	/**
//	 * Jinran added
//	 * @param siteID
//	 * @return
//	 * @throws Exception
//	 */
//	public List<SnpList> getAllSnpList(String siteID) throws Exception;

	public List<Protocol> getAllValidProtocols(String primarySiteID) throws Exception;

	public List<Protocol> getProtocols(String primarySiteID, String expName) throws Exception;

}
