package clinical.web.actions;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.ConfParams;
import clinical.server.vo.ConfParamsGroup;
import clinical.server.vo.Researchgroup;
import clinical.utils.Assertion;
import clinical.web.Constants;
import clinical.web.common.UserInfo;
import clinical.web.forms.AppConfigForm;
import clinical.web.helpers.AppConfigHelper;
import clinical.web.services.AppConfigService;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AppConfigAction.java 763 2013-02-01 18:36:31Z jinranc $
 */
public class AppConfigAction extends BaseLookupDispatchAction {
	private Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(AppConfigAction.class);
	public final static String OBJECT_TYPES = "download.object.types";

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.aconf.view", "view");
		map.put("button.aconf.switch.view", "switchView");
		map.put("button.aconf.edit", "editGroup");
		map.put("button.aconf.addVisitType", "addVisitType");
		map.put("button.aconf.deleteVisit", "deleteVisit");
		map.put("button.aconf.addResearchGroupType","addResearchGroupType");
		map.put("button.aconf.deleteResearchGroupType", "deleteResearchGroupType");
		return map;
	}

	public ActionForward view(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			log.info(">> view");
			getUserInfo(request);
			AppConfigForm acForm = (AppConfigForm) form;
			acForm.setCurGroupName("General");
			Map<String,MultiValuedProperty> mvParamMap = new HashMap<String,MultiValuedProperty>();
			AppConfigService acs = AppConfigService.getInstance();
			List<ConfParams> paramList = acs.getAllParams();
			Map<String, PropertyDescriptor> pdMap = AppConfigHelper.getPropertyDescriptorMap(acForm
					.getClass());

			Map<String,String> fieldHelpMap = new HashMap<String, String>();
			acForm.setFieldHelpMap(fieldHelpMap);
			for (ConfParams p : paramList) {
				String confPropsName = p.getName();
				int index = AppConfigHelper.getConfPropsIndexNumber(confPropsName);
				if (index == -1) {
					String jvn = AppConfigHelper.toJavaVarName(confPropsName);
					PropertyDescriptor pd = pdMap.get(jvn);
					if (pd != null) {
						AppConfigHelper.setProperty(acForm, p.getValue(), pd);
						if (p.getDescription() != null) {
							String descr = p.getDescription().replaceAll("\\r?\\n", " ");
							fieldHelpMap.put(jvn, descr);
						} else {
							fieldHelpMap.put(jvn, "No description!");
						}
					}
				} else {
					String prefix = confPropsName.substring(0, confPropsName.lastIndexOf('.'));
					if (prefix.equals(OBJECT_TYPES)) {
						MultiValuedProperty mvp = mvParamMap.get(prefix);
						if ( mvp == null) {
							mvp = new MultiValuedProperty(prefix);
							mvParamMap.put(prefix, mvp);
						}
						mvp.addValue(index - 1, p.getValue());
					}
				}
			}
			/*
			for (Map.Entry<String,String> entry : fieldHelpMap.entrySet()) {
				System.out.println(entry.getKey() + " -> " + entry.getValue());
			}
			*/

			if ( !mvParamMap.isEmpty()) {
				MultiValuedProperty mvp = mvParamMap.get(OBJECT_TYPES);
				if ( mvp != null) {
					List<String> list = mvp.getIndexOrderedValues();
					acForm.setObjectTypes(list);
				}
			}

			//set visit types listbox values
			Collection<LabelValueBean> colVisittypes = acs.getAllVisitTypes();
			acForm.setVisitTypes(colVisittypes);

			//set research group types listbox values
			Collection<LabelValueBean> colResearchGrouptypes = acs.getAllResearchGroupTypes();
			acForm.setResearchGroupTypes(colResearchGrouptypes);
			
			//set research group array values
			ArrayList<BigDecimal> researchGrps = new ArrayList<BigDecimal>();
			researchGrps = acs.getResearchGroups();
			acForm.setResearchGroupTypeIds(researchGrps);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("AppConfigAction", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward switchView(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			getUserInfo(request);
			// just forward after user authentication checking
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("AppConfigAction", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}
	
	public ActionForward addVisitType(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			UserInfo ui = getUserInfo(request);
			AppConfigService acs = AppConfigService.getInstance();
			AppConfigForm acForm = (AppConfigForm) form;
	
			acs.addVisitType(acForm.getVisitType().trim(), acForm.getVisitTypeDesc(), ui);

			Collection<LabelValueBean> colVisittypes = acs.getAllVisitTypes();
			acForm.setVisitTypes(colVisittypes);
			
			//clear new visittype textbox
			acForm.setVisitType(null);
			
			// just forward after user authentication checking
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("AppConfigAction", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward deleteVisit(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			AppConfigService acs = AppConfigService.getInstance();
			AppConfigForm acForm = (AppConfigForm) form;
	
			BigDecimal[]visitNames = acForm.getSelVisitTypes();
			for(BigDecimal visitName : visitNames){
				acs.deleteVisitType(visitName, ui);	
			}			

			Collection<LabelValueBean> colVisittypes = acs.getAllVisitTypes();
			acForm.setVisitTypes(colVisittypes);
			
			//clear new visittype textbox
			acForm.setVisitType(null);
			
			// just forward after user authentication checking
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("AppConfigAction", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward addResearchGroupType(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		try {
			UserInfo ui = getUserInfo(request);
			AppConfigService acs = AppConfigService.getInstance();
			AppConfigForm acForm = (AppConfigForm) form;
	
			acs.addResearchGroupType(acForm.getResearchGroupType().trim(), acForm.getResearchGroupTypeDesc(), ui);

			Collection<LabelValueBean> colResearchGroupTypes = acs.getAllResearchGroupTypes();
			acForm.setResearchGroupTypes(colResearchGroupTypes);
			
			//clear new visittype textbox
			acForm.setResearchGroupType(null);
			
			// just forward after user authentication checking
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("AppConfigAction", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}	
	
	public ActionForward deleteResearchGroupType(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			AppConfigService acs = AppConfigService.getInstance();
			AppConfigForm acForm = (AppConfigForm) form;
	
			BigDecimal[]researchGrpTypeIds = acForm.getSelResearchGroupTypes();
			for(BigDecimal researchGrpTypeId : researchGrpTypeIds){
				//skip deletion if this group type is already used in nc_researchgroup table
				if(!acs.researchGrpTypeUsed(researchGrpTypeId, ui)){
					acs.deleteResearchGrpType(researchGrpTypeId, ui);	
				}					
			}			

			Collection<LabelValueBean> colResearchGroupTypes = acs.getAllResearchGroupTypes();
			acForm.setResearchGroupTypes(colResearchGroupTypes);
			
			//clear new visittype textbox
			acForm.setResearchGroupType(null);
			
			// just forward after user authentication checking
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("AppConfigAction", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward editGroup(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			log.info("editGroup");
			getUserInfo(request);

			if ( log.isDebugEnabled()) {
				Enumeration<?> it = request.getParameterNames();
				while(it.hasMoreElements()) {
					String name = (String) it.nextElement();
					String[] values = request.getParameterValues(name);
					System.out.println(name + " => " + values[0]);
				}
				System.out.println("-------------------");
			}
			AppConfigService acs = AppConfigService.getInstance();
			AppConfigForm acForm = (AppConfigForm) form;
			String groupName = acForm.getCurGroupName();

			ConfParamsGroup pg = acs.getParamGroup(groupName);
			Assertion.assertNotNull(pg);

			Map<String, PropertyDescriptor> pdMap = AppConfigHelper
			.getPropertyDescriptorMap(acForm.getClass());

			List<ConfParams> paramList = acs.getAllParams();
			for (ConfParams p : paramList) {
				if ( !p.getParamGroupId().equals(pg.getUniqueId())) {
					continue;
				}
				String jvn = AppConfigHelper.toJavaVarName(p.getName());
				// System.out.println("jvn:" + jvn);
				PropertyDescriptor pd = pdMap.get(jvn);
				if (pd != null) {
					if ( p.getType().equals("bool")) {
                       String value = request.getParameter(jvn);
                       System.out.println("bool value=" + value + " for " + jvn);
                       if ( value == null) {
                    	   AppConfigHelper.setProperty(acForm, "false", pd);
                       } else {
                    	   AppConfigHelper.setProperty(acForm, "true", pd);
                       }
					}
				}
			}

			updateParamsForGroup(acs, acForm, pg, pdMap);

			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			log.error("AppConfigAction", x);
			return processExceptions(request, response, mapping, form, x);
		}
	}

	protected void updateParamsForGroup(AppConfigService acs,
			AppConfigForm acForm, ConfParamsGroup pg, Map<String, PropertyDescriptor> pdMap)
			throws ClassNotFoundException, IntrospectionException,
			IllegalAccessException, InvocationTargetException, Exception
	{
		List<ConfParams> paramList = acs.getAllParams();
		for (ConfParams p : paramList) {
			if ( !p.getParamGroupId().equals(pg.getUniqueId())) {
				continue;
			}
			String jvn = AppConfigHelper.toJavaVarName(p.getName());
			PropertyDescriptor pd = pdMap.get(jvn);
			if (pd != null) {
				String newValue = AppConfigHelper.getProperty(acForm, pd);

				if (!newValue.equals(p.getValue())) {
					System.out.println("newValue=" + newValue + " p:" + p.getName());
					acs.updateParameter(p.getName(), newValue);
				}
			}
		}
	}

	public static class MultiValuedProperty {
		String propertyName;
		Map<Integer,String> valueMap = new HashMap<Integer, String>(7);

		public MultiValuedProperty(String propertyName) {
			this.propertyName = propertyName;
		}

		public void addValue(int idx, String value) {
			valueMap.put(new Integer(idx), value);
		}

		public List<String> getIndexOrderedValues() {
			List<String> values = new ArrayList<String>( valueMap.size());
			List<Integer> keys = new ArrayList<Integer>( valueMap.keySet());
			Collections.sort(keys);
			for (Integer idx : keys) {
				values.add( valueMap.get(idx));
			}
			return values;
		}
	}

}
