package clinical.web.actions;

import edu.emory.mathcs.backport.java.util.Collections;
import groovy.time.TimeDuration;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.LabelValueBean;
import org.codehaus.groovy.runtime.TimeCategory;
import org.json.JSONArray;
import org.json.JSONObject;

import cryptix.util.core.FileUtil;


import clinical.cache.CacheUtils;
import clinical.server.vo.Assessmentscorecode;
import clinical.server.vo.Experiment;
import clinical.server.vo.Expsegment;
import clinical.server.vo.Protocol;
import clinical.server.vo.Storedquery;
import clinical.utils.Assertion;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.Constants;
import clinical.web.GeneList;
import clinical.web.GeneQueryResults;
import clinical.web.GeneticChip;
import clinical.web.GeneticObjs;
import clinical.web.GeneticSession;
import clinical.web.IAnalysisResultService;
import clinical.web.IAssessmentService;
import clinical.web.IGeneticService;
import clinical.web.IRemoteDBServices;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBCache;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.exception.BaseException;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.BatchQueryForm;
import clinical.web.forms.SaveQueryForm;
import clinical.web.forms.StoredQuerySelector;
import clinical.web.helpers.BatchQueryHelper;
import clinical.web.helpers.ExperimentSelector;
import clinical.web.helpers.ExperimentSessionSelector;
import clinical.web.helpers.ProtocolSelector;
import clinical.web.helpers.QueryWizardHelper;
import clinical.web.helpers.BatchQueryHelper.ClsFileDataRow;
import clinical.web.helpers.BatchQueryHelper.ClsFileHeaderRow;
import clinical.web.scheduler.IJob;
import clinical.web.scheduler.JobException;
import clinical.web.scheduler.JobScheduler;
import clinical.web.vo.AssessmentQueryInfo;
import clinical.web.vo.AssessmentResultSummary;
import clinical.web.vo.QueryInfo;
import clinical.web.vo.QuerySummary;
import clinical.web.vo.SubjectAsScoreValueSummary;
import clinical.web.SnpList;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentQueryAction.java 826 2013-08-01 22:43:11Z jinranc $
 */
public class AssessmentQueryAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(AssessmentQueryAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.aq.show", "show");
		map.put("action.aq.load_saved_query", "loadSavedQuery");
		map.put("action.aq.query", "query");
		map.put("action.aq.msquery", "multiSiteQuery");

		map.put("action.aq.save_query", "saveQuery");
		map.put("action.aq.get_scorecodes", "getScorecodes");
		map.put("action.aq.change_exp", "changeExp"); //Jinran added
		map.put("action.aq.delete_query", "deleteQuery"); //Jinran added
		
		map.put("action.aq.change_exp_session",	"changeExpSession"); //Jinran added
		map.put("action.aq.change_session",	"changeSession"); //Jinran added
		
		map.put("action.aq.new_session", "newSession"); //Jinran added
		map.put("action.aq.delete_session", "deleteSession");
		map.put("action.aq.gene_add_snp", "addSnp");
		map.put("action.aq.gene_delete_snp", "deleteSnpList");
		map.put("action.aq.gene_update_snp", "updateSnp");
		map.put("action.aq.gene_query", "queryGenetics");
		
		map.put("action.aq.gene_add_gene", "addGeneList");
		map.put("action.aq.gene_delete_gene", "deleteGeneList");
		map.put("action.aq.gene_update_gene", "updateGeneList");
		
		map.put("action.aq.export_map", "exportMap");
		map.put("action.aq.export_ped", "exportPed");
		
		map.put("button.batch.query", "showBatchQueryForm");
		return map;
	}

	public ActionForward show(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("in show");
		IDBCache dbCache = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			IAssessmentService asService = ServiceFactory
					.getAssessmentService(dbID);
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
			dbCache = ServiceFactory.getDBCache(dbID);
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

//			List<AssessmentSelectionInfo> asiList = rds
//					.getAllAssessmentsWithScores(primarySiteID); //Jinran commented
			List<AssessmentSelectionInfo> asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); //Jinran added
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
 
			queryForm.clean();

			IAnalysisResultService ars = ServiceFactory.getAnalysisResultService(dbID);

			boolean supportAnalysisQuery = ars.hasAnalysisMetaData();
			queryForm.setSupportAnalysisQuery(supportAnalysisQuery);
			boolean supportAssessmentQuery = !asiList.isEmpty();
			queryForm.setSupportAssessmentQuery(supportAssessmentQuery);

			for (AssessmentSelectionInfo asi : asiList) {
				queryForm.addAssessment(asi);
			}
			QueryInfo qi = queryForm.getQueryInfo();
			if (qi == null) {
				qi = new QueryInfo(new AssessmentQueryInfo(asiList));
				queryForm.setQueryInfo(qi);
			} else {
				if (qi.getAqi() != null && qi.getAqi().hasQueryParts()) {
					qi.getAqi().resetAllSelected();
				}
			}

			// prepare the stored query summaries for this user
			QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui
					.getPerceivedName(), queryForm);

			QueryWizardHelper.prepareExperimentSelector(ui, queryForm, dbCache);

			/********* Jinran added for Imaging Query *****************/
			//QueryWizardHelper.prepareProtocolSel(ui, dbID, queryForm);
			QueryWizardHelper.prepareProtocolSel(ui, dbID, queryForm, qi);
			/**********************************************************/

			/******************************************************/
			/*****   Jinran added genetic query form starts  *****/
			/******************************************************/
			QueryWizardHelper.prepareExperimentSessionSelector(ui, queryForm, dbCache);
			
			IGeneticService geneService = ServiceFactory.getGeneticService(dbID);			
			
			List<SnpList> snpList = geneService.getAllSnpList();
			session.setAttribute("snpList", snpList);
			
			//this allSnpList is to add an blank entry into SNP List dropdownlist
			List<SnpList> allSnpList = geneService.getAllSnpList();
			SnpList noneSnpList = new SnpList();
			noneSnpList.setUniqueId(BigDecimal.valueOf(0));
			noneSnpList.setName("");
			noneSnpList.setList(null);
			allSnpList.add(0, noneSnpList);

			List<GeneList> geneListCols = geneService.getAllGeneList();
			session.setAttribute("geneListCols", geneListCols);

			//this allGeneListCols is to add a blank entry to Gene List dropdown
			List<GeneList> allGeneListCols = geneService.getAllGeneList();
			GeneList noneGeneListCol = new GeneList();
			noneGeneListCol.setUniqueId(BigDecimal.valueOf(0));
			noneGeneListCol.setName("");
			noneGeneListCol.setList(null);
			allGeneListCols.add(0, noneGeneListCol);
			
			Collection<GeneticSession> geneSnpSessions = new ArrayList<GeneticSession>();
			GeneticSession gsEmpty = new GeneticSession();
			gsEmpty.setChipId(BigDecimal.valueOf(-1));
			gsEmpty.setSessionId(BigDecimal.valueOf(-1));
			gsEmpty.setSessionName("");
			geneSnpSessions.add(gsEmpty);
			for(GeneticSession gs : geneService.getAllSession()){
				geneSnpSessions.add(gs);	
			}
			
			//Collection<GeneticSession> geneSessions = geneService.getAllSession();
			Collection<GeneticSession> geneSessions = getGeneSessions(
					queryForm, geneService);		
			
			String sessionName = "";		
			for(GeneticSession gSession : geneSessions){
				sessionName = gSession.getSessionName();
				break;
			}	
//			//Collection<GeneticChip>	gChips = geneService.getAllChips();
			Collection<GeneticChip>	gChips = geneService.getChipsOnSession(sessionName);
			
//			//Collection<LabelValueBean> genomeReleases = geneService.getUniqueGenomeRelease();
			Collection<LabelValueBean> genomeReleases = geneService.getUniqueGenomeReleaseOnSession(sessionName);
			
			GeneticObjs geneticObj = new GeneticObjs();
			
			geneticObj.setSsList(geneSessions);
			geneticObj.setSnpSessionList(geneSnpSessions);
			geneticObj.setGeneChip(gChips);			
			geneticObj.setUniqueGenomeRelease(genomeReleases);			
			geneticObj.setSnpListCols(snpList);
			geneticObj.setAllSnpListCols(allSnpList);
			geneticObj.setGeneListCols(geneListCols);
			geneticObj.setAllGeneListCols(allGeneListCols);
			geneticObj.setGeneSessionList(geneSnpSessions);
			
			//initialize controls value
			queryForm.initializeQueryForm();
			
			queryForm.setGeneticObj(geneticObj);		
			
			GeneQueryResults geneQueryResults = new GeneQueryResults(1);
			queryForm.setGeneQResults(geneQueryResults);			
			/******************************************************/
			/*****   Jinran added genetic query form ends  *****/
			/******************************************************/			
			
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	private Collection<GeneticSession> getGeneSessions(
			AsQueryBuilderForm queryForm, IGeneticService geneService)
			throws Exception {
		String expName = new String();
		for(LabelValueBean lvb : queryForm.getExpSessionSel().getExperimentInfos()){				
			if(lvb.getValue().equals(Integer.toString(queryForm.getExpSessionSel().getSelectedExpSessionID()))){
				expName = lvb.getLabel();
				break;
			}
		}
		Collection<GeneticSession> geneSessions;
		if(expName.equals("All Experiments Sessions")){
			geneSessions = geneService.getAllSession();
		}else{
			geneSessions = geneService.getSessionOnExp(expName.substring(0, expName.indexOf(" Sessions")));	 	
		}
		return geneSessions;
	}


	public ActionForward query(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("**** query");
		AsQueryBuilderForm queryForm = null;
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			queryForm = (AsQueryBuilderForm) form;
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

//			qa.handleQuery(queryString, queryForm.getDdQueryString(),
//					primarySiteID); //commented by Jinran
			
			//Jinran added starts
			String selPros = request.getParameter("selProtocols"); //if empty, means select all
			if(selPros.equals("")){
				selPros = Constants.ALL_PROTOCOLS;
			}
			log.info("selected protocols: " + selPros);
			queryForm.setSelectedProtocols(selPros.split("#")); //set selProtocols and allProtocols fields, 
																//the delimiter is set "#" in AssessmentQuery.jsp
			String selVers = request.getParameter("selVersions"); //if empty, means select all
			if(selVers.equals("")){
				selVers = Constants.ALL_VERSIONS;
			}
			String[] selVersions = selVers.split("#");
			queryForm.setSelectedProVers(selVersions);
			
			String[] selectedExpsegs = getSelectedExpSegs(queryForm.getListExpSegments(),queryForm.getSelectedProtocols(), selVersions);
			queryForm.setSelectedSegments(selectedExpsegs);			
			String[] allExpsegs = getDistinctExpSegs(queryForm.getListExpSegments());
			queryForm.setAllSegments(allExpsegs);
			
			String seltypes = request.getParameter("selDTypes"); //if empty, means select all
			if(seltypes.equals("")){
				seltypes = Constants.ALL_TYPES;
			}
			log.info("selected data types: " + seltypes);
			String[] selDtypes = seltypes.split("#");
			queryForm.setSelectedDataTypes(selDtypes); //set selDataTypes fields, delimiter is set "#" in AssessmentQuery.jsp
			
			//get query type (e.q. assess&imaging, assess|imaging)
			String queryType = request.getParameter("queryType");
			
			//get query validated checkbox value, "validated", "notvalidated", "both"
			String isValidated = request.getParameter("validateText");
			queryForm.setStrValidated(isValidated);
			
			qa.handleQueryNewer(queryString, queryForm.getDdQueryString(),
					primarySiteID, allExpsegs, selectedExpsegs, selDtypes, 
					selVersions, queryForm.getExpSelector().getSelectedExpID(), 
					queryForm.getSelectedProtocols(), queryType, isValidated);				

			//Add assessment to asilist			
			String expName = new String();
			for(LabelValueBean lvb : queryForm.getExpSelector().getExperimentInfos()){				
				if(lvb.getValue().equals(Integer.toString(queryForm.getExpSelector().getSelectedExpID()))){
					expName = lvb.getLabel();
					break;
				}
			}			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();			
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
			if(expName.equals("All Experiments")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
			}else if(expName.equals("All Experiments without Regression")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
			}else{
				asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
			}					
						
			queryForm.deleteAssessment();
			for(AssessmentSelectionInfo asi : asiList){
				queryForm.addAssessment(asi);					
			}
			
			/*******************************************************************************************/
			/* Do genetics query part starts */
			/*******************************************************************************************/
			
			/*******************************************************************************************/
			/* Do genetics query part ends */
			/*******************************************************************************************/
				
			return mapping.findForward(Constants.FORWARD_RESULTS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			// clean state for next query
			if (queryForm != null) {
				queryForm.setDdQueryString(null);
				queryForm.setCaQueryString(null);
			}
		}
	}

	private String[] getDistinctExpSegs(List<Expsegment> listExpSegments) {		
		List<String> listAllDisExpsegs = new ArrayList<String>();
		
		try{
			for(Expsegment seg : listExpSegments){
				String name = "";
				if(seg.getName()!=null){
					name = seg.getName();
				}
				int index = Collections.binarySearch(listAllDisExpsegs, name);			
				if(index<0){
					listAllDisExpsegs.add(Math.abs(index)-1, name);
				}
			}
			
			int i = 0;
			String[] allExpsegs = new String[listAllDisExpsegs.size()];
			for(String s : listAllDisExpsegs){
				allExpsegs[i++] = s;
			}
			
			return allExpsegs;
			
		}catch(Exception e){
			log.debug(e.getMessage());
			return null;
		}
		
	}

	private String[] getSelectedExpSegs(List<Expsegment> list,
			String[] selectedProtocols, String[] selectedVersions) {
		boolean bAllVers = false;
		for(String sVer : selectedVersions){
			if(sVer.equals(Constants.ALL_VERSIONS)){
				bAllVers = true;
				break;
			}
		}
		
		List<String> listExpSeg = new ArrayList<String>();
		for(String s : selectedProtocols){
			if(s.equals(Constants.ALL_PROTOCOLS)){				
				if(bAllVers==true){
					for(Expsegment expseg : list){
						String name = "";
						if(expseg.getName()!=null){
							name = expseg.getName();
						}
						int idx = Collections.binarySearch(listExpSeg, name);
						if(idx<0){
							listExpSeg.add(Math.abs(idx)-1, name);	
						}																	
					}
				}else{
					for(Expsegment expseg : list){
						for(int i=0; i<selectedVersions.length;i++){
							if(selectedVersions[i].equals(expseg.getProtocolversion().toString())){
								String name = "";
								if(expseg.getName()!=null){
									name = expseg.getName();
								}
								int idx = Collections.binarySearch(listExpSeg, name);
								if(idx<0){
									listExpSeg.add(Math.abs(idx)-1, name);	
								}												
							}	
						}					
					}					
				}
				String[] selectedExpsegs = new String[listExpSeg.size()];
				int i = 0;
				for(String str : listExpSeg){
					selectedExpsegs[i++] = str;
				}
				return selectedExpsegs;
			}			
		}		
		
		listExpSeg = new ArrayList<String>();
		for(Expsegment expseg : list){
			for(String s : selectedProtocols){	
				if(expseg.getProtocolid().toLowerCase().equals(s.toLowerCase())){
					if(bAllVers==true){
						String name = "";
						if(expseg.getName()!=null){
							name = expseg.getName();
						}
						int idx = Collections.binarySearch(listExpSeg, name);
						if(idx<0){
							listExpSeg.add(Math.abs(idx)-1, name);	
						}
						continue;
					}

					for(int i=0; i<selectedVersions.length; i++){
						if(expseg.getProtocolversion().toString().equals(selectedVersions[i])){
							String name = "";
							if(expseg.getName()!=null){
								name = expseg.getName();
							}
							int index = Collections.binarySearch(listExpSeg, name);
							if(index<0){
								listExpSeg.add(Math.abs(index)-1, name);
							}					 							
						}
					}
				}
			}
		}
		int j = 0;
		String[] selectedExpsegs = new String[listExpSeg.size()];
		for(String s : listExpSeg){
			selectedExpsegs[j++] = s;
		}
		
		return selectedExpsegs;
	}

	public ActionForward multiSiteQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("**** multiSiteQuery");
		AsQueryBuilderForm queryForm = null;
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			queryForm = (AsQueryBuilderForm) form;
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

			//qa.handleMultisiteQuery(queryString, queryForm.getDdQueryString(),
			//		primarySiteID);
			
			//Jinran added starts
			String selPros = request.getParameter("selProtocols");
			queryForm.setSelectedProtocols(selPros.split("#")); //set selProtocols and allProtocols fields, 
																//the delimiter is set "#" in AssessmentQuery.jsp
			String selVers = request.getParameter("selVersions");
			String[] selVersions = selVers.split("#");
			queryForm.setSelectedProVers(selVersions);
			
			String[] selectedExpsegs = getSelectedExpSegs(queryForm.getListExpSegments(),queryForm.getSelectedProtocols(), selVersions);
			queryForm.setSelectedSegments(selectedExpsegs);			
			String[] allExpsegs = getDistinctExpSegs(queryForm.getListExpSegments());
			queryForm.setAllSegments(allExpsegs);
			
			String seltypes = request.getParameter("selDTypes");
			log.info("selected data types: " + seltypes);
			String[] selDtypes = seltypes.split("#");
			queryForm.setSelectedDataTypes(selDtypes); //set selDataTypes fields, delimiter is set "#" in AssessmentQuery.jsp
						
			qa.handleMultisiteQueryNew(queryString, queryForm.getDdQueryString(),
					primarySiteID, allExpsegs, selectedExpsegs, selDtypes, selVersions);				
			//Jinran added ends
			
			//Jinran added. Add assessment to asilist			
			String expName = new String();
			for(LabelValueBean lvb : queryForm.getExpSelector().getExperimentInfos()){				
				if(lvb.getValue().equals(Integer.toString(queryForm.getExpSelector().getSelectedExpID()))){
					expName = lvb.getLabel();
					break;
				}
			}			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();			
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
			if(expName.equals("All Experiments")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
			}else if(expName.equals("All Experiments without Regression")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
			}else{
				asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
			}
			queryForm.deleteAssessment();
			for(AssessmentSelectionInfo asi : asiList){
				queryForm.addAssessment(asi);					
			}	

			
			return mapping.findForward(Constants.FORWARD_RESULTS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			// clean state for next query
			if (queryForm != null) {
				queryForm.setDdQueryString(null);
				queryForm.setCaQueryString(null);
			}
		}

	}

	public ActionForward loadSavedQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService = null;
		try {
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			StoredQuerySelector sqs = queryForm.getSavedQuerySelector();

			IDBCache dbCache = ServiceFactory.getDBCache(dbID);

			log.info("selected query ID=" + sqs.getSelectedQueryID());
			JSONObject js = QueryWizardHelper.loadJSONQueryFromDB(ui,
					asService, sqs.getSelectedQueryID(), ui.getPerceivedName());
			
			QueryInfo qi = queryForm.getQueryInfo();

			Assertion.assertNotNull(qi);
			// System.out.println(js.toString(2));
			qi.jsonToQuery(js);

			//Jinran added
			String expName = new String();
			for(LabelValueBean lvb : queryForm.getExpSelector().getExperimentInfos()){
				if(lvb.getValue().equals(qi.getExpIDStr())){
					expName = lvb.getLabel();
					break;
				}
			}			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
			if(expName.equals("All Experiments")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
			}else if(expName.equals("All Experiments without Regression")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
			}else{
				asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
			}			
			qi.getAqi().setAsiList(asiList);		

			// set assessment query
			qi.prepareStoredQuery();

			ExperimentSelector expSelector = queryForm.getExpSelector();
			if (expSelector == null) {
				QueryWizardHelper.prepareExperimentSelector(ui, queryForm,
						dbCache);
				expSelector = queryForm.getExpSelector();
			}
			expSelector.setSelectedExpID(GenUtils.toInt(qi.getExpIDStr(), -1));
			
			// set panel index
			int panelIndex = 1;
			// get score info from stored query
			response.addCookie(new Cookie("assPanelIndex", "0"));
			if(js.has("asQPIList")){
				JSONArray jsQpi = js.getJSONArray("asQPIList");
				for(int jj = 0; jj<jsQpi.length(); jj++){
					if(jsQpi.getJSONObject(jj).has("score")){
						response.addCookie(new Cookie("assPanelIndex", String.valueOf(panelIndex++)));
					}
				}
			}
						
			/********* Jinran added for Imaging Query *****************/
			//QueryWizardHelper.prepareProtocolSel(ui, dbID, queryForm);
			QueryWizardHelper.prepareProtocolSel(ui, dbID, queryForm, qi);
			// make imaging panel visible
			response.addCookie(new Cookie("imgPanelIndex", "0"));
			if(js.has("protocols")){
				response.addCookie(new Cookie("imgPanelIndex", String.valueOf(panelIndex++)));
			}
			/**********************************************************/

			/********* Jinran added for Genetics Query portion ************/
			response.addCookie(new Cookie("genPanelIndex", "0"));
			
			/**************************************************************/
			
			int selectedExpSSId;				
			for(LabelValueBean lvb : queryForm.getExpSessionSel().getExperimentInfos()){				
				if(lvb.getLabel().equals(expName + " Sessions")){
					selectedExpSSId = Integer.valueOf(lvb.getValue());
					queryForm.getExpSessionSel().setSelectedExpSessionID(selectedExpSSId);
					break;
				}
			}
			
			
			return mapping.findForward(Constants.SUCCESS);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward saveQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService;
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			//Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);

			JSONObject js = new JSONObject(queryString);
			QueryInfo qi = queryForm.getQueryInfo();
			if (qi == null) {
				qi = new QueryInfo(AssessmentQueryInfo.initializeFromJSON(js));
				queryForm.setQueryInfo(qi);
			} else {
				if (qi.getAqi() == null) {
					qi.setAqi(AssessmentQueryInfo.initializeFromJSON(js));
				} else {
					qi.getAqi().updateQueryFromJSON(js);
				}
			}
			qi.prepareStoredQuery();

			SaveQueryForm sqForm = (SaveQueryForm) session
					.getAttribute(Constants.STORED_QUERY_FORM_KEY);
			if (sqForm != null) {
				sqForm.setDescription("");
				sqForm.getStoredQueryDescriptions().clear();
				sqForm.getStoredQueryIdDesc().clear(); //Jinran added
			} else {
				sqForm = new SaveQueryForm();
				session.setAttribute(Constants.STORED_QUERY_FORM_KEY, sqForm);
			}
			List<Storedquery> storedQueries = asService
					.getAvailableStoredQueries(ui, ui.getPerceivedName());
			for (Storedquery sq : storedQueries) {
				sqForm.addStoredQueryDescription(sq.getDescription());
				sqForm.addStoredQueryIdDesc(sq.getDescription(), sq.getUniqueid()); //Jinran added
			}
			
			sqForm.getSavedQuerySelector().setSelectedQueryID(queryForm.getSavedQuerySelector().getSelectedQueryID()); //pass selected queryId

			//Jinran added
			String selPros = request.getParameter("selProtocols");
			String selVers = request.getParameter("selVersions");
			String seltypes = request.getParameter("selDTypes");
			sqForm.setSaveProtocols(selPros);
			sqForm.setSaveVersions(selVers);
			sqForm.setSaveTypes(seltypes);
			
			String filterGenetics = request.getParameter("filterANDORGen");
			String filterAssess = request.getParameter("filterANDORAssess");
			String filterImaging = request.getParameter("filterANDORImg");
			
			sqForm.setFilterAssess(filterAssess);
			sqForm.setFilterGenetics(filterGenetics);
			sqForm.setFilterImaging(filterImaging);

			return mapping.findForward(Constants.SAVE_QUERY);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public ActionForward getScorecodes(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			System.out.println(":::: getScorecodes");
			HttpSession session = request.getSession(false);

			String asID = request.getParameter("asID");
			Assertion.assertNotNull(asID);
			String scoreName = request.getParameter("scoreName");
			Assertion.assertNotNull(scoreName);
			String key = asID + "_" + scoreName;
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			IDBCache dbCache = ServiceFactory.getDBCache(dbID);
			Map<String, List<Assessmentscorecode>> scoreCodeMap = dbCache
					.getScoreCodeMap(ui, false);
			JSONObject js = new JSONObject();
			js.put("asID", asID);
			js.put("scoreName", scoreName);
			List<Assessmentscorecode> scList = scoreCodeMap.get(key);
			if (scList != null) {
				js.put("hasEnums", true);
				JSONArray jsArr = new JSONArray();
				js.put("sci", jsArr);
				for (Assessmentscorecode asc : scList) {
					JSONObject scJs = new JSONObject();
					scJs.put("l", asc.getScorecodevalue());
					scJs.put("c", asc.getScorecode());
					jsArr.put(scJs);
				}
			} else {
				js.put("hasEnums", false);
			}
			response.setContentType("application/json");
			String jsonStr = js.toString();
			log.info("jsonStr:" + jsonStr);
			response.getOutputStream().println(jsonStr);
			return null;
		} catch (Exception x) {
			x.printStackTrace();
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public static Map<String, Experiment> toMap(List<Experiment> experiments) {
		Map<String, Experiment> map = new HashMap<String, Experiment>();
		for (Iterator<Experiment> iter = experiments.iterator(); iter.hasNext();) {
			Experiment exp = iter.next();
			map.put(exp.getUniqueid().toString(), exp);
		}
		return map;
	}
	
	/**
	 * Jinran added. Action when Experiments dropdown changes.
	 * @param mapping
	 * @param form
	 * @param request
	 * @param response
	 * @return
	 * @throws Exception
	 */
	public ActionForward changeExp(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {		
		String expName = new String();
		expName = request.getParameter("curExp");
		
		log.info("in changeExp, curExp: " + expName);
		
		//UserInfo ui = getUserInfo(request);
		HttpSession session = request.getSession(false);
		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
		IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
		Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
		String primarySiteID = dbID2SiteIDMap.get(dbID);
		
		List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
		if(expName.equals("All Experiments")){
			asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
		}else if(expName.equals("All Experiments without Regression")){
			asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
			expName = "All Experiments";
		}else{
			asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
		}		

		AsQueryBuilderForm asform = (AsQueryBuilderForm) form;
		asform.deleteAssessment();	
		
		QueryInfo qi = new QueryInfo(new AssessmentQueryInfo(asiList));
		asform.setQueryInfo(qi);
		
		//populate protocol selector
		List<Protocol> proList = new ArrayList<Protocol>();
		if(expName.equals("All Experiments")){
			proList = rds.getAllValidProtocols(primarySiteID); 	
		}else if(expName.equals("All Experiments without Regression")){
			proList = rds.getAllValidProtocols(primarySiteID); 
		}else{
			proList = rds.getProtocols(primarySiteID, expName); 	
		}				
		ProtocolSelector proSelector = new ProtocolSelector(proList);
		BigDecimal[] ids = new BigDecimal[1];
		ids[0] = BigDecimal.valueOf(-1);
		if(proSelector.getProtocolCols().size()>0){
			proSelector.setSelProtocolIds(ids);
		}
		if(proSelector.getProtocolVers().size()>0){
			proSelector.setSelProtocolVers(ids);
		}
		if(proSelector.getDataTypes().size()>0){
			proSelector.setSelDataTypes(ids);
		}
		asform.setProSelector(proSelector);
		
		//change Exp.Session Selector selected items		
		int selectedExpSSId;				
		for(LabelValueBean lvb : asform.getExpSessionSel().getExperimentInfos()){				
			if(lvb.getLabel().equals(expName + " Sessions")){
				selectedExpSSId = Integer.valueOf(lvb.getValue());
				asform.getExpSessionSel().setSelectedExpSessionID(selectedExpSSId);
				break;
			}
		}
		
		// populate Session Selector items
		IGeneticService geneService = ServiceFactory.getGeneticService(dbID);		
		Collection<GeneticSession> geneSessions = getGeneSessions(asform, geneService);		
		asform.getGeneticObj().setSsList(geneSessions);
		asform.getGeneticObj().setSelectedSS(BigDecimal.ZERO);
		
		//change ChipID Selector
		String sessionName = "";
		for(GeneticSession gSession : asform.getGeneticObj().getSsList()){
			sessionName = gSession.getSessionName();
			break;
		}
		populateChipIds(asform, geneService, sessionName);
		
		//change GenomeRelease Selector
		populateGenomeRelease(asform, geneService, sessionName);
				
		return mapping.findForward(Constants.SUCCESS);		
	}

	private void populateGenomeRelease(AsQueryBuilderForm asform,
			IGeneticService geneService, String sessionName) throws Exception {
		Collection<LabelValueBean> geneGenomeRelease;
		if(sessionName.equals("All")){
			geneGenomeRelease = geneService.getUniqueGenomeRelease();
		}else{
			geneGenomeRelease = geneService.getUniqueGenomeReleaseOnSession(sessionName);
		}
		asform.getGeneticObj().setUniqueGenomeRelease(geneGenomeRelease);
	}

	private void populateChipIds(AsQueryBuilderForm asform,
			IGeneticService geneService, String sessionName ) throws Exception {
		/*String sessionName = "";		
		for(GeneticSession gSession : asform.getGeneticObj().getSsList()){
			sessionName = gSession.getSessionName();
			break;
		}*/		
		Collection<GeneticChip> geneChips;
		if(sessionName.equals("All")){
			geneChips = geneService.getAllChips();
		}else{
			geneChips = geneService.getChipsOnSession(sessionName);	 	
		}				
		asform.getGeneticObj().setGeneChip(geneChips);
		/*return sessionName;*/
	}

	
	/*
	 * Populate Session dropdown, ChipId drp, and GenomeRelease drp when 
	 * Exp.Session drp changes selection
	 */
	public ActionForward changeExpSession(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {		
		String expSsName = new String();
		expSsName = request.getParameter("curExpSs");
		
		log.info("in changeExpSession, curExpSession: " + expSsName);
		
		HttpSession session = request.getSession(false);
		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
		AsQueryBuilderForm asform = (AsQueryBuilderForm) form;
		
		// populate Session Selector items
		IGeneticService geneService = ServiceFactory.getGeneticService(dbID);		
		Collection<GeneticSession> geneSessions = getGeneSessions(asform, geneService);		
		asform.getGeneticObj().setSsList(geneSessions);
		asform.getGeneticObj().setSelectedSS(BigDecimal.ZERO);
		
		String sessionName = "";
		for(GeneticSession gSession : asform.getGeneticObj().getSsList()){
			sessionName = gSession.getSessionName();
			break;
		}
		populateChipIds(asform, geneService, sessionName);		
		
		populateGenomeRelease(asform, geneService, sessionName);
		
		return mapping.findForward(Constants.SUCCESS);		
	}

	/*
	 * Populate ChipId and GenomeRelease drp when Session drp changes selection
	 */
	public ActionForward changeSession(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {		
		HttpSession session = request.getSession(false);
		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
		AsQueryBuilderForm asform = (AsQueryBuilderForm) form;
		
		// populate Session Selector items
		IGeneticService geneService = ServiceFactory.getGeneticService(dbID);		
		
		String sessionName = request.getParameter("curSs");
		
		populateChipIds(asform, geneService, sessionName);		
		
		populateGenomeRelease(asform, geneService, sessionName);
		
		return mapping.findForward(Constants.SUCCESS);		
	}

	
	/**
	 * Jinran added
	 * 
	 * Delete stored query from db 
	 * 
	 */
	public ActionForward deleteQuery(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IDBCache dbCache = null;
		try{
			// cancel delete action
			String cancel = request.getParameter("cancelDelete");
			log.info("cancelDelete: " + cancel);
			if(!cancel.equals("no")){
				return mapping.findForward(Constants.DELETE);
			}
			
			//use assessmentservice as interface to interact with db
			IAssessmentService asService = null;
			UserInfo ui = getUserInfo(request);
			
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			asService = ServiceFactory.getAssessmentService(dbID);
			
			String queryName = request.getParameter("queryName");
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			StoredQuerySelector sqs = queryForm.getSavedQuerySelector();			
			BigDecimal queryId = new BigDecimal(sqs.getSelectedQueryID());
			log.info("queryName: " + queryName + ". queryId: " + queryId);

			//delete stored query from db
			asService.deleteStoredAssessmentQuery(ui, queryId);

			//reload AssessmentQueryForm
			queryForm.clean();

			IAnalysisResultService ars = ServiceFactory.getAnalysisResultService(dbID);
			boolean supportAnalysisQuery = ars.hasAnalysisMetaData();
			queryForm.setSupportAnalysisQuery(supportAnalysisQuery);
			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();
			dbCache = ServiceFactory.getDBCache(dbID);
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);
			List<AssessmentSelectionInfo> asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); //Jinran added
			boolean supportAssessmentQuery = !asiList.isEmpty();
			queryForm.setSupportAssessmentQuery(supportAssessmentQuery);

			for (AssessmentSelectionInfo asi : asiList) {
				queryForm.addAssessment(asi);
			}
			QueryInfo qi = queryForm.getQueryInfo();
			if (qi == null) {
				qi = new QueryInfo(new AssessmentQueryInfo(asiList));
				queryForm.setQueryInfo(qi);
			} else {
				if (qi.getAqi() != null && qi.getAqi().hasQueryParts()) {
					qi.getAqi().resetAllSelected();
				}
			}

			// prepare the stored query summaries for this user
			QueryWizardHelper.prepareStoredQueryDescriptions(ui, asService, ui
					.getPerceivedName(), queryForm);

			QueryWizardHelper.prepareExperimentSelector(ui, queryForm, dbCache);

			return mapping.findForward(Constants.SUCCESS);		}
		catch(Exception x){
			return processExceptions(request, response, mapping, form, x);
		}
	}
	
	public ActionForward addSnp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
		throws Exception{
		try{
			String snpName = request.getParameter("snpgeneNameText");
			String snpValue = request.getParameter("snpgeneValueText");
			
			IGeneticService snpService = null;
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			snpService = ServiceFactory.getGeneticService(dbID);			
			
			BigDecimal sessionId = null;
			
			if(request.getParameter("sessionIdText")!=null){
				sessionId = BigDecimal.valueOf(Integer.valueOf(request.getParameter("sessionIdText")));
			}
			
			snpService.addSnpList(sessionId, snpName, snpValue);
			
			//bind to datagrid
			List<SnpList> snpList = snpService.getAllSnpList();
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			session.setAttribute("snpList", snpList);
			
			List<SnpList> allSnpList = snpService.getAllSnpList();
			SnpList noneSnpList = new SnpList();
			noneSnpList.setUniqueId(BigDecimal.valueOf(0));
			noneSnpList.setName("");
			noneSnpList.setList(null);
			allSnpList.add(0, noneSnpList);
			queryForm.getGeneticObj().setAllSnpListCols(allSnpList);
			
			return mapping.findForward(Constants.SUCCESS);
		}
		catch(Exception e){
			return processExceptions(request, response, mapping, form, e);
		}
	}

	public ActionForward addGeneList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
		throws Exception{
	try{
		String geneName = request.getParameter("snpgeneNameText");
		String geneValue = request.getParameter("snpgeneValueText");
		
		IGeneticService snpService = null;
		HttpSession session = request.getSession(false);
		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
		snpService = ServiceFactory.getGeneticService(dbID);			
		
		BigDecimal sessionId = null;
		
		if(request.getParameter("sessionIdText")!=null){
			sessionId = BigDecimal.valueOf(Integer.valueOf(request.getParameter("sessionIdText")));
		}
		
		snpService.addGeneList(sessionId, geneName, geneValue);
		
		//bind to datagrid
		List<GeneList> geneList = snpService.getAllGeneList();
		AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;					
		//queryForm.getGeneticObj().setGeneListCols(geneList);
		session.setAttribute("geneListCols", geneList);
		
		List<GeneList> allGeneListCols = snpService.getAllGeneList();
		GeneList noneGeneListCol = new GeneList();
		noneGeneListCol.setUniqueId(BigDecimal.valueOf(0));
		noneGeneListCol.setName("");
		noneGeneListCol.setList(null);
		allGeneListCols.add(0, noneGeneListCol);
		queryForm.getGeneticObj().setAllGeneListCols(allGeneListCols);
		
		return mapping.findForward(Constants.SUCCESS);
	}
	catch(Exception e){
		return processExceptions(request, response, mapping, form, e);
	}
}

	public ActionForward deleteSnpList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
		throws Exception {
		try{
			String snpName = request.getParameter("snpgeneNameText");			
			
			IGeneticService snpService = null;
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			snpService = ServiceFactory.getGeneticService(dbID);			
				
			snpService.deleteSnpList(snpName);
			
			//bind to datagrid
			List<SnpList> snpList = snpService.getAllSnpList();
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			//queryForm.setSnpListCols(snpList);
			//queryForm.getGeneticObj().setSnpListCols(snpList);
			
			List<SnpList> allSnpList = snpService.getAllSnpList();
			SnpList noneSnpList = new SnpList();
			noneSnpList.setUniqueId(BigDecimal.valueOf(0));
			noneSnpList.setName("");
			noneSnpList.setList(null);
			allSnpList.add(0, noneSnpList);
			queryForm.getGeneticObj().setAllSnpListCols(allSnpList);
			
			session.setAttribute("snpList", snpList);			
	
			return mapping.findForward(Constants.SUCCESS);
		}
		catch(Exception e){
			return processExceptions(request, response, mapping, form, e);
		}
	}
	
	public ActionForward deleteGeneList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
		throws Exception {
	try{
		String geneName = request.getParameter("snpgeneNameText");			
		
		IGeneticService snpService = null;
		HttpSession session = request.getSession(false);
		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
		snpService = ServiceFactory.getGeneticService(dbID);			
			
		snpService.deleteGeneList(geneName);
		
		//bind to datagrid
		List<GeneList> geneList = snpService.getAllGeneList();
		AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
		//queryForm.setSnpListCols(snpList);
		//queryForm.getGeneticObj().setGeneListCols(geneList);
		List<GeneList> allGeneListCols = snpService.getAllGeneList();
		GeneList noneGeneListCol = new GeneList();
		noneGeneListCol.setUniqueId(BigDecimal.valueOf(0));
		noneGeneListCol.setName("");
		noneGeneListCol.setList(null);
		allGeneListCols.add(0, noneGeneListCol);
		queryForm.getGeneticObj().setAllGeneListCols(allGeneListCols);
		
		session.setAttribute("geneListCols", geneList);			

		return mapping.findForward(Constants.SUCCESS);
	}
	catch(Exception e){
		return processExceptions(request, response, mapping, form, e);
	}
}

	public ActionForward updateSnp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
			throws Exception{
		try{
			String oldSnpName = request.getParameter("oldSnpGeneNameText");
			String snpName = request.getParameter("snpgeneNameText");
			String snpValue = request.getParameter("snpgeneValueText");
			
			
			IGeneticService snpService = null;
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			snpService = ServiceFactory.getGeneticService(dbID);			
			
			BigDecimal sessionId = null;
			if(request.getParameter("sessionIdText")!=null){
				sessionId = BigDecimal.valueOf(Integer.valueOf(request.getParameter("sessionIdText")));
			}
			
			snpService.updateSnpList(oldSnpName, sessionId, snpName, snpValue);
			
			//bind to datagrid
			List<SnpList> snpList = snpService.getAllSnpList();
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			session.setAttribute("snpList", snpList);		
			
			List<SnpList> allSnpList = snpService.getAllSnpList();
			SnpList noneSnpList = new SnpList();
			noneSnpList.setUniqueId(BigDecimal.valueOf(0));
			noneSnpList.setName("");
			noneSnpList.setList(null);
			allSnpList.add(0, noneSnpList);
			queryForm.getGeneticObj().setAllSnpListCols(allSnpList);
			
			return mapping.findForward(Constants.SUCCESS);
		}
		catch(Exception e){
			return processExceptions(request, response, mapping, form, e);
		}
	}
	
	public ActionForward updateGeneList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
		throws Exception{
		try{
			String oldGeneName = request.getParameter("oldSnpGeneNameText");
			String geneName = request.getParameter("snpgeneNameText");
			String geneValue = request.getParameter("snpgeneValueText");
			
			
			IGeneticService snpService = null;
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			snpService = ServiceFactory.getGeneticService(dbID);			
			
			BigDecimal sessionId = null;
			if(request.getParameter("sessionIdText")!=null){
				sessionId = BigDecimal.valueOf(Integer.valueOf(request.getParameter("sessionIdText")));
			}
			
			snpService.updateGeneList(oldGeneName, sessionId, geneName, geneValue);
			
			//bind to datagrid
			List<GeneList> geneList = snpService.getAllGeneList();
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			//queryForm.getGeneticObj().setGeneListCols(geneList);
			session.setAttribute("geneListCols", geneList);
			
			List<GeneList> allGeneListCols = snpService.getAllGeneList();
			GeneList noneGeneListCol = new GeneList();
			noneGeneListCol.setUniqueId(BigDecimal.valueOf(0));
			noneGeneListCol.setName("");
			noneGeneListCol.setList(null);
			allGeneListCols.add(0, noneGeneListCol);
			queryForm.getGeneticObj().setAllGeneListCols(allGeneListCols);
			
			return mapping.findForward(Constants.SUCCESS);
		}
		catch(Exception e){
			return processExceptions(request, response, mapping, form, e);
		}
	}


	public ActionForward deleteSession(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response)
			throws Exception {		
		try{
			// cancel delete action
			String cancel = request.getParameter("cancelDelete");
			log.info("cancelDelete: " + cancel);
			if(!cancel.equals("no")){
				return mapping.findForward(Constants.DELETE);
			}
		
			IGeneticService sessionService = null;
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			sessionService = ServiceFactory.getGeneticService(dbID);			
			
			String sessionName = request.getParameter("sessionIdText");
			
			sessionService.deleteSession(sessionName);
			
			show(mapping, form, request, response);

			return mapping.findForward(Constants.SUCCESS);		
		}
		catch(Exception x){
			return processExceptions(request, response, mapping, form, x);
		}	
	}

	public ActionForward queryGenetics(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("**** queryGenetics");
		AsQueryBuilderForm queryForm = null;
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			queryForm = (AsQueryBuilderForm) form;
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

//			qa.handleQuery(queryString, queryForm.getDdQueryString(),
//					primarySiteID);
			
			//Jinran added starts
			String selPros = request.getParameter("selProtocols"); //if empty, means select all
			if(selPros.equals("")){
				selPros = Constants.ALL_PROTOCOLS;
			}
			log.info("selected protocols: " + selPros);
			queryForm.setSelectedProtocols(selPros.split("#")); //set selProtocols and allProtocols fields, 
																//the delimiter is set "#" in AssessmentQuery.jsp
			String selVers = request.getParameter("selVersions"); //if empty, means select all
			if(selVers.equals("")){
				selVers = Constants.ALL_VERSIONS;
			}
			String[] selVersions = selVers.split("#");
			queryForm.setSelectedProVers(selVersions);
			
			String[] selectedExpsegs = getSelectedExpSegs(queryForm.getListExpSegments(),queryForm.getSelectedProtocols(), selVersions);
			queryForm.setSelectedSegments(selectedExpsegs);			
			String[] allExpsegs = getDistinctExpSegs(queryForm.getListExpSegments());
			queryForm.setAllSegments(allExpsegs);
			
			String seltypes = request.getParameter("selDTypes"); //if empty, means select all
			if(seltypes.equals("")){
				seltypes = Constants.ALL_TYPES;
			}
			log.info("selected data types: " + seltypes);
			String[] selDtypes = seltypes.split("#");
			queryForm.setSelectedDataTypes(selDtypes); //set selDataTypes fields, delimiter is set "#" in AssessmentQuery.jsp
			
			//get query type (e.q. assess&imaging, assess|imaging)
			String queryType = request.getParameter("queryType");
			
			qa.handleQueryNew(queryString, queryForm.getDdQueryString(),
					primarySiteID, allExpsegs, selectedExpsegs, selDtypes, 
					selVersions, queryForm.getExpSelector().getSelectedExpID(), queryForm.getSelectedProtocols(), queryType);				

			
			//Jinran added. Add assessment to asilist			
			String expName = new String();
			for(LabelValueBean lvb : queryForm.getExpSelector().getExperimentInfos()){				
				if(lvb.getValue().equals(Integer.toString(queryForm.getExpSelector().getSelectedExpID()))){
					expName = lvb.getLabel();
					break;
				}
			}			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();			
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
			if(expName.equals("All Experiments")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
			}else if(expName.equals("All Experiments without Regression")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
			}else{
				asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
			}
			queryForm.deleteAssessment();
			for(AssessmentSelectionInfo asi : asiList){
				queryForm.addAssessment(asi);					
			}
			
			/*******************************************************************************************/
			/* Do genetics query part starts */
			/*******************************************************************************************/
			IGeneticService geneService = null;				
			geneService = ServiceFactory.getGeneticService(dbID);
			
			ArrayList<String> listSubjectIds = new ArrayList<String>();
			//queryForm's summaryList contains subjectId info. use these when do genetics part query
			if(queryForm.getQsList()!=null){
				//log.info("subject ids: " );
				for(QuerySummary qs : queryForm.getQsList()){
					listSubjectIds.add(qs.getSubjectID());					
					//log.info("Id: " + qs.getSubjectID());
				}				
			}else{
				ResultSet rsSubj = geneService.getAllSubjectIds(expName);
				if(rsSubj!=null){
					while(rsSubj.next()){
						listSubjectIds.add(rsSubj.getString("subjectid"));
						//log.info("Id: " + rsSubj.getString("subjectid"));
					}
				}
			}
			
			boolean doGeneticQuery = false;
			for(boolean bResult : queryForm.getResults()){
				if(bResult){
					doGeneticQuery = bResult;
					break;
				}
			}
			// conduct genetic query b/c at least on of the get fields is checked.
			if(doGeneticQuery){
				GeneQueryResults geneQueryResults = new GeneQueryResults();
				
				//set all check boxes in bean form
				setCheckBoxValues(request, queryForm);			
					
				//build genetic query string
				String geneQueryString = geneQueryResults.buildGeneticQueryString(queryForm, listSubjectIds, true, "");
				if(geneQueryString==null){
					return mapping.findForward(Constants.SUCCESS);
				}
				
				//query database to get data back				
				ResultSet rs = geneService.getDataFromGeneTables(geneQueryString);
									
				ArrayList<GeneQueryResults> list = new ArrayList<GeneQueryResults>(); 
				list = geneQueryResults.retrieveGeneticQueryResults(geneQueryString, rs);		

				session.setAttribute("listResults", list);
				
				queryForm.setGeneQResults(geneQueryResults);
			}		
			/*******************************************************************************************/
			/* Do genetics query part ends */
			/*******************************************************************************************/		
			
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			// clean state for next query
			if (queryForm != null) {
				queryForm.setDdQueryString(null);
				queryForm.setCaQueryString(null);
			}
		}
	}

	private void setCheckBoxValues(HttpServletRequest request,
			AsQueryBuilderForm queryForm) {
		String checkAll = "chromAll";
		String sCheck = request.getParameter(checkAll);
		if(sCheck!=null && sCheck.equals("true")){
			queryForm.setChromAll(true);				
		}else{
			queryForm.setChromAll(false);				
		}				
		
		String chromoArr[] = new String[26];
		boolean bChromoArr[] = new boolean[26];
		for(int i=0; i<26; i++){
			chromoArr[i] = "chromArr[" + i + "]";
			String schr = request.getParameter(chromoArr[i]);
			if(schr!=null && schr.equals("true")){
				bChromoArr[i] = true;
			}else{
				bChromoArr[i] = false;
			}
		}
		queryForm.setChromArr(bChromoArr);
		
		String sGetResults[] = new String[8];
		boolean bGetResults[] = new boolean[8];
		for(int i=0; i<8; i++){
			sGetResults[i] = "results[" + i + "]";
			String schr = request.getParameter(sGetResults[i]);
			if(schr!=null && schr.equals("true")){
				bGetResults[i] = true;
			}else{
				bGetResults[i] = false;
			}
		}
		queryForm.setResults(bGetResults);
	}

	public ActionForward exportMap(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("**** export MAP");
		AsQueryBuilderForm queryForm = null;		
		
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			queryForm = (AsQueryBuilderForm) form;
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

//			qa.handleQuery(queryString, queryForm.getDdQueryString(),
//					primarySiteID);

			//Jinran added starts
			String selPros = request.getParameter("selProtocols"); //if empty, means select all
			if(selPros.equals("")){
				selPros = Constants.ALL_PROTOCOLS;
			}
			log.info("selected protocols: " + selPros);
			queryForm.setSelectedProtocols(selPros.split("#")); //set selProtocols and allProtocols fields, 
																//the delimiter is set "#" in AssessmentQuery.jsp
			String selVers = request.getParameter("selVersions"); //if empty, means select all
			if(selVers.equals("")){
				selVers = Constants.ALL_VERSIONS;
			}
			String[] selVersions = selVers.split("#");
			queryForm.setSelectedProVers(selVersions);
			
			String[] selectedExpsegs = getSelectedExpSegs(queryForm.getListExpSegments(),queryForm.getSelectedProtocols(), selVersions);
			queryForm.setSelectedSegments(selectedExpsegs);			
			String[] allExpsegs = getDistinctExpSegs(queryForm.getListExpSegments());
			queryForm.setAllSegments(allExpsegs);
			
			String seltypes = request.getParameter("selDTypes"); //if empty, means select all
			if(seltypes.equals("")){
				seltypes = Constants.ALL_TYPES;
			}
			log.info("selected data types: " + seltypes);
			String[] selDtypes = seltypes.split("#");
			queryForm.setSelectedDataTypes(selDtypes); //set selDataTypes fields, delimiter is set "#" in AssessmentQuery.jsp
			
			//get query type (e.q. assess&imaging, assess|imaging)
			String queryType = request.getParameter("queryType");
			
			qa.handleQueryNew(queryString, queryForm.getDdQueryString(),
					primarySiteID, allExpsegs, selectedExpsegs, selDtypes, 
					selVersions, queryForm.getExpSelector().getSelectedExpID(), queryForm.getSelectedProtocols(), queryType);				

			//Jinran added. Add assessment to asilist			
			String expName = new String();
			for(LabelValueBean lvb : queryForm.getExpSelector().getExperimentInfos()){				
				if(lvb.getValue().equals(Integer.toString(queryForm.getExpSelector().getSelectedExpID()))){
					expName = lvb.getLabel();
					break;
				}
			}			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();			
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
			if(expName.equals("All Experiments")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
			}else if(expName.equals("All Experiments without Regression")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
			}else{
				asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
			}
			queryForm.deleteAssessment();
			for(AssessmentSelectionInfo asi : asiList){
				queryForm.addAssessment(asi);					
			}
			
			/*******************************************************************************************/
			/* Do genetics query part starts */
			/*******************************************************************************************/
			IGeneticService geneService = null;				
			geneService = ServiceFactory.getGeneticService(dbID);
			
			ArrayList<String> listSubjectIds = new ArrayList<String>();
			//queryForm's summaryList contains subjectId info. use these when do genetics part query
			if(queryForm.getQsList()!=null){
				//log.info("subject ids: " );
				for(QuerySummary qs : queryForm.getQsList()){
					listSubjectIds.add(qs.getSubjectID());					
					//log.info("Id: " + qs.getSubjectID());
				}				
			}else{
				ResultSet rsSubj = geneService.getAllSubjectIds(expName);
				if(rsSubj!=null){
					while(rsSubj.next()){
						listSubjectIds.add(rsSubj.getString("subjectid"));
						//log.info("Id: " + rsSubj.getString("subjectid"));
					}
				}
			}
			
			boolean doGeneticQuery = false;
			for(boolean bResult : queryForm.getResults()){
				if(bResult){
					doGeneticQuery = bResult;
					break;
				}
			}
			
			// conduct genetic query no matter any "Get" field is checked or not
			doGeneticQuery = true;    // columns in MAP and PED file are fixed. Output not depending on "Get" field
			if(doGeneticQuery){
				GeneQueryResults geneQueryResults = new GeneQueryResults();
				
//				java.text.DateFormat dateFormat = new java.text.SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
//				java.util.Date date = new java.util.Date();
//				log.info("Start exporting MAP file @time: " + dateFormat.format(date));
				
				//build query string to get record count
				String queryRecordCount = geneQueryResults.buildQueryGetRecordCount(queryForm, listSubjectIds, Constants.MAP_FILE);
				if(queryRecordCount==null){
					return mapping.findForward(Constants.SUCCESS);
				}
				
				String geneQueryString = geneQueryResults.buildGeneticQueryString(queryForm, listSubjectIds,true, Constants.MAP_FILE);
				if(geneQueryString==null){
					return mapping.findForward(Constants.SUCCESS);
				}
				
				String id = String.valueOf(System.currentTimeMillis());				
				File file = JobScheduler.getInstance().getGeneExportFileForJob(ui.getName(), id, Constants.MAP_FILE);
								
				GeneExportFileJob geneExportMAPJob = 
					new GeneExportFileJob(Constants.MAP_FILE, "", geneService, "", queryRecordCount, geneQueryString,
							file.getAbsolutePath(), dbID, ui, id);

				JobScheduler scheduler = JobScheduler.getInstance();
				scheduler.addJob(geneExportMAPJob);
			}		
			/*******************************************************************************************/
			/* Do genetics query part ends */
			/*******************************************************************************************/		
			
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			// clean state for next query
			if (queryForm != null) {
				queryForm.setDdQueryString(null);
				queryForm.setCaQueryString(null);
			}			
		}
	}


	public ActionForward exportPed(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("**** export PED");
		AsQueryBuilderForm queryForm = null;
		
		try {
			UserInfo ui = getUserInfo(request);
			String queryString = request.getParameter("queryString");
			Assertion.assertNotNull(queryString);
			log.info("queryString:" + queryString);

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			queryForm = (AsQueryBuilderForm) form;
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);

			QueryAggregator qa = new QueryAggregator(dbID, ui, queryForm);

//			qa.handleQuery(queryString, queryForm.getDdQueryString(),
//					primarySiteID);
			
			//Jinran added starts
			String selPros = request.getParameter("selProtocols"); //if empty, means select all
			if(selPros.equals("")){
				selPros = Constants.ALL_PROTOCOLS;
			}
			log.info("selected protocols: " + selPros);
			queryForm.setSelectedProtocols(selPros.split("#")); //set selProtocols and allProtocols fields, 
																//the delimiter is set "#" in AssessmentQuery.jsp
			String selVers = request.getParameter("selVersions"); //if empty, means select all
			if(selVers.equals("")){
				selVers = Constants.ALL_VERSIONS;
			}
			String[] selVersions = selVers.split("#");
			queryForm.setSelectedProVers(selVersions);
			
			String[] selectedExpsegs = getSelectedExpSegs(queryForm.getListExpSegments(),queryForm.getSelectedProtocols(), selVersions);
			queryForm.setSelectedSegments(selectedExpsegs);			
			String[] allExpsegs = getDistinctExpSegs(queryForm.getListExpSegments());
			queryForm.setAllSegments(allExpsegs);
			
			String seltypes = request.getParameter("selDTypes"); //if empty, means select all
			if(seltypes.equals("")){
				seltypes = Constants.ALL_TYPES;
			}
			log.info("selected data types: " + seltypes);
			String[] selDtypes = seltypes.split("#");
			queryForm.setSelectedDataTypes(selDtypes); //set selDataTypes fields, delimiter is set "#" in AssessmentQuery.jsp
			
			//get query type (e.q. assess&imaging, assess|imaging)
			String queryType = request.getParameter("queryType");
			
			qa.handleQueryNew(queryString, queryForm.getDdQueryString(),
					primarySiteID, allExpsegs, selectedExpsegs, selDtypes, 
					selVersions, queryForm.getExpSelector().getSelectedExpID(), queryForm.getSelectedProtocols(), queryType);				

			
			//Jinran added. Add assessment to asilist			
			String expName = new String();
			for(LabelValueBean lvb : queryForm.getExpSelector().getExperimentInfos()){				
				if(lvb.getValue().equals(Integer.toString(queryForm.getExpSelector().getSelectedExpID()))){
					expName = lvb.getLabel();
					break;
				}
			}			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();			
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
			if(expName.equals("All Experiments")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
			}else if(expName.equals("All Experiments without Regression")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
			}else{
				asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
			}
			queryForm.deleteAssessment();
			for(AssessmentSelectionInfo asi : asiList){
				queryForm.addAssessment(asi);					
			}
			
			/*******************************************************************************************/
			/* Do genetics query part starts */
			/*******************************************************************************************/
			IGeneticService geneService = null;				
			geneService = ServiceFactory.getGeneticService(dbID);
			
			ArrayList<String> listSubjectIds = new ArrayList<String>();
			//queryForm's summaryList contains subjectId info. use these when do genetics part query
			if(queryForm.getQsList()!=null){
				for(QuerySummary qs : queryForm.getQsList()){
					listSubjectIds.add(qs.getSubjectID());					
				}				
			}else{
				ResultSet rsSubj = geneService.getAllSubjectIds(expName);
				if(rsSubj!=null){
					while(rsSubj.next()){
						listSubjectIds.add(rsSubj.getString("subjectid"));
					}
				}
			}
			
			boolean doGeneticQuery = false;
			for(boolean bResult : queryForm.getResults()){
				if(bResult){
					doGeneticQuery = bResult;
					break;
				}
			}
			// conduct genetic query no matter any "Get" field is checked or not
			doGeneticQuery = true;    // columns in MAP and PED file are fixed. Output not depending on "Get" field
			if(doGeneticQuery){
				GeneQueryResults geneQueryResults = new GeneQueryResults();
				
				//set all check boxes in bean form
				setCheckBoxValues(request, queryForm);				

				//build query string to get record count
				String queryRecordCountPED = geneQueryResults.buildQueryGetRecordCount(queryForm, listSubjectIds, Constants.PED_FILE);
				if(queryRecordCountPED==null){
					return mapping.findForward(Constants.SUCCESS);
				}				
				String geneQueryStringPED = geneQueryResults.buildGeneticQueryString(queryForm, listSubjectIds,true, Constants.PED_FILE);
				if(geneQueryStringPED==null){
					return mapping.findForward(Constants.SUCCESS);
				}
				
				String queryRecordCountMAP = geneQueryResults.buildQueryGetRecordCount(queryForm, listSubjectIds, Constants.MAP_FILE);
				if(queryRecordCountMAP==null){
					return mapping.findForward(Constants.SUCCESS);
				}
				String geneQueryStringMAP = geneQueryResults.buildGeneticQueryString(queryForm, listSubjectIds, true, Constants.MAP_FILE);
				if(geneQueryStringMAP==null){
					return mapping.findForward(Constants.SUCCESS);
				}
				
				String id = String.valueOf(System.currentTimeMillis());				
				//File file = JobScheduler.getInstance().getGeneExportFileForJob(ui.getName(), id, Constants.PED_FILE.toLowerCase());
				File file = JobScheduler.getInstance().getGeneExportFileForJob(ui.getName(), id, "tar");
				
				GeneExportFileJob geneExportPEDJob = 
					new GeneExportFileJob(Constants.PED_FILE, queryRecordCountPED, geneService, geneQueryStringPED, 
							queryRecordCountMAP, geneQueryStringMAP, file.getAbsolutePath(), dbID, ui, id);

				JobScheduler scheduler = JobScheduler.getInstance();
				scheduler.addJob(geneExportPEDJob);
			}		
			/*******************************************************************************************/
			/* Do genetics query part ends */
			/*******************************************************************************************/		
			
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		} finally {
			// clean state for next query
			if (queryForm != null) {
				queryForm.setDdQueryString(null);
				queryForm.setCaQueryString(null);
			}			
		}
	}
	
	/*
	 * This function will direct user to Batch Query Submission page;
	 * It should retrieve all subjects in the selected experiment both IsValidated or NotValidated,
	 * and store into QuerySummary List
	 */
	public ActionForward showBatchQueryForm(ActionMapping mapping,
			ActionForm form, HttpServletRequest request,
			HttpServletResponse response) throws Exception {
		try {
			UserInfo ui = getUserInfo(request);
			getUserInfo(request);
			HttpSession session = request.getSession(false);
			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) form;
			
			//added
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			Map<String, String> dbID2SiteIDMap = CacheUtils.getDBID2SiteIDMap();
			String primarySiteID = dbID2SiteIDMap.get(dbID);
			//Add assessment to asilist			
			String expName = new String();
			for(LabelValueBean lvb : queryForm.getExpSelector().getExperimentInfos()){				
				if(lvb.getValue().equals(Integer.toString(queryForm.getExpSelector().getSelectedExpID()))){
					expName = lvb.getLabel();
					break;
				}
			}			
			IRemoteDBServices rds = ServiceFactory.getRemoteDBServices();			
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>();
			if(expName.equals("All Experiments")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 	
			}else if(expName.equals("All Experiments without Regression")){
				asiList = rds.getAllValidAssessmentsWithScores(primarySiteID); 
			}else{
				asiList = rds.getAssessmentsWithScoresOnExp(primarySiteID, expName); 	
			}						
			queryForm.deleteAssessment();
			for(AssessmentSelectionInfo asi : asiList){
				queryForm.addAssessment(asi);					
			}
			
			List<AssessmentSelectionInfo> newAsiList = new ArrayList<AssessmentSelectionInfo>(
					asiList.size());
			for (AssessmentSelectionInfo asi : asiList) {
				AssessmentSelectionInfo newAsi = new AssessmentSelectionInfo(
						asi, false, false);
				newAsiList.add(newAsi);
			}
			BatchQueryForm bqForm = new BatchQueryForm();
			bqForm.setAsiList(newAsiList);

			bqForm.setBatchQueryAll(true);
			bqForm.setIsValidated(Constants.BothValidAndInvalid);

			IAssessmentService asService = ServiceFactory.getAssessmentService(dbID);
			
			List<SubjectAsScoreValueSummary> summaryList = 
				asService.batchQueryForAll(ui, queryForm.getExpSelector().getSelectedExpID(),primarySiteID);
			
			List<QuerySummary> qsList = new ArrayList<QuerySummary>();
			
			for (SubjectAsScoreValueSummary ss: summaryList) {
				AssessmentResultSummary ars = new AssessmentResultSummary();
				ars.setSiteID(ss.getSiteID());
				
				QuerySummary qs = new QuerySummary(ss.getSubjectID(), String.valueOf(ss.getExperimentID()));	         
				qs.setArs(ars);
		        qsList.add(qs);
			}
			queryForm.setQsList(qsList);
			
			session.setAttribute(Constants.BATCHQUERY_FORM_KEY, bqForm);
			return mapping.findForward("show_bq");
		} catch (Exception x) {
			log.error(x);
			return processExceptions(request, response, mapping, form, x);
		}
	}
	
	public static class GeneExportFileJob implements IJob{
		protected String fileType;
		protected IGeneticService geneService;
		protected String resultsFile;
		protected boolean canceled = false;
		protected String dbID;
		protected UserInfo ui;
		protected String id;	
		protected String geneQueryStringPED;
		protected String geneQueryStringMAP;
		protected String queryRecordCountPED;
		protected String queryRecordCountMAP;
		
		protected long recordCountMAP=0;
		protected long recordCountPED=0;
		protected long offSetMAP = 0;
		protected long offSetPED = 0;
		
		private Map<Integer, String> lookupMapSnp = new HashMap<Integer, String>();
		private Map<Long, String> lookupMapPosSnp = new HashMap<Long, String>(); //key is position, value is snpname
		
		private LinkedList<Long> listPos = new LinkedList<Long>();
		
		//private Log log = LogFactory.getLog(AssessmentQueryAction.class);
		private Log log = LogFactory.getLog(GeneExportFileJob.class);
		
		public GeneExportFileJob(String filetype, String queryRecordCountPED, IGeneticService geneService, 
				String geneQueryPED, String queryRecordCountMAP, String geneQueryMAP, String resultsFile, 
				String dbID, UserInfo ui, String id){
			super();			
			this.fileType = filetype;
			this.geneService = geneService;
			this.queryRecordCountPED = queryRecordCountPED;			
			this.geneQueryStringPED = geneQueryPED;
			this.queryRecordCountMAP = queryRecordCountMAP;			
			this.geneQueryStringMAP = geneQueryMAP;
			this.resultsFile = resultsFile;
			this.dbID = dbID;
			this.ui = ui;
			this.id = id;
		}
		
		@Override
		public String getID() {
			return id;
		}

		@Override
		public String getUser() {
			return ui.getPerceivedName();
		}

		@Override
		public String getType() {
			return "Exporting Genetics File";
		}

		@Override
		public String getDescription() {
			if(fileType.equals(Constants.PED_FILE)){
				return "PED and MAP files tar ball";
			}else if(fileType.equals(Constants.MAP_FILE)){
				return "MAP files";
			}else
				return "";
		}

		@Override
		public void execute() throws JobException {
			try{	
				//handle MAP file
				if(queryRecordCountMAP.length()>0){
					//get total number of MAP records from db and calculate offset
					ResultSet rsRecordCountMAP = null;
					rsRecordCountMAP = geneService.getDataFromGeneTables(queryRecordCountMAP);
					if(rsRecordCountMAP.next()){
						recordCountMAP = rsRecordCountMAP.getLong(1);
					}									
					offSetMAP = recordCountMAP/Constants.QUERY_OFFSET;
					if(recordCountMAP%Constants.QUERY_OFFSET>0){
						offSetMAP++;
					}
				}				
				
				//handle PED file
				if(queryRecordCountPED.length()>0){
					//get total number of MAP records from db and calculate offset
					ResultSet rsRecordCountPED = null;
					rsRecordCountPED = geneService.getDataFromGeneTables(queryRecordCountPED);
					if(rsRecordCountPED.next()){
						recordCountPED = rsRecordCountPED.getLong(1);
					}					
					offSetPED = recordCountPED/Constants.QUERY_OFFSET;
					if(recordCountPED%Constants.QUERY_OFFSET>0){
						offSetPED++;
					}
				}				
			}
			catch(Exception e){
				throw new JobException(e);
			}
			
		}

		@Override
		public void saveResults(File file) throws JobException {
			try{
				//query database to get data back
				if(fileType.equals(Constants.PED_FILE)){
					File mapFile = new File(file.getPath().substring(0, file.getPath().lastIndexOf(".")) + "." + Constants.MAP_FILE);
					File pedFile = new File(file.getPath().substring(0, file.getPath().lastIndexOf(".")) + "." + Constants.PED_FILE);
					
					//handle MAP file
					for(long i=0; i<offSetMAP; i++){
						List<ClsFileDataRow> dataRowList = new LinkedList<ClsFileDataRow>();						
						
						java.text.DateFormat format = new java.text.SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
						java.util.Date date1 = new java.util.Date();
						log.info("\n Running MAP query...");						
						ResultSet rs = geneService.createRSForMAPPEDFile(geneQueryStringMAP, i);						
						java.util.Date date2 = new java.util.Date();
						TimeDuration td = TimeCategory.minus(date2, date1);
						log.info("MAP query takes " +   td.toMilliseconds());						
												
						log.info("Running addMapDataRow...");
						BatchQueryHelper.addMapDataRow(dataRowList,rs);						
						date1 = new java.util.Date();
						log.info("AddMapDataRow takes " +  TimeCategory.minus(date1, date2).toMilliseconds());
						
						log.info("Running hashmap loop...");
						//add position and snpname to a HashMap						
						for(int j=0; j<dataRowList.size(); j++){
//							lookupMapPosSnp.put(Long.valueOf(dataRowList.get(j).getPosition()), dataRowList.get(j).getRs());
							listPos.add(Long.valueOf(dataRowList.get(j).getPosition()));  //faster
						}						
						date2 = new java.util.Date();
						log.info("Hashmap loop takes " +  TimeCategory.minus(date2,date1).toMilliseconds());
						
						log.info("Running write to MAP file...");						
						if(!BatchQueryHelper.writeMAPFile2(mapFile, dataRowList)){
							throw new JobException();
						}
						date1 = new java.util.Date();
						log.info("Write to MAP file takes " +  TimeCategory.minus(date1,date2).toMilliseconds());
						
						rs.close();
						dataRowList.clear();						
					}					
					
					//sort hashmap by position using TreeMap
//					int k = 0;
//
//					Map<Long, String> sortedMap = new TreeMap<Long, String>(lookupMapPosSnp);					
//					for(Long key : sortedMap.keySet()){
//						lookupMapSnp.put(k, sortedMap.get(key));
//						k++;
//					}		
					
					Collections.sort(listPos);  //faster
					
					//handle PED file
					for(long i=0; i<offSetPED; i++){
						List<ClsFileDataRow> dataRowList = new LinkedList<ClsFileDataRow>();						
						
						//java.text.DateFormat format = new java.text.SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
						java.util.Date date1 = new java.util.Date();
						log.info("\n Running PED query...");						
						ResultSet rs = geneService.createRSForMAPPEDFile(geneQueryStringPED, i);
						java.util.Date date2 = new java.util.Date();
						log.info("PED query takes " +  TimeCategory.minus(date2,date1).toMilliseconds());
												
						log.info("Running addPEDDataRow... " );
//						BatchQueryHelper.addPEDDataRow(rs,dataRowList, lookupMapSnp);
						BatchQueryHelper.addPEDDataRowNew(rs,dataRowList, listPos); //faster
						date1 = new java.util.Date();
						log.info("addPEDDataRow takes " +  TimeCategory.minus(date1,date2).toMilliseconds());
						
						log.info("Running writePED file..."  );
						if(!BatchQueryHelper.writeToPEDFile(pedFile, dataRowList)){
							throw new JobException();
						}
						date2 = new java.util.Date();
						log.info("Write PED file takes " +  TimeCategory.minus(date2,date1).toMilliseconds());
						
						rs.close();
						dataRowList.clear();						
					}					
					
					//compress MAP and PED files together
					List<File> files = new LinkedList<File>();
					files.add(pedFile);
					files.add(mapFile);
					if(!FileUtils.compressFilesToTarFile(files, file)){
						throw new JobException();
					}					
					
				}else if(fileType.equals(Constants.MAP_FILE)){
					File mapFile = new File(file.getPath().substring(0, file.getPath().lastIndexOf(".")) + "." + Constants.MAP_FILE);
					
//					for(long i=0; i<offSetMAP; i++){
//						List<ClsFileDataRow> dataRowList = new LinkedList<ClsFileDataRow>();						
//						
//						ResultSet rs = geneService.createRSForMAPPEDFile(geneQueryStringMAP, i);
//						BatchQueryHelper.addMapDataRow(dataRowList,rs);
//						
//						if(!BatchQueryHelper.writeToMAPFile(mapFile, dataRowList)){
//							throw new JobException();
//						}
//						rs.close();
//						dataRowList.clear();						
//					}
					
					for(long i=0; i<offSetMAP; i++){
						List<ClsFileDataRow> dataRowList = new LinkedList<ClsFileDataRow>();						
						
						java.text.DateFormat format = new java.text.SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
						java.util.Date date1 = new java.util.Date();
						log.info("\n Running MAP query...");						
						ResultSet rs = geneService.createRSForMAPPEDFile(geneQueryStringMAP, i);						
						java.util.Date date2 = new java.util.Date();
						TimeDuration td = TimeCategory.minus(date2, date1);
						log.info("MAP query takes " +   td.toMilliseconds());						
												
						log.info("Running addMapDataRow...");
						BatchQueryHelper.addMapDataRow(dataRowList,rs);						
						date1 = new java.util.Date();
						log.info("AddMapDataRow takes " +  TimeCategory.minus(date1, date2).toMilliseconds());
												
						log.info("Running write to MAP file...");						
						if(!BatchQueryHelper.writeMAPFile2(mapFile, dataRowList)){
							throw new JobException();
						}
						date1 = new java.util.Date();
						log.info("Write to MAP file takes " +  TimeCategory.minus(date1,date2).toMilliseconds());
						
						rs.close();
						dataRowList.clear();						
					}
				}

			}
			catch(Exception e){
				e.printStackTrace();
				throw new JobException(e);
			}
			
		}

		@Override
		public String[] getResultsFiles() {
			return new String[] { resultsFile };
		}

		@Override
		public void cancel() {
			canceled = true;			
		}

		@Override
		public String getDbID() {
			return dbID;
		}

		@Override
		public UserInfo getUserInfo() {
			return ui;
		}

		@Override
		public String getFileType() {
			return fileType;
		}	
		
	}

}
