package clinical.web.actions;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
//import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
//import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

//import clinical.cache.CacheUtils;
import clinical.web.Constants;
//import clinical.web.IAnalysisResultService;
//import clinical.web.IAssessmentService;
//import clinical.web.IRemoteDBServices;
//import clinical.web.ServiceFactory;
//import clinical.web.common.IDBCache;
//import clinical.web.common.UserInfo;
//import clinical.web.common.vo.AssessmentSelectionInfo;
//import clinical.web.forms.AsQueryBuilderForm;
//import clinical.web.helpers.QueryWizardHelper;
//import clinical.web.vo.AssessmentQueryInfo;
//import clinical.web.vo.QueryInfo;
import clinical.web.GeneticChip;
import clinical.web.GeneticObjs;
import clinical.web.GeneticSession;
import clinical.web.IGeneticService;
import clinical.web.ServiceFactory;
import clinical.web.forms.GeneNewSession;

public class GeneNewSessionAction extends BaseLookupDispatchAction{

	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(AssessmentQueryAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.gene.show", "show");
		map.put("action.gene.addSession", "addSession");
		map.put("action.gene.cancelSession", "cancelSession");
		return map;
	}

	public ActionForward show(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		GeneNewSession gnsForm = (GeneNewSession) form; 
		
		HttpSession session = request.getSession(false);
		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
		IGeneticService geneService = ServiceFactory.getGeneticService(dbID);
		
		GeneticObjs geneticObj = new GeneticObjs();
		
		Collection<GeneticChip>	gChips = geneService.getAllChips();		
		geneticObj.setGeneChip(gChips);
		
		Collection<GeneticSession> gSessions = geneService.getAllSession();
		geneticObj.setSsList(gSessions);
		
		gnsForm.setGeneObj(geneticObj);
		
		return mapping.findForward(Constants.NEW);
	}
	
	public ActionForward addSession(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("in GeneNewSessionAction addSession");
//		IDBCache dbCache = null;
		try {			
			String sessionName;
			String sessionDesc;			
			BigDecimal selectedChipId;
			
			GeneNewSession gnsForm = (GeneNewSession) form;
			
			sessionName = gnsForm.getSessionName();
			sessionDesc = gnsForm.getSessionDesc();			
			selectedChipId = gnsForm.getGeneObj().getSelectedGeneChipId();
			
			gnsForm.clear();
			
			IGeneticService gnsService = null;
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			gnsService = ServiceFactory.getGeneticService(dbID);
			
			gnsService.addGeneSession(sessionName, sessionDesc, selectedChipId);
			
			response.sendRedirect(response.encodeRedirectURL("caquery.do?actionParam=Show"));
			
			return mapping.findForward(Constants.SUCCESS);
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}
	
//	public ActionForward cancelSession(ActionMapping mapping, ActionForm form,
//			HttpServletRequest request, HttpServletResponse response)
//			throws Exception {
//		return mapping.findForward(Constants.SUCCESS);
//	}

}