package clinical.web.actions;

//import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.json.JSONArray;
import org.json.JSONObject;

import clinical.server.ReceivedfilesInfo;
import clinical.server.vo.Experiment;
import clinical.server.vo.Imageprotocols;
import clinical.web.Constants;
import clinical.web.common.UserInfo;
import clinical.web.forms.ProcessFile;
import clinical.web.helpers.ExpSubjInfo;
import clinical.web.services.ImagingFileService;
//import clinical.web.test.DataTablesParamUtility;
//import clinical.web.test.JQueryDataTableParamModel;
import clinical.server.vo.Protocol;


public class ProcessFileAction extends BaseLookupDispatchAction{	
	
	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(ProcessFileAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.pf.show", "show");
		map.put("action.pf.getData", "getImagingFileData");
		map.put("action.pf.placing", "placing");
		return map;
	}
	
	public ActionForward show(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		
		try{
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			
			ImagingFileService ifs = new ImagingFileService(dbID);		
			List<ReceivedfilesInfo> rcvdFiles = ifs.getDistinctReceivedFilesInfo(ui);		
			
			ProcessFile pf = (ProcessFile)form;
			pf.setAllRcvdFiles(rcvdFiles);
	
			List<Experiment> exps = ifs.getAllExperiments(ui);
			pf.setAllExperiments(exps);
			
			List<ExpSubjInfo> expSubjInfo = ifs.getAllExpSubjInfo(ui);
			pf.setAllExpSubjInfo(expSubjInfo);
			
			List<Protocol> imageProtocols = ifs.getAllImageProtocols(ui);
			pf.setAllImageProtocols(imageProtocols);
			
			return mapping.findForward(Constants.NEW);
		}
		catch(Exception ex){
			return processExceptions(request, response, mapping, form, ex);
		}
	}

//	public ActionForward getImagingFileData(ActionMapping mapping, ActionForm form,
//			HttpServletRequest request, HttpServletResponse response)
//			throws Exception {	
//		
//		UserInfo ui = getUserInfo(request);
//		HttpSession session = request.getSession(false);
//		String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
//
//		JQueryDataTableParamModel param = DataTablesParamUtility.getParam(request);		
//		String sEcho = param.sEcho;
//		int iTotalRecords; // total number of records (unfiltered)
//		int iTotalDisplayRecords;//value will be set when code filters companies by keyword
//		
//		ImagingFileService ifs = new ImagingFileService(dbID);
//		//List<Receivedfiles> allRcvdFiles = ifs.getAllReceivedFiles(ui);
//		List<ReceivedfilesInfo> allRcvdFiles = ifs.getAllReceivedFilesInfo(ui);		
//		iTotalRecords = allRcvdFiles.size();
//		
//		List<ReceivedfilesInfo> newRcvdFilesInfo = new LinkedList<ReceivedfilesInfo>();
//		for(ReceivedfilesInfo rf : allRcvdFiles)
//		{
//			if(rf.getFileid().toString().contains(param.sSearch.toLowerCase())
//			||
//			rf.getFilename().contains(param.sSearch.toLowerCase())
//			||
//			rf.getTemplocation().contains(param.sSearch.toLowerCase())
//			||
//			rf.getPermlocation().contains(param.sSearch.toLowerCase())
//			||
//			rf.getProcessed().toString().contains(param.sSearch.toLowerCase())
//			||
//			rf.getSeriesdate().contains(param.sSearch.toLowerCase())
//			||
//			rf.getSeriesdescription().contains(param.sSearch.toLowerCase())
//			||
//			rf.getSeriesnumber().contains(param.sSearch.toLowerCase())
//			||
//			rf.getPermlocation().contains(param.sSearch.toLowerCase())
//			||
//			rf.getPatientid().contains(param.sSearch.toLowerCase())
//			)
//			{
//				newRcvdFilesInfo.add(rf);
//			}			
//		}
//		iTotalDisplayRecords = newRcvdFilesInfo.size();
//		final int sortColumnIndex = param.iSortColumnIndex;
//		final int sortDirection = param.sSortDirection.equals("asc") ? 1 : -1;
//		Collections.sort(newRcvdFilesInfo, new Comparator<ReceivedfilesInfo>(){
//			public int compare(ReceivedfilesInfo r1, ReceivedfilesInfo r2) {
//				switch(sortColumnIndex){
//				case 0:
//					return r1.getFileid().toString().compareTo(r2.getFileid().toString())*sortDirection;
//				case 1:
//					return r1.getFilename().compareTo(r2.getFilename())*sortDirection;
//				case 2:
//					return r1.getTemplocation().compareTo(r2.getTemplocation())*sortDirection;
//				case 3:
//					return r1.getPermlocation().compareTo(r2.getPermlocation())*sortDirection;
//				case 4:
//					return r1.getProcessed().compareTo(r2.getProcessed())*sortDirection;
//				case 5:
//					return r1.getPatientid().compareTo(r2.getPatientid())*sortDirection;
//				case 6:
//					return r1.getSeriesnumber().compareTo(r2.getSeriesnumber())*sortDirection;
//				case 7:
//					return r1.getSeriesdescription().compareTo(r2.getSeriesdescription())*sortDirection;
//				case 8:
//					return r1.getSeriesdate().compareTo(r2.getSeriesdate())*sortDirection;
//				}
//				return 0;
//			}			
//		});
//		
//		if(newRcvdFilesInfo.size()< param.iDisplayStart + param.iDisplayLength)
//			newRcvdFilesInfo = newRcvdFilesInfo.subList(param.iDisplayStart, newRcvdFilesInfo.size());
//		else
//			newRcvdFilesInfo = newRcvdFilesInfo.subList(param.iDisplayStart, param.iDisplayStart + param.iDisplayLength);
//		
//
//		//return mapping.findForward(Constants.NEW);
//		JSONArray data = new JSONArray(); //data that will be shown in the table		
//		try {
//			JSONObject jsonResponse = new JSONObject();			
//			jsonResponse.put("sEcho", sEcho);
//			jsonResponse.put("iTotalRecords", iTotalRecords);
//			jsonResponse.put("iTotalDisplayRecords", iTotalDisplayRecords);
//			
//			for(ReceivedfilesInfo c : newRcvdFilesInfo){
//				JSONArray row = new JSONArray();				
//				row.put(c.getFileid());			
//				row.put(c.getFilename());
//				row.put(c.getTemplocation());
//				row.put(c.getPermlocation());
//				row.put(c.getProcessed());
//				row.put(c.getPatientid());
//				row.put(c.getSeriesnumber());
//				row.put(c.getSeriesdescription());
//				row.put(c.getSeriesdate());
//				data.put(row);
//			}
//			jsonResponse.put("aaData", data);
//
//			response.setContentType("application/Json");
//			response.getWriter().print(jsonResponse.toString());
//			
//		} catch (Exception e) {
//			e.printStackTrace();
//			response.setContentType("text/html");
//			response.getWriter().print(e.getMessage());
//			log.error(e.getMessage());
//		}
//
//		return null;
//	}

	public ActionForward placing(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		
		try{
			String exp = request.getParameter("selectedExp");
			String subjId = request.getParameter("selectedSubj");
			String visitNumber = request.getParameter("selectedVisit");
			String protocolName = request.getParameter("selectedProtocol");
			
			UserInfo ui = getUserInfo(request);
			HttpSession session = request.getSession(false);
			String dbID = (String) session.getAttribute(Constants.SESSION_DBID_KEY);
			
			ImagingFileService ifs = new ImagingFileService(dbID);		
			List<ReceivedfilesInfo> rcvdFiles = ifs.getDistinctReceivedFilesInfo(ui);		
			
			ProcessFile pf = (ProcessFile)form;
			pf.setAllRcvdFiles(rcvdFiles);
	
			List<Experiment> exps = ifs.getAllExperiments(ui);
			pf.setAllExperiments(exps);
			
			List<ExpSubjInfo> expSubjInfo = ifs.getAllExpSubjInfo(ui);
			pf.setAllExpSubjInfo(expSubjInfo);
			
			List<Protocol> imageProtocols = ifs.getAllImageProtocols(ui);
			pf.setAllImageProtocols(imageProtocols);
			
			return mapping.findForward(Constants.NEW);
		}
		catch(Exception ex){
			return processExceptions(request, response, mapping, form, ex);
		}
	}

}
