package clinical.web.actions;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.web.Constants;
import clinical.web.ISubjectAssessmentManagement;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.exception.ValidationException;
import clinical.web.forms.ReconciliationForm;
import clinical.web.forms.SubjectVisitManagementForm;
import clinical.web.game.AssessmentManagementHelper;
import clinical.web.helpers.SubjectManagementHelper;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.vo.ReconScoreValueInfo;
import clinical.web.vo.ScoreValue;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ReconciliationAction.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class ReconciliationAction extends BaseAction {
	private Log log = LogFactory.getLog(LogonAction.class);

	public ReconciliationAction() {
	}

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		log.info("ReconciliationAction");
		ISubjectAssessmentManagement isam = null;
		try {
			UserInfo ui = getUserInfo(request);
			ReconciliationForm recForm = (ReconciliationForm) form;
			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);
			isam = ServiceFactory.getSubjectAssessmentManagement(dbID);

			SubjectVisitManagementForm svmForm = (SubjectVisitManagementForm) session
					.getAttribute(Constants.SVMFORM_KEY);

			AssessmentScoreValues asv = new AssessmentScoreValues(recForm
					.getTheAsi());
			int expID = Integer.parseInt(recForm.getExperimentID());
			asv.setExperimentID(expID);
			asv.setSubjectID(recForm.getSelectedSubjectID());
			asv.setVisitID(recForm.getTheAsi().getVisitID());
			asv.setSegmentID(recForm.getTheAsi().getSegmentID());

			boolean reconciled = isam.isAssessmentReconciled(ui, recForm
					.getSelectedSubjectID(), expID, recForm.getTheAsi()
					.getVisitID(), recForm.getTheAsi().getSegmentID(), recForm
					.getTheAsi().getAssessmentID());

			if (reconciled) {
				SubjectManagementHelper.prepareForSegmentManPage(session, ui,
						dbID, svmForm, recForm.getSelectedSubjectID(), expID,
						recForm.getTheAsi().getSegmentID(), 1,
						SubjectManagementHelper.RETRIEVE_BOTH, true);

				return mapping.findForward(Constants.SUCCESS);
			}

			int idx = 0;
			for (ReconScoreValueInfo rsvi : recForm.getMismatchedList()) {
				int selEntryIDAsGood = Integer.parseInt(recForm
						.getSelEntryIDAsGoodArr(idx));

				if (rsvi.getReconciledValue().getUncorrectedValue().length() == 0
						&& selEntryIDAsGood != -1) {
					ScoreValue sv = (ScoreValue) rsvi.getScoreValues().get(
							selEntryIDAsGood - 1);
					rsvi.getReconciledValue().setValue(sv.getValue());
					log.info("reconciled value " + rsvi.getReconciledValue());
				}
				if (rsvi.getReconciledValue().getUncorrectedValue().length() == 0
						&& selEntryIDAsGood == -1) {
					// raise validation error
					throw new ValidationException(
							"No final value provided for score '"
									+ rsvi.getReconciledValue().getName()
									+ "'!");
				} else {
					// check if rsvi.getReconciledValue().getUncorrectedValue()
					// is correct type
					checkType(rsvi.getScoreName(), rsvi.getScoreType(), rsvi
							.getReconciledValue().getUncorrectedValue());
				}

				++idx;
			}

			AssessmentManagementHelper amh = AssessmentManagementHelper
					.getInstance("clinical.web.game.forms");
			Map<String, Map<String, String>> dbVarMetaDataMap = amh
					.prepareDbVarMetaDataMap(recForm.getTheAsi().getName());

			isam.saveReconciledAssessmentData(dbID, ui, asv, recForm
					.getReconMap(), dbVarMetaDataMap);

			// since the assessment is reconciled at this point update the cache
			// (svmForm)
			// to reflect the changes.

			SubjectManagementHelper.prepareForSegmentManPage(session, ui, dbID,
					svmForm, recForm.getSelectedSubjectID(), expID, recForm
							.getTheAsi().getSegmentID(), 1,
					SubjectManagementHelper.RETRIEVE_BOTH, true);

		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
		return mapping.findForward(Constants.SUCCESS);
	}

	protected static boolean checkType(String scoreName, String scoreType,
			String rawValue) throws ValidationException {
		if (scoreType.equals("float")) {
			try {
				Float.parseFloat(rawValue);
				return true;
			} catch (NumberFormatException nfe) {
				throw new ValidationException("Final value of score '"
						+ scoreName + " is not a valid floating point number:"
						+ nfe.getMessage());
			}
		} else if (scoreType.equals("int")) {
			try {
				Integer.parseInt(rawValue);
			} catch (NumberFormatException nfe) {
				throw new ValidationException("Final value of score '"
						+ scoreName + " is not a valid integer:"
						+ nfe.getMessage());
			}
		}
		return true;
	}

}
