package clinical.web.common;

import clinical.web.exception.AuthenticationException;
/**
 *  Interface for user credential checking. It hides the details and/or method of authentication.
 *
 * @author I. Burak Ozyurt
 * @version $Id: IAuthenticationService.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public interface IAuthenticationService {
  /**
   * Given an application user name and a password checks the user's credentials and
   * if OK, returns a <code>UserInfo</code> object
   * @param user an application user name (usually different then the database named user)
   * @param pwd the password of the application user
   * @param dbID the unique id of the connected database
   * @return
   * @throws AuthenticationException
   * @see clinical.web.common.UserInfo
   */
   public UserInfo authenticate(String user, String pwd, String dbID) throws AuthenticationException;
   
   /**
    * 
    * @param email
    * @param dbID
    * @return
    * @throws AuthenticationException
    */
   public UserInfo authenticateAnonymous(String email, String dbID) throws AuthenticationException;

   /**
    *
    * @param dbID the unique id of the database for which you want to get a default user information
    * @param ui A wrapper class for the currently connected user
    * @return a <code>UserInfo</code> wrapper class for the default user of the database with <code>dbID</code>
    * @throws AuthenticationException
    * @see clinical.web.common.UserInfo
    */
   public UserInfo getDefaultUser(String dbID, UserInfo ui) throws AuthenticationException;

}