package clinical.web.common.vo;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.vo.Analysis;
import clinical.server.vo.Extendedtuple;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AnalysisExTupleInfo.java,v 1.1.2.1 2008/07/30 00:59:31 bozyurt
 *          Exp $
 */
public class AnalysisExTupleInfo implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Analysis analysis;
	protected Set<Extendedtuple> exTupleSet;

	public AnalysisExTupleInfo(Analysis analysis) {
		this.analysis = analysis;
		exTupleSet = new HashSet<Extendedtuple>(7);
	}

	public void addExTuple(Extendedtuple et) {
		if (!exTupleSet.contains(et)) {
			exTupleSet.add(et);
		}
	}

	public Analysis getAnalysis() {
		return analysis;
	}

	public Set<Extendedtuple> getExTupleSet() {
		return exTupleSet;
	}

	public JSONObject toJSON() throws JSONException {
		JSONObject js = new JSONObject();
		JSONObject anJS = new JSONObject();
		anJS.put("name", analysis.getName());
		anJS.put("id", analysis.getUniqueid().intValue());
		js.put("analysis", anJS);

		JSONArray arr = new JSONArray();
		for (Extendedtuple et : exTupleSet) {
			JSONObject etJS = new JSONObject();
			etJS.put("name", et.getName());
			etJS.put("id", et.getUniqueid().intValue());
			arr.put(etJS);
		}
		js.put("exTupleSet", arr);
		return js;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((analysis == null) ? 0 : analysis.getName().hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final AnalysisExTupleInfo other = (AnalysisExTupleInfo) obj;
		if (analysis == null) {
			if (other.analysis != null)
				return false;
		} else if (!analysis.getName().equals(other.analysis.getName()))
			return false;
		return true;
	}

	public String toString() {
		StringBuilder buf = new StringBuilder();
		buf.append("AnalysisExTupleInfo::[");
		buf.append(analysis.toString());
		for (Extendedtuple et : exTupleSet) {
			buf.append("\n\t").append(et);
		}
		buf.append(']');
		return buf.toString();
	}
}
