package clinical.web.common.vo;

import org.json.JSONException;
import org.json.JSONObject;


/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: TupleQueryInfo.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class TupleQueryInfo {
	protected CommonTupleDataInfo ctdi;
	protected String measGroupName;
	protected String measGroupFieldName;
	protected String exTupleName;

	public TupleQueryInfo(CommonTupleDataInfo ctdi, String measGroupFieldName,
			String measGroupName, String exTupleName) {
		this.ctdi = ctdi;
		this.measGroupName = measGroupName;
		this.measGroupFieldName = measGroupFieldName;
		this.exTupleName = exTupleName;
	}
	
	public TupleQueryInfo(TupleQueryInfo other) {
		this.ctdi = new CommonTupleDataInfo(other.ctdi);
		this.measGroupName = other.measGroupName;
		this.measGroupFieldName = other.measGroupFieldName;
		this.exTupleName = other.exTupleName;
	}

	public CommonTupleDataInfo getCtdi() {
		return ctdi;
	}

	public String getMeasGroupName() {
		return measGroupName;
	}

	public String getMeasGroupFieldName() {
		return measGroupFieldName;
	}

	public JSONObject toJSON(JSONObject js) throws JSONException {
		js.put("mgName", measGroupName);
		js.put("varName", measGroupFieldName);
		js.put("tupleName", exTupleName);
		js.put("ctdi", ctdi.toJSON(new JSONObject()));
		return js;
	}

	public static TupleQueryInfo initializeFromJSON(JSONObject js)
			throws JSONException {
		String measGroupFieldName = js.getString("mgName");
		String measGroupName = js.getString("varName");
		String exTupleName = js.getString("tupleName");
		CommonTupleDataInfo ctdi = CommonTupleDataInfo.initializeFromJSON(js
				.getJSONObject("ctdi"));
		return new TupleQueryInfo(ctdi, measGroupFieldName, measGroupName, exTupleName);
	}
	
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("TupleQueryInfo::[");
		sb.append("measGroupName=").append(measGroupName);
		sb.append(",varName=").append(measGroupFieldName);
		
		sb.append(']');
		return sb.toString();
	}

	public String getExTupleName() {
		return exTupleName;
	}
}
