package clinical.web.forms;

import java.util.List;

import org.apache.struts.action.ActionForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.ReceivedfilesInfo;
import clinical.server.vo.Experiment;
import clinical.web.helpers.ExpSubjInfo;
import clinical.server.vo.Protocol;

public class ProcessFile extends ActionForm{

	private static final long serialVersionUID = -3938406024199176821L;
	
	private List<ReceivedfilesInfo> allRcvdFiles;
	private List<Experiment> allExperiments;
	private List<ExpSubjInfo> allExpSubjInfo;
	private List<Protocol> allImageProtocols;
	
	public ProcessFile(){}

	public void setAllRcvdFiles(List<ReceivedfilesInfo> allRcvdFiles) {
		this.allRcvdFiles = allRcvdFiles;
	}

	public List<ReceivedfilesInfo> getAllRcvdFiles() {
		return allRcvdFiles;
	}

	public String getJSONStr(){
		JSONArray jsarray = new JSONArray();
		
		try {
			for(ReceivedfilesInfo rcvdFI : allRcvdFiles){
				JSONObject js = new JSONObject();			
				js.put("id", rcvdFI.getFileid());
				js.put("name", rcvdFI.getFilename());
				js.put("subjectid", rcvdFI.getPatientid());
				js.put("seriesdate", rcvdFI.getSeriesdate());
				js.put("seriesnumber", rcvdFI.getSeriesnumber());
				js.put("seriesdesc", rcvdFI.getSeriesdescription());
				js.put("seriestime", rcvdFI.getSeriestime());
				jsarray.put(js);
			}
			
			return jsarray.toString(2);
			
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}		
	}

	public void setAllExperiments(List<Experiment> allExperiments) {
		this.allExperiments = allExperiments;
	}

	public List<Experiment> getAllExperiments() {
		return allExperiments;
	}

	public void setAllExpSubjInfo(List<ExpSubjInfo> allExpSubjInfo) {
		this.allExpSubjInfo = allExpSubjInfo;
	}

	public List<ExpSubjInfo> getAllExpSubjInfo() {
		return allExpSubjInfo;
	}

	public String getJSONStr1(){
		JSONArray jsarray = new JSONArray();
		
		try {
			for(ExpSubjInfo expsub : allExpSubjInfo){
				jsarray.put(expsub.toJSON(new JSONObject()));
			}
			
			return jsarray.toString(2);
			
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}		
	}

	public void setAllImageProtocols(List<Protocol> allImageProtocols) {
		this.allImageProtocols = allImageProtocols;
	}

	public List<Protocol> getAllImageProtocols() {
		return allImageProtocols;
	}
	
	public String getJSONStr2(){
		JSONArray jsarray = new JSONArray();
		
		try {
			for(Protocol imagePro : allImageProtocols){
				JSONObject js = new JSONObject();			
				js.put("name", imagePro.getName());
				js.put("desc", imagePro.getDescription());				
				jsarray.put(js);
			}
			
			return jsarray.toString(2);
			
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}		
	}
}
