package clinical.web.forms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.struts.action.ActionForm;

import clinical.web.download.SubjectImageDataBundle;
import clinical.web.helpers.HeaderInfo;
import clinical.web.vo.ExpSubjectsIDBInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ShoppingCartForm.java 700 2012-10-19 17:33:59Z jinranc $
 */
public class ShoppingCartForm extends ActionForm {
	protected List<SubjectImageDataBundle> items = new ArrayList<SubjectImageDataBundle>(
			10);
	protected String bundleName;
	/* contains user selected full paths for images to be downloaded */
	protected String selectedFiles;
	protected int idCounter = 0;
	protected boolean jobScheduled = false;
	protected String scheduledJobID = null;

	protected boolean supportEmail = false;
	protected String email;
	protected boolean notifyByEmail = false;
	protected boolean willNotify = false;
	protected boolean allEmpty = false;
	protected Map<String,List<SubjectImageDataBundle>> exp2SIDBMap;
	// protected Map<String,String> expID2NameMap = new HashMap<String, String>(11);
	
	protected Map<String, ExpSubjectsIDBInfo> esidbMap; 
	//protected List<String> expNames;
	
	private String[] selProtocols;
	private String[] allProtocols;

	private static final long serialVersionUID = -8786477689225985730L;

	//Jinran added
	private String longFormat = "wide";
	
	public ShoppingCartForm() {
		super();
	}

	public void addItem(SubjectImageDataBundle sidb) {
		if (!items.contains(sidb)) {
			items.add(sidb);
		}
	}

	public void removeItem(String subjectID) {
//		for (Iterator<SubjectImageDataBundle> iter = items.iterator(); iter
//				.hasNext();) {
//			SubjectImageDataBundle sidb = iter.next();
//			if (sidb.getSubjectID().equals(subjectID)) {
//				iter.remove();
//				break;
//			}
//		}
		for(int i=0; i<items.size(); i++){
			SubjectImageDataBundle sidb = items.get(i);
			if(sidb.getSubjectID().equals(subjectID)){
				items.remove(i);
				break;
			}
		}
	}

	public String getBundleName() {
		return bundleName;
	}

	public List<SubjectImageDataBundle> getItems() {
		//sort list first, then output
/*		Collections.sort(items, new Comparator<SubjectImageDataBundle>() {
			public int compare(SubjectImageDataBundle s1, SubjectImageDataBundle s2) {
				return s1.getSubjectID().compareTo(s2.getSubjectID());
			}
		});*/
		return items;
	}

	public int getItemCount() {
		return items.size();
	}

	public String getSelectedFiles() {
		return selectedFiles;
	}

	public void setBundleName(String bundleName) {
		this.bundleName = bundleName;
	}

	public void setSelectedFiles(String selectedFiles) {
		this.selectedFiles = selectedFiles;
	}

	public int nextId() {
		return ++idCounter;
	}

	public boolean isJobScheduled() {
		return jobScheduled;
	}

	public void setJobScheduled(boolean jobScheduled) {
		this.jobScheduled = jobScheduled;
	}

	public String getScheduledJobID() {
		return scheduledJobID;
	}

	public void setScheduledJobID(String scheduledJobID) {
		this.scheduledJobID = scheduledJobID;
	}

	public void clearItems() {
		items.clear();
	}

	public boolean isSupportEmail() {
		return supportEmail;
	}

	public String getEmail() {
		return email;
	}

	public boolean isNotifyByEmail() {
		return notifyByEmail;
	}

	public boolean isWillNotify() {
		return willNotify;
	}

	public void setSupportEmail(boolean supportEmail) {
		this.supportEmail = supportEmail;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public void setNotifyByEmail(boolean notifyByEmail) {
		this.notifyByEmail = notifyByEmail;
	}

	public void setWillNotify(boolean willNotify) {
		this.willNotify = willNotify;
	}

	public boolean isAllEmpty() {
		for(SubjectImageDataBundle sidb : items) {
			if ( !sidb.isEmpty()) 
				return false;
		}
		return true;
	}

	public Map<String, List<SubjectImageDataBundle>> getExp2SIDBMap() {
		return exp2SIDBMap;
	}

	//TODO assumption database experiment ids across federated databases are unique
	/*
	public  void setExp2SIDBMap(
			Map<String, List<SubjectImageDataBundle>> exp2SIDBMap) {
		this.exp2SIDBMap = exp2SIDBMap;
		for(Map.Entry<String, List<SubjectImageDataBundle>> entry : exp2SIDBMap.entrySet()) {
			List<SubjectImageDataBundle> sidbList = entry.getValue();
			String expID = entry.getKey();
			for(SubjectImageDataBundle sidb : sidbList) {
				expID2NameMap.put(expID, sidb.getExperimentName(expID) );
				//FIXME
			}
		}
	}
*/
	
	public List<String> getExpNames() {
		List<String> expNames = new ArrayList<String>(esidbMap.keySet());
		Collections.sort(expNames);
		return expNames;
	}

	public Map<String, ExpSubjectsIDBInfo> getEsidbMap() {
		return esidbMap;
	}

	public void setEsidbMap(Map<String, ExpSubjectsIDBInfo> esidbMap) {
		this.esidbMap = esidbMap;
	}

	public void setSelProtocols(String[] selProtocols) {
		this.selProtocols = selProtocols;
	}

	public String[] getSelProtocols() {
		return selProtocols;
	}

	public void setAllProtocols(String[] allProtocols) {
		this.allProtocols = allProtocols;
	}

	public String[] getAllProtocols() {
		return allProtocols;
	}

	//Jinran added
	public void setLongFormat(String longFormat) {
		this.longFormat = longFormat;
	}

	public String getLongFormat() {
		return longFormat;
	}

}
