package clinical.web.game.forms;

import java.util.*;
import javax.servlet.http.*;
import java.text.*;

import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
/**
  *
  * @version $Id: BARSForm.java 91 2009-08-17 23:38:26Z bozyurt $
  * @author Generated by Clinical Assessment Layout Manager (CALM)
  */

public class BARSForm extends ActionForm {

    private String ID= "";
    private String ASS= "";
    private String TYPE= "";
    private String medication= "";
    private String objective= "";
    private String awarenessOfRestlessness= "";
    private String distressRelatedToRestlessness= "";
    private String globalClinicalAssessmentOfAkathisia= "";
    private String date = "";
    private String time = "";
    private String informantid = "";
    private String informantrelation = "";
    private DynamicDropDownSelector clinicalrater;

    // variables standard for each generated Assessment Struts Form Bean
    private String assessmentID;
    private String subjectID;
    private String experimentID;
    private String visitID;
    private String segmentID;
    private int currentPageIdx = 1;
    private String selectedQuestion = "";
    private String skippedQuestions = "";
    private String dataClassificationForSkipped = "";

    private static Map pageQuestionsMap;
    private static Map variableMap = null;
    private static Map mandatoryFieldMetaDataMap = null;

    public BARSForm() {
    }

    public String getID() {  return this.ID; }
    public String getASS() {  return this.ASS; }
    public String getTYPE() {  return this.TYPE; }
    public String getMedication() {  return this.medication; }
    public String getObjective() {  return this.objective; }
    public String getAwarenessOfRestlessness() {  return this.awarenessOfRestlessness; }
    public String getDistressRelatedToRestlessness() {  return this.distressRelatedToRestlessness; }
    public String getGlobalClinicalAssessmentOfAkathisia() {  return this.globalClinicalAssessmentOfAkathisia; }
    public String getDate() {  return this.date; }
    public String getTime() {  return this.time; }
    public String getInformantid() {  return this.informantid; }
    public String getInformantrelation() {  return this.informantrelation; }
    public DynamicDropDownSelector getClinicalrater() {  return this.clinicalrater; }

    public void setID(String newValue) {  this.ID = newValue; }
    public void setASS(String newValue) {  this.ASS = newValue; }
    public void setTYPE(String newValue) {  this.TYPE = newValue; }
    public void setMedication(String newValue) {  this.medication = newValue; }
    public void setObjective(String newValue) {  this.objective = newValue; }
    public void setAwarenessOfRestlessness(String newValue) {  this.awarenessOfRestlessness = newValue; }
    public void setDistressRelatedToRestlessness(String newValue) {  this.distressRelatedToRestlessness = newValue; }
    public void setGlobalClinicalAssessmentOfAkathisia(String newValue) {  this.globalClinicalAssessmentOfAkathisia = newValue; }
    public void setDate(String newValue) {  this.date = newValue; }
    public void setTime(String newValue) {  this.time = newValue; }
    public void setInformantid(String newValue) {  this.informantid = newValue; }
    public void setInformantrelation(String newValue) {  this.informantrelation = newValue; }
    public void setClinicalrater(DynamicDropDownSelector newValue) {  this.clinicalrater = newValue; }

                    
                    
                    


    public String getAssessmentID() {  return this.assessmentID; }
    public String getSubjectID() {  return this.subjectID; }
    public String getExperimentID() {  return this.experimentID; }
    public String getVisitID() {  return this.visitID; }
    public String getSegmentID() {  return this.segmentID; }
    public int getCurrentPageIdx() {  return this.currentPageIdx; }
    public String getSelectedQuestion() {  return this.selectedQuestion; }
    public String getSkippedQuestions() {  return this.skippedQuestions; }
    public String getDataClassificationForSkipped() {  return this.dataClassificationForSkipped; }

    public void setAssessmentID(String newValue) {  this.assessmentID = newValue; }
    public void setSubjectID(String newValue) {  this.subjectID = newValue; }
    public void setExperimentID(String newValue) {  this.experimentID = newValue; }
    public void setVisitID(String newValue) {  this.visitID = newValue; }
    public void setSegmentID(String newValue) {  this.segmentID = newValue; }
    public void setCurrentPageIdx(int newValue) {  this.currentPageIdx = newValue; }
    public void setSelectedQuestion(String newValue) {  this.selectedQuestion = newValue; }
    public void setSkippedQuestions(String newValue) {  this.skippedQuestions = newValue; }
    public void setDataClassificationForSkipped(String newValue) {  this.dataClassificationForSkipped = newValue; }

    
public static class PageVariableInfo {
      int pageNumber;
      String formVarName;
      String dbVarName;
      Map metaDataMap;
      public PageVariableInfo(int pageNumber, String formVarName, String dbVarName) {
        this.pageNumber = pageNumber;
        this.formVarName = formVarName;
        this.dbVarName = dbVarName;
      }

      public int getPageNumber() { return this.pageNumber; }
      public String getFormVarName() { return this.formVarName; }
      public String getDbVarName() { return this.dbVarName; }
      public void addMetaData(String name, String value) {
        if (metaDataMap == null) {
          metaDataMap = new HashMap(3);
        }
        metaDataMap.put(name, value);
      }
      public Map getMetaDataMap() { return metaDataMap; }
    }

    private final static String assessmentName = "Barnes Akathisia Rating Scale";

    public static String getAssessmentName() { return assessmentName; }

    public static Map getVariableMap() {
      synchronized(BARSForm.class) {
        if (variableMap == null) {
      variableMap = new LinkedHashMap();
      PageVariableInfo pvi = null;

          variableMap.put("ID", pvi = new PageVariableInfo(1,"ID","ID") );
          variableMap.put("ASS", pvi = new PageVariableInfo(1,"ASS","ASS") );
          variableMap.put("TYPE", pvi = new PageVariableInfo(1,"TYPE","TYPE") );
          variableMap.put("medication", pvi = new PageVariableInfo(1,"medication","medication") );
          variableMap.put("Objective", pvi = new PageVariableInfo(2,"objective","Objective") );
          variableMap.put("Awareness of Restlessness", pvi = new PageVariableInfo(2,"awarenessOfRestlessness","Awareness of Restlessness") );
          variableMap.put("Distress related to restlessness", pvi = new PageVariableInfo(2,"distressRelatedToRestlessness","Distress related to restlessness") );
          variableMap.put("Global Clinical Assessment of Akathisia", pvi = new PageVariableInfo(2,"globalClinicalAssessmentOfAkathisia","Global Clinical Assessment of Akathisia") );
        }
      }
      return variableMap;
    }
    public static Map getMandatoryFieldMetaDataMap() {
      if (mandatoryFieldMetaDataMap == null) {
        mandatoryFieldMetaDataMap = new HashMap(3);
        Map mdMap = new HashMap(3);
        mandatoryFieldMetaDataMap.put("clinicalrater",mdMap);
        mdMap.put("query","select a.name from nc_databaseuser a, nc_userclass b where a.userclass = b.uniqueid and b.name = 'researcher'");
      }
      return mandatoryFieldMetaDataMap;
    }


 public static class PageQuestionInfo {
    int pageNumber;
    int questionNumber;
    String type;
    int minAnswer;
    int maxAnswer;
    List scoreNames = new LinkedList();
    Map scoreNameIDMAp = new HashMap(3);

    public PageQuestionInfo(int pageNumber, int questionNumber, String type) {
      this(pageNumber, questionNumber, type, 1, 1);
    }

    public PageQuestionInfo(int pageNumber, int questionNumber, String type,
                            int minAnswer, int maxAnswer)
    {
      this.pageNumber = pageNumber;
      this.questionNumber = questionNumber;
      this.type = type;
      this.minAnswer = minAnswer;
      this.maxAnswer = maxAnswer;
    }

    public int getPageNumber() { return pageNumber; }
    public int getQuestionNumber() { return questionNumber; }
    public String getType() { return type; }
    public int getMinAnswer() { return minAnswer; }
    public int getMaxAnswer() { return maxAnswer; }

    public void addScoreNameIDAssoc(String scoreName, int id) {
       scoreNameIDMAp.put(scoreName, new Integer(id));
    }

    public Integer getIDForScoreName(String scoreName) {
       return (Integer) scoreNameIDMAp.get(scoreName);
    }

    public void addScoreName(String scoreName) {
      scoreNames.add(scoreName);
    }

    public List getScoreNames() { return scoreNames; }
  }


    public static Map getPageQuestionsMap() {
      synchronized(BARSForm.class) {
        if (pageQuestionsMap == null) {
          pageQuestionsMap = new LinkedHashMap();

          List list = null;
          PageQuestionInfo pqi = null;
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(2), list);
          list.add( pqi = new PageQuestionInfo(2,3,"regular") );
          pqi.addScoreName("Objective");
          pqi.addScoreNameIDAssoc("Objective",0);
          list.add( pqi = new PageQuestionInfo(2,2,"regular") );
          pqi.addScoreName("Global Clinical Assessment of Akathisia");
          pqi.addScoreNameIDAssoc("Global Clinical Assessment of Akathisia",0);
          list.add( pqi = new PageQuestionInfo(2,1,"regular") );
          pqi.addScoreName("Distress related to restlessness");
          pqi.addScoreNameIDAssoc("Distress related to restlessness",0);
          list.add( pqi = new PageQuestionInfo(2,4,"regular") );
          pqi.addScoreName("Awareness of Restlessness");
          pqi.addScoreNameIDAssoc("Awareness of Restlessness",0);
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(1), list);
          list.add( pqi = new PageQuestionInfo(1,7,"regular") );
          pqi.addScoreName("medication");
          pqi.addScoreNameIDAssoc("medication",0);
          list.add( pqi = new PageQuestionInfo(1,6,"regular") );
          pqi.addScoreName("TYPE");
          pqi.addScoreNameIDAssoc("TYPE",0);
          list.add( pqi = new PageQuestionInfo(1,5,"regular") );
          pqi.addScoreName("ASS");
          pqi.addScoreNameIDAssoc("ASS",0);
        }
      }
      return pageQuestionsMap;
    }

    private String q3_notes = "";
    private String q7_notes = "";
    private String q2_notes = "";
    private String q1_notes = "";
    private String q6_notes = "";
    private String q5_notes = "";
    private String q4_notes = "";

    public String getQ3_notes() {  return this.q3_notes; }
    public void setQ3_notes(String newValue) {  this.q3_notes = newValue; }
    public String getQ7_notes() {  return this.q7_notes; }
    public void setQ7_notes(String newValue) {  this.q7_notes = newValue; }
    public String getQ2_notes() {  return this.q2_notes; }
    public void setQ2_notes(String newValue) {  this.q2_notes = newValue; }
    public String getQ1_notes() {  return this.q1_notes; }
    public void setQ1_notes(String newValue) {  this.q1_notes = newValue; }
    public String getQ6_notes() {  return this.q6_notes; }
    public void setQ6_notes(String newValue) {  this.q6_notes = newValue; }
    public String getQ5_notes() {  return this.q5_notes; }
    public void setQ5_notes(String newValue) {  this.q5_notes = newValue; }
    public String getQ4_notes() {  return this.q4_notes; }
    public void setQ4_notes(String newValue) {  this.q4_notes = newValue; }
    
    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }
}
