package clinical.web.game.forms;

import java.util.*;
import javax.servlet.http.*;
import java.text.*;

import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
/**
  *
  * @version $Id: DemographicsForm.java 91 2009-08-17 23:38:26Z bozyurt $
  * @author Generated by Clinical Assessment Layout Manager (CALM)
  */

public class DemographicsForm extends ActionForm {

    private String race = "";
    private String ethnicity = "";
    private String education= "";
    private String motherSEducation= "";
    private String fatherSEducation= "";
    private String occupation = "";
    private String motherSOccupation = "";
    private String fatherSOccupation = "";
    private String age= "";
    private String maritalStatus = "";
    private String livingArrangement = "";
    private String numberOfChildren= "";
    private String gender = "";
    private String handedness = "";
    private String date = "";
    private String time = "";
    private String informantid = "";
    private String informantrelation = "";
    private DynamicDropDownSelector clinicalrater;

    // variables standard for each generated Assessment Struts Form Bean
    private String assessmentID;
    private String subjectID;
    private String experimentID;
    private String visitID;
    private String segmentID;
    private int currentPageIdx = 1;
    private String selectedQuestion = "";
    private String skippedQuestions = "";
    private String dataClassificationForSkipped = "";

    private static Map pageQuestionsMap;
    private static Map variableMap = null;
    private static Map mandatoryFieldMetaDataMap = null;

    public DemographicsForm() {
    }

    public String getRace() {  return this.race; }
    public String getEthnicity() {  return this.ethnicity; }
    public String getEducation() {  return this.education; }
    public String getMotherSEducation() {  return this.motherSEducation; }
    public String getFatherSEducation() {  return this.fatherSEducation; }
    public String getOccupation() {  return this.occupation; }
    public String getMotherSOccupation() {  return this.motherSOccupation; }
    public String getFatherSOccupation() {  return this.fatherSOccupation; }
    public String getAge() {  return this.age; }
    public String getMaritalStatus() {  return this.maritalStatus; }
    public String getLivingArrangement() {  return this.livingArrangement; }
    public String getNumberOfChildren() {  return this.numberOfChildren; }
    public String getGender() {  return this.gender; }
    public String getHandedness() {  return this.handedness; }
    public String getDate() {  return this.date; }
    public String getTime() {  return this.time; }
    public String getInformantid() {  return this.informantid; }
    public String getInformantrelation() {  return this.informantrelation; }
    public DynamicDropDownSelector getClinicalrater() {  return this.clinicalrater; }

    public void setRace(String newValue) {  this.race = newValue; }
    public void setEthnicity(String newValue) {  this.ethnicity = newValue; }
    public void setEducation(String newValue) {  this.education = newValue; }
    public void setMotherSEducation(String newValue) {  this.motherSEducation = newValue; }
    public void setFatherSEducation(String newValue) {  this.fatherSEducation = newValue; }
    public void setOccupation(String newValue) {  this.occupation = newValue; }
    public void setMotherSOccupation(String newValue) {  this.motherSOccupation = newValue; }
    public void setFatherSOccupation(String newValue) {  this.fatherSOccupation = newValue; }
    public void setAge(String newValue) {  this.age = newValue; }
    public void setMaritalStatus(String newValue) {  this.maritalStatus = newValue; }
    public void setLivingArrangement(String newValue) {  this.livingArrangement = newValue; }
    public void setNumberOfChildren(String newValue) {  this.numberOfChildren = newValue; }
    public void setGender(String newValue) {  this.gender = newValue; }
    public void setHandedness(String newValue) {  this.handedness = newValue; }
    public void setDate(String newValue) {  this.date = newValue; }
    public void setTime(String newValue) {  this.time = newValue; }
    public void setInformantid(String newValue) {  this.informantid = newValue; }
    public void setInformantrelation(String newValue) {  this.informantrelation = newValue; }
    public void setClinicalrater(DynamicDropDownSelector newValue) {  this.clinicalrater = newValue; }

                    
                    
                    


    public String getAssessmentID() {  return this.assessmentID; }
    public String getSubjectID() {  return this.subjectID; }
    public String getExperimentID() {  return this.experimentID; }
    public String getVisitID() {  return this.visitID; }
    public String getSegmentID() {  return this.segmentID; }
    public int getCurrentPageIdx() {  return this.currentPageIdx; }
    public String getSelectedQuestion() {  return this.selectedQuestion; }
    public String getSkippedQuestions() {  return this.skippedQuestions; }
    public String getDataClassificationForSkipped() {  return this.dataClassificationForSkipped; }

    public void setAssessmentID(String newValue) {  this.assessmentID = newValue; }
    public void setSubjectID(String newValue) {  this.subjectID = newValue; }
    public void setExperimentID(String newValue) {  this.experimentID = newValue; }
    public void setVisitID(String newValue) {  this.visitID = newValue; }
    public void setSegmentID(String newValue) {  this.segmentID = newValue; }
    public void setCurrentPageIdx(int newValue) {  this.currentPageIdx = newValue; }
    public void setSelectedQuestion(String newValue) {  this.selectedQuestion = newValue; }
    public void setSkippedQuestions(String newValue) {  this.skippedQuestions = newValue; }
    public void setDataClassificationForSkipped(String newValue) {  this.dataClassificationForSkipped = newValue; }

    
public static class PageVariableInfo {
      int pageNumber;
      String formVarName;
      String dbVarName;
      Map metaDataMap;
      public PageVariableInfo(int pageNumber, String formVarName, String dbVarName) {
        this.pageNumber = pageNumber;
        this.formVarName = formVarName;
        this.dbVarName = dbVarName;
      }

      public int getPageNumber() { return this.pageNumber; }
      public String getFormVarName() { return this.formVarName; }
      public String getDbVarName() { return this.dbVarName; }
      public void addMetaData(String name, String value) {
        if (metaDataMap == null) {
          metaDataMap = new HashMap(3);
        }
        metaDataMap.put(name, value);
      }
      public Map getMetaDataMap() { return metaDataMap; }
    }

    private final static String assessmentName = "Demographics";

    public static String getAssessmentName() { return assessmentName; }

    public static Map getVariableMap() {
      synchronized(DemographicsForm.class) {
        if (variableMap == null) {
      variableMap = new LinkedHashMap();
      PageVariableInfo pvi = null;

          variableMap.put("Race", pvi = new PageVariableInfo(2,"race","Race") );
          variableMap.put("Ethnicity", pvi = new PageVariableInfo(2,"ethnicity","Ethnicity") );
          variableMap.put("Education", pvi = new PageVariableInfo(2,"education","Education") );
          variableMap.put("Mother's Education", pvi = new PageVariableInfo(2,"motherSEducation","Mother's Education") );
          variableMap.put("Father's Education", pvi = new PageVariableInfo(2,"fatherSEducation","Father's Education") );
          variableMap.put("Occupation", pvi = new PageVariableInfo(2,"occupation","Occupation") );
          variableMap.put("Mother's Occupation", pvi = new PageVariableInfo(2,"motherSOccupation","Mother's Occupation") );
          variableMap.put("Father's Occupation", pvi = new PageVariableInfo(2,"fatherSOccupation","Father's Occupation") );
          variableMap.put("Age", pvi = new PageVariableInfo(2,"age","Age") );
          variableMap.put("Marital Status", pvi = new PageVariableInfo(2,"maritalStatus","Marital Status") );
          variableMap.put("Living Arrangement", pvi = new PageVariableInfo(2,"livingArrangement","Living Arrangement") );
          variableMap.put("Number of Children", pvi = new PageVariableInfo(2,"numberOfChildren","Number of Children") );
          variableMap.put("Gender", pvi = new PageVariableInfo(2,"gender","Gender") );
          variableMap.put("Handedness", pvi = new PageVariableInfo(2,"handedness","Handedness") );
        }
      }
      return variableMap;
    }
    public static Map getMandatoryFieldMetaDataMap() {
      if (mandatoryFieldMetaDataMap == null) {
        mandatoryFieldMetaDataMap = new HashMap(3);
        Map mdMap = new HashMap(3);
        mandatoryFieldMetaDataMap.put("clinicalrater",mdMap);
        mdMap.put("query","select a.name from nc_databaseuser a, nc_userclass b where a.userclass = b.uniqueid and b.name = 'researcher'");
      }
      return mandatoryFieldMetaDataMap;
    }


 public static class PageQuestionInfo {
    int pageNumber;
    int questionNumber;
    String type;
    int minAnswer;
    int maxAnswer;
    List scoreNames = new LinkedList();
    Map scoreNameIDMAp = new HashMap(3);

    public PageQuestionInfo(int pageNumber, int questionNumber, String type) {
      this(pageNumber, questionNumber, type, 1, 1);
    }

    public PageQuestionInfo(int pageNumber, int questionNumber, String type,
                            int minAnswer, int maxAnswer)
    {
      this.pageNumber = pageNumber;
      this.questionNumber = questionNumber;
      this.type = type;
      this.minAnswer = minAnswer;
      this.maxAnswer = maxAnswer;
    }

    public int getPageNumber() { return pageNumber; }
    public int getQuestionNumber() { return questionNumber; }
    public String getType() { return type; }
    public int getMinAnswer() { return minAnswer; }
    public int getMaxAnswer() { return maxAnswer; }

    public void addScoreNameIDAssoc(String scoreName, int id) {
       scoreNameIDMAp.put(scoreName, new Integer(id));
    }

    public Integer getIDForScoreName(String scoreName) {
       return (Integer) scoreNameIDMAp.get(scoreName);
    }

    public void addScoreName(String scoreName) {
      scoreNames.add(scoreName);
    }

    public List getScoreNames() { return scoreNames; }
  }


    public static Map getPageQuestionsMap() {
      synchronized(DemographicsForm.class) {
        if (pageQuestionsMap == null) {
          pageQuestionsMap = new LinkedHashMap();

          List list = null;
          PageQuestionInfo pqi = null;
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(2), list);
          list.add( pqi = new PageQuestionInfo(2,3,"regular") );
          pqi.addScoreName("Education");
          pqi.addScoreNameIDAssoc("Education",0);
          list.add( pqi = new PageQuestionInfo(2,14,"regular") );
          pqi.addScoreName("Handedness");
          pqi.addScoreNameIDAssoc("Handedness",0);
          list.add( pqi = new PageQuestionInfo(2,6,"regular") );
          pqi.addScoreName("Occupation");
          pqi.addScoreNameIDAssoc("Occupation",0);
          list.add( pqi = new PageQuestionInfo(2,1,"regular") );
          pqi.addScoreName("Race");
          pqi.addScoreNameIDAssoc("Race",0);
          list.add( pqi = new PageQuestionInfo(2,5,"regular") );
          pqi.addScoreName("Father's Education");
          pqi.addScoreNameIDAssoc("Father's Education",0);
          list.add( pqi = new PageQuestionInfo(2,11,"regular") );
          pqi.addScoreName("Living Arrangement");
          pqi.addScoreNameIDAssoc("Living Arrangement",0);
          list.add( pqi = new PageQuestionInfo(2,4,"regular") );
          pqi.addScoreName("Mother's Education");
          pqi.addScoreNameIDAssoc("Mother's Education",0);
          list.add( pqi = new PageQuestionInfo(2,12,"regular") );
          pqi.addScoreName("Number of Children");
          pqi.addScoreNameIDAssoc("Number of Children",0);
          list.add( pqi = new PageQuestionInfo(2,7,"regular") );
          pqi.addScoreName("Mother's Occupation");
          pqi.addScoreNameIDAssoc("Mother's Occupation",0);
          list.add( pqi = new PageQuestionInfo(2,2,"regular") );
          pqi.addScoreName("Ethnicity");
          pqi.addScoreNameIDAssoc("Ethnicity",0);
          list.add( pqi = new PageQuestionInfo(2,10,"regular") );
          pqi.addScoreName("Marital Status");
          pqi.addScoreNameIDAssoc("Marital Status",0);
          list.add( pqi = new PageQuestionInfo(2,13,"regular") );
          pqi.addScoreName("Gender");
          pqi.addScoreNameIDAssoc("Gender",0);
          list.add( pqi = new PageQuestionInfo(2,9,"regular") );
          pqi.addScoreName("Age");
          pqi.addScoreNameIDAssoc("Age",0);
          list.add( pqi = new PageQuestionInfo(2,8,"regular") );
          pqi.addScoreName("Father's Occupation");
          pqi.addScoreNameIDAssoc("Father's Occupation",0);
        }
      }
      return pageQuestionsMap;
    }

    private String q3_notes = "";
    private String q14_notes = "";
    private String q6_notes = "";
    private String q1_notes = "";
    private String q5_notes = "";
    private String q11_notes = "";
    private String q4_notes = "";
    private String q12_notes = "";
    private String q7_notes = "";
    private String q2_notes = "";
    private String q10_notes = "";
    private String q13_notes = "";
    private String q9_notes = "";
    private String q8_notes = "";

    public String getQ3_notes() {  return this.q3_notes; }
    public void setQ3_notes(String newValue) {  this.q3_notes = newValue; }
    public String getQ14_notes() {  return this.q14_notes; }
    public void setQ14_notes(String newValue) {  this.q14_notes = newValue; }
    public String getQ6_notes() {  return this.q6_notes; }
    public void setQ6_notes(String newValue) {  this.q6_notes = newValue; }
    public String getQ1_notes() {  return this.q1_notes; }
    public void setQ1_notes(String newValue) {  this.q1_notes = newValue; }
    public String getQ5_notes() {  return this.q5_notes; }
    public void setQ5_notes(String newValue) {  this.q5_notes = newValue; }
    public String getQ11_notes() {  return this.q11_notes; }
    public void setQ11_notes(String newValue) {  this.q11_notes = newValue; }
    public String getQ4_notes() {  return this.q4_notes; }
    public void setQ4_notes(String newValue) {  this.q4_notes = newValue; }
    public String getQ12_notes() {  return this.q12_notes; }
    public void setQ12_notes(String newValue) {  this.q12_notes = newValue; }
    public String getQ7_notes() {  return this.q7_notes; }
    public void setQ7_notes(String newValue) {  this.q7_notes = newValue; }
    public String getQ2_notes() {  return this.q2_notes; }
    public void setQ2_notes(String newValue) {  this.q2_notes = newValue; }
    public String getQ10_notes() {  return this.q10_notes; }
    public void setQ10_notes(String newValue) {  this.q10_notes = newValue; }
    public String getQ13_notes() {  return this.q13_notes; }
    public void setQ13_notes(String newValue) {  this.q13_notes = newValue; }
    public String getQ9_notes() {  return this.q9_notes; }
    public void setQ9_notes(String newValue) {  this.q9_notes = newValue; }
    public String getQ8_notes() {  return this.q8_notes; }
    public void setQ8_notes(String newValue) {  this.q8_notes = newValue; }
    
    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }
}
