package clinical.web.game.forms;

import java.util.*;
import javax.servlet.http.*;
import java.text.*;

import org.apache.commons.logging.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;
/**
  *
  * @version $Id: SARSForm.java 91 2009-08-17 23:38:26Z bozyurt $
  * @author Generated by Clinical Assessment Layout Manager (CALM)
  */

public class SARSForm extends ActionForm {

    private String status= "";
    private String medication= "";
    private String interview= "";
    private String staff= "";
    private String family= "";
    private String friends= "";
    private String other= "";
    private String reliability= "";
    private String GAIT= "";
    private String armDropping= "";
    private String shoulderShaking= "";
    private String elbowRigidty= "";
    private String cogwheelingRight= "";
    private String cogwheelingLeft= "";
    private String cogwheelingOverall= "";
    private String rigidityOfMajorJointsRight= "";
    private String rigidityOfMajorJointsLeft= "";
    private String rigidityOfMajorJointsOverall= "";
    private String fixationOfPositionOrWristRigidty= "";
    private String legPendulousness= "";
    private String headDropping= "";
    private String glabellaTap= "";
    private String tremorRight= "";
    private String tremorLeft= "";
    private String tremorOverall= "";
    private String salivation= "";
    private String balance= "";
    private String akinesia= "";
    private String akathisia= "";
    private String addendumAcuteDsytonicReaction= "";
    private String cooperativeness= "";
    private String date = "";
    private String time = "";
    private String informantid = "";
    private String informantrelation = "";
    private DynamicDropDownSelector clinicalrater;

    // variables standard for each generated Assessment Struts Form Bean
    private String assessmentID;
    private String subjectID;
    private String experimentID;
    private String visitID;
    private String segmentID;
    private int currentPageIdx = 1;
    private String selectedQuestion = "";
    private String skippedQuestions = "";
    private String dataClassificationForSkipped = "";

    private static Map pageQuestionsMap;
    private static Map variableMap = null;
    private static Map mandatoryFieldMetaDataMap = null;

    public SARSForm() {
    }

    public String getStatus() {  return this.status; }
    public String getMedication() {  return this.medication; }
    public String getInterview() {  return this.interview; }
    public String getStaff() {  return this.staff; }
    public String getFamily() {  return this.family; }
    public String getFriends() {  return this.friends; }
    public String getOther() {  return this.other; }
    public String getReliability() {  return this.reliability; }
    public String getGAIT() {  return this.GAIT; }
    public String getArmDropping() {  return this.armDropping; }
    public String getShoulderShaking() {  return this.shoulderShaking; }
    public String getElbowRigidty() {  return this.elbowRigidty; }
    public String getCogwheelingRight() {  return this.cogwheelingRight; }
    public String getCogwheelingLeft() {  return this.cogwheelingLeft; }
    public String getCogwheelingOverall() {  return this.cogwheelingOverall; }
    public String getRigidityOfMajorJointsRight() {  return this.rigidityOfMajorJointsRight; }
    public String getRigidityOfMajorJointsLeft() {  return this.rigidityOfMajorJointsLeft; }
    public String getRigidityOfMajorJointsOverall() {  return this.rigidityOfMajorJointsOverall; }
    public String getFixationOfPositionOrWristRigidty() {  return this.fixationOfPositionOrWristRigidty; }
    public String getLegPendulousness() {  return this.legPendulousness; }
    public String getHeadDropping() {  return this.headDropping; }
    public String getGlabellaTap() {  return this.glabellaTap; }
    public String getTremorRight() {  return this.tremorRight; }
    public String getTremorLeft() {  return this.tremorLeft; }
    public String getTremorOverall() {  return this.tremorOverall; }
    public String getSalivation() {  return this.salivation; }
    public String getBalance() {  return this.balance; }
    public String getAkinesia() {  return this.akinesia; }
    public String getAkathisia() {  return this.akathisia; }
    public String getAddendumAcuteDsytonicReaction() {  return this.addendumAcuteDsytonicReaction; }
    public String getCooperativeness() {  return this.cooperativeness; }
    public String getDate() {  return this.date; }
    public String getTime() {  return this.time; }
    public String getInformantid() {  return this.informantid; }
    public String getInformantrelation() {  return this.informantrelation; }
    public DynamicDropDownSelector getClinicalrater() {  return this.clinicalrater; }

    public void setStatus(String newValue) {  this.status = newValue; }
    public void setMedication(String newValue) {  this.medication = newValue; }
    public void setInterview(String newValue) {  this.interview = newValue; }
    public void setStaff(String newValue) {  this.staff = newValue; }
    public void setFamily(String newValue) {  this.family = newValue; }
    public void setFriends(String newValue) {  this.friends = newValue; }
    public void setOther(String newValue) {  this.other = newValue; }
    public void setReliability(String newValue) {  this.reliability = newValue; }
    public void setGAIT(String newValue) {  this.GAIT = newValue; }
    public void setArmDropping(String newValue) {  this.armDropping = newValue; }
    public void setShoulderShaking(String newValue) {  this.shoulderShaking = newValue; }
    public void setElbowRigidty(String newValue) {  this.elbowRigidty = newValue; }
    public void setCogwheelingRight(String newValue) {  this.cogwheelingRight = newValue; }
    public void setCogwheelingLeft(String newValue) {  this.cogwheelingLeft = newValue; }
    public void setCogwheelingOverall(String newValue) {  this.cogwheelingOverall = newValue; }
    public void setRigidityOfMajorJointsRight(String newValue) {  this.rigidityOfMajorJointsRight = newValue; }
    public void setRigidityOfMajorJointsLeft(String newValue) {  this.rigidityOfMajorJointsLeft = newValue; }
    public void setRigidityOfMajorJointsOverall(String newValue) {  this.rigidityOfMajorJointsOverall = newValue; }
    public void setFixationOfPositionOrWristRigidty(String newValue) {  this.fixationOfPositionOrWristRigidty = newValue; }
    public void setLegPendulousness(String newValue) {  this.legPendulousness = newValue; }
    public void setHeadDropping(String newValue) {  this.headDropping = newValue; }
    public void setGlabellaTap(String newValue) {  this.glabellaTap = newValue; }
    public void setTremorRight(String newValue) {  this.tremorRight = newValue; }
    public void setTremorLeft(String newValue) {  this.tremorLeft = newValue; }
    public void setTremorOverall(String newValue) {  this.tremorOverall = newValue; }
    public void setSalivation(String newValue) {  this.salivation = newValue; }
    public void setBalance(String newValue) {  this.balance = newValue; }
    public void setAkinesia(String newValue) {  this.akinesia = newValue; }
    public void setAkathisia(String newValue) {  this.akathisia = newValue; }
    public void setAddendumAcuteDsytonicReaction(String newValue) {  this.addendumAcuteDsytonicReaction = newValue; }
    public void setCooperativeness(String newValue) {  this.cooperativeness = newValue; }
    public void setDate(String newValue) {  this.date = newValue; }
    public void setTime(String newValue) {  this.time = newValue; }
    public void setInformantid(String newValue) {  this.informantid = newValue; }
    public void setInformantrelation(String newValue) {  this.informantrelation = newValue; }
    public void setClinicalrater(DynamicDropDownSelector newValue) {  this.clinicalrater = newValue; }

                    
                    
                    


    public String getAssessmentID() {  return this.assessmentID; }
    public String getSubjectID() {  return this.subjectID; }
    public String getExperimentID() {  return this.experimentID; }
    public String getVisitID() {  return this.visitID; }
    public String getSegmentID() {  return this.segmentID; }
    public int getCurrentPageIdx() {  return this.currentPageIdx; }
    public String getSelectedQuestion() {  return this.selectedQuestion; }
    public String getSkippedQuestions() {  return this.skippedQuestions; }
    public String getDataClassificationForSkipped() {  return this.dataClassificationForSkipped; }

    public void setAssessmentID(String newValue) {  this.assessmentID = newValue; }
    public void setSubjectID(String newValue) {  this.subjectID = newValue; }
    public void setExperimentID(String newValue) {  this.experimentID = newValue; }
    public void setVisitID(String newValue) {  this.visitID = newValue; }
    public void setSegmentID(String newValue) {  this.segmentID = newValue; }
    public void setCurrentPageIdx(int newValue) {  this.currentPageIdx = newValue; }
    public void setSelectedQuestion(String newValue) {  this.selectedQuestion = newValue; }
    public void setSkippedQuestions(String newValue) {  this.skippedQuestions = newValue; }
    public void setDataClassificationForSkipped(String newValue) {  this.dataClassificationForSkipped = newValue; }

    
public static class PageVariableInfo {
      int pageNumber;
      String formVarName;
      String dbVarName;
      Map metaDataMap;
      public PageVariableInfo(int pageNumber, String formVarName, String dbVarName) {
        this.pageNumber = pageNumber;
        this.formVarName = formVarName;
        this.dbVarName = dbVarName;
      }

      public int getPageNumber() { return this.pageNumber; }
      public String getFormVarName() { return this.formVarName; }
      public String getDbVarName() { return this.dbVarName; }
      public void addMetaData(String name, String value) {
        if (metaDataMap == null) {
          metaDataMap = new HashMap(3);
        }
        metaDataMap.put(name, value);
      }
      public Map getMetaDataMap() { return metaDataMap; }
    }

    private final static String assessmentName = "Simpson Angus Rating Scale";

    public static String getAssessmentName() { return assessmentName; }

    public static Map getVariableMap() {
      synchronized(SARSForm.class) {
        if (variableMap == null) {
      variableMap = new LinkedHashMap();
      PageVariableInfo pvi = null;

          variableMap.put("Status", pvi = new PageVariableInfo(1,"status","Status") );
          variableMap.put("Medication", pvi = new PageVariableInfo(1,"medication","Medication") );
          variableMap.put("Interview", pvi = new PageVariableInfo(1,"interview","Interview") );
          variableMap.put("Staff", pvi = new PageVariableInfo(1,"staff","Staff") );
          variableMap.put("Family", pvi = new PageVariableInfo(1,"family","Family") );
          variableMap.put("Friends", pvi = new PageVariableInfo(1,"friends","Friends") );
          variableMap.put("Other", pvi = new PageVariableInfo(1,"other","Other") );
          variableMap.put("Reliability", pvi = new PageVariableInfo(1,"reliability","Reliability") );
          variableMap.put("GAIT", pvi = new PageVariableInfo(2,"GAIT","GAIT") );
          variableMap.put("Arm Dropping", pvi = new PageVariableInfo(2,"armDropping","Arm Dropping") );
          variableMap.put("Shoulder Shaking", pvi = new PageVariableInfo(2,"shoulderShaking","Shoulder Shaking") );
          variableMap.put("Elbow Rigidty", pvi = new PageVariableInfo(2,"elbowRigidty","Elbow Rigidty") );
          variableMap.put("Cogwheeling Right", pvi = new PageVariableInfo(2,"cogwheelingRight","Cogwheeling Right") );
          variableMap.put("Cogwheeling Left", pvi = new PageVariableInfo(2,"cogwheelingLeft","Cogwheeling Left") );
          variableMap.put("Cogwheeling Overall", pvi = new PageVariableInfo(2,"cogwheelingOverall","Cogwheeling Overall") );
          variableMap.put("Rigidity of major joints Right", pvi = new PageVariableInfo(3,"rigidityOfMajorJointsRight","Rigidity of major joints Right") );
          variableMap.put("Rigidity of major joints Left", pvi = new PageVariableInfo(3,"rigidityOfMajorJointsLeft","Rigidity of major joints Left") );
          variableMap.put("Rigidity of major joints Overall", pvi = new PageVariableInfo(3,"rigidityOfMajorJointsOverall","Rigidity of major joints Overall") );
          variableMap.put("Fixation of Position or wrist rigidty", pvi = new PageVariableInfo(3,"fixationOfPositionOrWristRigidty","Fixation of Position or wrist rigidty") );
          variableMap.put("Leg Pendulousness", pvi = new PageVariableInfo(3,"legPendulousness","Leg Pendulousness") );
          variableMap.put("Head Dropping", pvi = new PageVariableInfo(3,"headDropping","Head Dropping") );
          variableMap.put("Glabella Tap", pvi = new PageVariableInfo(3,"glabellaTap","Glabella Tap") );
          variableMap.put("Tremor Right", pvi = new PageVariableInfo(4,"tremorRight","Tremor Right") );
          variableMap.put("Tremor Left", pvi = new PageVariableInfo(4,"tremorLeft","Tremor Left") );
          variableMap.put("Tremor Overall", pvi = new PageVariableInfo(4,"tremorOverall","Tremor Overall") );
          variableMap.put("Salivation", pvi = new PageVariableInfo(4,"salivation","Salivation") );
          variableMap.put("Balance", pvi = new PageVariableInfo(4,"balance","Balance") );
          variableMap.put("Akinesia", pvi = new PageVariableInfo(4,"akinesia","Akinesia") );
          variableMap.put("Akathisia", pvi = new PageVariableInfo(4,"akathisia","Akathisia") );
          variableMap.put("Addendum Acute Dsytonic Reaction", pvi = new PageVariableInfo(5,"addendumAcuteDsytonicReaction","Addendum Acute Dsytonic Reaction") );
          variableMap.put("Cooperativeness", pvi = new PageVariableInfo(5,"cooperativeness","Cooperativeness") );
        }
      }
      return variableMap;
    }
    public static Map getMandatoryFieldMetaDataMap() {
      if (mandatoryFieldMetaDataMap == null) {
        mandatoryFieldMetaDataMap = new HashMap(3);
        Map mdMap = new HashMap(3);
        mandatoryFieldMetaDataMap.put("clinicalrater",mdMap);
        mdMap.put("query","select a.name from nc_databaseuser a, nc_userclass b where a.userclass = b.uniqueid and b.name = 'researcher'");
      }
      return mandatoryFieldMetaDataMap;
    }


 public static class PageQuestionInfo {
    int pageNumber;
    int questionNumber;
    String type;
    int minAnswer;
    int maxAnswer;
    List scoreNames = new LinkedList();
    Map scoreNameIDMAp = new HashMap(3);

    public PageQuestionInfo(int pageNumber, int questionNumber, String type) {
      this(pageNumber, questionNumber, type, 1, 1);
    }

    public PageQuestionInfo(int pageNumber, int questionNumber, String type,
                            int minAnswer, int maxAnswer)
    {
      this.pageNumber = pageNumber;
      this.questionNumber = questionNumber;
      this.type = type;
      this.minAnswer = minAnswer;
      this.maxAnswer = maxAnswer;
    }

    public int getPageNumber() { return pageNumber; }
    public int getQuestionNumber() { return questionNumber; }
    public String getType() { return type; }
    public int getMinAnswer() { return minAnswer; }
    public int getMaxAnswer() { return maxAnswer; }

    public void addScoreNameIDAssoc(String scoreName, int id) {
       scoreNameIDMAp.put(scoreName, new Integer(id));
    }

    public Integer getIDForScoreName(String scoreName) {
       return (Integer) scoreNameIDMAp.get(scoreName);
    }

    public void addScoreName(String scoreName) {
      scoreNames.add(scoreName);
    }

    public List getScoreNames() { return scoreNames; }
  }


    public static Map getPageQuestionsMap() {
      synchronized(SARSForm.class) {
        if (pageQuestionsMap == null) {
          pageQuestionsMap = new LinkedHashMap();

          List list = null;
          PageQuestionInfo pqi = null;
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(3), list);
          list.add( pqi = new PageQuestionInfo(3,20,"regular") );
          pqi.addScoreName("Head Dropping");
          pqi.addScoreNameIDAssoc("Head Dropping",0);
          list.add( pqi = new PageQuestionInfo(3,17,"regular") );
          pqi.addScoreName("Rigidity of major joints Overall");
          pqi.addScoreNameIDAssoc("Rigidity of major joints Overall",0);
          list.add( pqi = new PageQuestionInfo(3,16,"regular") );
          pqi.addScoreName("Rigidity of major joints Left");
          pqi.addScoreNameIDAssoc("Rigidity of major joints Left",0);
          list.add( pqi = new PageQuestionInfo(3,15,"regular") );
          pqi.addScoreName("Rigidity of major joints Right");
          pqi.addScoreNameIDAssoc("Rigidity of major joints Right",0);
          list.add( pqi = new PageQuestionInfo(3,18,"regular") );
          pqi.addScoreName("Fixation of Position or wrist rigidty");
          pqi.addScoreNameIDAssoc("Fixation of Position or wrist rigidty",0);
          list.add( pqi = new PageQuestionInfo(3,19,"regular") );
          pqi.addScoreName("Leg Pendulousness");
          pqi.addScoreNameIDAssoc("Leg Pendulousness",0);
          list.add( pqi = new PageQuestionInfo(3,21,"regular") );
          pqi.addScoreName("Glabella Tap");
          pqi.addScoreNameIDAssoc("Glabella Tap",0);
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(1), list);
          list.add( pqi = new PageQuestionInfo(1,32,"regular") );
          pqi.addScoreName("Other");
          pqi.addScoreNameIDAssoc("Other",0);
          list.add( pqi = new PageQuestionInfo(1,5,"regular") );
          pqi.addScoreName("Family");
          pqi.addScoreNameIDAssoc("Family",0);
          list.add( pqi = new PageQuestionInfo(1,7,"regular") );
          pqi.addScoreName("Reliability");
          pqi.addScoreNameIDAssoc("Reliability",0);
          list.add( pqi = new PageQuestionInfo(1,31,"regular") );
          pqi.addScoreName("Friends");
          pqi.addScoreNameIDAssoc("Friends",0);
          list.add( pqi = new PageQuestionInfo(1,3,"regular") );
          pqi.addScoreName("Interview");
          pqi.addScoreNameIDAssoc("Interview",0);
          list.add( pqi = new PageQuestionInfo(1,1,"regular") );
          pqi.addScoreName("Status");
          pqi.addScoreNameIDAssoc("Status",0);
          list.add( pqi = new PageQuestionInfo(1,4,"regular") );
          pqi.addScoreName("Staff");
          pqi.addScoreNameIDAssoc("Staff",0);
          list.add( pqi = new PageQuestionInfo(1,2,"regular") );
          pqi.addScoreName("Medication");
          pqi.addScoreNameIDAssoc("Medication",0);
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(2), list);
          list.add( pqi = new PageQuestionInfo(2,13,"regular") );
          pqi.addScoreName("Cogwheeling Left");
          pqi.addScoreNameIDAssoc("Cogwheeling Left",0);
          list.add( pqi = new PageQuestionInfo(2,9,"regular") );
          pqi.addScoreName("Arm Dropping");
          pqi.addScoreNameIDAssoc("Arm Dropping",0);
          list.add( pqi = new PageQuestionInfo(2,14,"regular") );
          pqi.addScoreName("Cogwheeling Overall");
          pqi.addScoreNameIDAssoc("Cogwheeling Overall",0);
          list.add( pqi = new PageQuestionInfo(2,8,"regular") );
          pqi.addScoreName("GAIT");
          pqi.addScoreNameIDAssoc("GAIT",0);
          list.add( pqi = new PageQuestionInfo(2,11,"regular") );
          pqi.addScoreName("Elbow Rigidty");
          pqi.addScoreNameIDAssoc("Elbow Rigidty",0);
          list.add( pqi = new PageQuestionInfo(2,12,"regular") );
          pqi.addScoreName("Cogwheeling Right");
          pqi.addScoreNameIDAssoc("Cogwheeling Right",0);
          list.add( pqi = new PageQuestionInfo(2,10,"regular") );
          pqi.addScoreName("Shoulder Shaking");
          pqi.addScoreNameIDAssoc("Shoulder Shaking",0);
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(5), list);
          list.add( pqi = new PageQuestionInfo(5,29,"regular") );
          pqi.addScoreName("Addendum Acute Dsytonic Reaction");
          pqi.addScoreNameIDAssoc("Addendum Acute Dsytonic Reaction",0);
          list.add( pqi = new PageQuestionInfo(5,30,"regular") );
          pqi.addScoreName("Cooperativeness");
          pqi.addScoreNameIDAssoc("Cooperativeness",0);
          list = new LinkedList();
          pageQuestionsMap.put( new Integer(4), list);
          list.add( pqi = new PageQuestionInfo(4,24,"regular") );
          pqi.addScoreName("Tremor Overall");
          pqi.addScoreNameIDAssoc("Tremor Overall",0);
          list.add( pqi = new PageQuestionInfo(4,23,"regular") );
          pqi.addScoreName("Tremor Left");
          pqi.addScoreNameIDAssoc("Tremor Left",0);
          list.add( pqi = new PageQuestionInfo(4,25,"regular") );
          pqi.addScoreName("Salivation");
          pqi.addScoreNameIDAssoc("Salivation",0);
          list.add( pqi = new PageQuestionInfo(4,26,"regular") );
          pqi.addScoreName("Balance");
          pqi.addScoreNameIDAssoc("Balance",0);
          list.add( pqi = new PageQuestionInfo(4,28,"regular") );
          pqi.addScoreName("Akathisia");
          pqi.addScoreNameIDAssoc("Akathisia",0);
          list.add( pqi = new PageQuestionInfo(4,27,"regular") );
          pqi.addScoreName("Akinesia");
          pqi.addScoreNameIDAssoc("Akinesia",0);
          list.add( pqi = new PageQuestionInfo(4,22,"regular") );
          pqi.addScoreName("Tremor Right");
          pqi.addScoreNameIDAssoc("Tremor Right",0);
        }
      }
      return pageQuestionsMap;
    }

    private String q20_notes = "";
    private String q32_notes = "";
    private String q13_notes = "";
    private String q9_notes = "";
    private String q17_notes = "";
    private String q14_notes = "";
    private String q5_notes = "";
    private String q16_notes = "";
    private String q15_notes = "";
    private String q7_notes = "";
    private String q31_notes = "";
    private String q8_notes = "";
    private String q29_notes = "";
    private String q24_notes = "";
    private String q23_notes = "";
    private String q30_notes = "";
    private String q18_notes = "";
    private String q25_notes = "";
    private String q26_notes = "";
    private String q19_notes = "";
    private String q28_notes = "";
    private String q3_notes = "";
    private String q27_notes = "";
    private String q1_notes = "";
    private String q11_notes = "";
    private String q4_notes = "";
    private String q12_notes = "";
    private String q2_notes = "";
    private String q21_notes = "";
    private String q10_notes = "";
    private String q22_notes = "";

    public String getQ20_notes() {  return this.q20_notes; }
    public void setQ20_notes(String newValue) {  this.q20_notes = newValue; }
    public String getQ32_notes() {  return this.q32_notes; }
    public void setQ32_notes(String newValue) {  this.q32_notes = newValue; }
    public String getQ13_notes() {  return this.q13_notes; }
    public void setQ13_notes(String newValue) {  this.q13_notes = newValue; }
    public String getQ9_notes() {  return this.q9_notes; }
    public void setQ9_notes(String newValue) {  this.q9_notes = newValue; }
    public String getQ17_notes() {  return this.q17_notes; }
    public void setQ17_notes(String newValue) {  this.q17_notes = newValue; }
    public String getQ14_notes() {  return this.q14_notes; }
    public void setQ14_notes(String newValue) {  this.q14_notes = newValue; }
    public String getQ5_notes() {  return this.q5_notes; }
    public void setQ5_notes(String newValue) {  this.q5_notes = newValue; }
    public String getQ16_notes() {  return this.q16_notes; }
    public void setQ16_notes(String newValue) {  this.q16_notes = newValue; }
    public String getQ15_notes() {  return this.q15_notes; }
    public void setQ15_notes(String newValue) {  this.q15_notes = newValue; }
    public String getQ7_notes() {  return this.q7_notes; }
    public void setQ7_notes(String newValue) {  this.q7_notes = newValue; }
    public String getQ31_notes() {  return this.q31_notes; }
    public void setQ31_notes(String newValue) {  this.q31_notes = newValue; }
    public String getQ8_notes() {  return this.q8_notes; }
    public void setQ8_notes(String newValue) {  this.q8_notes = newValue; }
    public String getQ29_notes() {  return this.q29_notes; }
    public void setQ29_notes(String newValue) {  this.q29_notes = newValue; }
    public String getQ24_notes() {  return this.q24_notes; }
    public void setQ24_notes(String newValue) {  this.q24_notes = newValue; }
    public String getQ23_notes() {  return this.q23_notes; }
    public void setQ23_notes(String newValue) {  this.q23_notes = newValue; }
    public String getQ30_notes() {  return this.q30_notes; }
    public void setQ30_notes(String newValue) {  this.q30_notes = newValue; }
    public String getQ18_notes() {  return this.q18_notes; }
    public void setQ18_notes(String newValue) {  this.q18_notes = newValue; }
    public String getQ25_notes() {  return this.q25_notes; }
    public void setQ25_notes(String newValue) {  this.q25_notes = newValue; }
    public String getQ26_notes() {  return this.q26_notes; }
    public void setQ26_notes(String newValue) {  this.q26_notes = newValue; }
    public String getQ19_notes() {  return this.q19_notes; }
    public void setQ19_notes(String newValue) {  this.q19_notes = newValue; }
    public String getQ28_notes() {  return this.q28_notes; }
    public void setQ28_notes(String newValue) {  this.q28_notes = newValue; }
    public String getQ3_notes() {  return this.q3_notes; }
    public void setQ3_notes(String newValue) {  this.q3_notes = newValue; }
    public String getQ27_notes() {  return this.q27_notes; }
    public void setQ27_notes(String newValue) {  this.q27_notes = newValue; }
    public String getQ1_notes() {  return this.q1_notes; }
    public void setQ1_notes(String newValue) {  this.q1_notes = newValue; }
    public String getQ11_notes() {  return this.q11_notes; }
    public void setQ11_notes(String newValue) {  this.q11_notes = newValue; }
    public String getQ4_notes() {  return this.q4_notes; }
    public void setQ4_notes(String newValue) {  this.q4_notes = newValue; }
    public String getQ12_notes() {  return this.q12_notes; }
    public void setQ12_notes(String newValue) {  this.q12_notes = newValue; }
    public String getQ2_notes() {  return this.q2_notes; }
    public void setQ2_notes(String newValue) {  this.q2_notes = newValue; }
    public String getQ21_notes() {  return this.q21_notes; }
    public void setQ21_notes(String newValue) {  this.q21_notes = newValue; }
    public String getQ10_notes() {  return this.q10_notes; }
    public void setQ10_notes(String newValue) {  this.q10_notes = newValue; }
    public String getQ22_notes() {  return this.q22_notes; }
    public void setQ22_notes(String newValue) {  this.q22_notes = newValue; }
    
    public void reset(ActionMapping mapping, HttpServletRequest request) {
    }
}
