package clinical.web.helpers;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
//import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

//import org.jfree.util.Log;
import clinical.comm.Collection;
import clinical.utils.FileUtils;
//import clinical.web.actions.AnalysisResultQueryAction;
//import clinical.web.actions.SVNavigateAction.Header;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.services.BatchQueryResult;
import clinical.web.services.AssessmentServiceHelper.SiteAsiInfo;
//import clinical.web.vo.QuerySummary;
import clinical.web.vo.ASValueKey;
import clinical.web.vo.AssessmentResultSummary;
import clinical.web.vo.QuerySummary;
import clinical.web.vo.SubjectAsScoreValueSummary;
import clinical.web.vo.VisitSegAsResultValues;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import edu.emory.mathcs.backport.java.util.Collections;




//import com.sun.java.util.collections.Map.Entry;

/**
 * @author I. Burak Ozyurt
 * @version $Id: BatchQueryHelper.java 453 2011-08-31 17:45:09Z jinranc $
 */
public class BatchQueryHelper {	
	private static Log log = LogFactory.getLog(BatchQueryHelper.class);
	
	private static ResultSet geneResultSet;
	public static void setGeneResultSet(ResultSet rs) {
		geneResultSet = rs;
	}

	public static ResultSet getGeneResultSet() {
		return geneResultSet;
	}

	/*
	 * Jinran added
	 * An object class represents a header row in wide format in CSV file
	 */	
	public static class ClsHeaderRow{
		private String subjectID;
		private String siteID;
		private String expID;
		private String visitID;
		private String segID;
		private List<String> assAndScoreName = new LinkedList<String>(); //name combined with assessment name and score name
		//private String scoreValue;
		private String subjectIDValue;
		
		private String visitName;
		private String visitDate;
		private String studyGroup;	//research group name
		private String segmentName;
		private String segmentDate;
		private String studyName;	//nc_expStudy name
		private String studyDate;	//nc_expStudy date
		private String studyId;		//nc_expStudy id
		
		
		public void setSubjectIDValue(String value){
			this.subjectIDValue = value;
		}
		
		public String getSubjectIDValue(){
			return this.subjectIDValue;
		}
			
		public void setSubjectID(String subjectID) {
			this.subjectID = subjectID;
		}
		
		public String getSubjectID() {
			return subjectID;
		}
		
		public void setSiteID(String siteID) {
			this.siteID = siteID;
		}
		
		public String getSiteID() {
			return siteID;
		}
		
		public void setExpID(String expID) {
			this.expID = expID;
		}
		
		public String getExpID() {
			return expID;
		}
		
		public void setVisitID(String visitID) {
			this.visitID = visitID;
		}
		
		public String getVisitID() {
			return visitID;
		}
		
		public void setSegID(String segID) {
			this.segID = segID;
		}
		
		public String getSegID() {
			return segID;
		}

		public void setAssAndScoreName(List<String> assAndScoreName) {
			this.assAndScoreName = assAndScoreName;
		}

		public List<String> getAssAndScoreName() {
			return assAndScoreName;
		}

		public void setVisitName(String visitName) {
			this.visitName = visitName;
		}

		public String getVisitName() {
			return visitName;
		}

		public void setVisitDate(String visitDate) {
			this.visitDate = visitDate;
		}

		public String getVisitDate() {
			return visitDate;
		}

		public void setStudyGroup(String studyGroup) {
			this.studyGroup = studyGroup;
		}

		public String getStudyGroup() {
			return studyGroup;
		}

		public void setSegmentName(String segmentName) {
			this.segmentName = segmentName;
		}

		public String getSegmentName() {
			return segmentName;
		}

		public void setSegmentDate(String segmentDate) {
			this.segmentDate = segmentDate;
		}

		public String getSegmentDate() {
			return segmentDate;
		}

		public void setStudyName(String studyName) {
			this.studyName = studyName;
		}

		public String getStudyName() {
			return studyName;
		}

		public void setStudyDate(String studyDate) {
			this.studyDate = studyDate;
		}

		public String getStudyDate() {
			return studyDate;
		}

		public void setStudyId(String studyId) {
			this.studyId = studyId;
		}

		public String getStudyId() {
			return studyId;
		}		

	}
	
	/*
	 * Jinran added
	 * An object class represents a data row in wide format in CSV file 
	 */
	public static class ClsDataRow{
		private String subjectID;
		private String siteID;
		private String expID;
		private String visitID;
		private String segID;
		
		private String visitName = "";
		private String visitDate = "";
		private String studyGroup = "";
		private String segmentName = "";
		private String segmentDate = "";
		private String studyName = "";
		private String studyId = "";
		private String studyDate = "";
		
		private HashMap<String, String> assAndScoreNameValue = new HashMap<String, String>(); //name and value combined with assessment name and score name

		public ClsDataRow(List<String> assAndScoreName){

			for(String name: assAndScoreName){
				this.assAndScoreNameValue.put(name.toString(), ".");	
			}			
		}
		
		public ClsDataRow() {
			// TODO Auto-generated constructor stub
		}

		public void setSubjectID(String subjectID) {
			this.subjectID = subjectID;
		}
		
		public String getSubjectID() {
			return subjectID;
		}
		
		public void setSiteID(String siteID) {
			this.siteID = siteID;
		}
		
		public String getSiteID() {
			return siteID;
		}
		
		public void setExpID(String expID) {
			this.expID = expID;
		}
		
		public String getExpID() {
			return expID;
		}
		
		public void setVisitID(String visitID) {
			this.visitID = visitID;
		}
		
		public String getVisitID() {
			return visitID;
		}
		
		public void setSegID(String segID) {
			this.segID = segID;
		}
		
		public String getSegID() {
			return segID;
		}

		public void setAssAndScoreNameValue(HashMap<String, String> assAndScoreNameValue) {
			this.assAndScoreNameValue = assAndScoreNameValue;
		}

		public HashMap<String, String> getAssAndScoreNameValue() {
			return assAndScoreNameValue;
		}

		public void setVisitName(String visitName) {
			this.visitName = visitName;
		}

		public String getVisitName() {
			return visitName;
		}

		public void setVisitDate(String visitDate) {
			this.visitDate = visitDate;
		}

		public String getVisitDate() {
			return visitDate;
		}

		public void setStudyGroup(String studyGroup) {
			this.studyGroup = studyGroup;
		}

		public String getStudyGroup() {
			return studyGroup;
		}

		public void setSegmentName(String segmentName) {
			this.segmentName = segmentName;
		}

		public String getSegmentName() {
			return segmentName;
		}

		public void setSegmentDate(String segmentDate) {
			this.segmentDate = segmentDate;
		}

		public String getSegmentDate() {
			return segmentDate;
		}

		public void setStudyName(String studyName) {
			this.studyName = studyName;
		}

		public String getStudyName() {
			return studyName;
		}

		public void setStudyId(String studyId) {
			this.studyId = studyId;
		}

		public String getStudyId() {
			return studyId;
		}

		public void setStudyDate(String studyDate) {
			this.studyDate = studyDate;
		}

		public String getStudyDate() {
			return studyDate;
		}		

	}
	
	public static void prepareCSV(BufferedWriter out, List<QuerySummary> qsList, String longFormat){
		try{
			if(longFormat.equals("long")){ // unrevised format (long)			
				outputLongFormatCSV(qsList, out, null);
			}else if(longFormat.equals("wide")){ //output in wide format
				outputWideFormatCSV(qsList, out, null);			
			}else if(longFormat.equals("wider")){
				outputWiderFormatCSV(qsList, out, null);
			}	
		}catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	public static void prepareCSVFile(File file, BatchQueryResult bqr, String longFormat)
			throws Exception {
		
		BufferedWriter out = null;

		if(longFormat.equals("long")){ // unrevised format (long)			
			outputLongFormat(bqr, out, file);
		}else if(longFormat.equals("wide")){ 
			outputWideFormat(bqr, out, file);
		}else if(longFormat.equals("wider")){
			outputWiderFormat(bqr, out, file);
		}
	}
	
	/*
	 * Export csv file in long format: subjectId, experiment, visitId, segmentId, assessmentName, scoreName, scoreValue
	 */
	private static void outputLongFormatCSV(List<QuerySummary> qsList, BufferedWriter out, File file){
		StringBuilder buf = new StringBuilder(256);
		buf.append("SubjectID,");
		buf.append("SiteID,");
		buf.append("ExperimentID,");
		buf.append("VisitID,");
		buf.append("SegmentID,");
		buf.append("AssessmentName,");
		buf.append("ScoreName,");
		buf.append("ScoreValue");
		String header = buf.toString();

		try {
			if(file!=null){
				out = new BufferedWriter(new FileWriter(file));
			}
			
			out.write(header);
			out.newLine();

			String[] row = new String[8];
			
			for(QuerySummary qs : qsList){
				AssessmentResultSummary ars = qs.getArs();
				for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
					row[0] = ars.getSubjectID();
					String siteID = vsarv.getSiteID();

					if (siteID == null) {
						row[1] = ars.getSubjectID().substring(0, 4);
					} else {
						row[1] = siteID;
					}

					for(ASValueKey aKey : vsarv.getSasvsMap().keySet()){
						row[2] = String.valueOf(ars.getExpName());
						row[3] = String.valueOf(vsarv.getVisitID());
						row[4] = String.valueOf(vsarv.getSegmentID());
						row[5] = aKey.getAsName();
						row[6] = aKey.getScoreName();
						// TODO multiple values per score
						SubjectAsScoreValueSummary sasvs = vsarv.getSasvsMap().get(aKey);			
//						row[7] = sasvs.getValue() != null ? sasvs.getValue().toString()	: ".";
//						if(sasvs.getScoreType().equals("integer")){
//							if(sasvs.getValue().equals("")){
//								row[7]=".";
//							}
//						}						
						if(sasvs.getValue()!=null){
							row[7]= sasvs.getValue().toString();
							if(sasvs.getScoreType().equals("integer")){
								if(sasvs.getValue().equals("")) row[7] = ".";							
							}						
						}else{
							row[7]=".";
						}
						buf = new StringBuilder(200);
						for (int i = 0; i < row.length; i++) {
							buf.append(row[i]).append(',');
						}							
					}
					out.write(buf.substring(0, buf.length() - 1));
					out.newLine();
				}
			}
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			FileUtils.close(out);
		}		
	}	

	/*
	 * Export csv file in Wide Format. SubjectId, ExperimentID, VisitId, SegmentId, Var1, Var2, ... VarN 
	 */
	private static void outputWideFormatCSV(List<QuerySummary>qsList, BufferedWriter out, File file) throws IOException{
		// Add header row
		ClsHeaderRow hdr = addHeaderRowCSV(qsList, "wide");
		
		// Add data row		
		List<ClsDataRow> dataRowList = addDataRowCSV(qsList, hdr, "wide");
		
		// export to csv file
		exportFile(file, out, hdr, dataRowList, "wide");							
	}
	
	/*
	 * Export csv file in Wider Format. SubjectId, ExperimentID, Var1_visit1, Var1_visit2, ... VarN_visit1, varN_visitN 
	 */
	private static void outputWiderFormatCSV(List<QuerySummary> qsList, BufferedWriter out, File file){
		ClsHeaderRow hdr = addHeaderRowCSV(qsList, "wider");
		
		List<ClsDataRow> dataRowList = addDataRowCSV(qsList, hdr, "wider"); 

		exportFile(file, out, hdr, dataRowList, "wider");				
	}

	private static List<ClsDataRow> addDataRowCSV(List<QuerySummary> qsList,
			ClsHeaderRow hdr, String format) {
		List<ClsDataRow> dataRowList = new LinkedList<ClsDataRow>();				
		
		for(QuerySummary qs : qsList){
			AssessmentResultSummary ars = qs.getArs();
			for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
				String name = new String();
				ClsDataRow dr = new ClsDataRow();
				if(format.equals("wide")||format.equals("long")){
					dr = dataRowContainsSubject(dataRowList, ars.getSubjectID(), vsarv.getSiteID(), 
							String.valueOf(ars.getExpName()), String.valueOf(vsarv.getVisitID()), String.valueOf(vsarv.getSegmentID()));					
				}else if(format.equals("wider")){
					dr = dataRowContainsSubject(dataRowList, ars.getSubjectID(), vsarv.getSiteID(), 
							String.valueOf(ars.getExpName()));
				}
				
				if(dr!=null){
					String asName = null;	
					String scoreName = null;
					StringBuilder sb = new StringBuilder();
					
					for(ASValueKey aKey : vsarv.getSasvsMap().keySet()){
						asName = aKey.getAsName();
						scoreName = aKey.getScoreName();
						sb.append(asName);
						sb.append("_");
						sb.append(scoreName);
						if(format.equals("wider")){
							sb.append("_Visit");
							sb.append(vsarv.getVisitID());
							sb.append("_Seg");
							sb.append(vsarv.getSegmentID());
						}
						sb.append(",");
						name = replaceWithUnderScore(sb.toString());

						if(dr.getAssAndScoreNameValue().containsKey(name)){
							SubjectAsScoreValueSummary sasvs = vsarv.getSasvsMap().get(aKey);								
//							String score = sasvs.getValue() != null ? sasvs.getValue().toString(): ".";
//							if(sasvs.getScoreType().equals("integer")){
//								if(sasvs.getValue().equals("")){
//									score=".";
//								}
//							}
							String score;
							if(sasvs.getValue()!=null){
								score = sasvs.getValue().toString();
								if(sasvs.getScoreType().equals("integer")){
									if(sasvs.getValue().equals("")) score = ".";							
								}						
							}else{
								score=".";
							}
							dr.getAssAndScoreNameValue().put(name, score);
						}else{
							log.info("Error in creating header columns.");
						}
					}
				}else{
					//Subject does not exist in DataRowList
					//create a new clsDataRow
					ClsDataRow dataRow = new ClsDataRow(); 
					if(hdr!=null){
						dataRow  = new ClsDataRow(hdr.assAndScoreName);							
					}
					dataRow.subjectID = ars.getSubjectID();
					dataRow.siteID = vsarv.getSiteID();
					if (dataRow.siteID == null) {
						dataRow.siteID = ars.getSubjectID().substring(0, 4);
					} 
					
					for(ASValueKey aKey : vsarv.getSasvsMap().keySet()){
						String asName = null;
						String scoreName = null;
						
						asName = aKey.getAsName();
						scoreName = aKey.getScoreName();
						
						dataRow.expID =ars.getExpName();
						
						if(!format.equals("wider")){
							if(vsarv.getVisitName()!=null) dataRow.visitName = String.valueOf(vsarv.getVisitName());
							if(vsarv.getVisitDate()!=null) dataRow.visitDate = String.valueOf(vsarv.getVisitDate());
							dataRow.visitID =String.valueOf(vsarv.getVisitID());
							if(vsarv.getStudyName()!=null) dataRow.studyName = String.valueOf(vsarv.getStudyName());
							if(vsarv.getStudyDate()!=null) dataRow.studyDate = String.valueOf(vsarv.getStudyDate());
							if(vsarv.getStudyID()!=-1) dataRow.studyId = String.valueOf(vsarv.getStudyID());
							if(vsarv.getSegmentName()!=null) dataRow.segmentName = String.valueOf(vsarv.getSegmentName());
							if(vsarv.getSegmentDate()!=null) dataRow.segmentDate = String.valueOf(vsarv.getSegmentDate());
							dataRow.segID = String.valueOf(vsarv.getSegmentID());							
							if(vsarv.getStudyGroup()!=null) dataRow.studyGroup = String.valueOf(vsarv.getStudyGroup());							
						}
						
						StringBuilder sb = new StringBuilder();
						sb.append(asName);
						sb.append("_");
						sb.append(scoreName);
						if(format.equals("wider")){
							sb.append("_Visit");
							sb.append(vsarv.getVisitID());
							sb.append("_Seg");
							sb.append(vsarv.getSegmentID());
						}
						sb.append(",");
						name = replaceWithUnderScore(sb.toString());
						if(dataRow.getAssAndScoreNameValue().containsKey(name)){
							SubjectAsScoreValueSummary sasvs = vsarv.getSasvsMap().get(aKey);
//							String score = sasvs.getValue() != null ? sasvs.getValue().toString(): ".";
//							if(sasvs.getScoreType().equals("integer")){
//								if(sasvs.getValue().equals("")){
//									score=".";
//								}
//							}
							String score;
							if(sasvs.getValue()!=null){
								score = sasvs.getValue().toString();
								if(sasvs.getScoreType().equals("integer")){
									if(sasvs.getValue().equals("")) score = ".";							
								}						
							}else{
								score=".";
							}
							dataRow.getAssAndScoreNameValue().put(name, score);
						}else{
							log.info("Error in creating header columns.");
						}
					}
					dataRowList.add(dataRow);
				}
				
			}
		}
		return dataRowList;
	}

	private static ClsHeaderRow addHeaderRowCSV(List<QuerySummary> qsList, String format) {
		ClsHeaderRow hdr = new ClsHeaderRow();
		hdr.subjectID = "SubjectID,";
		hdr.siteID =	"SiteID,";
		hdr.expID = "Experiment,";
		if(format.equals("wide")||format.equals("long")){
			hdr.visitName = "VisitName,";
			hdr.visitDate = "VisitDate,";
			hdr.visitID = "VisitID,";
			hdr.setStudyName("StudyName,");
			hdr.setStudyDate("StudyDate,");
			hdr.setStudyId("StudyId,");			
			hdr.segmentName = "SegmentName,";
			hdr.segmentDate = "SegmentDate,";
			hdr.segID = "SegmentID,";
			hdr.studyGroup = "StudyGroup,";						
		}
		
		// Add Header row		
		String ass_scoreName;
		
		for(QuerySummary qs : qsList){
			AssessmentResultSummary ars = qs.getArs();
			for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
				//get assessment name and score name
				String siteID = vsarv.getSiteID();
				if (siteID == null) {
					siteID = ars.getSubjectID().substring(0, 4);
				} 
				
				String asName = null;
				String scoreName = null;			
				for(ASValueKey aKey : vsarv.getSasvsMap().keySet()){
					asName = aKey.getAsName();
					scoreName = aKey.getScoreName();
					
					StringBuilder sb = new StringBuilder();
					sb.append(asName);
					sb.append("_");
					sb.append(scoreName);
					if(format.equals("wider")){
						sb.append("_Visit");
						sb.append(vsarv.getVisitID());
						sb.append("_Seg");
						sb.append(vsarv.getSegmentID());
					}
					sb.append(",");
					ass_scoreName = sb.toString();
					
					//replace non-alphabet or non-underscore with underscore
					ass_scoreName = replaceWithUnderScore(ass_scoreName);
					
					//add column name to header row if not exists in hdr object
					Boolean bExist = false;
					if(hdr.assAndScoreName!=null){
						for(String st: hdr.assAndScoreName){
							if(ass_scoreName.equals(st)){
								bExist = true;
								break;
							}
						}	
					}					
					if(!bExist){
						hdr.assAndScoreName.add(ass_scoreName);
						java.util.Collections.sort(hdr.assAndScoreName);
					}
				}	
			}
		}
		return hdr;
	}
	
	private static void exportFile(File file, BufferedWriter out, ClsHeaderRow hdr, List<ClsDataRow> dataRowList, 
			String longFormat){		
		//output to csv		
		try{		
			if(file!=null){
				out = new BufferedWriter(new FileWriter(file));
			}
			
			StringBuilder buf = new StringBuilder();
			
			//write header first
			buf.append(hdr.subjectID);
			buf.append(hdr.siteID);
			buf.append(hdr.expID);
			if(longFormat.equals("wide")||longFormat.equals("long")){
				buf.append(hdr.visitName);
				buf.append(hdr.visitDate);
				buf.append(hdr.visitID);
				buf.append(hdr.studyName);
				buf.append(hdr.studyDate);
				buf.append(hdr.studyId);
				buf.append(hdr.segmentName);
				buf.append(hdr.segmentDate);
				buf.append(hdr.segID);				
				buf.append(hdr.studyGroup);				
			}
			for(String sName : hdr.assAndScoreName){
				buf.append(sName);
			}
			buf.deleteCharAt(buf.length()-1);
			out.write(buf.toString());
			out.newLine();
			
			//write datarow				
			for(ClsDataRow drow : dataRowList){
				buf = new StringBuilder();
				buf.append(drow.subjectID);
				buf.append(",");
				buf.append(drow.siteID);
				buf.append(",");
				buf.append(drow.expID);
				buf.append(",");
				if(longFormat.equals("wide")||longFormat.equals("wide")){
					buf.append(drow.visitName);
					buf.append(",");
					buf.append(drow.visitDate);
					buf.append(",");					
					buf.append(drow.visitID);
					buf.append(",");
					buf.append(drow.studyName);
					buf.append(",");
					buf.append(drow.studyDate);
					buf.append(",");
					buf.append(drow.studyId);
					buf.append(",");
					buf.append(drow.segmentName);
					buf.append(",");
					buf.append(drow.segmentDate);
					buf.append(",");
					buf.append(drow.segID);
					buf.append(",");
					buf.append(drow.studyGroup);
					buf.append(",");					
				}
				
				for(String sName : hdr.assAndScoreName){
					Boolean bFind = false;
					for(Map.Entry<String,String> entry : drow.assAndScoreNameValue.entrySet()){
						if(entry.getKey().equals(sName)){
							buf.append(entry.getValue().toString());
							buf.append(",");
							bFind = true;
							break;
						}							
					}	
					if(bFind.equals(false)){
						buf.append(".");
						buf.append(",");
					}
				}					
				
				buf.deleteCharAt(buf.length()-1);
				out.write(buf.toString());
				out.newLine();
			}
		}
		catch (IOException e) {
		// TODO Auto-generated catch block
			e.printStackTrace();
		}
		finally{
			FileUtils.close(out);
		}
	}

	/*
	 * Export batch query results in long format: subjectId, experiment, visitId, segmentId, assessmentName, scoreName, scoreValue
	 */
	private static void outputLongFormat(BatchQueryResult bqr, BufferedWriter out, File file){
		StringBuilder buf = new StringBuilder(256);
		buf.append("SubjectID,");
		buf.append("SiteID,");
		buf.append("ExperimentID,");
		buf.append("VisitID,");
		buf.append("SegmentID,");
		buf.append("AssessmentName,");
		buf.append("ScoreName,");
		buf.append("ScoreValue");
		String header = buf.toString();

		Map<String, String> map = new HashMap<String, String>(37);
		String theSite = null;
		Set<String> seenSites = new HashSet<String>(17);
		for (Map.Entry<String, SiteAsiInfo> entry : bqr.getSaiMap().entrySet()) {
			String siteID = entry.getKey();
			if (!seenSites.contains(siteID.toUpperCase())) {
				theSite = siteID.toUpperCase();
				seenSites.add(theSite);
			}
			SiteAsiInfo sai = entry.getValue();

			for (AssessmentSelectionInfo asi : sai.getAsiList()) {
				StringBuffer keyBuf = new StringBuffer(asi.getAssessmentID()
						.toString());
				keyBuf.append('_').append(siteID.toUpperCase());
				map.put(keyBuf.toString(), asi.getName());
			}
		}
		if (seenSites.size() > 1) {
			theSite = null;
		}

		try {
			if(file!=null){
				out = new BufferedWriter(new FileWriter(file));
			}

			out.write(header);
			out.newLine();

			String[] row = new String[8];
			for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
				row[0] = sasvs.getSubjectID();
				String siteID = sasvs.getSiteID();
				
				if (siteID == null) {
					row[1] = sasvs.getSubjectID().substring(0, 4);
				} else {
					row[1] = siteID;
				}

				String asName = null;
				StringBuilder keyBuf = new StringBuilder();
				keyBuf.append(sasvs.getAssessmentID()).append('_');
				keyBuf.append(siteID.toUpperCase());
				asName = map.get(keyBuf.toString());
				if (asName == null) {
					// hack for BDR
					// in BDR data from multiple sites are pooled , they have
					// different site ids but same assessment ids
					if (theSite != null) {
						keyBuf = new StringBuilder();
						keyBuf.append(sasvs.getAssessmentID()).append('_')
								.append(theSite);
						asName = map.get(keyBuf.toString());
					}
				}

				row[2] = String.valueOf(sasvs.getExperimentID());
				row[3] = String.valueOf(sasvs.getVisitID());
				row[4] = String.valueOf(sasvs.getSegmentID());
				row[5] = asName;
				row[6] = sasvs.getScoreName();
				// TODO multiple values per score
//				row[7] = sasvs.getValue() != null ? sasvs.getValue().toString()
//						: ".";
//				if(sasvs.getScoreType().equals("integer")){
//					if(sasvs.getValue().equals("")){
//						row[7]=".";
//					}
//				}				
				if(sasvs.getValue()!=null){
					row[7] = sasvs.getValue().toString();
					if(sasvs.getScoreType().equals("integer")){
						if(sasvs.getValue().equals("")) row[7] = ".";							
					}						
				}else{
					row[7] = ".";
				}
				buf = new StringBuilder(200);
				for (int i = 0; i < row.length; i++) {
					buf.append(row[i]).append(',');
				}
				out.write(buf.substring(0, buf.length() - 1));
				out.newLine();
			}

		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			FileUtils.close(out);
		}		
	}

	/*
	 * Export batch query results in Wide Format. SubjectId, ExperimentID, VisitId, SegmentId, Var1, Var2, ... VarN 
	 */
	private static void outputWideFormat(BatchQueryResult bqr, BufferedWriter out, File file){
		ClsHeaderRow hdr = new ClsHeaderRow();
		Map<String, String> map = new HashMap<String, String>(37);
		String theSite = null;
		
		addHeaderToFile(bqr, hdr,map, theSite, "wide");
		
		List<ClsDataRow> dataRowList = addDataRowToFile(bqr, hdr, map,
					theSite, "wide");

		exportFile(file, out, hdr,dataRowList, "wide");						
	}

	/*
	 * Export batch query results in Wider Format. SubjectId, ExperimentID, Var1_visit1, Var1_visit2, ... VarN_visit1, varN_visitN 
	 */
	private static void outputWiderFormat(BatchQueryResult bqr, BufferedWriter out, File file){
		ClsHeaderRow hdr = new ClsHeaderRow();
		Map<String, String> map = new HashMap<String, String>(37);
		String theSite = null;
		
		theSite = addHeaderToFile(bqr, hdr, map, theSite, "wider");
	
		List<ClsDataRow> dataRowList = addDataRowToFile(bqr, hdr, map,
					theSite, "wider");

		exportFile(file, out, hdr, dataRowList, "wider");		
	}

	private static List<ClsDataRow> addDataRowToFile(BatchQueryResult bqr,
			ClsHeaderRow hdr, Map<String, String> map, String theSite, String format) {
		List<ClsDataRow> dataRowList = new LinkedList<ClsDataRow>();				
						
		for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
			String name = new String();
			ClsDataRow dr = new ClsDataRow();
			if(format.equals("wide")||format.equals("long")){
				dr = dataRowContainsSubject(dataRowList, sasvs.getSubjectID(), sasvs.getSiteID(), 
						String.valueOf(sasvs.getExperimentID()), String.valueOf(sasvs.getVisitID()), String.valueOf(sasvs.getSegmentID()));
			}else if(format.equals("wider")){
				dr = dataRowContainsSubject(dataRowList, sasvs.getSubjectID(), sasvs.getSiteID(), 
						String.valueOf(sasvs.getExperimentID()));
			}
			
			if(dr!=null){
				String asName = null;
				StringBuilder keyBuf = new StringBuilder();
				keyBuf.append(sasvs.getAssessmentID()).append('_');
				keyBuf.append(dr.siteID.toUpperCase());
				asName = map.get(keyBuf.toString());

				if (asName == null) {
					// hack for BDR
					// in BDR data from multiple sites are pooled , they have
					// different site ids but same assessment ids
					if (theSite != null) {
						keyBuf = new StringBuilder();
						keyBuf.append(sasvs.getAssessmentID()).append('_')
								.append(theSite);
						asName = map.get(keyBuf.toString());
					}
				}
					
				StringBuilder sb = new StringBuilder();
				sb.append(asName);
				sb.append("_");
				sb.append(sasvs.getScoreName());
				if(format.equals("wider")){
					sb.append("_Visit");
					sb.append(sasvs.getVisitID());
					sb.append("_Seg");
					sb.append(sasvs.getSegmentID());
				}
				sb.append(",");
				name = replaceWithUnderScore(sb.toString());
				
				if(dr.getAssAndScoreNameValue().containsKey(name)){
//					String score = sasvs.getValue() != null ? sasvs.getValue().toString(): ".";
//					if(sasvs.getScoreType().equals("integer")){
//						if(sasvs.getValue().equals("")){
//							score=".";
//						}
//					}
					String score;
					if(sasvs.getValue()!=null){
						score = sasvs.getValue().toString();
						if(sasvs.getScoreType().equals("integer")){
							if(sasvs.getValue().equals("")) score = ".";							
						}						
					}else{
						score=".";
					}
					dr.getAssAndScoreNameValue().put(name, score);
				}else{
					log.info("Error in creating header columns.");
				}
			}else{
				//Subject does not exist in DataRowList
				//create a new clsDataRow
				ClsDataRow dataRow = new ClsDataRow(); 
				if(hdr!=null){
					dataRow  = new ClsDataRow(hdr.assAndScoreName);							
				}
				dataRow.subjectID = sasvs.getSubjectID();
				dataRow.siteID = sasvs.getSiteID();
				if (dataRow.siteID == null) {
					dataRow.siteID = sasvs.getSubjectID().substring(0, 4);
				} 
				
				String asName = null;
				StringBuilder keyBuf = new StringBuilder();
				keyBuf.append(sasvs.getAssessmentID()).append('_');
				keyBuf.append(dataRow.siteID.toUpperCase());
				asName = map.get(keyBuf.toString());

				if (asName == null) {
					// hack for BDR
					// in BDR data from multiple sites are pooled , they have
					// different site ids but same assessment ids
					if (theSite != null) {
						keyBuf = new StringBuilder();
						keyBuf.append(sasvs.getAssessmentID()).append('_')
								.append(theSite);
						asName = map.get(keyBuf.toString());
					}
				}

				dataRow.expID =String.valueOf(sasvs.getExperimentID());
				if(format.equals("wide")||format.equals("long")){
					if(sasvs.getVisitName()!=null) dataRow.visitName = String.valueOf(sasvs.getVisitName());
					if(sasvs.getVisitDate()!=null) dataRow.visitDate = String.valueOf(sasvs.getVisitDate());
					dataRow.visitID =String.valueOf(sasvs.getVisitID());
					if(sasvs.getStudyName()!=null) dataRow.studyName = String.valueOf(sasvs.getStudyName());
					if(sasvs.getStudyDate()!=null) dataRow.studyDate = String.valueOf(sasvs.getStudyDate());
					if(sasvs.getStudyId()!=null) dataRow.studyId = String.valueOf(sasvs.getStudyId());
					if(sasvs.getSegmentName()!=null) dataRow.segmentName = String.valueOf(sasvs.getSegmentName());
					if(sasvs.getSegmentDate()!=null) dataRow.segmentDate = String.valueOf(sasvs.getSegmentDate());
					dataRow.segID = String.valueOf(sasvs.getSegmentID());					
					if(sasvs.getStudyGroup()!=null) dataRow.studyGroup = String.valueOf(sasvs.getStudyGroup());										
				}
				
				StringBuilder sb = new StringBuilder();
				sb.append(asName);
				sb.append("_");
				sb.append(sasvs.getScoreName());
				if(format.equals("wider")){
					sb.append("_Visit");
					sb.append(sasvs.getVisitID());
					sb.append("_Seg");
					sb.append(sasvs.getSegmentID());
				}
				sb.append(",");
				name = replaceWithUnderScore(sb.toString());
				
				if(dataRow.getAssAndScoreNameValue().containsKey(name)){
//					String score = sasvs.getValue() != null ? sasvs.getValue().toString(): ".";
//					if(sasvs.getScoreType().equals("integer")){
//						if(sasvs.getValue().equals("")){
//							score=".";
//						}
//					}
					String score;
					if(sasvs.getValue()!=null){
						score = sasvs.getValue().toString();
						if(sasvs.getScoreType().equals("integer")){
							if(sasvs.getValue().equals("")) score = ".";							
						}						
					}else{
						score=".";
					}
					dataRow.getAssAndScoreNameValue().put(name, score);
				}else{
					log.info("Error in creating header columns.");
				}
				
				dataRowList.add(dataRow);
			}					
		}
		return dataRowList;
	}

	private static String addHeaderToFile(BatchQueryResult bqr,
			ClsHeaderRow hdr, Map<String, String> map, String theSite, String format) {
		hdr.subjectID = "SubjectID,";
		hdr.siteID =	"SiteID,";
		hdr.expID = "ExperimentID,";		
		if(format.equals("wide")||format.equals("long")){
			hdr.visitName = "VisitName,";
			hdr.visitDate = "VisitDate,";
			hdr.visitID = "VisitID,";
			hdr.studyName = "StudyName,";
			hdr.studyDate = "StudyDate,";
			hdr.studyId = "StudyId,";
			hdr.segmentName = "SegmentName,";
			hdr.segmentDate = "SegmentDate,";
			hdr.segID = "SegmentID,";			
			hdr.studyGroup = "StudyGroup,";			
		}
		
		Set<String> seenSites = new HashSet<String>(17);
		for (Map.Entry<String, SiteAsiInfo> entry : bqr.getSaiMap().entrySet()) {
			String siteID = entry.getKey();
			if (!seenSites.contains(siteID.toUpperCase())) {
				theSite = siteID.toUpperCase();
				seenSites.add(theSite);
			}
			SiteAsiInfo sai = entry.getValue();

			for (AssessmentSelectionInfo asi : sai.getAsiList()) {
				StringBuffer keyBuf = new StringBuffer(asi.getAssessmentID()
						.toString());
				keyBuf.append('_').append(siteID.toUpperCase());
				map.put(keyBuf.toString(), asi.getName());
			}
		}
		if (seenSites.size() > 1) {
			theSite = null;
		}
		
		// Add Header row
		String ass_scoreName;
		
		//Create header row by looping the subject score list. Var1_Visit1_Seg1, Var1_Visit1_Seg2, Var1_Visit2_Seg1, Var1_Visit2_Seg2, Var... 
		for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
				//get assessment name and score name
				String siteID = sasvs.getSiteID();
				if (siteID == null) {
					siteID = sasvs.getSubjectID().substring(0, 4);
				} 
				
				String asName = null;
				StringBuilder keyBuf = new StringBuilder();
				keyBuf.append(sasvs.getAssessmentID()).append('_');
				keyBuf.append(siteID.toUpperCase());
				asName = map.get(keyBuf.toString());

				if (asName == null) {
					// hack for BDR
					// in BDR data from multiple sites are pooled , they have
					// different site ids but same assessment ids
					if (theSite != null) {
						keyBuf = new StringBuilder();
						keyBuf.append(sasvs.getAssessmentID()).append('_')
								.append(theSite);
						asName = map.get(keyBuf.toString());
					}
				}
				
				StringBuilder sb = new StringBuilder();
				sb.append(asName);
				sb.append("_");
				sb.append(sasvs.getScoreName());
				if(format.equals("wider")){
					sb.append("_Visit");
					sb.append(sasvs.getVisitID());
					sb.append("_Seg");
					sb.append(sasvs.getSegmentID());
				}
				sb.append(",");				
				ass_scoreName = sb.toString();
				
				//replace non-alphabet or non-underscore with underscore
				ass_scoreName = replaceWithUnderScore(ass_scoreName);
				
				//add column name to header row if not exists in hdr object
				Boolean bExist = false;
				if(hdr.assAndScoreName!=null){
					for(String st: hdr.assAndScoreName){
						if(ass_scoreName.equals(st)){
							bExist = true;
							break;
						}
					}	
				}					
				if(!bExist){
					hdr.assAndScoreName.add(ass_scoreName);
					java.util.Collections.sort(hdr.assAndScoreName);
				}
		}
		return theSite;
	}
	
	private static ClsDataRow dataRowContainsSubject(List<ClsDataRow> lst, String subId, String siteId, 
			String expId, String visitId, String segId){
		ClsDataRow result = null;
		
		for(ClsDataRow dr : lst){
			if(dr.subjectID.equals(subId)){
				if(dr.siteID.equals(siteId)){
					if(dr.expID.equals(expId)){
						if(dr.visitID.equals(visitId)){
							if(dr.segID.equals(segId)){
								result = new ClsDataRow();
								result = dr;
								return result;
							}
						}
					}
				}
			}			
		}
		return result;
	}
	
	private static ClsDataRow dataRowContainsSubject(List<ClsDataRow> lst, String subId, String siteId, String expId){
		ClsDataRow result = null;
		
		for(ClsDataRow dr : lst){
			if(dr.subjectID.equals(subId)){
				if(dr.siteID.equals(siteId)){
					if(dr.expID.equals(expId)){
						result = new ClsDataRow();
						result = dr;
						return result;						
					}
				}
			}			
		}
		return result;
	}

	public static void prepareCSVFile(File file,
			List<AssessmentSelectionInfo> asiList, BatchQueryResult bqr)
			throws Exception {
		BufferedWriter out = null;

		StringBuffer buf = new StringBuffer(256);
		buf.append("SubjectID,");
		buf.append("Site ID,");
		buf.append("Experiment ID,");
		buf.append("Visit ID,");
		buf.append("Segment ID,");
		buf.append("Assessment Name,");
		buf.append("Score Name,");
		buf.append("Score Value");
		String header = buf.toString();

		Map<String, String> map = new HashMap<String, String>(37);
		for (SiteAsiInfo sai : bqr.getSaiMap().values()) {
			for (AssessmentSelectionInfo asi : sai.getAsiList()) {
				StringBuilder sb = new StringBuilder(sai.getSiteID());
				sb.append('_').append(asi.getAssessmentID().toString());
				map.put(sb.toString(), asi.getName());
			}
		}

		try {
			out = new BufferedWriter(new FileWriter(file));

			out.write(header);
			out.newLine();

			String[] row = new String[8];
			for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
				row[0] = sasvs.getSubjectID();
				if (sasvs.getSiteID() == null) {
					row[1] = sasvs.getSubjectID().substring(0, 4);
				} else {
					row[1] = sasvs.getSiteID();
				}

				row[2] = String.valueOf(sasvs.getExperimentID());
				row[3] = String.valueOf(sasvs.getVisitID());
				row[4] = String.valueOf(sasvs.getSegmentID());
				StringBuilder sb = new StringBuilder();
				// TODO assumption: the first 4 digits of the BIRN ID indicates
				// the acquisition AND retrieval site ID
				// if siteID is not explicitly specified.
				if (sasvs.getSiteID() != null) {
					sb.append(sasvs.getSiteID());
				} else {
					sb.append(sasvs.getSubjectID().substring(0, 4));
				}
				sb.append('_').append(sasvs.getAssessmentID());
				String key = sb.toString();
				row[5] = map.get(key);
				row[6] = sasvs.getScoreName();
				if (sasvs.isMultiValued()) {
					for (Object value : sasvs.getValues()) {
//						row[7] = value != null ? value.toString() : ".";
//						if(sasvs.getScoreType().equals("integer")){
//							if(sasvs.getValue().equals("")){
//								row[7]=".";
//							}
//						}						
						if(value!=null){
							row[7] = value.toString();
							if(sasvs.getScoreType().equals("integer")){
								if(value.equals("")) row[7] = ".";							
							}						
						}else{
							row[7]=".";
						}
						writeRow(out, row);
					}
				} else {
//					row[7] = sasvs.getValue() != null ? sasvs.getValue()
//							.toString() : ".";
//					if(sasvs.getScoreType().equals("integer")){						
//						if(sasvs.getValue()!=null){
//							if (sasvs.getValue().equals("")) 
//								row[7]=".";
//						}
//					}					
					if(sasvs.getValue()!=null){
						row[7] = sasvs.getValue().toString();
						if(sasvs.getScoreType().equals("integer")){
							if(sasvs.getValue().equals("")) row[7] = ".";							
						}						
					}else{
						row[7]=".";
					}
					writeRow(out, row);
				}

			}

		} finally {
			FileUtils.close(out);
		}
	}

	protected static void writeRow(BufferedWriter out, String[] row)
			throws IOException {
		StringBuilder sb;
		sb = new StringBuilder(200);
		for (int i = 0; i < row.length; i++) {
			sb.append(row[i]).append(',');
		}
		out.write(sb.substring(0, sb.length() - 1));
		out.newLine();
	}

	//--------------------------------------------------------------------------------------------------------------//
	//--------------------------------------------------------------------------------------------------------------//
	// Export Genetic Query Results to Different Types of Files
	public static class ClsFileHeaderRow{
		//MAP file headers
		private String chr;
		private String rs;
		private String distance;
		private String position;
		
		//PED file headers
		private String familyId;
		private String individualId;
		private String fatherId;
		private String motherId;
		private String sex;
		private String status;
		private List<String> genotypes;
		
		public void setChr(String chr) {
			this.chr = chr;
		}
		public String getChr() {
			return chr;
		}
		public void setRs(String rs) {
			this.rs = rs;
		}
		public String getRs() {
			return rs;
		}
		public void setDistance(String distance) {
			this.distance = distance;
		}
		public String getDistance() {
			return distance;
		}
		public void setPosition(String position) {
			this.position = position;
		}
		public String getPosition() {
			return position;
		}

		public void setFamilyId(String familyId) {
			this.familyId = familyId;
		}
		public String getFamilyId() {
			return familyId;
		}
		public void setIndividualId(String individualId) {
			this.individualId = individualId;
		}
		public String getIndividualId() {
			return individualId;
		}
		public void setFatherId(String fatherId) {
			this.fatherId = fatherId;
		}
		public String getFatherId() {
			return fatherId;
		}
		public void setMotherId(String motherId) {
			this.motherId = motherId;
		}
		public String getMotherId() {
			return motherId;
		}
		public void setSex(String sex) {
			this.sex = sex;
		}
		public String getSex() {
			return sex;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getStatus() {
			return status;
		}
		public void setGenotypes(List<String> genotypes) {
			this.genotypes = genotypes;
		}
		public List<String> getGenotypes() {
			return genotypes;
		}
		

	}

	public static class ClsFileDataRow{
		//MAP file data row
		private String chr;
		private String rs;
		private String distance;
		private String position;
		
		//PED file data row
		private String familyId;
		private String individualId;
		private String fatherId;
		private String motherId;
		private String sex;
		private String status;
		private List<String> genotypes;
		
		public void setChr(String chr) {
			this.chr = chr;
		}
		public String getChr() {
			return chr;
		}
		public void setRs(String rs) {
			this.rs = rs;
		}
		public String getRs() {
			return rs;
		}
		public void setDistance(String distance) {
			this.distance = distance;
		}
		public String getDistance() {
			return distance;
		}
		public void setPosition(String position) {
			this.position = position;
		}
		public String getPosition() {
			return position;
		}

		public void setFamilyId(String familyId) {
			this.familyId = familyId;
		}
		public String getFamilyId() {
			return familyId;
		}
		public void setIndividualId(String individualId) {
			this.individualId = individualId;
		}
		public String getIndividualId() {
			return individualId;
		}
		public void setFatherId(String fatherId) {
			this.fatherId = fatherId;
		}
		public String getFatherId() {
			return fatherId;
		}
		public void setMotherId(String motherId) {
			this.motherId = motherId;
		}
		public String getMotherId() {
			return motherId;
		}
		public void setSex(String sex) {
			this.sex = sex;
		}
		public String getSex() {
			return sex;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getStatus() {
			return status;
		}
		public void setGenotypes(List<String> genotypes) {
			this.genotypes = genotypes;
		}
		public List<String> getGenotypes() {
			return genotypes;
		}
	}
	
	private static ClsFileHeaderRow addMapHeaderRow(){
		ClsFileHeaderRow header = new ClsFileHeaderRow();
		
		header.chr = "Chromosome";
		header.rs = "SNP name";
		header.distance = "Distance";
		header.position = "Position";
		
		return header;		
	}
	
	public static List<ClsFileDataRow> addMapDataRowOld(List<ClsFileDataRow>dataRowList, ResultSet rs){
		try{
			if(rs!=null){
				while(rs.next()){
					ClsFileDataRow mapRow = new ClsFileDataRow();
					mapRow.position = rs.getString("position");
					//check if this record is in dataRowList already
					int index = java.util.Collections.binarySearch(dataRowList, mapRow, new Comparator<ClsFileDataRow>(){
						@Override
						public int compare(ClsFileDataRow o1, ClsFileDataRow o2) {
							return Long.valueOf(o1.position).compareTo(Long.valueOf(o2.position));
						}						
					});
					
					if(index<0){ //this snp not exists, then add
						mapRow.chr = rs.getString("chr");
						mapRow.rs = rs.getString("snpname");
						mapRow.distance = "0";
						mapRow.position = rs.getString("position");						
						dataRowList.add(Math.abs(index)-1, mapRow);	
					}					
				}
			}	

		}
		catch(Exception ex){
			System.err.println(ex.getMessage());
		}
		
		return dataRowList;	
	}

	public static List<ClsFileDataRow> addMapDataRow(List<ClsFileDataRow>dataRowList, ResultSet rs){
		try{
			if(rs!=null){
				int index = 0;
				
				while(rs.next()){
					ClsFileDataRow mapRow = new ClsFileDataRow();
					
					mapRow.chr = rs.getString("chr");
					mapRow.rs = rs.getString("snpname");
					mapRow.distance = "0";
					mapRow.position = rs.getString("position");						
					dataRowList.add(index, mapRow);
					index++;
				}
			}	

		}
		catch(Exception ex){
			System.err.println(ex.getMessage());
		}
		
		return dataRowList;	
	}

	public static void exportMAPFile(BufferedWriter out, List<ClsFileDataRow> dataRowList){
		try{			
			StringBuilder buf = new StringBuilder();
				
			//write datarow				
			for(ClsFileDataRow drow : dataRowList){
				buf = new StringBuilder();
				buf.append(drow.chr);
				buf.append("\t");
				buf.append(drow.rs);
				buf.append("\t");
				buf.append(drow.distance);
				buf.append("\t");
				buf.append(drow.position);
				out.write(buf.toString());
				out.newLine();
			}			
		}
		catch (IOException e) {
		// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
	
	private static ClsFileHeaderRow addPEDHeaderRow(){
		ClsFileHeaderRow header = new ClsFileHeaderRow();
		
		header.familyId = "Family ID";
		header.individualId = "Individual ID";
		header.fatherId = "Father ID";
		header.motherId = "Mother ID";
		header.sex = "Sex";
		header.status = "Status";
		List<String> sGtypes = new LinkedList<String>();
		sGtypes.add("Genotypes");
		header.setGenotypes(sGtypes);		
		return header;		
	}
	
	public static List<ClsFileDataRow> addPEDDataRowOld(ResultSet rs, List<ClsFileDataRow> dRows, Map<Integer, String> snpHashMap){		
		try{			
			if(rs!=null){
				// PED file contains subject per row, each row contains all the genotypes for that subject
				String prevSnpName = "";
				Integer elementPos =  null;
				
				while(rs.next()){
					//boolean subjectExist = false;
					ClsFileDataRow pedRow = new ClsFileDataRow();
					pedRow.individualId = rs.getString("subjectid");					
					
					int index = java.util.Collections.binarySearch(dRows, pedRow, new Comparator<ClsFileDataRow>(){
						public int compare(ClsFileDataRow o1, ClsFileDataRow o2){
							return o1.individualId.compareTo(o2.individualId);					
						}					
					});
					
					if(index>=0){ //subject exists in the list
						//get the element from the list						
						ClsFileDataRow modRow = dRows.get(index);						
						List<String> strGTypes = new LinkedList<String>();
						strGTypes = modRow.getGenotypes();
						
						//get position key value from HashMap, then insert the element to this position						
						if(!rs.getString("snpname").equals(prevSnpName)){							
							elementPos = getKeyByValue(snpHashMap, rs.getString("snpname"));	
						}
						prevSnpName = rs.getString("snpname");
						
						if(elementPos!=null){
							strGTypes.set(elementPos, convertAlleleToGenoType(rs.getString("allele1"), rs.getString("allele2")));
						}
						
						modRow.setGenotypes(strGTypes);
						dRows.set(index, modRow);
					}else{
						pedRow = new ClsFileDataRow();
						pedRow.familyId = "0";
						pedRow.individualId = rs.getString("subjectid");
						pedRow.fatherId = rs.getString("fatherid");
						pedRow.motherId = rs.getString("motherid");
						pedRow.sex = "-9";
						pedRow.status = "-9";
						List<String> strGTypes = new LinkedList<String>();
												
						//get position key value from HashMap, then insert the element to this position
						for(int i=0; i<snpHashMap.size(); i++){
							strGTypes.add(i, "00");
						}
						
						if(!rs.getString("snpname").equals(prevSnpName)){
							elementPos = getKeyByValue(snpHashMap, rs.getString("snpname"));	
						}
						prevSnpName = rs.getString("snpname");
						
						if(elementPos!=null){
							strGTypes.set(elementPos, convertAlleleToGenoType(rs.getString("allele1"), rs.getString("allele2")));
						}
						
						pedRow.setGenotypes(strGTypes);
						dRows.add(Math.abs(index)-1, pedRow);			
					}
				}
			}
		}		
		catch(NumberFormatException e){
			e.printStackTrace();
		}
		catch(Exception ex){
			ex.printStackTrace();
		}		
		return dRows;	
	}
	
	
	//This function add results set of ped data to a ClsFileDataRow list
	//This is faster than addPEDDataRow function
	public static List<ClsFileDataRow> addPEDDataRowNew(ResultSet rs, List<ClsFileDataRow> dRows, LinkedList<Long> listPos){		
		try{			
			if(rs!=null){
				// PED file contains subject per row, each row contains all the genotypes for that subject
				String prevPosName = "";
				Integer elementPos =  null;
				
				while(rs.next()){
					//boolean subjectExist = false;
					ClsFileDataRow pedRow = new ClsFileDataRow();
					pedRow.individualId = rs.getString("subjectid");					
					
					int index = java.util.Collections.binarySearch(dRows, pedRow, new Comparator<ClsFileDataRow>(){
						public int compare(ClsFileDataRow o1, ClsFileDataRow o2){
							return o1.individualId.compareTo(o2.individualId);					
						}					
					});
					
					if(index>=0){ //subject exists in the list
						//get the element from the list						
						ClsFileDataRow modRow = dRows.get(index);						
						List<String> strGTypes = new LinkedList<String>();
						strGTypes = modRow.getGenotypes();
						
						//get position key value from HashMap, then insert the element to this position						
						if(!rs.getString("position").equals(prevPosName)){							
							elementPos = Collections.binarySearch(listPos, Long.valueOf(rs.getString("position")));
						}
						prevPosName = rs.getString("position");
						
						if(elementPos>=0){
							strGTypes.set(elementPos, convertAlleleToGenoType(rs.getString("allele1"), rs.getString("allele2")));
						}
//						else{
//							strGTypes.add(Math.abs(elementPos)-1, convertAlleleToGenoType(rs.getString("allele1"), rs.getString("allele2")));
//						}
						
						modRow.setGenotypes(strGTypes);
						dRows.set(index, modRow);
					}else{
						pedRow = new ClsFileDataRow();
						pedRow.familyId = "0";
						pedRow.individualId = rs.getString("subjectid");
						pedRow.fatherId = rs.getString("fatherid");
						pedRow.motherId = rs.getString("motherid");
						pedRow.sex = "-9";
						pedRow.status = "-9";
						List<String> strGTypes = new LinkedList<String>();
												
						//get position key value from HashMap, then insert the element to this position
						for(int i=0; i<listPos.size(); i++){
							strGTypes.add(i, "00");
						}
						
						if(!rs.getString("position").equals(prevPosName)){
							elementPos = Collections.binarySearch(listPos, Long.valueOf(rs.getString("position")));	
						}
						prevPosName = rs.getString("position");
						
						if(elementPos>=0){
							strGTypes.set(elementPos, convertAlleleToGenoType(rs.getString("allele1"), rs.getString("allele2")));
						}
//						else{
//							strGTypes.add(Math.abs(elementPos)-1, convertAlleleToGenoType(rs.getString("allele1"), rs.getString("allele2")));
//						}						
						
						pedRow.setGenotypes(strGTypes);
						dRows.add(Math.abs(index)-1, pedRow);			
					}
				}
			}
		}		
		catch(NumberFormatException e){
			e.printStackTrace();
		}
		catch(Exception ex){
			ex.printStackTrace();
		}		
		return dRows;	
	}
	
	public static List<ClsFileDataRow> addPEDDataRow(ResultSet rs, List<ClsFileDataRow> dRows, Map<Integer, String> snpHashMap){		
		try{			
			if(rs!=null){
				// PED file contains subject per row, each row contains all the genotypes for that subject				
				String prevIndividualId = "";				
				String prevSnpName = "";				
				Integer elementPos =  null;
				
				int index = -1;				 

				while(rs.next()){
					if(!prevIndividualId.equals(rs.getString("subjectid"))){
						ClsFileDataRow pedRow = new ClsFileDataRow();
						pedRow.familyId = "0";
						pedRow.individualId = rs.getString("subjectid");
						pedRow.fatherId = rs.getString("fatherid");
						pedRow.motherId = rs.getString("motherid");
						pedRow.sex = "-9";
						pedRow.status = "-9";
						List<String> strGTypes = new LinkedList<String>();
												
						//get position key value from HashMap, then insert the element to this position
						for(int i=0; i<snpHashMap.size(); i++){
							strGTypes.add(i, "00");
						}
						
						if(elementPos!=null){
							strGTypes.set(elementPos, convertAlleleToGenoType(rs.getString("allele1"), rs.getString("allele2")));
						}
						
						pedRow.setGenotypes(strGTypes);
						dRows.add(++index, pedRow);			
						
						prevIndividualId = rs.getString("subjectid");
					}else{
						ClsFileDataRow modRow = dRows.get(index);						
						List<String> strGTypes = new LinkedList<String>();
						strGTypes = modRow.getGenotypes();
						String strSnpName = rs.getString("snpname");
						
						//get position key value from HashMap, then insert the element to this position						
						if(!strSnpName.equals(prevSnpName)){							
							elementPos = getKeyByValue(snpHashMap, strSnpName);	
						}
						prevSnpName = strSnpName;
						
						if(elementPos!=null){
							strGTypes.set(elementPos, convertAlleleToGenoType(rs.getString("allele1"), rs.getString("allele2")));
						}
						
						modRow.setGenotypes(strGTypes);
						dRows.set(index, modRow);	
						
						prevIndividualId = rs.getString("subjectid");
					}
				}
			}
		}		
		catch(NumberFormatException e){
			e.printStackTrace();
		}
		catch(Exception ex){
			ex.printStackTrace();
		}		
		return dRows;	
	}
	
	
	public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
	    for (java.util.Map.Entry<T, E> entry : map.entrySet()) {
	        if (value.equals(entry.getValue())) {
	            return entry.getKey();
	        }
	    }
	    return null;
	}

	public static void writePEDFile(BufferedWriter out, List<ClsFileDataRow> dataRowList){
		try{			
			StringBuilder buf = new StringBuilder();
			
			//write datarow				
			for(ClsFileDataRow drow : dataRowList){
				buf = writeDataRowToBuf(drow);
								
				out.write(buf.toString());
				out.newLine();
			}			
		}
		catch (IOException e) {
		// TODO Auto-generated catch block
			e.printStackTrace();
		}		
	}
	
	public static void writePEDFile2(File file, List<ClsFileDataRow> dataRowList){
		BufferedWriter out = null;
		
		try{			
			if(file!=null){
				out = new BufferedWriter(new FileWriter(file));
			}
			
			StringBuilder buf = new StringBuilder();
			
			//write datarow			
			if(dataRowList!=null){
				for(ClsFileDataRow drow : dataRowList){
					buf = writeDataRowToBuf(drow);
									
					out.write(buf.toString());
					out.newLine();
				}							
			}
		}
		catch (IOException e) {
		// TODO Auto-generated catch block
			e.printStackTrace();
		}		
		finally {
			FileUtils.close(out);
		}
	}

	public static void writePortionPEDFile(File file, List<ClsFileDataRow> dataRowList){
		BufferedWriter out = null;
		String lastLine = "";
		String lastSubject = "";
		StringBuilder buf = new StringBuilder();
		
		try{			
			if(file!=null){				
				//get the last line of the file
				lastLine = readLastLine(file.getAbsolutePath());
				
				//get last subjectId
				if(lastLine.length()>0 && lastLine.indexOf("\t")>0){
					int firstTab = lastLine.indexOf("\t");
					int secondTab = lastLine.indexOf("\t", firstTab+1);
					lastSubject = lastLine.substring(firstTab+1, secondTab);
				}
				
				out = new BufferedWriter(new FileWriter(file, true));
				//write datarow			
				if(dataRowList!=null){					
					for(int i=0; i<dataRowList.size();i++){
						ClsFileDataRow drow = dataRowList.get(i);
						
						if(i==0 && drow.individualId.equals(lastSubject)){
							Iterator<String> itr = (Iterator<String>) drow.getGenotypes().iterator();				
							while(itr.hasNext()){									
								buf.append(itr.next());
								buf.append("\t");
							}											
							out.write(buf.toString());							
							continue;
						}
						if(i>0 || file.length()>0) out.newLine();
						buf = writeDataRowToBuf(drow);										
						out.write(buf.toString());						
					}
//						for(ClsFileDataRow drow : dataRowList){
//							if(drow.individualId.equals(lastSubject)){
//								Iterator<String> itr = (Iterator<String>) drow.getGenotypes().iterator();				
//								while(itr.hasNext()){									
//									buf.append(itr.next());
//									buf.append("\t");
//								}
//												
//								out.write(buf.toString());
//								out.newLine();
//							}else{
//								buf = new StringBuilder();
//								buf.append(drow.familyId);
//								buf.append("\t");
//								buf.append(drow.individualId);
//								buf.append("\t");
//								buf.append(drow.fatherId);
//								buf.append("\t");
//								buf.append(drow.motherId);
//								buf.append("\t");
//								buf.append(drow.sex);
//								buf.append("\t");
//								buf.append(drow.status);
//								buf.append("\t");
//								
//								Iterator<String> itr = (Iterator<String>) drow.getGenotypes().iterator();				
//								while(itr.hasNext()){									
//									buf.append(itr.next());
//									buf.append("\t");
//								}
//												
//								out.write(buf.toString());
//								out.newLine();							
//							}
//						}	
//					}
					
												
				}				
			}
		}
		catch (IOException e) {
		// TODO Auto-generated catch block
			e.printStackTrace();
		}		
		finally {
			FileUtils.close(out);
		}
	}

	
	/*
	 * Write datarow to file. Insert data to file in the order of subjectid. 
	 * Use a tmp file to store text, then overwrite back the file
	 */
/*	public static boolean writeToPEDFile(File file, List<ClsFileDataRow> dataRowList){
//		BufferedWriter out = null;
//		StringBuilder buf = new StringBuilder();
//		String filePath = file.getPath();
//		
//		try{			
//			if(file!=null){
//				if(dataRowList!=null){
//					if(file.length()==0){
//						for(int i=0; i<dataRowList.size(); i++){
//							ClsFileDataRow drow = dataRowList.get(i);
//
//							out = new BufferedWriter(new FileWriter(file, true));
//							buf = writeDataRowToBuf(drow);							
//							out.write(buf.toString());		
//							out.newLine();
//							out.close();	
//						}						
//					}else{
//						for(int i=0; i<dataRowList.size(); i++){
//							ClsFileDataRow drow = dataRowList.get(i);						
//							
//							//read line by line from file
//							//if subjid==drow.id, append genotype to the end of the line
//							//if subjid>drow.id, add a new line before this line
//							File tmpFile = new File(filePath + ".tmp");
//							BufferedReader input = new BufferedReader(new FileReader(file));							
//							
//							try{
//								String line = null;
//								boolean bWrote = false;
//								while((line=input.readLine())!=null){
//									int firstTab = line.indexOf("\t");
//									int secondTab = line.indexOf("\t", firstTab+1);
//									String subId = line.substring(firstTab+1, secondTab);
//										
//									if(!bWrote){
//										if(subId.equals(drow.individualId)){
//											buf = new StringBuilder();
//											buf.append(line);
//											
//											Iterator<String> itr = (Iterator<String>) drow.getGenotypes().iterator();				
//											while(itr.hasNext()){									
//												buf.append(itr.next());
//												buf.append("\t");
//											}
//											
//											BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
//											outTmp.write(buf.toString());
//											outTmp.newLine();
//											outTmp.close();
//											bWrote = true;
//											
//										}else if(subId.compareTo(drow.individualId)>0){
//											buf = new StringBuilder();
//											buf = writeDataRowToBuf(drow);
//											
//											BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
//											outTmp.write(buf.toString());
//											outTmp.newLine();
//											
//											buf = new StringBuilder();
//											buf.append(line);											
//											outTmp.write(buf.toString());
//											outTmp.newLine();
//											outTmp.close();
//											
//											bWrote = true;
//										}
//										else{
//											buf= new StringBuilder();
//											buf.append(line);	
//											
//											BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
//											outTmp.write(buf.toString());
//											outTmp.newLine();
//											outTmp.close();
//										}
//									}
//									else{
//										buf= new StringBuilder();
//										buf.append(line);
//										
//										BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));										
//										outTmp.write(buf.toString());											
//										outTmp.newLine();
//										outTmp.close();
//									}									
//								}
//								
//								if(!bWrote){
//									buf = new StringBuilder();
//									buf = writeDataRowToBuf(drow);
//									
//									BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
//									outTmp.write(buf.toString());
//									outTmp.newLine();
//									outTmp.close();
//								}
//							}
//							finally{
//								input.close();
//							}
//							
//							FileUtils.copyFile(tmpFile.getPath(), file.getPath());
//							if(!tmpFile.delete()){
//								return false;
//							}
//								
//						}
//					}
//				}
//			}			
//			return true;
//		}
//		catch (IOException e) {
//		// TODO Auto-generated catch block
//			e.printStackTrace();
//			return false;
//		}		
//		finally {
//			FileUtils.close(out);			
//		}
//		
//	}
*/
	public static boolean writeToPEDFileOld(File file, List<ClsFileDataRow> dataRowList){
		BufferedWriter out = null;
		StringBuilder buf = new StringBuilder();
		String filePath = file.getPath();
		
		try{			
			if(file!=null){
				if(dataRowList!=null){
					if(file.length()==0){
						for(int i=0; i<dataRowList.size(); i++){
							ClsFileDataRow drow = dataRowList.get(i);

							out = new BufferedWriter(new FileWriter(file, true));
							buf = writeDataRowToBuf(drow);							
							out.write(buf.toString());		
							out.newLine();
							out.close();	
						}						
					}else{
						//read line by line from file
						//if subjid==drow.id, insert genotype to the correct position of array
						//if subjid>drow.id, add a new line before this line
						//output buf to tmp file, then copy tmp file to file
						File tmpFile = new File(filePath + ".tmp");
						BufferedReader input = new BufferedReader(new FileReader(file));							
						String line = null;
												
						try{
							while((line=input.readLine())!=null){
								int firstTab = line.indexOf("\t");
								int secondTab = line.indexOf("\t", firstTab+1);
								String subId = line.substring(firstTab+1, secondTab);
								boolean bWrite = false;
								
								for(int i=0; i<dataRowList.size(); ){
									ClsFileDataRow drow = dataRowList.get(0);								
									
									if(subId.equals(drow.individualId)){
										int sixTab = getDelimPosition(line, 6);									
										String genoTypesArr[] = line.substring(sixTab+1).split("\t");
										
										for(int k=0; k<drow.getGenotypes().size();k++){
											if(!drow.getGenotypes().get(k).equals("00") && genoTypesArr[k].equals("00")){
												genoTypesArr[k] = drow.getGenotypes().get(k);
											}												
										}											
										
										buf = new StringBuilder();
										buf.append(line.substring(0, sixTab+1));
										
										for(int j=0; j<genoTypesArr.length; j++){
											buf.append(genoTypesArr[j].toString());
											buf.append("\t");
										}											
										
										BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
										outTmp.write(buf.toString());
										outTmp.newLine();
										outTmp.close();
										
										bWrite = true;
										
										dataRowList.remove(drow);
										
										break;
																			
									}else if(subId.compareTo(drow.individualId)>0){
										buf = new StringBuilder();
										buf = writeDataRowToBuf(drow);
										
										BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
										outTmp.write(buf.toString());
										outTmp.newLine();
										outTmp.close();
										
										dataRowList.remove(drow);
										
									}
									else{
										buf= new StringBuilder();
										buf.append(line);	
										
										BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
										outTmp.write(buf.toString());
										outTmp.newLine();
										outTmp.close();
										
										bWrite = true;
										
										break;
									}
								}
								
								if(!bWrite){
									buf= new StringBuilder();
									buf.append(line);	
									
									BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
									outTmp.write(buf.toString());
									outTmp.newLine();
									outTmp.close();
									
									bWrite = true;								
								}
							}
							
							//in case file reaches the end, datarowlist still not reach the end
							if(dataRowList.size()>0){
								for(int i=0; i<dataRowList.size(); i++){
									buf = new StringBuilder();
									buf = writeDataRowToBuf(dataRowList.get(i));
									
									BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
									outTmp.write(buf.toString());
									outTmp.newLine();
									outTmp.close();																		
								}
							}
						}
						finally{
							input.close();
						}
						
						FileUtils.copyFile(tmpFile.getPath(), file.getPath());
						if(!tmpFile.delete()){
							return false;
						}
						
					}
				}
			}			
			return true;
		}
		catch (IOException e) {
		// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}		
		finally {
			FileUtils.close(out);			
		}
		
	}
	
	
	public static boolean writeToPEDFile(File file, List<ClsFileDataRow> dataRowList){
		BufferedWriter out = null;
		StringBuilder buf = new StringBuilder();
		String filePath = file.getPath();
		
		try{			
			if(file!=null){
				if(dataRowList!=null){
					if(file.length()==0){
						for(int i=0; i<dataRowList.size(); i++){
							ClsFileDataRow drow = dataRowList.get(i);

							out = new BufferedWriter(new FileWriter(file, true));
							buf = writeDataRowToBuf(drow);							
							out.write(buf.toString());		
							out.newLine();
							out.close();	
						}						
					}else{
						//read last line from file
						//if subjid==drow.id, insert genotype to the correct position of array
						//else append drow to the file
						//output buf to file
						File tmpFile = new File(filePath + ".tmp");
						BufferedReader input = new BufferedReader(new FileReader(file));
						String line = null;
						String lastLine = null;
						String lastSubject = null;
							
						int numberLines = countFileLines(file.getAbsolutePath());
						int idx = 0;
						while((line=input.readLine())!=null && idx<numberLines-1){
							buf= new StringBuilder();
							buf.append(line);	
							
							BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
							outTmp.write(buf.toString());
							outTmp.newLine();
							outTmp.close();
							idx++;
						}
													
						
						try{
							//get the last line of the file
							//lastLine = readLastLine(file.getAbsolutePath());
							lastLine = getLastLine(file.getAbsolutePath());
							
							//get last subjectId
							if(lastLine.length()>0 && lastLine.indexOf("\t")>0){
								int firstTab = lastLine.indexOf("\t");
								int secondTab = lastLine.indexOf("\t", firstTab+1);
								lastSubject = lastLine.substring(firstTab+1, secondTab);
							}
							
							//out = new BufferedWriter(new FileWriter(file, true));
							//BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
							
							//write datarow			
							if(dataRowList!=null){					
								for(int i=0; i<dataRowList.size();i++){
									ClsFileDataRow drow = dataRowList.get(i);
									
									if(i==0){
										if(drow.individualId.equals(lastSubject))
										{
											int sixTab = getDelimPosition(lastLine, 6);									
											String genoTypesArr[] = lastLine.substring(sixTab+1).split("\t");
											
											for(int k=0; k<drow.getGenotypes().size();k++){												
												if(!drow.getGenotypes().get(k).equals("00") && genoTypesArr[k].equals("00")){
													genoTypesArr[k] = drow.getGenotypes().get(k);
												}												
											}											
											
											buf = new StringBuilder();
											buf.append(lastLine.substring(0, sixTab+1));
											
											for(int j=0; j<genoTypesArr.length; j++){
												buf.append(genoTypesArr[j].toString());
												buf.append("\t");
											}
											
											BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
											outTmp.write(buf.toString());
											outTmp.newLine();										
											outTmp.close();
											
											continue;
										}
										else{
											buf = new StringBuilder();
											buf.append(lastLine);
											
											BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
											outTmp.write(buf.toString());
											outTmp.newLine();											
											outTmp.close();
										}
									}

									buf = new StringBuilder();
									buf = writeDataRowToBuf(drow);
									
									BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
									outTmp.write(buf.toString());
									outTmp.newLine();								
									outTmp.close();
								}
							}
						}
						finally{	
							input.close();
						}
						FileUtils.copyFile(tmpFile.getPath(), file.getPath());
						if(!tmpFile.delete()){
							return false;
						}
					}
				}
			}			
			return true;
		}
		catch (IOException e) {
		// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}		
		finally {
			FileUtils.close(out);			
		}
		
	}

	public static int count(String filename) throws IOException {
	    InputStream is = new BufferedInputStream(new FileInputStream(filename));
	    try {
	        byte[] c = new byte[1024];
	        int count = 0;
	        int readChars = 0;
	        while ((readChars = is.read(c)) != -1) {
	            for (int i = 0; i < readChars; ++i) {
	                if (c[i] == '\n')
	                    ++count;
	            }
	        }
	        return count;
	    } finally {
	        is.close();
	    }
	}
	
	public static int countFileLines(String fileName) throws IOException{
		try{            
			LineNumberReader lineCounter = new LineNumberReader(
	        	new InputStreamReader(new FileInputStream(fileName)));
			int linenumber = 0;
            
			while (lineCounter.readLine() != null){
				linenumber++;
			}
			
			return linenumber;
			
		}catch (Exception done){
			done.printStackTrace();
			return 0;
        }    
	}

	
	public static int getDelimPosition(String str, int numberDelim){
		if(numberDelim==1){
			return str.indexOf("\t", 0);
		}else{
			return str.indexOf("\t", getDelimPosition(str, numberDelim-1)+1);			
		}
	}
	
	/*
	 * Write datarow to file. Insert data to file in the order of subjectid. 
	 * Use a tmp file to store text, then overwrite back the file
	 */
	public static boolean writeToMAPFile(File file, List<ClsFileDataRow> dataRowList){
		BufferedWriter out = null;
		StringBuilder buf = new StringBuilder();
		
		try{
			String filePath = file.getPath();
			if(file!=null){	
				if(file.length()==0){
					if(dataRowList!=null){
						out = new BufferedWriter(new FileWriter(file, true));
	
						for(int i=0; i<dataRowList.size(); i++){
							ClsFileDataRow drow = dataRowList.get(i);
	
							buf = writeMAPDataRowToBuf(drow);							
							out.write(buf.toString());		
							out.newLine();						
						}
						out.close();
					}
				}else{
					String line = null;
					File tmpFile = new File(filePath + ".tmp");					
					BufferedReader input = new BufferedReader(new FileReader(file));
					
					try{
						while((line=input.readLine())!=null){
							int firstTab = line.indexOf("\t");
							int secondTab = line.indexOf("\t", firstTab+1);
							int thirdTab = line.indexOf("\t", secondTab+1);
							String posId = line.substring(thirdTab+1);	
							boolean bWrite = false;
							
							for(int i=0; i<dataRowList.size(); ){
								ClsFileDataRow drow = dataRowList.get(0);
								
								if(Integer.valueOf(posId).compareTo(Integer.valueOf(drow.position))>0){
									buf = new StringBuilder();
									buf = writeMAPDataRowToBuf(drow);
									
									BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
									outTmp.write(buf.toString());
									outTmp.newLine();
									outTmp.close();
									dataRowList.remove(drow);
								}else{
									buf = new StringBuilder();
									buf.append(line);			
									
									BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
									outTmp.write(buf.toString());
									outTmp.newLine();
									outTmp.close();
									bWrite = true;
									break;
								}						
							}
							if(!bWrite){
								buf = new StringBuilder();
								buf.append(line);
								
								BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
								outTmp.write(buf.toString());
								outTmp.newLine();
								outTmp.close();
								bWrite = true;
							}
						}

						//in case file reaches the end, datarowlist still not reach the end
						if(dataRowList.size()>0){
							for(int i=0; i<dataRowList.size(); i++){
								buf = new StringBuilder();
								buf = writeMAPDataRowToBuf(dataRowList.get(i));
								
								BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
								outTmp.write(buf.toString());
								outTmp.newLine();
								outTmp.close();
							}
						}
					}
					finally{
						input.close();
					}
				
					FileUtils.copyFile(tmpFile.getPath(), file.getPath());
					if(!tmpFile.delete()){
						return false;
					}
						
						
//					for(int i=0; i<dataRowList.size(); i++){
//						ClsFileDataRow drow = dataRowList.get(i);						
//					
//						//read line by line from file
//						//if subjid==drow.id, append genotype to the end of the line
//						//if subjid>drow.id, add a new line before this line
//						File tmpFile = new File(filePath + ".tmp");
//						BufferedReader input = new BufferedReader(new FileReader(file));							
//						
//						try{
//							String line = null;
//							boolean bWrote = false;
//							while((line=input.readLine())!=null){
//								int firstTab = line.indexOf("\t");
//								int secondTab = line.indexOf("\t", firstTab+1);
//								int thirdTab = line.indexOf("\t", secondTab+1);
//								//int lastTab = line.lastIndexOf("\t");
//								String posId = line.substring(thirdTab+1);
//									
//								if(!bWrote){
//									if(Integer.valueOf(posId).compareTo(Integer.valueOf(drow.position))>0){
//										buf = new StringBuilder();
//										buf = writeMAPDataRowToBuf(drow);
//										
//										BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
//										outTmp.write(buf.toString());
//										outTmp.newLine();
//										
//										buf = new StringBuilder();
//										buf.append(line);											
//										outTmp.write(buf.toString());
//										outTmp.newLine();
//										outTmp.close();
//										
//										bWrote = true;
//									}
//									else{
//										buf= new StringBuilder();
//										buf.append(line);	
//									
//										BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
//										outTmp.write(buf.toString());
//										outTmp.newLine();
//										outTmp.close();
//									}
//								}
//								else{
//									buf= new StringBuilder();
//									buf.append(line);
//								
//									BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));										
//									outTmp.write(buf.toString());											
//									outTmp.newLine();
//									outTmp.close();
//								}									
//							}
//						
//							if(!bWrote){
//								buf = new StringBuilder();
//								buf = writeMAPDataRowToBuf(drow);
//							
//								BufferedWriter outTmp = new BufferedWriter(new FileWriter(tmpFile,true));
//								outTmp.write(buf.toString());
//								outTmp.newLine();
//								outTmp.close();
//							}
//						}
//						finally{
//							input.close();
//						}
//					
//						FileUtils.copyFile(tmpFile.getPath(), file.getPath());
//						if(!tmpFile.delete()){
//							return false;
//						}
//					}					
				}			
			}
			return true;
		}
		catch (IOException e) {
		// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}		
		finally {
			FileUtils.close(out);			
		}				
	}
	
	private static StringBuilder writeDataRowToBuf(ClsFileDataRow drow) {
		StringBuilder buf;
		buf = new StringBuilder();
		buf.append(drow.familyId);
		buf.append("\t");
		buf.append(drow.individualId);
		buf.append("\t");
		buf.append(drow.fatherId);
		buf.append("\t");
		buf.append(drow.motherId);
		buf.append("\t");
		buf.append(drow.sex);
		buf.append("\t");
		buf.append(drow.status);
		buf.append("\t");
		
//		Iterator<String> itr = (Iterator<String>) drow.getGenotypes().iterator();				
//		while(itr.hasNext()){									
//			buf.append(itr.next());
//			buf.append("\t");		
//		}
		
		for(int i=0; i<drow.getGenotypes().size(); i++){
			buf.append(drow.getGenotypes().get(i).toString());
			buf.append("\t");
		}
		
		return buf;
	}

	private static StringBuilder writeMAPDataRowToBuf(ClsFileDataRow drow){
		StringBuilder buf = new StringBuilder();		
		buf = new StringBuilder();
		buf.append(drow.chr);
		buf.append("\t");
		buf.append(drow.rs);
		buf.append("\t");
		buf.append(drow.distance);
		buf.append("\t");
		buf.append(drow.position);	
		return buf;
	}
	
	public static boolean writeMAPFile2(File file, List<ClsFileDataRow> dataRowList){
		BufferedWriter out = null;
		try{		
			if(file!=null){
				out = new BufferedWriter(new FileWriter(file, true));
			}
			
			StringBuilder buf = new StringBuilder();
				
			//write datarow	
			if(dataRowList!=null){
				for(ClsFileDataRow drow : dataRowList){
					buf = new StringBuilder();
					buf.append(drow.chr);
					buf.append("\t");
					buf.append(drow.rs);
					buf.append("\t");
					buf.append(drow.distance);
					buf.append("\t");
					buf.append(drow.position);
					out.write(buf.toString());
					out.newLine();
				}			
				
			}
			return true;
		}
		catch (IOException e) {
		// TODO Auto-generated catch block
			e.printStackTrace();
			return false;
		}
		finally {
			FileUtils.close(out);
		}
	}
	
	public static String convertAlleleToGenoType(String allele1, String allele2){
		String sGenoType = "";
		
		if(allele1.equals("A")){			
			sGenoType = "1";
		}else if(allele1.equals("C")){
			sGenoType = "2";
		}else if(allele1.equals("G")){
			sGenoType = "3";
		}else if(allele1.equals("T")){
			sGenoType = "4";
		}else if(allele1.equals("-")){
			sGenoType = "0";
		}else{
			sGenoType = "-";
		}
		
		if(allele2.equals("A")){			
			sGenoType += "1";
		}else if(allele2.equals("C")){
			sGenoType += "2";
		}else if(allele2.equals("G")){
			sGenoType += "3";
		}else if(allele2.equals("T")){
			sGenoType += "4";
		}else if(allele2.equals("-")){
			sGenoType += "0";
		}
		else{
			sGenoType += "-";
		}
		
		return sGenoType;		
	}

	public static String readLastLine(String fileName ) {
	    try {
//	    	if(file.length()==0){
//	    		return "";
//	    	}
	    	
	        java.io.File file = new java.io.File( fileName );
	        java.io.RandomAccessFile fileHandler = new java.io.RandomAccessFile( file, "r" );
	        long fileLength = file.length() - 1;
	        StringBuilder sb = new StringBuilder();
	 
	        for( long filePointer = fileLength; filePointer != -1; filePointer-- ) {
	            fileHandler.seek( filePointer );
	            int readByte = fileHandler.readByte();                
	 
	            if( readByte == 0xA ) {
	                if( filePointer == fileLength ) {
	                    continue;
	                } else {
	                    break;
	                }
	            } else if( readByte == 0xD ) {
	                if( filePointer == fileLength - 1 ) {
	                    continue;
	                } else {
	                    break;
	                }                    
	            }
	 
	            sb.append( ( char ) readByte );
	        }
	 
	        String lastLine = sb.reverse().toString();
	        return lastLine;
	    } catch( java.io.FileNotFoundException e ) {
	        e.printStackTrace();
	        return null;
	    } catch( java.io.IOException e ) {
	        e.printStackTrace();
	        return null;
	    }
	}
	
	public static String getLastLine(String fileName){
	    try{
	    	//java.io.File file = new java.io.File(fileName);
	    	FileInputStream in = new FileInputStream(fileName);
	    	BufferedReader br = new BufferedReader(new InputStreamReader(in));
	    	         
	    	String strLine = null, tmp;
	    	 
	    	while ((tmp = br.readLine()) != null)
	    	{
	    	   strLine = tmp;
	    	}
	    	     
	    	in.close();
	        
	        return strLine;
	    }catch(java.io.FileNotFoundException e){
	    	e.printStackTrace();
	    	return null;
	    }catch(java.io.IOException e){
	    	e.printStackTrace();
	    	return null;
	    }
	    finally{
	    	
	    }
	}
	
	protected static String replaceWithUnderScore(String str){
		String tempStr = str; 
		
		for(int i = 0; i<tempStr.length()-1; i++){
			char ch = tempStr.charAt(i);
			if(Character.isLetter(ch)){
				continue;
			}else if(ch == '_'){
				continue;
			}else if(Character.isDigit(ch)){
				continue;
			}
			else{
				tempStr = tempStr.replace(ch, '_');				
			}			
		}
	return tempStr;
	}
}
