package clinical.web.helpers;

import java.util.List;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.vo.Subjexperiment;


public class ExpSubjInfo {
	
	private String experimentId;
	private String experimentName;	
	
	private List<Subjexperiment> subjExps;
	
	public ExpSubjInfo(){		
	}

	public void setExperimentId(String experimentId) {
		this.experimentId = experimentId;
	}
	
	public String getExperimentId() {
		return experimentId;
	}
	
	public JSONObject toJSON(JSONObject js){	
		try {			
			js.put("experimentid",	experimentId);
			js.put("experimentname", this.experimentName);
		
			JSONArray jsAr = new JSONArray();
			for(Subjexperiment subjExp : subjExps){				
				jsAr.put(subjExp.toJSON(new JSONObject()));
			}
			js.put("subjectvisit", jsAr);
			
			return js;	
		}			
		catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}		
	}


	public void setExperimentName(String experimentName) {
		this.experimentName = experimentName;
	}


	public String getExperimentName() {
		return experimentName;
	}


	public void setSubjExps(List<Subjexperiment> subjExps) {
		this.subjExps = subjExps;
	}


	public List<Subjexperiment> getSubjExps() {
		return subjExps;
	}
}
