package clinical.web.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.struts.util.LabelValueBean;

import clinical.server.vo.Experiment;

/**
 * Model (data) for the experiment dropdown
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ExperimentSelector.java 688 2012-09-27 21:52:56Z jinranc $
 */
public class ExperimentSelector implements Serializable {
	private static final long serialVersionUID = 1L;
	protected Collection<LabelValueBean> experimentInfos;
	protected int selectedExpID;
	public final static int ALL_EXPERIMENTS = -1;
	public final static int ALL_EXPERIMENTS_MINUS_REGRESSION = -2;

	public ExperimentSelector(List<Experiment> experiments) {
		experimentInfos = new ArrayList<LabelValueBean>(experiments.size() + 2);
		LabelValueBean lvb = new LabelValueBean("All Experiments", String
				.valueOf(ALL_EXPERIMENTS));
		experimentInfos.add(lvb);
		/*lvb = new LabelValueBean("All Experiments without Regression", String
				.valueOf(ALL_EXPERIMENTS_MINUS_REGRESSION));
		experimentInfos.add(lvb);*/
		for (Experiment exp : experiments) {
			lvb = new LabelValueBean(exp.getName(), exp.getUniqueid()
					.toString());
			experimentInfos.add(lvb);
		}
		selectedExpID = ALL_EXPERIMENTS;
	}

	public Collection<LabelValueBean> getExperimentInfos() {
		return this.experimentInfos;
	}

	public void setSelectedExpID(int newSelectedExpID) {
		this.selectedExpID = newSelectedExpID;
	}

	public int getSelectedExpID() {
		return this.selectedExpID;
	}

}
