package clinical.web.helpers;

import java.util.Collection;

import org.apache.struts.util.LabelValueBean;

import clinical.web.common.query.AbstractQueryPartInfo;

/**
 * Represents the model for the query part (single search predicate) of a bean
 * property for Query by Criteria mechanism supported for complex queries in a
 * single table.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: PropertyQueryPartInfo.java,v 1.3 2006/05/02 01:01:30 bozyurt
 *          Exp $
 */
public class PropertyQueryPartInfo extends AbstractQueryPartInfo {
	protected String propertyName;
	protected String label;
	boolean numeric;
	private static final long serialVersionUID = 1L;
	
	public PropertyQueryPartInfo(String propertyName, String label,
			boolean numeric) {
		super();
		this.propertyName = propertyName;
		this.label = label;
		this.numeric = numeric;
		if (numeric)
			prepareNumericLogicalOps();
		else
			prepareVarcharLogicalOps();
	}

	public String getPropertyName() {
		return propertyName;
	}

	public String getLabel() {
		return label;
	}

	public boolean isNumeric() {
		return numeric;
	}

	// to fool buggy Struts bean tags (IBO)
	public Collection<LabelValueBean> getLogicalOps() {
		return super.getLogicalOps();
	}
	
	@Override
	public Collection<LabelValueBean> getRhsEnums() {
		return rhsEnums;
	}
}
