package clinical.web.services;

import java.sql.Connection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import clinical.server.ReceivedfilesInfo;
import clinical.server.dao.ImageprotocolsDAO;
import clinical.server.dao.ProtocolDAO;
import clinical.server.dao.ReceivedfilesDAO;
import clinical.server.dao.ReceivedfilesdcmtagDAO;
import clinical.server.vo.Experiment;
import clinical.server.vo.Imageprotocols;
import clinical.server.vo.Receivedfiles;
import clinical.server.vo.Receivedfilesdcmtag;
import clinical.web.DAOFactory;
import clinical.web.IImagingFileService;
import clinical.web.ISequenceHelper;
import clinical.web.ServiceFactory;
import clinical.web.common.IDBPoolService;
import clinical.web.common.ISecurityService;
import clinical.web.common.UserInfo;
import clinical.web.exception.BaseException;
import clinical.web.exception.DBPoolServiceException;
import clinical.web.helpers.ExpSubjInfo;
import clinical.server.vo.Protocol;

public class ImagingFileService implements IImagingFileService{
	/** Connection pool service interface */
	protected IDBPoolService dbPoolService;
	protected String dbType;
	protected ISecurityService securityService;

	/**
	 * interface for retrieving and caching nearly static data from the
	 * database.
	 */
	protected DBCache dbCache;
	/** unique number generator for primary keys */
	protected ISequenceHelper seqHelper;
	protected String dbID;
	private Log log = LogFactory.getLog(JobManagementServiceImpl.class);

	public ImagingFileService(String dbID) throws BaseException {
		dbPoolService = ServiceFactory.getPoolService(dbID);
		dbCache = DBCache.getInstance(dbID);
		seqHelper = ServiceFactory.getSequenceHelper(dbID);
		this.dbID = dbID;
		securityService = ServiceFactory.getSecurityService();
		this.dbType = securityService.getDBType(dbID);
	}

	@Override
	public List<Receivedfiles> getAllReceivedFiles(UserInfo ui)
			throws Exception {
		Connection con = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			ReceivedfilesDAO dao = DAOFactory.createReceivedfilesDAO(dbID);
			Receivedfiles criteriaBean = new Receivedfiles();
			return dao.find(con, criteriaBean);
		} catch (Exception x) {
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		} finally {
			releaseConnection(con, ui);
		}
	}

	protected void releaseConnection(Connection con, UserInfo ui) {
		if (con == null) {
			return;
		}
		try {
			dbPoolService.releaseConnection(ui.getName(), con);
		} catch (DBPoolServiceException x) {
			log.error("Cannot release connection for user " + ui.getName(), x);
		}
	}

	@Override
	public List<Receivedfilesdcmtag> getAllReceivedFilesDcmTags(UserInfo ui)
			throws Exception {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<ReceivedfilesInfo> getAllReceivedFilesInfo(UserInfo ui)
			throws Exception {
		Connection con = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			ReceivedfilesdcmtagDAO dao = DAOFactory.createReceivedfilesdcmtagDAO(dbID);
			ReceivedfilesInfo criteriaBean = new ReceivedfilesInfo();
			return dao.findReceivedFilesWithDcmTags(con, criteriaBean);
		} catch (Exception x) {
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		} finally {
			releaseConnection(con, ui);
		}	
	}
	
	public List<ReceivedfilesInfo> getDistinctReceivedFilesInfo(UserInfo ui)
			throws Exception {
		Connection con = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			ReceivedfilesdcmtagDAO dao = DAOFactory.createReceivedfilesdcmtagDAO(dbID);
			ReceivedfilesInfo criteriaBean = new ReceivedfilesInfo();
			return dao.findReceivedFilesBySeriesNoTime(con, criteriaBean);
		} catch (Exception x) {
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		} finally {
			releaseConnection(con, ui);
		}
		
	}
	
	public List<Experiment> getAllExperiments(UserInfo ui)
			throws Exception {		
		try {			
			List<Experiment> experiments = dbCache.getExperiments(ui, true);
			return experiments;
		} catch (Exception x) {
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		}		
	}

	public List<ExpSubjInfo> getAllExpSubjInfo(UserInfo ui)
		throws Exception {		
		
		try{
			return dbCache.getAllExpSubjInfo(ui, false);
		
//		Connection con = null;
//		List<ExpSubjInfo> expSubjInfos = new ArrayList<ExpSubjInfo>();
//		
//		try {			
//			con = dbPoolService.getConnection(ui.getName());
//			ISubjectVisitHandler handler = null;
//			handler = ServiceFactory.getSubjectVisitHandler();
//			
//			List<Experiment> exps = dbCache.getExperiments(ui, true);
//			for(Experiment exp : exps)
//			{
//				ExpSubjInfo expSubj = new ExpSubjInfo();
//				expSubj.setExperimentId(exp.getUniqueid().toString());
//				expSubj.setExperimentName(exp.getName());
//								
//				SubjexperimentDAO dao = DAOFactory.createSubjexperimentDAO(dbID);
//				Subjexperiment cr = new Subjexperiment();
//				cr.setNcExperimentUniqueid(exp.getUniqueid());
//
//				List<Subjexperiment> subjExps = dao.find(con, cr);
//				
//				for(Subjexperiment subjExp : subjExps){					
//					List<VisitInfo> visitInfos = handler.getVisitInfos(dbID, con, subjExp.getSubjectid());
//					subjExp.setVisitInfos(visitInfos);
//				}
//				expSubj.setSubjExps(subjExps);
//				
//				expSubjInfos.add(expSubj);
//			}			
			
		} catch (Exception x) {			
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		}		
	}
	
	public List<Protocol> getAllImageProtocols(UserInfo ui)
			throws Exception {		
		Connection con = null;
		try {
			con = dbPoolService.getConnection(ui.getName());
			ProtocolDAO dao = DAOFactory.createProtocolDAO(dbID);
			Protocol criteriaBean = new Protocol();
			return dao.find(con, criteriaBean);
		} catch (Exception x) {
			log.error("Error in getAllJobs", x);
			throw new Exception(x);
		} finally {
			releaseConnection(con, ui);
		}
	}

}
