package clinical.web.vo;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.web.common.vo.AnalysisResultSummary;
import clinical.web.common.vo.VisitSegAnalysisResultValues;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: QuerySummary.java 826 2013-08-01 22:43:11Z jinranc $
 */
public class QuerySummary implements Serializable {
	private static final long serialVersionUID = 1L;
	private String subjectID;
	private String expID;
	protected AssessmentResultSummary ars;
	protected AnalysisResultSummary ddrs;
	protected boolean hasArs = false;
	private String[] selectedSegs;
	private String[] allSegs;
	private String[] selectedDataTypes;
	private String[] selectedVersions;
	
	public QuerySummary(String subjectID, String expID) {
		super();
		this.subjectID = subjectID;
		this.expID = expID;
	}
	
	public QuerySummary(String subjectID, String expID, String[] selSegs, 
			String[] allSegs, String[] selDTypes, String[] selVersions) {
		super();
		this.subjectID = subjectID;
		this.expID = expID;
		this.setAllSegs(allSegs);
		this.setSelectedSegs(selSegs);
		this.setSelectedDataTypes(selDTypes);
		this.setSelectedVersions(selVersions);
	}

	public String getSiteID() {
		if ( ars != null)
			return ars.getSiteID();
		if ( ddrs != null)
			return ddrs.getSiteID();
		return null;
	}

	public AssessmentResultSummary getArs() {
		return ars;
	}
	
	public void setArs(AssessmentResultSummary ars) {
		this.ars = ars;
		if(selectedSegs!=null && selectedSegs.length>=1){
			String sSelectedSegs = selectedSegs[0];
			for(int i=1; i<selectedSegs.length; i++){
				sSelectedSegs = sSelectedSegs + "#" + selectedSegs[i];
			}		
			this.ars.setSelectedSegs(sSelectedSegs);			
		}
		
		if(allSegs!=null && allSegs.length>=1){
			String sAllPros = allSegs[0];
			for(int i=1; i<allSegs.length; i++){
				sAllPros = sAllPros + "#" + allSegs[i];
			}
			this.ars.setAllSegs(sAllPros);			
		}
		
		if(selectedDataTypes!=null && selectedDataTypes.length>=1){
			String sDTypes = selectedDataTypes[0];
			for(int i=1; i<selectedDataTypes.length; i++){
				sDTypes = sDTypes + "#" + selectedDataTypes[i];
			}
			this.ars.setSelectedDataTypes(sDTypes);			
		}
		
		if(selectedVersions!=null && selectedVersions.length>=1){
			String sVers = selectedVersions[0];
			for(int i=1; i<selectedVersions.length; i++){
				sVers = sVers + "#" + selectedVersions[i];
			}
			this.ars.setSelectedVers(sVers);			
		}			
	}

	public AnalysisResultSummary getDdrs() {
		return ddrs;
	}

	public void setDdrs(AnalysisResultSummary ddrs) {
		this.ddrs = ddrs;
	}

	public String getSubjectID() {
		return subjectID;
	}

	public String getExpID() {
		return expID;
	}

	public Map<String, String> getParamMap() {
		if (ars != null)
			return ars.getParamMap();
		else
			return ddrs.getParamMap();
	}

	public String getExpName() {
		if (ars != null) {
			return ars.getExpName();
		} else {
			return ddrs.getExpName();
		}		
	}
	
	public String getParamJSON() {
		if (ars != null)
			return ars.getParamJSON();
		else 
			return ddrs.getParamJSON();
	}

	public String getAllSiteIDs() {
		java.util.Set<String> uniqSiteIDs = new HashSet<String>(17);
		if (ars != null)
			uniqSiteIDs = ars.getUniqSiteIDs();
		if (ddrs != null)
			uniqSiteIDs.addAll(ddrs.getUniqSiteIDs());
		StringBuilder buf = new StringBuilder();
		for (Iterator<String> it = uniqSiteIDs.iterator(); it.hasNext();) {
			String sid = it.next();
			buf.append(sid);
			if (it.hasNext())
				buf.append(',');
		}

		return buf.toString();
	}

	public List<VSRWrapper> getVSRWrapperList() {
		List<VSRWrapper> list = null;
		Map<String, VSRWrapper> map = null;
		if (ars != null) {
			list = new ArrayList<VSRWrapper>(ars.getVsarvList().size());
			for (VisitSegAsResultValues vsarv : ars.getVsarvList()) {
				list.add(new VSRWrapper(vsarv));
			}
			if (ddrs != null) {
				map = new HashMap<String, VSRWrapper>();
				for (VSRWrapper vsr : list) {
					VisitSegAsResultValues vsarv = vsr.caVS;
					String key = vsarv.getSiteID() + ":" + vsarv.getVisitID()
							+ ":" + vsarv.getSegmentID();
					map.put(key, vsr);
				}
			}
		} else if (ddrs != null) {
			list = new ArrayList<VSRWrapper>(ddrs.getVsarvList().size());
			for (VisitSegAnalysisResultValues ddVS : ddrs.getVsarvList()) {
				list.add(new VSRWrapper(null, ddVS));
			}
		}
		if (map != null) {
			for (VisitSegAnalysisResultValues ddVS : ddrs.getVsarvList()) {
				String key = ddVS.getSiteID() + ":" + ddVS.getVisitID() + ":"
						+ ddVS.getSegmentID();

				VSRWrapper vsr = map.get(key);
				if (vsr != null) {
					vsr.ddVS = ddVS;
				}
			}
		}

		return list;
	}
	
	

	public static class VSRWrapper {
		VisitSegAsResultValues caVS;
		VisitSegAnalysisResultValues ddVS;

		public VSRWrapper(VisitSegAsResultValues caVS) {
			this.caVS = caVS;
		}

		public VSRWrapper(VisitSegAsResultValues caVS,
				VisitSegAnalysisResultValues ddVS) {
			this.caVS = caVS;
			this.ddVS = ddVS;
		}

		public VisitSegAsResultValues getCaVS() {
			return caVS;
		}

		public VisitSegAnalysisResultValues getDdVS() {
			return ddVS;
		}
	}
	
	public void setSelectedSegs(String[] selectedSegs) {
		this.selectedSegs = selectedSegs;
	}

	public String[] getSelectedSegs() {
		return selectedSegs;
	}



	public void setAllSegs(String[] allSegs) {
		this.allSegs = allSegs;
	}

	public String[] getAllSegs() {
		return allSegs;
	}



	public void setSelectedDataTypes(String[] selectedDataTypes) {
		this.selectedDataTypes = selectedDataTypes;
	}

	public String[] getSelectedDataTypes() {
		return selectedDataTypes;
	}



	public void setSelectedVersions(String[] selectedVersions) {
		this.selectedVersions = selectedVersions;
	}

	public String[] getSelectedVersions() {
		return selectedVersions;
	}

	public JSONObject toJSON(JSONObject js) throws JSONException {		
		StringBuilder sb = new StringBuilder();
		
		sb.append("['subjectID=").append(subjectID).append("',");
		sb.append("'siteID=").append(getSiteID()).append("',");
		sb.append("'expID=").append(expID).append("',");
		
		if(selectedSegs!=null){
			String jsArr= selectedSegs[0];			
			for(int i=1; i<selectedSegs.length; i++) {
				jsArr = jsArr + "#" + selectedSegs[i];
			}
			sb.append("'selectedSegments=").append(jsArr).append("',");
		}
		
		if(allSegs!=null){
			String jsArr= allSegs[0];			
			for(int i=1; i<allSegs.length; i++) {
				jsArr = jsArr + "#" + allSegs[i];
			}
			sb.append("'allSegments=").append(jsArr).append("',");
		}
		
		if(selectedDataTypes!=null){
			String jsArr= selectedDataTypes[0];			
			for(int i=1; i<selectedDataTypes.length; i++) {
				jsArr = jsArr + "#" + selectedDataTypes[i];
			}
			sb.append("'selectedDataTypes=").append(jsArr).append("',");
		}
		
		if(selectedVersions!=null){
			String jsArr= selectedVersions[0];			
			for(int i=1; i<selectedVersions.length; i++) {
				jsArr = jsArr + "#" + selectedVersions[i];
			}
			sb.append("'selectedVers=").append(jsArr).append("']");
		}		
		js.put("allInfo", sb.toString());
		
		js.put("subjectID", subjectID);
		js.put("siteID", getSiteID());
		js.put("expID", expID);
		if (selectedSegs!=null) {
			String jsArr= selectedSegs[0];			
			for(int i=1; i<selectedSegs.length; i++) {
				jsArr = jsArr + "#" + selectedSegs[i];
			}
			js.put("selectedSegments", jsArr);
		}
		
		if(allSegs!=null){
			String jsArr= allSegs[0];			
			for(int i=1; i<allSegs.length; i++) {
				jsArr = jsArr + "#" + allSegs[i];
			}
			js.put("allSegments", jsArr);
		}
		
		if(selectedDataTypes!=null){
			String jsArr= selectedDataTypes[0];			
			for(int i=1; i<selectedDataTypes.length; i++) {
				jsArr = jsArr + "#" + selectedDataTypes[i];
			}
			js.put("selectedDataTypes", jsArr);
		}
		
		if(selectedVersions!=null){
			String jsArr= selectedVersions[0];			
			for(int i=1; i<selectedVersions.length; i++) {
				jsArr = jsArr + "#" + selectedVersions[i];
			}
			js.put("selectedVers", jsArr);
		}
		
		return js;
	}
}
