package clinical.web.vo;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ScoreMetaData.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class ScoreMetaData {
	protected String scoreName;
	protected String asName;
	protected String scoreType;

	public ScoreMetaData(String scoreName, String asName, String scoreType) {
		super();
		this.scoreName = scoreName;
		this.asName = asName;
		this.scoreType = scoreType;
	}

	public String getScoreName() {
		return scoreName;
	}

	public String getAsName() {
		return asName;
	}

	public String getScoreType() {
		return scoreType;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((asName == null) ? 0 : asName.hashCode());
		result = prime * result
				+ ((scoreName == null) ? 0 : scoreName.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final ScoreMetaData other = (ScoreMetaData) obj;
		if (asName == null) {
			if (other.asName != null)
				return false;
		} else if (!asName.equals(other.asName))
			return false;
		if (scoreName == null) {
			if (other.scoreName != null)
				return false;
		} else if (!scoreName.equals(other.scoreName))
			return false;
		return true;
	}
}
