package clinical.web.vo;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

import clinical.server.vo.Expcomponent;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: Visit.java 844 2014-02-27 18:51:10Z jinranc $
 */

public class Visit {
   protected int componentID;
   protected int experimentID;
   protected String subjectID;
   protected java.sql.Timestamp timeStamp;
   protected String description;
   protected String visitType;
   protected String name = "";
   protected List<VisitSegment> visitSegments = new LinkedList<VisitSegment>();
   protected List<Study> studies = new LinkedList<Study>();
   protected boolean dirty = false;
   protected static SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");

   public Visit() {
   }

   public Visit(Expcomponent expComp) {
      componentID = expComp.getComponentid().intValue();
      experimentID = expComp.getNcExperimentUniqueid().intValue();
      subjectID = expComp.getSubjectid();
      timeStamp = expComp.getTimeStamp();
      description = expComp.getDescription();
      visitType = expComp.getVisittype();
      name = expComp.getName();
   }

   public Visit(Visit other) {
      componentID = other.getComponentID();
      experimentID = other.getExperimentID();
      subjectID = other.getSubjectID();
      timeStamp = other.timeStamp;
      description = other.getDescription();
      visitType = other.getVisitType();
      name = other.getName();
   }

   public void setDirty(boolean newDirty) {
      this.dirty = newDirty;
   }

   public boolean isDirty() {
      return this.dirty;
   }

   public Expcomponent toExpComponent() {
      Expcomponent comp = new Expcomponent();
      comp.setComponentid(new BigDecimal(String.valueOf(componentID)));
      comp
            .setNcExperimentUniqueid(new BigDecimal(String
                  .valueOf(experimentID)));
      comp.setSubjectid(subjectID);
      comp.setTimeStamp(timeStamp);
      comp.setDescription(description);
      comp.setVisittype(visitType);
      if (name != null)
         comp.setName(name);
      return comp;
   }

   public void addVisitSegment(VisitSegment segment) {
      visitSegments.add(segment);
   }

   public List<VisitSegment> getVisitSegments() {
      return visitSegments;
   }

   public VisitSegment getVisitSegment(int segmentID) {
      for (VisitSegment vs :visitSegments) {
         if (vs.getSegmentID() == segmentID) {
            return vs;
         }
      }
      return null;
   }

   public boolean hasSegment(int segmentID) {
      for (VisitSegment vs : visitSegments) {
         if (vs.getSegmentID() == segmentID)
            return true;
      }
      for (Study s : studies) {
         for (StudySegment ss : s.getStudySegments()) {
            if (ss.getSegmentID() == segmentID)
               return true;
         }
      }
      return false;
   }

   public void addStudy(Study study) {
      studies.add(study);
   }

   public List<Study> getStudies() {
      return studies;
   }

   public Study getStudy(int studyID) {
      for (Iterator<Study> iter = studies.iterator(); iter.hasNext();) {
         Study s = iter.next();
         if (s.getStudyID() == studyID) {
            return s;
         }
      }
      return null;
   }

   /**
    * 
    * @param studyID
    * @param srcStudy
    * @param setDirtyFlag if true means the cache is not saved to the database
    *           yet
    */
   public void updateStudy(int studyID, Study srcStudy, boolean setDirtyFlag) {
      Study study = getStudy(studyID);
      assert (study != null);
      study.setDescription(srcStudy.getDescription());
      study.setName(srcStudy.getName());
      if (setDirtyFlag) {
         setDirty(true);
      }
   }

   public String getComponentIDAsString() {
      return String.valueOf(componentID);
   }

   // ---------------------- setters --------------
   public void setComponentID(int newComponentID) {
      this.componentID = newComponentID;
      setDirty(true);
   }

   public void setExperimentID(int newExperimentID) {
      this.experimentID = newExperimentID;
      setDirty(true);
   }

   public void setSubjectID(String newSubjectid) {
      this.subjectID = newSubjectid;
      setDirty(true);
   }

   public void setTimeStamp(java.sql.Timestamp newTimeStamp) {
      this.timeStamp = newTimeStamp;
      setDirty(true);
   }

   public void setDescription(String newDescription) {
      this.description = newDescription;
      setDirty(true);
   }

   public void setVisitType(String newVisitType) {
      this.visitType = newVisitType;
      setDirty(true);
   }

   public void setName(String newName) {
      this.name = newName;
      setDirty(true);
   }

   // ---------------------- getters --------------
   public int getComponentID() {
      return this.componentID;
   }

   public int getExperimentID() {
      return this.experimentID;
   }

   public String getSubjectID() {
      return this.subjectID;
   }

   public String getTimeStamp() {
      if (timeStamp == null)
         return "";
      return df.format(new Date(this.timeStamp.getTime()));
   }

   public java.sql.Timestamp getTs() {
      return timeStamp;
   }

   public String getDescription() {
      return this.description;
   }

   public String getVisitType() {
      return this.visitType;
   }

   public String getName() {
      return this.name;
   }

   public String toString() {
      StringBuffer buf = new StringBuffer(200);
      buf.append("Visit::[");
      buf.append("componentID=").append(componentID);
      buf.append(", experimentID=").append(experimentID);
      buf.append(", subjectID=").append(subjectID);
      buf.append(", timeStamp=").append(timeStamp);
      buf.append(", description=").append(description);
      buf.append(", visitType=").append(visitType);
      buf.append(", name=").append(name);
      for (Iterator<VisitSegment> iter = visitSegments.iterator(); iter
            .hasNext();) {
         VisitSegment vs = iter.next();
         buf.append("\n\t").append(vs);
      }
      for (Iterator<Study> iter = studies.iterator(); iter.hasNext();) {
         Study study = iter.next();
         buf.append("\n\t").append(study);
      }
      buf.append(']');
      return buf.toString();
   }

	public boolean hasStudies() {
		return (studies != null && !studies.isEmpty());
	}

	public JSONObject toJSON(JSONObject js){		
		try {
			js.put("visitnumber", componentID);
			js.put("visitname", name);
			js.put("visittype", this.visitType);
			
			return js;
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
	}
}
