/*
  a simple modal prompt dialog box with a dropdown of possible selections
 */
hid_DDPrompt = function(icon, callOK, callCancel, posAnswers, cssClass) {
  if (arguments.length==0) return;
  this.base = jt_AppPrompt;
  this.base(icon, callOK, callCancel, cssClass);
  this.returnData = new Object();
  this.fInput = document.createElement('select');
  for(var i = 0; i < posAnswers.length; ++i) {
     var ope = document.createElement('option');
     ope.value= posAnswers[i];
     var tn = document.createTextNode( posAnswers[i]);
     ope.appendChild(tn);
     this.fInput.appendChild(ope);
  }	
  if (cssClass) this.fInput.className = cssClass;
  this.fInput.appDialog = this;
}

hid_DDPrompt.prototype = new jt_AppPrompt();
hid_DDPrompt.superClass = jt_AppPrompt.prototype;

hid_DDPrompt.prototype.askUser = function(htmlContent) {
  this.setContent(htmlContent);
  this.contentCell.appendChild(this.fInput);
  this.show();
  this.fInput.focus();
}


// {comps : [{type: 'radio', title:'Format', elems: [{name:'_format', label : 'A Segment Per Line', value:'segment', checked:true},
//  {name:'_format', label : 'A Visit Per Line', value:'visit', checked:false}]},
//   {type:'cb', title:'Content', elems: [{name:'_contnent', label : 'Include Derived Data', value:'segment', checked:true}]}]}
//
hid_DialogBox = function(icon, callOK, callCancel, dialogOpts)  {
  if (arguments.length==0) return;
  this.base = jt_AppPrompt;
  this.base(icon, callOK, callCancel, null);
  this.returnData = dialogOpts;
  var divNode = utils.newDomNode('div','hid_dialog_panel');
  var comps = dialogOpts.comps;
  for(var i = 0; i < comps.length; i++) {
	  if (comps[i].title) {
		  divNode.appendChild( utils.styledText(comps[i].title,{'font-weight': 'bold'}));
	  }
	  var groupDiv = utils.newDomNode('div','hdp_div_' + i);
	  groupDiv.setStyle({border :'1px solid black', padding: '3px', 'margin-bottom' : '3px'});
	  divNode.appendChild(groupDiv);
	  var elems = comps[i].elems;
	  for(var j = 0; j < elems.length; j++) {
		   var node = null;
			if (comps[i].type == 'radio') {
		        node = utils.newRadioBut("hdp_inp_" + i + "_" + j, elems[j].name, elems[j].label, elems[j].value, elems[j].checked);
			} else {
				node = utils.newCheckBox("hdp_inp_" + i + "_" + j, elems[j].name, elems[j].label, elems[j].value, elems[j].checked);
			}
			groupDiv.appendChild(node);
			groupDiv.appendChild( utils.newDomNode('br'));
	  }			  
  }
  this.fInput = divNode;
  this.fInput.appDialog = this;	
}

hid_DialogBox.prototype = new jt_AppPrompt();
hid_DialogBox.superClass = jt_AppPrompt.prototype;

hid_DialogBox.prototype.askUser = function(htmlContent) {
	if (htmlContent) {
		this.setContent(htmlContent);
 	}
	this.contentCell.appendChild(this.fInput);
	this.show();
	this.fInput.focus();
}

hid_DialogBox.prototype.hide = function(ok) {
   if (ok) {
		var comps = this.returnData.comps;
      for(var i = 0; i < comps.length; i++) {
			var elems = comps[i].elems;
			for(var j = 0; j < elems.length; j++) {
				var input = $("hdp_inp_" + i + "_" + j);
				if (input) 
				   elems[j].checked = input.checked;	
			}
		}
	}
	hid_DialogBox.superClass.hide.call(this,ok);
}
