<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>

    
	<script type="text/javascript">
	window.addOnLoadListener(onLoadHandler);
	
	var fileList = <c:out value="${processFileForm.JSONStr}" escapeXml="false" />;
	var expSubjList = <c:out value="${processFileForm.JSONStr1}" escapeXml="false" />;
	var protocolList = <c:out value="${processFileForm.JSONStr2}" escapeXml="false" />;
	var oTable;
	var gaiSelected = [];
	var selectedPatientId;
	var selectedExpName;
	var selectedVisitNumber;
	var selectedProtocol;	
	
	function getExpnameBySubjId(subj){
		var expName;
		
		for(var i=0; i<expSubjList.length;i++){
			for(var j=0; j<expSubjList[i].subjectvisit.length; j++){
				if(expSubjList[i].subjectvisit[j].subjectid==subj){
					expName =expSubjList[i].experimentname;
					return expName;
				}
			}
		}		
	}
	
	function onLoadHandler() {
		jQuery.noConflict();    	    	
    	
     	if (typeof jQuery == 'undefined') {  
 		    alert("not loaded");  
 		} else {			
			jQuery(function(){
				var tips = jQuery( ".validateTips" );
				
				function updateTips( t ) {
					tips.text( t ).addClass( "ui-state-error" );
				}				
				
				function checkRowSelected( patientId ) {
					if(patientId){
						if ( patientId.length <= 0 ) {			
							updateTips( "You haven't selected any row of data yet! " );
							return false;
						} else {
							return true;
						}	
					}else{						
						updateTips( "You haven't selected any row of data yet! " );
						return false;
					}
				}
				
		    	oTable = jQuery("#pfiles").dataTable({
		    		"sDom": 'T<"clear">lfrtip',
		            "oTableTools": {
		    			"sRowSelect": "multi",
						"aButtons": ["select_all",
						             "select_none"
									]
		    		},
		    		"sPaginationType": "full_numbers",
		            "bJQueryUI": true
		        });
		    	
		    	oTable.$('tr').click( function () {
		    	    var data = oTable.fnGetData( this );
		    	    if(null!=data){
		    	    	selectedPatientId = data[0];
		    	    	selectedExpName = getExpnameBySubjId(selectedPatientId);
		    	    }
		    	  });
	
		    	jQuery( "#dialog-form" ).dialog({
		    		autoOpen: false,
		    		height: 300,
		    		width: 450,
		    		modal: true,
		    		buttons: {
		    			"OK": function() {
			    			var bValid = true;				    		
				    		bValid = bValid && checkRowSelected(selectedPatientId);
				    		if ( bValid ) {
				    			var form=$('actp').form;
				    			$('actp').value="placing";
				    			form.selectedExp.value = selectedExpName;
				    			form.selectedSubj.value = selectedPatientId;
				    			form.selectedVisit.value =$('visitDropDown').options[$('visitDropDown').selectedIndex].text;
				    			form.selectedProtocol.value=$('protocolDropDown').options[$('protocolDropDown').selectedIndex].text;
				    			$('gSessionForm').submit();
					    		return false;
			    			}
		    			},
		    			Cancel: function() {
		    				jQuery( this ).dialog( "close" );
		    			}
		    		},
		    		close: function() {
		    			allFields.val( "" ).removeClass( "ui-state-error" );
		    		},
		    	});

		    	jQuery( "#processFile" ).button().click(function() {
		    		var expSel = $('expDropDown');		    		
		    		for(var i=0; i<expSel.length; i++){
		    			if(expSel.options[i].text==selectedExpName){
		    				expSel.selectedIndex = i;
		    			}	
		    		}
		    		popSubjDropDownOnExpName(expSel.options[expSel.selectedIndex].text);
		    		
		    		var subj = $('subjIdDropDown');		    		
		    		popVisitDrpOnExpnameSubj(expSel.options[expSel.selectedIndex].text, subj.options[subj.selectedIndex].text);
		    		
		    		popProtocolDropDown();
		    		
		    		tips.removeClass( "ui-state-error");
					tips.text( "Choose Experiment, Subject ID, and Visit Number from the following dropdowns list." );
		    		
		    		jQuery( "#dialog-form" ).dialog( "open" );

		    	});
 		    }); 
  		}    	
    } 
	
	function popSubjDropDownOnExpName(expName){
		jQuery('#subjIdDropDown').empty();
		
		var subjDrp = $('subjIdDropDown');
 		var nSubjId;
 		
 		for(var i=0; i<expSubjList.length; i++){
 			if(expSubjList[i].experimentname==expName){
 				for(var j=0; j<expSubjList[i].subjectvisit.length; j++){
 					nSubjId = expSubjList[i].subjectvisit[j].subjectid;
 					var option = new Option(nSubjId,j);
 					subjDrp.options[subjDrp.options.length] = option;
 					if(nSubjId ==selectedPatientId){
 						subjDrp.selectedIndex = subjDrp.options.length-1;
 					}
 				}
 			}
 		}
	}
    
 	function expDrpChange(){ 		
 		var expDrp = $('expDropDown');
 		var strExp = expDrp.options[expDrp.selectedIndex].text;
 		
 		popSubjDropDownOnExpName(strExp);
 	}
 	
 	function popVisitDrpOnExpnameSubj(expname, subjid){
 		jQuery('#visitDropDown').empty();
 		
 		var visitNumber; 		
 		var vDrp = $('visitDropDown');
 		for(var i=0; i<expSubjList.length; i++){
 			if(expSubjList[i].experimentname==expname){
 				for(var j=0; j<expSubjList[i].subjectvisit.length; j++){
 					if(expSubjList[i].subjectvisit[j].subjectid==subjid){
 						for(var k=0; k<expSubjList[i].subjectvisit[j].visitinfos.length; k++){
 							visitNumber = expSubjList[i].subjectvisit[j].visitinfos[k].visitnumber;
 							var option=new Option(visitNumber, k);
 							vDrp.options[vDrp.options.length] = option; 							
 						} 						
 					}
 				}
 			}
 		}
 	}
 	
 	function subjIdDrpChange(){
 		var expName = $('expDropDown').options[$('expDropDown').selectedIndex].text;
 		var subj = $('subjIdDropDown').options[$('subjIdDropDown').selectedIndex].text;
 		popVisitDrpOnExpnameSubj(expName, subj);
 	}
 	
 	function popProtocolDropDown(){
 		jQuery('#protocolDropDown').empty();
 		var pDrp =$('protocolDropDown'); 
 		var protocolName;
 		for(var i=0; i<protocolList.length; i++){
 			protocolName = protocolList[i].name;
 			var option = new Option(protocolName, i);
 			pDrp.options[pDrp.options.length] = option;
 		} 		
 	}
 	
	</script>
	
	<style>
	#pf {
 		float:left; 
 		padding:0px; 
 		padding-bottom: 1em; 
 		margin-left:10px;		 
 		width: 80%; 
	}


</style>

<html:form action="/processfile" styleId="gSessionForm" >
	<input type="hidden" name="actionParam" value="" id="actp" />
	<input type="hidden" name="selectedExp" value="" />
	<input type="hidden" name="selectedSubj" value="" />
	<input type="hidden" name="selectedVisit" value="" />
	<input type="hidden" name="selectedProtocol" value="" />
	
	<div id="pf">	
		<input type="button" id="processFile" value="Process..." class="submit-button" onclick="procesFile(this);" >
		<table id="pfiles" class="display" >
			<thead>
				<tr>					
					<th>Patient ID</th>
		            <th>Series Number</th>
		            <th>Series Description</th>		            
		            <th>Series Date</th>
		            <th>Series Time</th>
				</tr>
			</thead>
		    <tbody>	
		    	<c:forEach items="${processFileForm.allRcvdFiles}" var="singleFile">
		    		<tr>		    			
		    			<td><c:out value="${singleFile.patientid}"></c:out></td>
		    			<td><c:out value="${singleFile.seriesnumber}"></c:out></td>
		    			<td><c:out value="${singleFile.seriesdescription}"></c:out>
		    			<td><c:out value="${singleFile.seriesdate}"></c:out></td>
		    			<td><c:out value="${singleFile.seriestime}"></c:out></td>		    					    					    			
		    		</tr>
		    	</c:forEach>
		    </tbody>
		</table>		
	</div>
	
	<div id="dialog-form" title="Process Imaging File Series" >
	<p class="validateTips">Select Experiment, Subject ID, and Visit Number From the following dropdowns. </p>		
		<form>			
			<table>
				<tr>
					<td><label>Experiment:</label></td>
					<td>
						<select id="expDropDown" onchange="expDrpChange()">
							<c:forEach items="${processFileForm.allExperiments}" var="singleExp">
							<option id="<c:out value="${singleExp.uniqueid}"></c:out>" value="<c:out value="${singleExp.name}"></c:out>"><c:out value="${singleExp.name}"></c:out></option>
							</c:forEach>
						</select>
					</td>					
				</tr>				
				<tr>
					<td><label for="subjId">Subject ID:</label></td>
					<td>
						<select id="subjIdDropDown" onchange="subjIdDrpChange()">							
						</select>
					</td>
				</tr>
				<tr>
					<td><label for="visitId">Visit Number:</label></td>
					<td>
						<select id="visitDropDown" ></select>
					</td>
				</tr>
				<tr>
					<td><label for="protocolId">Protocol:</label></td>
					<td>
						<select id="protocolDropDown" ></select>
					</td>
				</tr>
				
			</table>
		</form>
	</div>
</html:form>

	
 <script>	
     //var divElem = $('pf');
     //var options = {color: "#00659c", corners: 'top'};
     //Rico.Corner.round( divElem, {color: "transparent"} );
     /*Rico.Corner.round( divElem,  {color: "#00659c", corners: 'top bottom'});*/
</script>