<%@ page contentType="text/html;charset=UTF-8" language="java" %>

<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jstl/fmt" %>

<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>

<script language='javascript' src='utils.js'></script>
<script type="text/javascript">

	var helpSystem = null;	

	function onLoadHandler() {
		var options = [];
		var url = '<html:rewrite page="/help.do?context=shopping_cart"/>';
		helpSystem = new bal.AjaxHelpSystem(url, options);
	}

	window.addOnLoadListener(onLoadHandler);

 function go(elem, actionValue) {
 	var list = new Array();    
 	<c:forEach var="item" items="${scForm.items}">
		append2List(list, <c:out value="${item.treeId}"/>.getSelectedTitles() );
	</c:forEach>
	if(list.length==0){
		alert("You haven't chosen any data yet. Please click checkbox to select data to download!");
		return false;
	}
	elem.form.action.value =actionValue;
	onSubmitHandler(elem.form);     
 }

 function go2(elem, actionValue) {
     elem.form.action.value =actionValue;
 }
 
 function append2List(list, items) {
    for(var i = 0; i < items.length; i++) {
    	list[list.length] = items[i];	
    }
 }
 
 function onSubmitHandler(form) {
    var list = new Array();    
   <c:forEach var="item" items="${scForm.items}">
    append2List(list, <c:out value="${item.treeId}"/>.getSelectedTitles() );
   </c:forEach>

    var str = "<list>";
    for(var i = 0; i < list.length; i++) {
       // alert("list["+ i + "].type=" + list[i].type); 
       if (list[i].type == 'ca') {
         str += "<ca>" + list[i].path + "</ca>";
       } else {
         str += "<item>" + list[i].path + "</item>";
       }
    }
    str += "</list>";
    form.results.value = str;
 }
 
 function removeItem(elem, subjectID) {
    elem.form.action.value = 'removeItem';
    elem.form.subjectID.value = subjectID;
    elem.form.submit();
    return false;
 }
 
 // global var 
 var totalSize = 0;
 
 function totalSizeHandler(checkedList, uncheckedList) {
     if ( uncheckedList) {
        // alert("uncheckedList:" + uncheckedList.length );
        
        for(var i = 0; i < uncheckedList.length; ++i) {
           var payload = uncheckedList[i].payload;
           if ( payload && !uncheckedList[i].hasChild) {
              totalSize -= payload;
           }
        }
     }
     if ( checkedList) {
        //alert("checkedList:" + checkedList.length );
        for(var i = 0; i < checkedList.length; ++i) {
           var payload = checkedList[i].payload;
           if ( payload && !checkedList[i].hasChild) {
              totalSize += payload;
           }
        }
     }
     var el = $('size-div');
     if ( el ) {
        str = "Download size : " + utils.formatFileSize(totalSize);
        el.innerHTML=str;
     }
 }

//find all dTree nodes, select them all or unselect them all
	function checkAll(elem){	 	 
		var inputs = elem.form.elements;	 
		var chkAll = $("chkAll");
		 
		for(var i=0; i<inputs.length;i++){
			if(inputs[i].type=="checkbox"	&& inputs[i].id.indexOf("cb_")===0){
				//if checkbox is root node, then click on it
				var pCube = inputs[i].parentNode.parentNode.parentNode;
				if(pCube){
					if(chkAll.checked){
						if(pCube.className=="dtree" && !inputs[i].checked){							 
							fakeClick("click", inputs[i]);
						} 
					}else{
						if(pCube.className=="dtree" && inputs[i].checked){							 
							fakeClick("click",inputs[i]);
						}
					}				 
				}
			}
		}

		var el = $('size-div');
		if ( el ) {
			str = "Download size : " + utils.formatFileSize(totalSize);
			el.innerHTML=str;
		}
	}
 
 //If applyAllSubjAndVisit is checked, find the first selected subject and apply its setting to the rest subjects
 //else uncheck all the subjects except the first one subject
 function applyAllSubjAndVisit(elem){	 
	 var appAll = $("appAll");
	 var arrNames = new Array();
	 var arrIdx=0;
	 
	 if(appAll.checked==true){		 
		 var inputs = elem.form.getElementsByTagName("div");
		 var subjectIdx = 1;
		 for(var i=0; i<inputs.length; i++){
			 if(inputs[i].className=="dtree" && subjectIdx==1){//find first subject's checkbox text value
				 var cb = inputs[i].getElementsByTagName("input");
				 for(var j=0;j<cb.length;j++){
					if(cb[j].type=="checkbox" && cb[j].id.indexOf("cb_")===0){
						if(cb[j].checked==true){
							 //get checkbox's parent node
							 var parentOfCheckBox = cb[j].parentNode;
							 var strCheckbox = parentOfCheckBox.getElementsByTagName("a");
							 for(var k=0; k<strCheckbox.length; k++){								 
								 if(strCheckbox[k].className=="node"){									 
									 //get all the checked values									 
									 arrNames[arrIdx++] = strCheckbox[k].innerHTML;
								 }
							 }
						 }
					}
				 }
				 break;
			 }
		 }
		 for(var i=0;i<inputs.length;i++){
			 if(inputs[i].className=="dtree"){ //apply to all subjects and visits				
			 	if(arrNames.length==0) return;
			 	var cb = inputs[i].getElementsByTagName("input");
			 	for(var j=0; j<cb.length; j++){
			 		if(cb[j].type=="checkbox" && cb[j].id.indexOf("cb_")===0){
			 			var pNode = cb[j].parentNode;
			 			var cbNode = pNode.getElementsByTagName("a");
			 			for(var k=0; k<cbNode.length; k++){
			 				if(cbNode[k].className=="node"){
			 					for(var l=0;l<arrNames.length;l++){			 						
			 						if(cbNode[k].innerHTML==arrNames[l]){
			 							cb[j].checked = true;
			 							//check all the sub-nodes
			 							var cbscb = cb[j].parentNode.nextSibling.getElementsByTagName("input");											
										for(var idx=0; idx<cbscb.length; idx++){
											if(cbscb[idx].type=="checkbox" && cbscb[idx].id.indexOf("cb_")===0){												
												if(cbscb[idx].checked==false) 
													fakeClick("click", cbscb[idx]);
											}
										}
			 							break;
			 						}
			 					}
			 				}
			 			}
			 		}
			 	}
			 	subjectIdx++;
			 }
		 }
	 }else{		 
		 var inputs = elem.form.getElementsByTagName("div");
		 var subjIdx = 1;
		 var visitIdx = 1;
		 for(var i=0;i<inputs.length;i++){			 
			 if(inputs[i].className=="dtree"){
				 if(subjIdx==1){
					 //clear settings of the first subject's visits except the first visit
					 var cb = inputs[i].getElementsByTagName("input");
					 for(var j=0; j<cb.length; j++){
						 if(cb[j].type=="checkbox" && cb[j].id.indexOf("cb_")==0){
							 var pNode = cb[j].parentNode;
							 var cbNode = pNode.getElementsByTagName("a");
							 for(var k=0; k<cbNode.length; k++){
								 if(cbNode[k].className=="node"){									 
									if(cbNode[k].innerHTML.indexOf("Visit")===0){
										 if(visitIdx++==1){
											 break;
										 }
										 else{
											cb[j].checked = false;
											var cbscb = cb[j].parentNode.nextSibling.getElementsByTagName("input");											
											for(var idx=0; idx<cbscb.length; idx++){
												if(cbscb[idx].type=="checkbox" && cbscb[idx].id.indexOf("cb_")===0){													
													if(cbscb[idx].checked)
														fakeClick("click",cbscb[idx]);
												}												
											}
										 }
									 }
								 }
							 }
						 }
					 }
				 }else{
					// clear settings of all subjects's visits except the first subject					
					var cb = getElementsByClassName("dtreeCB", "input", inputs[i]);
					 for(var j=0;j<cb.length;j++){						
						if(cb[j].checked) 
							fakeClick("click",cb[j]);
					 }
				 }
				 subjIdx++;				 
			 }
		 }
	 }
	 
 }
 
 function applySameVisit(elem){
	 var appSameVisit = $("appSameVisit");
	 var arrNames = new Array();
	 var arrIdx=0;
	 var arrVisitName = new Array();
	 var arrVisitNameIdx=0;
	 
	 if(appSameVisit.checked==true){		 
		 var inputs = elem.form.getElementsByTagName("div");
		 var subjectIdx = 1;
		 for(var i=0; i<inputs.length; i++){
			 if(inputs[i].className=="dtree" && subjectIdx==1){//find first subject's checkbox text value
				 var cb = inputs[i].getElementsByTagName("input");
				 for(var j=0;j<cb.length;j++){
					if(cb[j].type=="checkbox" && cb[j].id.indexOf("cb_")===0){
						if(cb[j].checked==true){
							 //get checkbox's parent node
							 var parentOfCheckBox = cb[j].parentNode;
							 var strCheckbox = parentOfCheckBox.getElementsByTagName("a");
							 for(var k=0; k<strCheckbox.length; k++){								 
								 if(strCheckbox[k].className=="node"){									 
									 //get all the selected checkbox string values									 
									 arrNames[arrIdx++] = strCheckbox[k].innerHTML;
									 //get visit string value
									 var visitNode = parentOfCheckBox.parentNode.previousSibling.getElementsByTagName("a");
									 for(var l=0; l<visitNode.length; l++){
										 if(visitNode[l].className=="node"){											 
											 if(visitNode[l].innerHTML.indexOf("Visit")===0){													
													if(contains(arrVisitName, visitNode[l].innerHTML)==false){														
														arrVisitName[arrVisitNameIdx++]=visitNode[l].innerHTML;
													}
										 	}
										}
									 }
								 }
							 }
						 }
					}
				 }
				 break;
			 }
		 }
		 for(var i=0;i<inputs.length;i++){
			 if(inputs[i].className=="dtree"){ //apply to the same visit of all other subjects				
			 	if(arrNames.length==0) return;
			 	if(subjectIdx++==1) continue;
			 	var cb = inputs[i].getElementsByTagName("input");
			 	for(var j=0; j<cb.length; j++){
			 		if(cb[j].type=="checkbox" && cb[j].id.indexOf("cb_")==0){
			 			var pNode = cb[j].parentNode;
			 			var cbNode = pNode.getElementsByTagName("a");
			 			for(var k=0; k<cbNode.length; k++){
			 				if(cbNode[k].className=="node"){
			 					for(var l=0;l<arrNames.length;l++){			 						
			 						if(cbNode[k].innerHTML==arrNames[l]){			 							
			 							if(cbNode[k].innerHTML.indexOf("Visit")==0){
			 								cb[j].checked = true;
			 							}else{
			 								var visitNode = pNode.parentNode.previousSibling.getElementsByTagName("a");
				 				 			for(var m=0; m<visitNode.length; m++){
				 				 				if(visitNode[m].className=="node"){
				 				 					for(var n=0; n<arrVisitName.length; n++){				 					 					
				 					 					if(visitNode[m].innerHTML == arrVisitName[n]){
				 					 						cb[j].checked = true;
				 					 						//check all the sub-nodes
				 				 							var cbscb = cb[j].parentNode.nextSibling.getElementsByTagName("input");											
				 											for(var idx=0; idx<cbscb.length; idx++){
				 												if(cbscb[idx].type=="checkbox" && cbscb[idx].id.indexOf("cb_")===0){
				 													if(!cbscb[idx].checked) 
				 														fakeClick("click",cbscb[idx]);
				 												}												
				 											}
				 				 							break;
				 					 					}
				 					 				}
				 				 				}
				 				 			}	
			 							}			 							
			 						}
			 					}
			 				}
			 			}
			 		}
			 	}
			 	subjectIdx++;
			 }
		 }
	 }else{
		 // clear all subjects's visits except the first one
		 var inputs = elem.form.getElementsByTagName("div");
		 var subjIdx = 1;
		 for(var i=0;i<inputs.length;i++){
			 if(inputs[i].className=="dtree"){
				 if(subjIdx!=1){					 
					 var cb = getElementsByClassName("dtreeCB","input", inputs[i]);
					 for(var j=0;j<cb.length;j++){						
						 if(cb[j].checked) 
						 	fakeClick("click",cb[j]);
					 }
				 }
				 subjIdx++;				 
			 }
		 }
	 }
 }

 function applySameVisitAtFileNodeLevel(elem){
	 var appSameVisit = $("appSameVisit");
	 var arrNames = new Array();
	 var arrIdx=0;
	 var arrVisitName = new Array();
	 var arrVisitNameIdx=0;
	 var arrFileNames = new Array()	;
	 var arrFileIdx = 0;
	 
	 if(appSameVisit.checked==true){		 
		 var inputs = elem.form.getElementsByTagName("div");
		 var subjectIdx = 1;
		 for(var i=0; i<inputs.length; i++){
			 if(inputs[i].className=="dtree" && subjectIdx==1){//find first subject's checkbox text value
				 var cb = inputs[i].getElementsByTagName("input");
				 for(var j=0;j<cb.length;j++){
					if(cb[j].type=="checkbox" && cb[j].id.indexOf("cb_")===0){
						if(cb[j].checked==true){
							 //get checkbox's parent node
							 var parentOfCheckBox = cb[j].parentNode;
							 var strCheckbox = parentOfCheckBox.getElementsByTagName("a");
							 for(var k=0; k<strCheckbox.length; k++){								 
								 if(strCheckbox[k].className=="node"){									 
									 //get all the selected checkbox string values									 
									 arrNames[arrIdx++] = strCheckbox[k].innerHTML;
									 //get visit string value
									 var visitNode = parentOfCheckBox.parentNode.previousSibling.getElementsByTagName("a");
									 for(var l=0; l<visitNode.length; l++){
										 if(visitNode[l].className=="node"){											 
											 if(visitNode[l].innerHTML.indexOf("Visit")===0){													
													if(contains(arrVisitName, visitNode[l].innerHTML)==false){														
														arrVisitName[arrVisitNameIdx++]=visitNode[l].innerHTML;
													}
										 	}
										}
									 }
								 }
							 }
							 if(strCheckbox.length==0){ //at file node level
								var fileName = parentOfCheckBox.lastChild.nodeValue;								 
								var grandparentOfCheckBox = parentOfCheckBox.parentNode;
								var upperLevelCB = grandparentOfCheckBox.previousSibling;
								var cbs = upperLevelCB.getElementsByTagName("a");
								var upperLevelNodeName;
								for(var k=0; k<cbs.length; k++){
									if(cbs[k].className="node"){
										upperLevelNodeName = cbs[k].innerHTML;
									}
								}
								var splitFileName;
								if(fileName){
									splitFileName =fileName.split(upperLevelNodeName);
								}
								if(fileName!=splitFileName){
									fileName = splitFileName[splitFileName.length-1];
								}
								//get visit string value
								var visitNode = grandparentOfCheckBox.parentNode.previousSibling.getElementsByTagName("a");
								var visitName;
								for(var l=0; l<visitNode.length; l++){
									if(visitNode[l].className=="node"){											 
										if(visitNode[l].innerHTML.indexOf("Visit")===0){													
											visitName=visitNode[l].innerHTML;
										}
									}
								}								 
								arrFileNames[arrFileIdx++] = visitName + "/" + upperLevelNodeName + "/" + fileName;
							}
						}
					}
				}
				break;
			}
		}
		for(var i=0;i<inputs.length;i++){
			if(inputs[i].className=="dtree"){ //apply to the same visit of all other subjects				
				//if(arrNames.length==0) return;
			 	if(subjectIdx++==1) continue;
			 	var cb = inputs[i].getElementsByTagName("input");
			 	for(var j=0; j<cb.length; j++){
			 		if(cb[j].type=="checkbox" && cb[j].id.indexOf("cb_")==0){
			 			var pNode = cb[j].parentNode;
			 			var cbNode = pNode.getElementsByTagName("a");
			 			for(var k=0; k<cbNode.length; k++){
			 				if(cbNode[k].className=="node"){
			 					for(var l=0;l<arrNames.length;l++){			 						
			 						if(cbNode[k].innerHTML==arrNames[l]){			 							
			 							if(cbNode[k].innerHTML.indexOf("Visit")==0){
			 								cb[j].checked = true;
			 							}else{
			 								var visitNode = pNode.parentNode.previousSibling.getElementsByTagName("a");
				 				 			for(var m=0; m<visitNode.length; m++){
				 				 				if(visitNode[m].className=="node"){
				 				 					for(var n=0; n<arrVisitName.length; n++){				 					 					
				 					 					if(visitNode[m].innerHTML == arrVisitName[n]){
				 					 						cb[j].checked = true;
				 					 						//check all the sub-nodes
				 				 							var cbscb = cb[j].parentNode.nextSibling.getElementsByTagName("input");											
				 											for(var idx=0; idx<cbscb.length; idx++){
				 												if(cbscb[idx].type=="checkbox" && cbscb[idx].id.indexOf("cb_")===0){
				 													if(!cbscb[idx].checked) 
				 														fakeClick("click",cbscb[idx]);
				 												}												
				 											}
				 				 							break;
				 					 					}
				 					 				}
				 				 				}
				 				 			}	
			 							}			 							
			 						}
			 					}
			 				}
			 			}
			 			if(cbNode.length==0){ //at file node level
			 				var fileName = pNode.lastChild.nodeValue;								 
							var grandparentOfCheckBox = pNode.parentNode;
							var upperLevelCB = grandparentOfCheckBox.previousSibling;
							var cbs = upperLevelCB.getElementsByTagName("a");
							var upperLevelNodeName;
							for(var k=0; k<cbs.length; k++){
								if(cbs[k].className="node"){
									upperLevelNodeName = cbs[k].innerHTML;
								}
							}
							var splitFileName;
							if(fileName){
								splitFileName =fileName.split(upperLevelNodeName);
							}
							if(fileName!=splitFileName){
								fileName = splitFileName[splitFileName.length-1];
							}
							//get visit string value
							var visitNode = grandparentOfCheckBox.parentNode.previousSibling.getElementsByTagName("a");
							var visitName;
							for(var l=0; l<visitNode.length; l++){
								if(visitNode[l].className=="node"){											 
									if(visitNode[l].innerHTML.indexOf("Visit")===0){													
										visitName=visitNode[l].innerHTML;
									}
								}
							}	
							for(var a=0; a<arrFileNames.length;a++){
								if(arrFileNames[a] == visitName + "/" + upperLevelNodeName + "/" + fileName){
									cb[j].checked = true;
								}	
							}
							
			 			}
			 		}
			 	}
			 	subjectIdx++;
			 }
		 }
	 }else{
		 // clear all subjects's visits except the first one
		 var inputs = elem.form.getElementsByTagName("div");
		 var subjIdx = 1;
		 for(var i=0;i<inputs.length;i++){
			 if(inputs[i].className=="dtree"){
				 if(subjIdx!=1){					 
					 var cb = getElementsByClassName("dtreeCB","input", inputs[i]);
					 for(var j=0;j<cb.length;j++){						
						 if(cb[j].checked) 
						 	fakeClick("click",cb[j]);
					 }
				 }
				 subjIdx++;				 
			 }
		 }
	 }
 }
 
 
 
 //If applyAllSubjAndVisit is checked, find the first selected subject and apply its setting to the rest subjects
 //else uncheck all the subjects except the first one subject
 function applyAllSubjAndVisitFileLevel(elem){	 
	 var appAll = $("appAll");
	 var arrNames = new Array();
	 var arrIdx=0;
	 var arrFileNames = new Array()	;
	 var arrFileIdx = 0;
	 
	 if(appAll.checked==true){		 
		 var inputs = elem.form.getElementsByTagName("div");
		 var subjectIdx = 1;
		 for(var i=0; i<inputs.length; i++){
			 if(inputs[i].className=="dtree" && subjectIdx==1){//find first subject's checkbox text value
				 var cb = inputs[i].getElementsByTagName("input");
				 for(var j=0;j<cb.length;j++){
					if(cb[j].type=="checkbox" && cb[j].id.indexOf("cb_")===0){
						if(cb[j].checked==true){
							 //get checkbox's parent node
							 var parentOfCheckBox = cb[j].parentNode;
							 var strCheckbox = parentOfCheckBox.getElementsByTagName("a");
							 for(var k=0; k<strCheckbox.length; k++){								 
								 if(strCheckbox[k].className=="node"){									 
									 //get all the checked values									 
									 arrNames[arrIdx++] = strCheckbox[k].innerHTML;
								 }
							 }
							 if(strCheckbox.length==0){ //at file level. if a file is selected...
								 var fileName = parentOfCheckBox.lastChild.nodeValue;								 
								 var grandparentOfCheckBox = parentOfCheckBox.parentNode;
								 var upperLevelCB = grandparentOfCheckBox.previousSibling;
								 var cbs = upperLevelCB.getElementsByTagName("a");
								 var upperLevelNodeName;
								 for(var k=0; k<cbs.length; k++){
									 if(cbs[k].className="node"){
										 upperLevelNodeName = cbs[k].innerHTML;
									 }
								 }
								 var splitFileName;
								 if(fileName){
									 splitFileName =fileName.split(upperLevelNodeName);
								 }
								 if(fileName!=splitFileName){
									 fileName = splitFileName[splitFileName.length-1];
								 }
								 arrFileNames[arrFileIdx++] = upperLevelNodeName + "/" + fileName;
							 }
						 }
					}
				 }
				 break;
			 }
		 }
		 for(var i=0;i<inputs.length;i++){
			 if(inputs[i].className=="dtree"){ //apply to all subjects and visits				
			 	//if(arrNames.length==0) return;
			 	var cb = inputs[i].getElementsByTagName("input");
			 	for(var j=0; j<cb.length; j++){
			 		if(cb[j].type=="checkbox" && cb[j].id.indexOf("cb_")===0){
			 			var pNode = cb[j].parentNode;
			 			var cbNode = pNode.getElementsByTagName("a");
			 			for(var k=0; k<cbNode.length; k++){
			 				if(cbNode[k].className=="node"){
			 					for(var l=0;l<arrNames.length;l++){			 						
			 						if(cbNode[k].innerHTML==arrNames[l]){
			 							cb[j].checked = true;
			 							//check all the sub-nodes
			 							var cbscb = cb[j].parentNode.nextSibling.getElementsByTagName("input");											
										for(var idx=0; idx<cbscb.length; idx++){
											if(cbscb[idx].type=="checkbox" && cbscb[idx].id.indexOf("cb_")===0){												
												if(cbscb[idx].checked==false) 
													fakeClick("click", cbscb[idx]);
											}
										}
			 							break;
			 						}
			 					}
			 				}
			 			}
			 			if(cbNode.length==0){ //at file level, check node whose name is contained in arrFileNames array
			 				var fileName = pNode.lastChild.nodeValue;
			 				var grandparentOfCheckBox = pNode.parentNode;
							var upperLevelCB = grandparentOfCheckBox.previousSibling;
							var cbs = upperLevelCB.getElementsByTagName("a");
							var upperLevelNodeName;
							for(var b=0; b<cbs.length; b++){
								if(cbs[b].className="node"){
									upperLevelNodeName = cbs[b].innerHTML;
								}
							}
							var splitFileName;
							if(fileName){
								splitFileName =fileName.split(upperLevelNodeName);
							}
							if(fileName!=splitFileName){
								fileName = splitFileName[splitFileName.length-1];
							}
							for(var a=0; a<arrFileNames.length; a++){
								if(arrFileNames[a]== upperLevelNodeName + "/" + fileName){
									cb[j].checked = true;
								}
							}
			 			}
			 		}
			 	}
			 	subjectIdx++;
			 }
		 }
	 }else{		 
		 var inputs = elem.form.getElementsByTagName("div");
		 var subjIdx = 1;
		 var visitIdx = 1;
		 for(var i=0;i<inputs.length;i++){			 
			 if(inputs[i].className=="dtree"){
				 if(subjIdx==1){
					 //clear settings of the first subject's visits except the first visit
					 var cb = inputs[i].getElementsByTagName("input");
					 for(var j=0; j<cb.length; j++){
						 if(cb[j].type=="checkbox" && cb[j].id.indexOf("cb_")==0){
							 var pNode = cb[j].parentNode;
							 var cbNode = pNode.getElementsByTagName("a");
							 for(var k=0; k<cbNode.length; k++){
								 if(cbNode[k].className=="node"){									 
									if(cbNode[k].innerHTML.indexOf("Visit")===0){
										 if(visitIdx++==1){
											 break;
										 }
										 else{
											cb[j].checked = false;
											var cbscb = cb[j].parentNode.nextSibling.getElementsByTagName("input");											
											for(var idx=0; idx<cbscb.length; idx++){
												if(cbscb[idx].type=="checkbox" && cbscb[idx].id.indexOf("cb_")===0){													
													if(cbscb[idx].checked)
														fakeClick("click",cbscb[idx]);
												}												
											}
										 }
									 }
								 }
							 }
						 }
					 }
				 }else{
					// clear settings of all subjects's visits except the first subject					
					var cb = getElementsByClassName("dtreeCB", "input", inputs[i]);
					 for(var j=0;j<cb.length;j++){						
						if(cb[j].checked) 
							fakeClick("click",cb[j]);
					 }
				 }
				 subjIdx++;				 
			 }
		 }
	 }
	 
 }

 
 function removeAll(elem){
	 elem.form.action.value = 'removeAll';
	 elem.form.submit();
	 return false;
 }
 
	function disableEnterKey(evt){
		var evt = (evt) ? evt : ((event) ? event : null);
		var node = (evt.target) ? evt.target : ((evt.srcElement) ? evt.srcElement : null);
		if ((evt.keyCode == 13) && (node.type=="text"))  {return false;} 
	}
 
</script>
<div class="error">
  <html:errors/>
</div>
<form method="post" action="<c:url value="/cart.do"/>">
 <input type="hidden" name="action" value=""></input>
<input type="hidden" name="results" value=""></input>
<input type="hidden" name="subjectID" value=""></input>

 
 <table border="0" cellspacing="0" bgcolor="#E9E9E9" class="tablelist">
 <tr bgcolor="#00659c">
   <td colspan="2" align="center">
     <span style="color:white; font-weight:bold; font-size:12pt;">Shopping Cart Contents </span>
   </td>
 </tr>
 
 <tr>
 	<td style="color:maroon; font-size: 10pt">
 		<br>Click <a class="filelink" href="../pages/mtaDoc/assessment/mtaAssessmentMeta.tgz">HERE</a> to Download Assessment Meta Data.<br><br>
 	</td>
 </tr>
 
 <tr><td colspan="2"><hr size="2pt" color="black"></td></tr>
 
 <tr>
   <td colspan="2">
     <div style="color:maroon; margin:0px; font-size: 10pt">Please provide a name for your download bundle and select the files you want to be included.</div>
   </td>
 </tr>
 
 <tr> 	
 	<td>
    	<span style="margin: 5px; font-size:9pt" >&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bundle Name:</span>
     	<html:text name="scForm" property="bundleName" onkeypress = "return disableEnterKey(event)" /> 
     	<span style="color:red;font-size:10pt; vertical-align:bottom;">*</span><br><br>
	</td> 	 	 	  
 </tr>
 
 <tr>
 	<td colspan="2">
 		<span style="color: maroon; font-size:10pt">Please select assessment data output format:</span>
 	</td>
 </tr>
 
 <tr>
 	<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 		<html:radio name="scForm" property="longFormat" value="long" disabled="false" styleClass="chk-box">
 			<span title="subjectID, visit, Variable Name, Variable Value" style="font-size:9pt">
 				Long format: Variables in rows
 			</span>
 		</html:radio> 		
 		<br>
 		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 		<html:radio name="scForm" property="longFormat" value="wide" disabled="false" styleClass="chk-box">
 			<span title="subjectID, visit, var1, var2, var3,….,varN" style="font-size:9pt">
 				Wide format: Variables in columns, visit number in column for repeated measurements
 			</span>
 		</html:radio>
 		<br>
 		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 		<html:radio name="scForm" property="longFormat" value="wider" disabled="false" styleClass="chk-box">
 			<span title="subjectID, var1_visit1, var1_visit2, var2_visit1, var2_visit2,…,varN_visit1, varN_visit2" style="font-size:9pt">
 				Wider format: Variables in columns with repeated measurements indicated by concatenating visit number to variable name.
 			</span>
 		</html:radio> 		 		
 		<br>
 		<br>
 	</td>
 </tr>
  
 <tr>
 	<td colspan="2">
 		<input type="submit" class="submit-button" value="Back to Search Results" onclick="go2(this,'Back')" style="font-size: 10pt"></input>
			&nbsp;
	 	<input type="submit" class="submit-button" value="Schedule Download" onclick="return go(this,'scheduleDownload')" style="font-size: 10pt"></input>
 	</td>
 </tr>
 
 <c:if test="${scForm.supportEmail}">
     <tr>
       <td colspan="2">
         <div style="border:1px dotted #2f4f4f; padding:0.5em; padding-right:1em;">
           <div style="padding-top:2px; padding-bottom:2px;">
            <html:checkbox name="scForm" property="notifyByEmail">Email Notification</html:checkbox>
           </div>
           <div style="padding-top:2px; padding-bottom:2px;">  
            <span style="font-weight:bold" >Notification email:</span>&nbsp;<html:text name="scForm" property="email" />
           </div> 
         </div>
     </td>
     </tr>
 </c:if>
 
 <tr>
  <td  colspan="2">
     <div id="size-div" style="margin:2px; padding:3px;">
     </div>
  </td>
 </tr>
 
 <c:if test="${scForm.allEmpty}" >
 <tr>
    <td colspan="2"> 
     <div id="warning-div" style="margin:2px; padding:3px;">
         <span style="color:red; font-weight: bold;">No matching image data has been found!</span> 
     </div>
    </td>
 </tr>
 </c:if>
 
 <!-- <tr><td colspan="2"><hr size="2pt" color="black"></td></tr> -->
 <tr><td colspan="2"><hr></td></tr>

 <c:if test="${!scForm.allEmpty}">
 	<tr>
 		<td align="left">
 		<span style="font-weight: normal; font-size:8pt; ">
			<c:if test="${scForm.allEmpty==false}"> 	
		 		<input type="checkbox" id="chkAll" name="all" value="ON" onclick="checkAll(this)">Select All	 			 		 	
		 	</c:if>	 	     
 		</span> 
 		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 		<span style="font-weight:normal; font-size:8pt; " title="Select the files of the first subject you want to download, then check this box to apply to all visits of all subjects">
			<c:if test="${scForm.allEmpty==false}"> 	
		 		<input type="checkbox" id="appAll" name="applAll" value="ON" onclick="applyAllSubjAndVisitFileLevel(this)">Apply to All Subjects and Visits	 				 		 	
		 	</c:if>
		 	<span id="help_25">
	 			<input type="image" src="images/questionmark2a.png" border=0	style="vertical-align: bottom; margin-bottom: 3px;"
								onclick="return helpHandler('help_25')"> 
			</span>	 	     
 		</span>
 		&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
 		<span style="font-weight:normal; font-size:8pt; " title="Select the files of the first subject you want to download, then check this box to apply to the same visits of all subjects">
			<c:if test="${scForm.allEmpty==false}"> 	
		 		<input type="checkbox" id="appSameVisit" name="applSameVisit" value="ON" onclick="applySameVisitAtFileNodeLevel(this)">Apply the Same Visit to All Subjects	 				 		 	
		 	</c:if>
		 	<span id="help_26">
	 			<input type="image" src="images/questionmark2a.png" border=0	style="vertical-align: bottom; margin-bottom: 3px;"
								onclick="return helpHandler('help_26')"> 
			</span>	 	     
 		</span>
 		</td>
 		<td align="right" width="70px"> 		 	
	 		<div title="Click to remove all subjects from shopping cart.">
	 			<button  onclick="removeAll(this);" class="result_header">Empty Cart<img alt="" src="images/cart_remove.png"></img></button>
	  		</div>
 		</td>
 	</tr>
 </c:if>
 
 <!-- <tr><td colspan="2"><div style="border-bottom: 1pt dotted #00659c; margin:0px;"></div></td></tr> -->
 <tr><td colspan="2"><hr style="border-bottom: 1px dotted #00659c; margin: 0px;border-top: 0px;border-left: 0px; border-right: 0px"></td></tr>
 
 <c:forEach var="item" items="${scForm.items}">
	<tr>
        <td>
        	<div id='item_<c:out value="${item.treeId}"/>' >
          		<script type="text/javascript">
             		<c:out value="${item.javascriptTree}" escapeXml="false"/>        
          		</script>
			</div>
		</td>
		<td width="50px" align="center">
			<span title="Click to remove this subject.">
    			<button onclick="return removeItem(this,'<c:out value="${item.subjectID}"/>');">
    				<img src="images/cart_remove.png" width="25" height="25" >
    			</button>
    		</span>
		</td>
	</tr>
	<!-- <tr><td colspan="2"><hr></td></tr> -->
	<tr><td colspan="2"><hr style="border-bottom: 1px dotted #00659c; margin: 0px;border-top: 0px;border-left: 0px; border-right: 0px"></td></tr>
 </c:forEach>
	
 <tr>
	<td colspan="2" align="right">
		<input type="submit" class="submit-button" value="Back to Search Results" onclick="go2(this,'Back')" style="font-size: 10pt"></input>
       		&nbsp;
       	<input type="submit" class="submit-button" value="Schedule Download" onclick="go(this,'scheduleDownload')" style="font-size: 10pt"></input>
	</td>
 </tr>
</table>
 
</form>
