<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>

<script language='javascript' src='popcalendar.js'></script>
<script language='javascript' src='validator.js'></script>
<script>
  function findElement(form, elemName) {
     var i;
     for(i=0; i < form.elements.length; ++i) {
        if ( form.elements[i].name == elemName)
           return form.elements[i];
     }
     return null;
  }

  function visitChanged(selectElem) {
     var selOption = selectElem.options[selectElem.selectedIndex];
     var form = selectElem.form;
     for(i=0; i < form.elements.length; ++i) {
        if ( form.elements[i].type == "hidden") {
          if ( form.elements[i].name == "selectedVisitID") {
              form.elements[i].value= selOption.value;
          }
          if ( form.elements[i].name == "action") {
             form.elements[i].value= "changeVisit";
          }
        }
     }
     form.submit();
  }

  function go(elem, actionValue) {
    elem.form.action.value =actionValue;
  }

  function validate(form) {
     var valMsg = "Please correct the following validation error(s):\n\n";
     var foundErrors = false;
     var nameElemMap = convertToElementMap(form);
     var visitDateElem = nameElemMap["currentVisit.timeStamp"];
     if ( validateDate( visitDateElem.value ) == false) {
       foundErrors = true;
       valMsg += "Visit date is not valid! It should be in 'mm/dd/yyyy' format!\n";
     }
     if (form.action.value == "Add Visit") {
      var segmentDateElem = nameElemMap["sfi[0].date"];
      if ( segmentDateElem != null) {
         if ( validateDate(segmentDateElem.value) == false) {
          foundErrors = true;
          valMsg += "Segment date is not valid! It should be in 'mm/dd/yyyy' format!\n";
         } else {
            if (!foundErrors && segmentDateElem.value != visitDateElem.value) {
               foundErrors = true;
                valMsg += "Both Visit Date and Segment Date must be the same!\n";
            }
         }
      }
      var segmentTimeElem =  nameElemMap["sfi[0].time"];
      if (segmentTimeElem.value.length > 0) {
          if ( validateTime(segmentTimeElem.value) == false) {
              foundErrors = true;
              valMsg += "Segment Time is not valid! It should be in 'hh:mm' format!\n";
          }
      }
     } // Add Visit
     if (foundErrors) {
       alert(valMsg);
       return false;
     }
     return true;
  }

</script>

<div class="error">
  <html:errors/>
</div>
<br>
<br>

<center>
<table border="0" cellspacing="0" cellpadding="2" bgcolor="#00659" width="80%">

<tr>
 <td>
<table border="0" cellspacing="0" width="100%" bgcolor="white">

<html:form action="/subjectman" onsubmit="return validate(this)">
  <html:hidden name="svmForm" property="selectedVisitID"/>
  <html:hidden name="svmForm" property="selectedSegmentID"/>
  <input type="hidden" name="action" value=""/>


 <%-- visit section --%>
 <tr bgcolor="#d3d3d3">
    <td colspan="2" class="header">Visit Management</td>
 </tr>
  <tr>
   <td> <b>Subject ID:</b>&nbsp;<bean:write name="svmForm" property="subject.subjectID"/> </td>
   <td> <b>Experiment:</b>&nbsp; <bean:write name="svmForm" property="currentVisit.experiment"/> </td>
  </tr>

  <logic:equal name="svmForm" property="currentAction" value="edit_visit">
   <tr>
      <td colspan="2"><b>Visit ID:</b>&nbsp;<bean:write name="svmForm"
                     property="currentVisit.visit.componentID"/></td>
   </tr>
 </logic:equal>

  <tr>
   <td colspan="2">
     <table border="0" cellspacing="0" cellpadding="2" width="100%">
      <tr>
      <bean:define id="visitDates" name="svmForm" property="visitDates"
           type="java.util.Collection"/>
      <td colspan="4">  
      <table border="0"  cellspacing="0" cellpadding="1" width="100%">  
       <tr>
       <td><b>Visit Date:</b></td>
         <td nowrap> <html:text name="svmForm" property="currentVisit.timeStamp"/>
        <input type=button onclick='popUpCalendar(this, findElement(this.form,"currentVisit.timeStamp"), "mm/dd/yyyy")' value='...' style='font-size:11px'>
      </td>

      <logic:equal name="svmForm" property="currentAction" value="add_visit">
         <bean:define id="visitTypes" name="svmForm" property="currentVisit.visitTypes"
           type="java.util.Collection"/>
         <td><b>Visit Type:</b></td>
         <td> <html:select name="svmForm" property="currentVisit.visitType">
                  <html:options collection="visitTypes" property="value"  labelProperty="label"/>
              </html:select>
         </td>
      </logic:equal>
      <logic:equal name="svmForm" property="currentAction" value="edit_visit">
         <td><b>Visit Type:</b></td>
         <td> <bean:write name="svmForm" property="currentVisit.visitType"/> </td>
      </logic:equal>
      </tr>
      <tr>
        <td><b>Name:</b></td>
        <td> <html:text name="svmForm" property="currentVisit.visit.name"/> </td>
        <td>&nbsp; </td>
        <td>&nbsp; </td>	
      </tr>
      </table>        
      </td>

         <td><b>Description:</b></td>
         <td> <html:textarea name="svmForm" property="currentVisit.visit.description" cols="40" rows="5"/></td>
      </tr>
      <tr><td colspan="6">&nbsp;</td></tr>
    </table>
   </td>
  </tr>

 <logic:equal name="svmForm" property="currentAction" value="add_visit">
 
    <tr  bgcolor="#d3d3d3" >
               <td colspan="2" class="header">Segments</td>
     </tr>
 <logic:iterate id="sfi" name="svmForm" property="currentVisit.segmentFormInfos" indexId="idx">
   <tr>
    <td colspan="2">
        <table border="0" cellspacing="0" cellpadding="0" width="100%">
           <tr>
             <logic:equal name="svmForm" property="currentAction" value="add_visit">
                <td colspan="6">&nbsp;</td>
             </logic:equal>
              <logic:equal name="svmForm" property="currentAction" value="edit_visit">
              <td colspan="6"><b>Segment ID:</b>&nbsp;
		     <bean:write name="sfi" property="visitSegment.segmentID" />
               </td>
             </logic:equal>
           </tr>
           <tr>
               <td><b>Date:</b></td>
              <td nowrap> <html:text name="sfi" property="date" indexed="true"/>
                 <input type=button
                   onclick='popUpCalendar(this, findElement(this.form,"<%= "sfi[" + idx +"].date"%>"),
                      "mm/dd/yyyy")' value='...' style='font-size:11px'>

              </td>
               <td><b>Time (hh:mm):</b></td>
               <td> <html:text name="sfi" property="time" indexed="true" /></td>
               <td> &nbsp; </td>
               <td> &nbsp; </td>
           </tr>
           <tr>
               <td><b>Name:</b></td>
               <td> <html:text name="sfi" property="name" indexed="true" /> </td>               
               <bean:define id="protocols" name="sfi" property="protocols"
                   type="java.util.Collection"/>
               <td><b>Protocol:</b></td>
               <td> <html:select name="sfi" property="protocolValue" indexed="true">
                       <html:options collection="protocols" property="value" labelProperty="label"/>
                    </html:select>
               </td>
               <td> &nbsp; </td>
               <td> &nbsp; </td>
           </tr>
           <tr>
             <td><b>Description:</b></td>
              <td colspan="4">
                 <html:textarea name="sfi" property="visitSegment.description" cols="60" rows="3" indexed="true"/>
              </td>
              <td>&nbsp;</td>
           </tr>
        </table>
        <!-- segment table -->
     </td>
   </tr>

 </logic:iterate>
</logic:equal>
 <tr>
    <td colspan="2" align="right">
        <logic:equal name="svmForm" property="currentAction" value="add_visit">
           <html:submit styleClass="submit-button" onclick="go(this,'Add Visit')">Add</html:submit>
         </logic:equal>
	 <logic:equal name="svmForm" property="currentAction" value="edit_visit">
	    <html:submit styleClass="submit-button"  onclick="go(this,'Update Visit')">Update</html:submit>
         </logic:equal>
   </td>
 </tr>

</html:form>


</table>
</td>
</tr>
</table>
