var bal = new Object();

bal.AjaxHelpSystem=function(url, options) {
  this.url = url;
  this.options = options;
  this.helpMap = new utils.Hash();
  this.ajaxHelper = new net.ContentLoader(this, url, "POST",
      options.requestParameters || [] );
  this.ajaxHelper.sendRequest(); 
}

bal.AjaxHelpSystem.prototype.ajaxUpdate=function(request) {
  var xmlDoc = request.responseXML;
  var docRoot = xmlDoc.getElementsByTagName('help-contents')[0];
  var helpMsgNodes = docRoot.getElementsByTagName('help');
  for(var i=0; i < helpMsgNodes.length; ++i) {
      var elChild = helpMsgNodes[i];
      var attrs = elChild.attributes;
      var msgId = attrs.getNamedItem("id").value;
      var content = elChild.firstChild.nodeValue; 
      this.helpMap.setItem(msgId, content);
   }
}

bal.AjaxHelpSystem.prototype.handleError=function(request) {
  if ( this.options && this.options.errorHandler) {
     this.options.errorHandler(request);
  }
}

bal.AjaxHelpSystem.prototype.findHelpMessage=function(msgId) {
   return this.helpMap.getItem(msgId);
}

/* a popup window class to display static information */
bal.InfoViewer=function(content, divElem) {
   styling.removeAllChildren(divElem);
   this.content = content;
   this.mainDiv = divElem;
   this.mainDiv.viewer = this;
   var table = document.createElement("table");
   this.tbod = document.createElement("tbody");
   table.appendChild(this.tbod);

   this.mainDiv.appendChild(table);

   var rowTr = document.createElement("tr");
   rowTr.className='infoViewRow';
   this.valTd = document.createElement("td");
   this.valTd.className = 'infoViewValue';
   this.valTd.viewer = this;
   rowTr.appendChild(this.valTd);
   if ( content.length > 40) {
       table.style.width='300px';
   }
   var valDiv = this.renderContent(content);
   this.valTd.appendChild(valDiv);

   this.tbod.appendChild(rowTr);
}

bal.InfoViewer.prototype.renderContent=function(content) {
  var contentDiv = document.createElement("div");
  contentDiv.className='infoViewInnerBorder';
  contentDiv.innerHTML=content;
  return contentDiv;
}

bal.InfoViewer.prototype.hide=function() {
  this.mainDiv.style.display='none';
}

bal.InfoViewer.showPopup=function(launcherDiv, content, parentDiv) {
  if (! parentDiv ) {
     parentDiv = launcherDiv;
  }
  var popupViewer = launcherDiv.popupViewer;
  var popupDiv = (popupViewer) ? popupViewer.mainDiv : null;
  if (!popupViewer) {
     popupDiv = document.createElement("div");
     popupDiv.className='infoViewBorder';
     var parentDomElem = parentDiv.parentNode;
     parentDomElem.appendChild(popupDiv);
     popupViewer = new bal.InfoViewer(content, popupDiv);
     popupViewer.parentObjViewer=parentDiv.viewer;
     launcherDiv.popupViewer = popupViewer;

     var closeButton = document.createElement("div");
     closeButton.className = 'objViewButton right';
     closeButton.viewer = popupViewer;
     closeButton.onclick=bal.InfoViewer.hide;
     var closeText = document.createTextNode("x");
     //  closeButton.appendChild(closeText);
     closeButton.innerHTML='<a href="#" class="objViewButton">x</a>';
     styling.insertAtTop(popupDiv, closeButton);
  }
  popupDiv.style.display='block';
  //var lX = parentDiv.offsetLeft;
  var lW = xWidth(parentDiv);
  //var lY = parentDiv.offsetTop;
  var lX=0;
  var lY=0;
  var obj = parentDiv;
  do{
	  lX += obj.offsetLeft;
	  lY += obj.offsetTop;
  } while (obj = obj.offsetParent);
  var pX = lX + lW - 4;
  var pY = lY + 4;
  xMoveTo( popupDiv, pX, pY);
  return popupViewer;
}
bal.InfoViewer.hide=function(e) {
  var viewer = this.viewer;
  if (viewer) {
    viewer.hide();
  }
  return false;
}

/*
 * a popup object
 */

 /* a popup window class to display static information */
bal.Popup=function(content, divElem) {
   styling.removeAllChildren(divElem);
   this.content = content;
   this.mainDiv = divElem;
   this.mainDiv.viewer = this;
   var table = document.createElement("table");
   this.tbod = document.createElement("tbody");
   table.appendChild(this.tbod);

   this.mainDiv.appendChild(table);

   var rowTr = document.createElement("tr");
   rowTr.className='infoViewRow';
   this.valTd = document.createElement("td");
   this.valTd.className = 'infoViewValue';
   this.valTd.viewer = this;
   rowTr.appendChild(this.valTd);
   if ( content.length > 40) {
       table.style.width='300px';
   }
   var valDiv = this.renderContent(content);
   this.valTd.appendChild(valDiv);

   this.tbod.appendChild(rowTr);
}

bal.Popup.prototype.renderContent=function(content) {
  var contentDiv = document.createElement("div");
  contentDiv.className='infoViewInnerBorder';
  contentDiv.innerHTML=content;
  return contentDiv;
}

   bal.Popup.prototype.hide=function() {
      this.mainDiv.style.display='none';
   }

   bal.Popup.showPopup=function(mx, my, launcherDiv, content, parentDiv) {
      if (! parentDiv ) {
         parentDiv = launcherDiv;
      }
      var popupViewer = launcherDiv.popupViewer;
      popupDiv = document.createElement("div");
      popupDiv.className='infoViewBorder';

      var popupDiv = (popupViewer) ? popupViewer.mainDiv : null;
      if ( !popupDiv) {
         popupDiv = document.createElement("div");
         popupDiv.className='infoViewBorder';
         var parentDomElem = parentDiv.parentNode;
         parentDomElem.appendChild(popupDiv);
      }
   
      popupViewer = new bal.Popup(content, popupDiv);
      popupViewer.parentObjViewer=parentDiv.viewer;
      launcherDiv.popupViewer = popupViewer;
  
      var closeButton = document.createElement("div");
      closeButton.className = 'objViewButton right';
      closeButton.viewer = popupViewer;
      closeButton.onclick=bal.Popup.hide;
      var closeText = document.createTextNode("x");
      //  closeButton.appendChild(closeText);
      closeButton.innerHTML='<a href="#" class="objViewButton">x</a>';
      styling.insertAtTop(popupDiv, closeButton);
  
      popupDiv.style.display='block';
      xMoveTo( popupDiv, mx, my);
      return popupViewer;
   }

   bal.Popup.hide=function(e) {
      var viewer = this.viewer;
      if (viewer) {
         viewer.hide();
      }
      return false;
   }

 