package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Brainsegmentdata;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class BrainsegmentdataDAO implements
		clinical.server.dao.BrainsegmentdataDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public BrainsegmentdataDAO() {
	}

	public void insert(Connection con, Brainsegmentdata bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_BRAINSEGMENTDATA ");
			buf
					.append(" (DATAID,TABLEID,SEGMENTID,COMPONENTID,NC_EXPERIMENTID,SUBJECTID,BRAINREGIONNAME,LATERALITY,MEASUREMENT,MEASUREMENTTYPE,UNIT,OWNER,MODTIME,MODUSER,ONTOLOGYSOURCE,CONCEPTID,EXTENSIONNAME,DATAURI,ISRAW,MEASUREMENTSYSTEM,UNIQUEID,ISBAD) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 22; ++i) {
				buf.append('?');
				if (i < 21)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getDataid(),
					Types.NUMERIC);
			ps.setObject(2, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(3, (java.math.BigDecimal) bean.getSegmentid(),
					Types.NUMERIC);
			ps.setObject(4, (java.math.BigDecimal) bean.getComponentid(),
					Types.NUMERIC);
			ps.setObject(5, (java.math.BigDecimal) bean.getNcExperimentid(),
					Types.NUMERIC);
			ps.setObject(6, (String) bean.getSubjectid(), Types.VARCHAR);
			ps.setObject(7, (String) bean.getBrainregionname(), Types.VARCHAR);
			ps.setObject(8, (String) bean.getLaterality(), Types.VARCHAR);
			ps.setObject(9, (Float) bean.getMeasurement(), Types.FLOAT);
			ps.setObject(10, (String) bean.getMeasurementtype(), Types.VARCHAR);
			ps.setObject(11, (String) bean.getUnit(), Types.VARCHAR);
			ps.setObject(12, (java.math.BigDecimal) bean.getOwner(),
					Types.NUMERIC);
			ps.setTimestamp(13, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(14, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(15, (String) bean.getOntologysource(), Types.VARCHAR);
			ps.setObject(16, (String) bean.getConceptid(), Types.VARCHAR);
			ps.setObject(17, (String) bean.getExtensionname(), Types.VARCHAR);
			ps.setObject(18, (String) bean.getDatauri(), Types.VARCHAR);
			ps.setObject(19, boolean2Number((Boolean) bean.getIsraw()),
					Types.NUMERIC);
			ps.setObject(20, (String) bean.getMeasurementsystem(),
					Types.VARCHAR);
			ps.setObject(21, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(22, boolean2Number((Boolean) bean.getIsbad()),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Brainsegmentdata bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("DATAID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("SEGMENTID");
		buf.append(',');
		buf.append("COMPONENTID");
		buf.append(',');
		buf.append("NC_EXPERIMENTID");
		buf.append(',');
		buf.append("SUBJECTID");
		buf.append(',');
		buf.append("BRAINREGIONNAME");
		buf.append(',');
		buf.append("LATERALITY");
		buf.append(',');
		buf.append("MEASUREMENT");
		buf.append(',');
		buf.append("MEASUREMENTTYPE");
		buf.append(',');
		buf.append("UNIT");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("ONTOLOGYSOURCE");
		buf.append(',');
		buf.append("CONCEPTID");
		buf.append(',');
		buf.append("EXTENSIONNAME");
		buf.append(',');
		buf.append("DATAURI");
		buf.append(',');
		buf.append("ISRAW");
		buf.append(',');
		buf.append("MEASUREMENTSYSTEM");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("ISBAD");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Brainsegmentdata bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getDataid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DATAID=?");
			qi.values.add(bean.getDataid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getSegmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SEGMENTID=?");
			qi.values.add(bean.getSegmentid());
			valueSet = true;
		}
		if (bean.getComponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COMPONENTID=?");
			qi.values.add(bean.getComponentid());
			valueSet = true;
		}
		if (bean.getNcExperimentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NC_EXPERIMENTID=?");
			qi.values.add(bean.getNcExperimentid());
			valueSet = true;
		}
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SUBJECTID=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getBrainregionname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("BRAINREGIONNAME=?");
			qi.values.add(bean.getBrainregionname());
			valueSet = true;
		}
		if (bean.getLaterality() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("LATERALITY=?");
			qi.values.add(bean.getLaterality());
			valueSet = true;
		}
		if (bean.getMeasurement() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MEASUREMENT=?");
			qi.values.add(bean.getMeasurement());
			valueSet = true;
		}
		if (bean.getMeasurementtype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MEASUREMENTTYPE=?");
			qi.values.add(bean.getMeasurementtype());
			valueSet = true;
		}
		if (bean.getUnit() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIT=?");
			qi.values.add(bean.getUnit());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getOntologysource() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ONTOLOGYSOURCE=?");
			qi.values.add(bean.getOntologysource());
			valueSet = true;
		}
		if (bean.getConceptid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CONCEPTID=?");
			qi.values.add(bean.getConceptid());
			valueSet = true;
		}
		if (bean.getExtensionname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("EXTENSIONNAME=?");
			qi.values.add(bean.getExtensionname());
			valueSet = true;
		}
		if (bean.getDatauri() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DATAURI=?");
			qi.values.add(bean.getDatauri());
			valueSet = true;
		}
		if (bean.getIsraw() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISRAW=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsraw()));
			valueSet = true;
		}
		if (bean.getMeasurementsystem() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MEASUREMENTSYSTEM=?");
			qi.values.add(bean.getMeasurementsystem());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getIsbad() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISBAD=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsbad()));
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Brainsegmentdata bean,
			Brainsegmentdata criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_BRAINSEGMENTDATA SET ");

		if (bean.getDataid() != null || bean.isNull("dataid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DATAID=? ");
			uqi.setValues.add(bean.getDataid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("dataid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getSegmentid() != null || bean.isNull("segmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SEGMENTID=? ");
			uqi.setValues.add(bean.getSegmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("segmentid"), uqi);
			valueSet = true;
		}
		if (bean.getComponentid() != null || bean.isNull("componentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("COMPONENTID=? ");
			uqi.setValues.add(bean.getComponentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("componentid"), uqi);
			valueSet = true;
		}
		if (bean.getNcExperimentid() != null || bean.isNull("ncExperimentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NC_EXPERIMENTID=? ");
			uqi.setValues.add(bean.getNcExperimentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ncExperimentid"), uqi);
			valueSet = true;
		}
		if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SUBJECTID=? ");
			uqi.setValues.add(bean.getSubjectid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("subjectid"), uqi);
			valueSet = true;
		}
		if (bean.getBrainregionname() != null || bean.isNull("brainregionname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("BRAINREGIONNAME=? ");
			uqi.setValues.add(bean.getBrainregionname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("brainregionname"), uqi);
			valueSet = true;
		}
		if (bean.getLaterality() != null || bean.isNull("laterality")) {
			if (valueSet)
				buf.append(", ");
			buf.append("LATERALITY=? ");
			uqi.setValues.add(bean.getLaterality());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("laterality"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurement() != null || bean.isNull("measurement")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MEASUREMENT=? ");
			uqi.setValues.add(bean.getMeasurement());
			uqi.sqlTypes.add(new Integer(Types.FLOAT));
			prepareNullSetListValue(bean.isNull("measurement"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurementtype() != null || bean.isNull("measurementtype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MEASUREMENTTYPE=? ");
			uqi.setValues.add(bean.getMeasurementtype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("measurementtype"), uqi);
			valueSet = true;
		}
		if (bean.getUnit() != null || bean.isNull("unit")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIT=? ");
			uqi.setValues.add(bean.getUnit());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("unit"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getOntologysource() != null || bean.isNull("ontologysource")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ONTOLOGYSOURCE=? ");
			uqi.setValues.add(bean.getOntologysource());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("ontologysource"), uqi);
			valueSet = true;
		}
		if (bean.getConceptid() != null || bean.isNull("conceptid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CONCEPTID=? ");
			uqi.setValues.add(bean.getConceptid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("conceptid"), uqi);
			valueSet = true;
		}
		if (bean.getExtensionname() != null || bean.isNull("extensionname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("EXTENSIONNAME=? ");
			uqi.setValues.add(bean.getExtensionname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("extensionname"), uqi);
			valueSet = true;
		}
		if (bean.getDatauri() != null || bean.isNull("datauri")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DATAURI=? ");
			uqi.setValues.add(bean.getDatauri());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("datauri"), uqi);
			valueSet = true;
		}
		if (bean.getIsraw() != null || bean.isNull("israw")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISRAW=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsraw()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("israw"), uqi);
			valueSet = true;
		}
		if (bean.getMeasurementsystem() != null
				|| bean.isNull("measurementsystem")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MEASUREMENTSYSTEM=? ");
			uqi.setValues.add(bean.getMeasurementsystem());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("measurementsystem"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getIsbad() != null || bean.isNull("isbad")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISBAD=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsbad()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isbad"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true)
				: new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Brainsegmentdata createObject(ResultSet rs) throws SQLException {
		Brainsegmentdata obj = new Brainsegmentdata();
		obj.setDataid((java.math.BigDecimal) rs.getObject(1));
		obj.setTableid((java.math.BigDecimal) rs.getObject(2));
		obj.setSegmentid((java.math.BigDecimal) rs.getObject(3));
		obj.setComponentid((java.math.BigDecimal) rs.getObject(4));
		obj.setNcExperimentid((java.math.BigDecimal) rs.getObject(5));
		obj.setSubjectid((String) rs.getObject(6));
		obj.setBrainregionname((String) rs.getObject(7));
		obj.setLaterality((String) rs.getObject(8));
		obj.setMeasurement((Float) rs.getObject(9));
		obj.setMeasurementtype((String) rs.getObject(10));
		obj.setUnit((String) rs.getObject(11));
		obj.setOwner((java.math.BigDecimal) rs.getObject(12));
		if (rs.getTimestamp(13) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(13).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(14));
		obj.setOntologysource((String) rs.getObject(15));
		obj.setConceptid((String) rs.getObject(16));
		obj.setExtensionname((String) rs.getObject(17));
		obj.setDatauri((String) rs.getObject(18));
		obj.setIsraw(convert2Boolean(rs.getObject(19)));
		obj.setMeasurementsystem((String) rs.getObject(20));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(21));
		obj.setIsbad(convert2Boolean(rs.getObject(22)));
		return obj;
	}

	public List<Brainsegmentdata> find(Connection con, Brainsegmentdata criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Brainsegmentdata> results = new LinkedList<Brainsegmentdata>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_BRAINSEGMENTDATA ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Brainsegmentdata item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Brainsegmentdata bean,
			Brainsegmentdata criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Brainsegmentdata criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_BRAINSEGMENTDATA ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	public List<Brainsegmentdata> findDistinctBrainRegions(Connection con)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Brainsegmentdata> results = new LinkedList<Brainsegmentdata>();
		StringBuffer buf = new StringBuffer(200);

		buf
				.append("SELECT DISTINCT BRAINREGIONNAME, LATERALITY, MEASUREMENTTYPE, UNIT FROM NC_BRAINSEGMENTDATA ");
		try {
			ps = con.prepareStatement(buf.toString());
			rs = ps.executeQuery();
			while (rs.next()) {
				Brainsegmentdata obj = new Brainsegmentdata();
				obj.setBrainregionname((String) rs.getObject(1));
				obj.setLaterality((String) rs.getObject(2));
				obj.setMeasurementtype((String) rs.getObject(3));
				obj.setUnit((String) rs.getObject(4));

				results.add(obj);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	/* +++ */
}// ;
