














package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.math.BigDecimal;

import clinical.web.exception.ValidationException;
import clinical.server.vo.Esignature;
import clinical.web.DBUtils;
import clinical.server.utils.*;

public class EsignatureDAO implements clinical.server.dao.EsignatureDAO {
/*+++    */
  // Enter your declarations here
/*+++    */

public EsignatureDAO () {}

public void insert(Connection con, Esignature bean) throws Exception
{
   PreparedStatement ps = null;
   StringBuffer buf = new StringBuffer(200);

   if ( bean == null)
       return;
   try {
     buf.append("INSERT INTO nc_esignature VALUES ");
     buf.append('(');
for(int i = 0; i < 5; ++i) {
  buf.append('?');
  if ( i <  4)
     buf.append(',');
}
buf.append(")");
     ps = con.prepareStatement( buf.toString() );
     ps.clearParameters();
                         ps.setObject(1,  bean.getUniqueid(), Types.NUMERIC);
                     
                         ps.setObject(2,  bean.getAssessImageId(), Types.NUMERIC);
                     
                         ps.setObject(3,  bean.getUsername(), Types.VARCHAR);
                     
                               ps.setObject(4, bean.getDateSigned() == null ? (java.sql.Timestamp) null : new java.sql.Timestamp(  bean.getDateSigned().getTime() ) );
                        
                         ps.setObject(5,  bean.getSignatureType(), Types.VARCHAR);
                     
          ps.executeUpdate();

   } finally {
      DBUtils.close(ps);
   }
}


protected String prepareColList(Esignature bean) {
  StringBuffer buf = new StringBuffer(200);
    buf.append("uniqueid" );
   buf.append(',');     buf.append("assess_image_id" );
   buf.append(',');     buf.append("username" );
   buf.append(',');     buf.append("date_signed" );
   buf.append(',');     buf.append("signature_type" );
      buf.append(' ');
  return buf.toString();
}

protected QueryInfo prepareWhereClause(Esignature bean) {
  StringBuffer buf = new StringBuffer(200);
    QueryInfo qi = new QueryInfo();
  boolean valueSet = false;
  buf.append("WHERE ");
    if (bean.getUniqueid() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("uniqueid=?");
                   qi.values.add(bean.getUniqueid());
                 valueSet = true;
  }
    if (bean.getAssessImageId() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("assess_image_id=?");
                   qi.values.add(bean.getAssessImageId());
                 valueSet = true;
  }
    if (bean.getUsername() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("username=?");
                   qi.values.add(bean.getUsername());
                 valueSet = true;
  }
    if (bean.getDateSigned() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("date_signed=?");
                   qi.values.add( new java.sql.Date( bean.getDateSigned().getTime() ));
                 valueSet = true;
  }
    if (bean.getSignatureType() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("signature_type=?");
                   qi.values.add(bean.getSignatureType());
                 valueSet = true;
  }
    qi.whereClause = (!valueSet) ? "" : buf.toString();
  return qi;
}

protected UpdateQueryInfo prepareUpdateQuery(Esignature bean,Esignature criteria ) throws ValidationException
{
  StringBuffer buf = new StringBuffer(200);
    UpdateQueryInfo uqi = new UpdateQueryInfo();
  boolean valueSet = false;
  buf.append("UPDATE nc_esignature SET ");
    if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
    if (valueSet)  buf.append(", ");
    buf.append("uniqueid=? ");
                    uqi.setValues.add(bean.getUniqueid()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("uniqueid"), uqi);
     valueSet = true;
  }
    if (bean.getAssessImageId() != null || bean.isNull("assessImageId")) {
    if (valueSet)  buf.append(", ");
    buf.append("assess_image_id=? ");
                    uqi.setValues.add(bean.getAssessImageId()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("assessImageId"), uqi);
     valueSet = true;
  }
    if (bean.getUsername() != null || bean.isNull("username")) {
    if (valueSet)  buf.append(", ");
    buf.append("username=? ");
                    uqi.setValues.add(bean.getUsername()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("username"), uqi);
     valueSet = true;
  }
    if (bean.getDateSigned() != null || bean.isNull("dateSigned")) {
    if (valueSet)  buf.append(", ");
    buf.append("date_signed=? ");
                  uqi.setValues.add( new java.sql.Timestamp( bean.getDateSigned().getTime() ) );
                 uqi.sqlTypes.add(new Integer( Types.DATE ) );
     prepareNullSetListValue( bean.isNull("dateSigned"), uqi);
     valueSet = true;
  }
    if (bean.getSignatureType() != null || bean.isNull("signatureType")) {
    if (valueSet)  buf.append(", ");
    buf.append("signature_type=? ");
                    uqi.setValues.add(bean.getSignatureType()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("signatureType"), uqi);
     valueSet = true;
  }
    if (!valueSet)
    throw new ValidationException("At least one field needs to be set for update!");

  uqi.query = buf.toString();
  QueryInfo qi = prepareWhereClause(criteria);
  uqi.query += qi.whereClause;
  uqi.whereValues = qi.values;
  return uqi;
}

protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
     if ( wasNull ) {
       uqi.nullSetList.add( new Boolean(true) );
     } else {
       uqi.nullSetList.add( new Boolean(false) );
     }
}


public Esignature createObject(ResultSet rs) throws SQLException {
   Esignature obj = new Esignature();
                  obj.setUniqueid( ( rs.getObject(1) != null) ?
              new java.math.BigDecimal( rs.getObject(1).toString() ) : null );
                        obj.setAssessImageId( ( rs.getObject(2) != null) ?
              new java.math.BigDecimal( rs.getObject(2).toString() ) : null );
                            obj.setUsername( (String ) rs.getObject(3) );
                                                     obj.setDateSigned( ( rs.getObject(4) != null) ?
              new java.util.Date( ((java.sql.Date) rs.getObject(4)).getTime() ) : null );
                                               obj.setSignatureType( (String ) rs.getObject(5) );
                   return obj;
}

public List<Esignature> find(Connection con, Esignature criteria) throws Exception
{

   PreparedStatement ps = null;
   ResultSet rs = null;
   List<Esignature> results = new LinkedList<Esignature>();
   StringBuffer buf = new StringBuffer(200);

   if ( criteria  == null)
       return null;
   buf.append("SELECT ");
   buf.append( prepareColList( criteria) );
   buf.append(" FROM nc_esignature ");
   QueryInfo qi = prepareWhereClause(criteria);
   buf.append( qi.whereClause );
   try {
      ps = con.prepareStatement( buf.toString() );
      ps.clearParameters();
      int i = 0;
      for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
         ps.setObject(++i, it.next() );
      }
      rs = ps.executeQuery();
      while(rs.next() ) {
          Esignature item = createObject(rs);
          results.add(item);
      }
   } finally {
      DBUtils.close(ps, rs);	
   }
   return results;
}

public void update(Connection con, Esignature bean, Esignature criteria) throws Exception
{
   PreparedStatement ps = null;

   if ( bean  == null)
       return;

   UpdateQueryInfo uqi =  prepareUpdateQuery(bean, criteria);
   try {
       ps = con.prepareStatement( uqi.query );
       ps.clearParameters();
       int i = 0;
       Iterator<Integer> it2 = uqi.sqlTypes.iterator();
       Iterator<Boolean> it3 = uqi.nullSetList.iterator();
       for(Iterator<?> it = uqi.setValues.iterator(); it.hasNext(); ) {
          Object value = it.next();
          Integer sqlType = (Integer) it2.next();
          boolean nullSet = ((Boolean) it3.next()).booleanValue();
          if ( nullSet) {
            ps.setNull(++i, sqlType.intValue() );
          } else {
             ps.setObject(++i, value);
          }
       }
       // for where part
       for(Iterator<?> it = uqi.whereValues.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();
   } finally {
      DBUtils.close(ps);	      
   }
}

public void delete(Connection con, Esignature criteria) throws Exception
{
    PreparedStatement ps = null;
    StringBuffer buf = new StringBuffer(200);
    buf.append("DELETE FROM nc_esignature ");

    QueryInfo qi = prepareWhereClause(criteria);
    buf.append( qi.whereClause );
    try {
       ps = con.prepareStatement( buf.toString() );
       ps.clearParameters();
       int i = 0;
       for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();

    } finally {
      DBUtils.close(ps);	
    }
}

  public static class QueryInfo {
    String whereClause;
    List<? super Object> values = new LinkedList<Object>();
    public QueryInfo() {}
    public QueryInfo(String whereClause) {
       this.whereClause = whereClause;
    }
  }

  public static class UpdateQueryInfo {
     String query;
     List<? super Object> setValues = new LinkedList<Object>();
	 List<Integer> sqlTypes = new LinkedList<Integer>();
	 List<Boolean> nullSetList = new LinkedList<Boolean>();
	 List<? super Object> whereValues = new LinkedList<Object>();
	 
     public UpdateQueryInfo() {}
  }

/*+++    */
  // Enter your code here
/*+++    */
}//;
