














package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.math.BigDecimal;

import clinical.web.exception.ValidationException;
import clinical.server.vo.Imageprotocolterms;
import clinical.web.DBUtils;
import clinical.server.utils.*;

public class ImageprotocoltermsDAO implements clinical.server.dao.ImageprotocoltermsDAO {
/*+++    */
  // Enter your declarations here
/*+++    */

public ImageprotocoltermsDAO () {}

public void insert(Connection con, Imageprotocolterms bean) throws Exception
{
   PreparedStatement ps = null;
   StringBuffer buf = new StringBuffer(200);

   if ( bean == null)
       return;
   try {
     buf.append("INSERT INTO nc_imageprotocolterms VALUES ");
     buf.append('(');
for(int i = 0; i < 4; ++i) {
  buf.append('?');
  if ( i <  3)
     buf.append(',');
}
buf.append(")");
     ps = con.prepareStatement( buf.toString() );
     ps.clearParameters();
                         ps.setObject(1,  bean.getId(), Types.NUMERIC);
                     
                         ps.setObject(2,  bean.getNcImageprotocolsId(), Types.NUMERIC);
                     
                         ps.setObject(3,  bean.getConceptId(), Types.VARCHAR);
                     
                         ps.setObject(4,  bean.getConceptSource(), Types.VARCHAR);
                     
          ps.executeUpdate();

   } finally {
      DBUtils.close(ps);
   }
}


protected String prepareColList(Imageprotocolterms bean) {
  StringBuffer buf = new StringBuffer(200);
    buf.append("id" );
   buf.append(',');     buf.append("nc_imageprotocols_id" );
   buf.append(',');     buf.append("concept_id" );
   buf.append(',');     buf.append("concept_source" );
      buf.append(' ');
  return buf.toString();
}

protected QueryInfo prepareWhereClause(Imageprotocolterms bean) {
  StringBuffer buf = new StringBuffer(200);
    QueryInfo qi = new QueryInfo();
  boolean valueSet = false;
  buf.append("WHERE ");
    if (bean.getId() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("id=?");
                   qi.values.add(bean.getId());
                 valueSet = true;
  }
    if (bean.getNcImageprotocolsId() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("nc_imageprotocols_id=?");
                   qi.values.add(bean.getNcImageprotocolsId());
                 valueSet = true;
  }
    if (bean.getConceptId() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("concept_id=?");
                   qi.values.add(bean.getConceptId());
                 valueSet = true;
  }
    if (bean.getConceptSource() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("concept_source=?");
                   qi.values.add(bean.getConceptSource());
                 valueSet = true;
  }
    qi.whereClause = (!valueSet) ? "" : buf.toString();
  return qi;
}

protected UpdateQueryInfo prepareUpdateQuery(Imageprotocolterms bean,Imageprotocolterms criteria ) throws ValidationException
{
  StringBuffer buf = new StringBuffer(200);
    UpdateQueryInfo uqi = new UpdateQueryInfo();
  boolean valueSet = false;
  buf.append("UPDATE nc_imageprotocolterms SET ");
    if (bean.getId() != null || bean.isNull("id")) {
    if (valueSet)  buf.append(", ");
    buf.append("id=? ");
                    uqi.setValues.add(bean.getId()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("id"), uqi);
     valueSet = true;
  }
    if (bean.getNcImageprotocolsId() != null || bean.isNull("ncImageprotocolsId")) {
    if (valueSet)  buf.append(", ");
    buf.append("nc_imageprotocols_id=? ");
                    uqi.setValues.add(bean.getNcImageprotocolsId()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("ncImageprotocolsId"), uqi);
     valueSet = true;
  }
    if (bean.getConceptId() != null || bean.isNull("conceptId")) {
    if (valueSet)  buf.append(", ");
    buf.append("concept_id=? ");
                    uqi.setValues.add(bean.getConceptId()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("conceptId"), uqi);
     valueSet = true;
  }
    if (bean.getConceptSource() != null || bean.isNull("conceptSource")) {
    if (valueSet)  buf.append(", ");
    buf.append("concept_source=? ");
                    uqi.setValues.add(bean.getConceptSource()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("conceptSource"), uqi);
     valueSet = true;
  }
    if (!valueSet)
    throw new ValidationException("At least one field needs to be set for update!");

  uqi.query = buf.toString();
  QueryInfo qi = prepareWhereClause(criteria);
  uqi.query += qi.whereClause;
  uqi.whereValues = qi.values;
  return uqi;
}

protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
     if ( wasNull ) {
       uqi.nullSetList.add( new Boolean(true) );
     } else {
       uqi.nullSetList.add( new Boolean(false) );
     }
}


public Imageprotocolterms createObject(ResultSet rs) throws SQLException {
   Imageprotocolterms obj = new Imageprotocolterms();
                      obj.setId( (Double ) rs.getObject(1) );
                                   obj.setNcImageprotocolsId( (Double ) rs.getObject(2) );
                                   obj.setConceptId( (String ) rs.getObject(3) );
                                   obj.setConceptSource( (String ) rs.getObject(4) );
                   return obj;
}

public List<Imageprotocolterms> find(Connection con, Imageprotocolterms criteria) throws Exception
{

   PreparedStatement ps = null;
   ResultSet rs = null;
   List<Imageprotocolterms> results = new LinkedList<Imageprotocolterms>();
   StringBuffer buf = new StringBuffer(200);

   if ( criteria  == null)
       return null;
   buf.append("SELECT ");
   buf.append( prepareColList( criteria) );
   buf.append(" FROM nc_imageprotocolterms ");
   QueryInfo qi = prepareWhereClause(criteria);
   buf.append( qi.whereClause );
   try {
      ps = con.prepareStatement( buf.toString() );
      ps.clearParameters();
      int i = 0;
      for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
         ps.setObject(++i, it.next() );
      }
      rs = ps.executeQuery();
      while(rs.next() ) {
          Imageprotocolterms item = createObject(rs);
          results.add(item);
      }
   } finally {
      DBUtils.close(ps, rs);	
   }
   return results;
}

public void update(Connection con, Imageprotocolterms bean, Imageprotocolterms criteria) throws Exception
{
   PreparedStatement ps = null;

   if ( bean  == null)
       return;

   UpdateQueryInfo uqi =  prepareUpdateQuery(bean, criteria);
   try {
       ps = con.prepareStatement( uqi.query );
       ps.clearParameters();
       int i = 0;
       Iterator<Integer> it2 = uqi.sqlTypes.iterator();
       Iterator<Boolean> it3 = uqi.nullSetList.iterator();
       for(Iterator<?> it = uqi.setValues.iterator(); it.hasNext(); ) {
          Object value = it.next();
          Integer sqlType = (Integer) it2.next();
          boolean nullSet = ((Boolean) it3.next()).booleanValue();
          if ( nullSet) {
            ps.setNull(++i, sqlType.intValue() );
          } else {
             ps.setObject(++i, value);
          }
       }
       // for where part
       for(Iterator<?> it = uqi.whereValues.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();
   } finally {
      DBUtils.close(ps);	      
   }
}

public void delete(Connection con, Imageprotocolterms criteria) throws Exception
{
    PreparedStatement ps = null;
    StringBuffer buf = new StringBuffer(200);
    buf.append("DELETE FROM nc_imageprotocolterms ");

    QueryInfo qi = prepareWhereClause(criteria);
    buf.append( qi.whereClause );
    try {
       ps = con.prepareStatement( buf.toString() );
       ps.clearParameters();
       int i = 0;
       for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();

    } finally {
      DBUtils.close(ps);	
    }
}

  public static class QueryInfo {
    String whereClause;
    List<? super Object> values = new LinkedList<Object>();
    public QueryInfo() {}
    public QueryInfo(String whereClause) {
       this.whereClause = whereClause;
    }
  }

  public static class UpdateQueryInfo {
     String query;
     List<? super Object> setValues = new LinkedList<Object>();
	 List<Integer> sqlTypes = new LinkedList<Integer>();
	 List<Boolean> nullSetList = new LinkedList<Boolean>();
	 List<? super Object> whereValues = new LinkedList<Object>();
	 
     public UpdateQueryInfo() {}
  }

/*+++    */
  // Enter your code here
/*+++    */
}//;
