package clinical.server.dao.postgres;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.web.exception.ValidationException;
import clinical.server.ReceivedfilesInfo;
import clinical.server.vo.Receivedfilesdcmtag;
import clinical.web.DBUtils;


public class ReceivedfilesdcmtagDAO implements clinical.server.dao.ReceivedfilesdcmtagDAO {
/*+++    */
  // Enter your declarations here
/*+++    */

public ReceivedfilesdcmtagDAO () {}

public void insert(Connection con, Receivedfilesdcmtag bean) throws Exception
{
   PreparedStatement ps = null;
   StringBuffer buf = new StringBuffer(200);

   if ( bean == null)
       return;
   try {
     buf.append("INSERT INTO nc_receivedfilesdcmtag VALUES ");
     buf.append('(');
for(int i = 0; i < 6; ++i) {
  buf.append('?');
  if ( i <  5)
     buf.append(',');
}
buf.append(")");
     ps = con.prepareStatement( buf.toString() );
     ps.clearParameters();
                         ps.setObject(1,  bean.getUniqueid(), Types.NUMERIC);
                     
                         ps.setObject(2,  bean.getFileid(), Types.NUMERIC);
                     
                         ps.setObject(3,  bean.getPatientid(), Types.VARCHAR);
                     
                         ps.setObject(4,  bean.getSeriesdescription(), Types.VARCHAR);
                     
                         ps.setObject(5,  bean.getSeriesnumber(), Types.VARCHAR);
                     
                         ps.setObject(6,  bean.getSeriesdate(), Types.VARCHAR);
                         
                         ps.setObject(7,  bean.getSeriestime(), Types.VARCHAR);
                     
          ps.executeUpdate();

   } finally {
      DBUtils.close(ps);
   }
}


protected String prepareColList(Receivedfilesdcmtag bean) {
  StringBuffer buf = new StringBuffer(200);
    buf.append("uniqueid" );
   buf.append(',');     buf.append("fileid" );
   buf.append(',');     buf.append("patientid" );
   buf.append(',');     buf.append("seriesdescription" );
   buf.append(',');     buf.append("seriesnumber" );
   buf.append(',');     buf.append("seriesdate" );
   buf.append(',');     buf.append("seriestime" );
      buf.append(' ');
  return buf.toString();
}

protected QueryInfo prepareWhereClause(Receivedfilesdcmtag bean) {
  StringBuffer buf = new StringBuffer(200);
    QueryInfo qi = new QueryInfo();
  boolean valueSet = false;
  buf.append("WHERE ");
    if (bean.getUniqueid() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("uniqueid=?");
                   qi.values.add(bean.getUniqueid());
                 valueSet = true;
  }
    if (bean.getFileid() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("fileid=?");
                   qi.values.add(bean.getFileid());
                 valueSet = true;
  }
    if (bean.getPatientid() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("patientid=?");
                   qi.values.add(bean.getPatientid());
                 valueSet = true;
  }
    if (bean.getSeriesdescription() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("seriesdescription=?");
                   qi.values.add(bean.getSeriesdescription());
                 valueSet = true;
  }
    if (bean.getSeriesnumber() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("seriesnumber=?");
                   qi.values.add(bean.getSeriesnumber());
                 valueSet = true;
  }
    if (bean.getSeriesdate() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("seriesdate=?");
                   qi.values.add(bean.getSeriesdate());
                 valueSet = true;
  }
    if (bean.getSeriestime() != null) {
        if (valueSet)
          buf.append(" AND ");
        buf.append("seriestime=?");
                      qi.values.add(bean.getSeriestime());
                    valueSet = true;
  }
    qi.whereClause = (!valueSet) ? "" : buf.toString();
  return qi;
}

protected UpdateQueryInfo prepareUpdateQuery(Receivedfilesdcmtag bean,Receivedfilesdcmtag criteria ) throws ValidationException
{
  StringBuffer buf = new StringBuffer(200);
    UpdateQueryInfo uqi = new UpdateQueryInfo();
  boolean valueSet = false;
  buf.append("UPDATE nc_receivedfilesdcmtag SET ");
    if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
    if (valueSet)  buf.append(", ");
    buf.append("uniqueid=? ");
                    uqi.setValues.add(bean.getUniqueid()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("uniqueid"), uqi);
     valueSet = true;
  }
    if (bean.getFileid() != null || bean.isNull("fileid")) {
    if (valueSet)  buf.append(", ");
    buf.append("fileid=? ");
                    uqi.setValues.add(bean.getFileid()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("fileid"), uqi);
     valueSet = true;
  }
    if (bean.getPatientid() != null || bean.isNull("patientid")) {
    if (valueSet)  buf.append(", ");
    buf.append("patientid=? ");
                    uqi.setValues.add(bean.getPatientid()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("patientid"), uqi);
     valueSet = true;
  }
    if (bean.getSeriesdescription() != null || bean.isNull("seriesdescription")) {
    if (valueSet)  buf.append(", ");
    buf.append("seriesdescription=? ");
                    uqi.setValues.add(bean.getSeriesdescription()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("seriesdescription"), uqi);
     valueSet = true;
  }
    if (bean.getSeriesnumber() != null || bean.isNull("seriesnumber")) {
    if (valueSet)  buf.append(", ");
    buf.append("seriesnumber=? ");
                    uqi.setValues.add(bean.getSeriesnumber()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("seriesnumber"), uqi);
     valueSet = true;
  }
    if (bean.getSeriesdate() != null || bean.isNull("seriesdate")) {
    if (valueSet)  buf.append(", ");
    buf.append("seriesdate=? ");
                    uqi.setValues.add(bean.getSeriesdate()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("seriesdate"), uqi);
     valueSet = true;
  }
    if (bean.getSeriestime() != null || bean.isNull("seriestime")) {
        if (valueSet)  buf.append(", ");
        buf.append("seriestime=? ");
                        uqi.setValues.add(bean.getSeriestime()); 
                      uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
         prepareNullSetListValue( bean.isNull("seriestime"), uqi);
         valueSet = true;
  }
    if (!valueSet)
    throw new ValidationException("At least one field needs to be set for update!");

  uqi.query = buf.toString();
  QueryInfo qi = prepareWhereClause(criteria);
  uqi.query += qi.whereClause;
  uqi.whereValues = qi.values;
  return uqi;
}

protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
     if ( wasNull ) {
       uqi.nullSetList.add( new Boolean(true) );
     } else {
       uqi.nullSetList.add( new Boolean(false) );
     }
}


public Receivedfilesdcmtag createObject(ResultSet rs) throws SQLException {
   Receivedfilesdcmtag obj = new Receivedfilesdcmtag();
                      obj.setUniqueid( Double.valueOf(rs.getObject(1).toString()) );
                                   obj.setFileid(Double.valueOf(rs.getObject(2).toString()) );
                                   obj.setPatientid( (String ) rs.getObject(3) );
                                   obj.setSeriesdescription( (String ) rs.getObject(4) );
                                   obj.setSeriesnumber( (String ) rs.getObject(5) );
                                   obj.setSeriesdate( (String ) rs.getObject(6) );
                                   obj.setSeriestime( (String ) rs.getObject(7) );
                   return obj;
}

public ReceivedfilesInfo createObjectRcvdFileInfo(ResultSet rs) throws SQLException {
	   ReceivedfilesInfo obj = new ReceivedfilesInfo();	   
	                                   obj.setFileid( (BigDecimal) rs.getObject(1) );
	                                   obj.setPatientid( (String ) rs.getObject(2) );
	                                   obj.setSeriesdescription( (String ) rs.getObject(3) );
	                                   obj.setSeriesnumber( (String ) rs.getObject(4) );
	                                   obj.setSeriesdate( (String ) rs.getObject(5) );
	                                   obj.setFilename( (String ) rs.getObject(6) );
	                                   obj.setTemplocation((String ) rs.getObject(7) );
	                                   obj.setPermlocation( (String ) rs.getObject(8) );
	                                   obj.setProcessed( (Boolean ) rs.getObject(9) );
	                   return obj;
}

public ReceivedfilesInfo createObjectRcvdSeriesInfo(ResultSet rs) throws SQLException {
	   ReceivedfilesInfo obj = new ReceivedfilesInfo();	                                   
	                                   obj.setPatientid( (String ) rs.getObject(1) );	                                   
	                                   obj.setSeriesnumber( (String ) rs.getObject(2) );
	                                   obj.setSeriesdate( (String ) rs.getObject(3) );
	                                   obj.setSeriestime( (String ) rs.getObject(4) );
	                                   obj.setSeriesdescription((String) rs.getObject(5));
	                                   
	                   return obj;
}

public List<Receivedfilesdcmtag> find(Connection con, Receivedfilesdcmtag criteria) throws Exception
{

   PreparedStatement ps = null;
   ResultSet rs = null;
   List<Receivedfilesdcmtag> results = new LinkedList<Receivedfilesdcmtag>();
   StringBuffer buf = new StringBuffer(200);

   if ( criteria  == null)
       return null;
   buf.append("SELECT ");
   buf.append( prepareColList( criteria) );
   buf.append(" FROM nc_receivedfilesdcmtag ");
   QueryInfo qi = prepareWhereClause(criteria);
   buf.append( qi.whereClause );
   try {
      ps = con.prepareStatement( buf.toString() );
      ps.clearParameters();
      int i = 0;
      for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
         ps.setObject(++i, it.next() );
      }
      rs = ps.executeQuery();
      while(rs.next() ) {
          Receivedfilesdcmtag item = createObject(rs);
          results.add(item);
      }
   } finally {
      DBUtils.close(ps, rs);	
   }
   return results;
}

public void update(Connection con, Receivedfilesdcmtag bean, Receivedfilesdcmtag criteria) throws Exception
{
   PreparedStatement ps = null;

   if ( bean  == null)
       return;

   UpdateQueryInfo uqi =  prepareUpdateQuery(bean, criteria);
   try {
       ps = con.prepareStatement( uqi.query );
       ps.clearParameters();
       int i = 0;
       Iterator<Integer> it2 = uqi.sqlTypes.iterator();
       Iterator<Boolean> it3 = uqi.nullSetList.iterator();
       for(Iterator<?> it = uqi.setValues.iterator(); it.hasNext(); ) {
          Object value = it.next();
          Integer sqlType = (Integer) it2.next();
          boolean nullSet = ((Boolean) it3.next()).booleanValue();
          if ( nullSet) {
            ps.setNull(++i, sqlType.intValue() );
          } else {
             ps.setObject(++i, value);
          }
       }
       // for where part
       for(Iterator<?> it = uqi.whereValues.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();
   } finally {
      DBUtils.close(ps);	      
   }
}

public void delete(Connection con, Receivedfilesdcmtag criteria) throws Exception
{
    PreparedStatement ps = null;
    StringBuffer buf = new StringBuffer(200);
    buf.append("DELETE FROM nc_receivedfilesdcmtag ");

    QueryInfo qi = prepareWhereClause(criteria);
    buf.append( qi.whereClause );
    try {
       ps = con.prepareStatement( buf.toString() );
       ps.clearParameters();
       int i = 0;
       for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();

    } finally {
      DBUtils.close(ps);	
    }
}

  public static class QueryInfo {
    String whereClause;
    List<? super Object> values = new LinkedList<Object>();
    public QueryInfo() {}
    public QueryInfo(String whereClause) {
       this.whereClause = whereClause;
    }
  }

  public static class UpdateQueryInfo {
     String query;
     List<? super Object> setValues = new LinkedList<Object>();
	 List<Integer> sqlTypes = new LinkedList<Integer>();
	 List<Boolean> nullSetList = new LinkedList<Boolean>();
	 List<? super Object> whereValues = new LinkedList<Object>();
	 
     public UpdateQueryInfo() {}
  }

  /*
   * Returns a list of all received files joined with dicom file tags
   * @see clinical.server.dao.ReceivedfilesdcmtagDAO#findReceivedFilesWithDcmTags(java.sql.Connection, clinical.server.ReceivedfilesInfo)
   */
@Override
public List<ReceivedfilesInfo> findReceivedFilesWithDcmTags(Connection con,
		ReceivedfilesInfo criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ReceivedfilesInfo> results = new LinkedList<ReceivedfilesInfo>();
		StringBuffer buf = new StringBuffer(200);

		if ( criteria  == null)
			return null;
		buf.append("SELECT t.fileid, t.patientid, t.seriesdescription, t.seriesnumber, t.seriesdate, t.seriestime, ");
		buf.append("f.filename, f.templocation, f.permlocation, f.processed  ");
		buf.append("FROM nc_receivedfilesdcmtag t inner join nc_receivedfiles f on t.fileid=f.fileid ");	   
	   
		try {
			ps = con.prepareStatement( buf.toString() );
			ps.clearParameters();	      
			rs = ps.executeQuery();
			while(rs.next() ) {
				ReceivedfilesInfo item = createObjectRcvdFileInfo(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);	
		}
		return results;	
	}


	/*
	 * Returns a list of received files distinct by patientid, seriesnumber,
	 * seriesdate, seriestime, seriesdescription
	 * 
	 * @see
	 * clinical.server.dao.ReceivedfilesdcmtagDAO#findReceivedFilesWithDcmTags
	 * (java.sql.Connection, clinical.server.ReceivedfilesInfo)
	 */
	@Override
	public List<ReceivedfilesInfo> findReceivedFilesBySeriesNoTime(
			Connection con, ReceivedfilesInfo criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ReceivedfilesInfo> results = new LinkedList<ReceivedfilesInfo>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT distinct patientid, seriesnumber, seriesdate, seriestime, seriesdescription ");
		buf.append("FROM nc_receivedfilesdcmtag ");

		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			rs = ps.executeQuery();
			while (rs.next()) {
				ReceivedfilesInfo item = createObjectRcvdSeriesInfo(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;

	}
	
	
	/*
	 * Returns a list of un-processed received files distinct by patientid, seriesnumber,
	 * seriesdate, seriestime, seriesdescription
	 * 
	 * @see
	 * clinical.server.dao.ReceivedfilesdcmtagDAO#findReceivedFilesWithDcmTags
	 * (java.sql.Connection, clinical.server.ReceivedfilesInfo)
	 */
	@Override
	public List<ReceivedfilesInfo> findUnprocessedReceivedFilesBySeriesNoTime(
			Connection con, ReceivedfilesInfo criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ReceivedfilesInfo> results = new LinkedList<ReceivedfilesInfo>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT distinct patientid, seriesnumber, seriesdate, seriestime, seriesdescription ");
		buf.append("FROM nc_receivedfilesdcmtag rfd  ");
		buf.append("INNER JOIN nc_receivedfiles rf ");
		buf.append("ON rfd.fileid = rf.fileid ");
		buf.append("WHERE rf.processed=false ");

		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			rs = ps.executeQuery();
			while (rs.next()) {
				ReceivedfilesInfo item = createObjectRcvdSeriesInfo(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;

	}

}
