package clinical.test;

import java.io.IOException;
import java.util.List;

import clinical.utils.GenUtils;
import clinical.web.common.query.Operator;
import clinical.web.services.AssessmentServiceHelper;
import clinical.web.vo.SubjectAsScoreValueSummary;

import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * @author I. Burak Ozyurt
 * @version $Id: AsQueryFilterTests.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class AsQueryFilterTests extends TestCase {

	public AsQueryFilterTests(String name) {
		super(name);
	}

	/**
	 * Harcoded path to testing intermediate query result serialization file.
	 *
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	public void testQueryFilter() throws Exception {
		List<Object> list = (List<Object>) GenUtils.deserialize("/home/bozyurt/query.ser");
		List<SubjectAsScoreValueSummary> summaryList = (List<SubjectAsScoreValueSummary>) list.get(0);
		Operator op = (Operator) list.get(1);

		summaryList = AssessmentServiceHelper.filterSearchResultsGroupedByVisit(summaryList,
				op);
		for (SubjectAsScoreValueSummary ssvs : summaryList) {
			System.out.println(ssvs);
		}
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite();
		suite.addTest( new AsQueryFilterTests("testQueryFilter"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}
}
