package clinical.test;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/**
 * @author I. Burak Ozyurt
 * @version $Id: FunctionalTestInputLoader.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class FunctionalTestInputLoader {
	protected Document doc;
	Map<String, TestCaseInfo> testCaseMap = new HashMap<String, TestCaseInfo>(7);

	public FunctionalTestInputLoader(String filename) throws IOException,
			JDOMException {
		SAXBuilder builder = new SAXBuilder(false); // no validation
		doc = builder.build(filename);
	}

	public TestCaseInfo getTestCaseInfo(String name) {
		return testCaseMap.get(name);
	}

	public void load() throws Exception {
		Element root = doc.getRootElement();
		List<?> tcElems = root.getChildren("test-case");
		for (Iterator<?> iter = tcElems.iterator(); iter.hasNext();) {
			Element tcElem = (Element) iter.next();
			parseTestCase(tcElem);
		}
	}

	protected void parseTestCase(Element tcElem) throws Exception {
		TestCaseInfo tci = new TestCaseInfo();
		String name = tcElem.getAttributeValue("name");
		tci.setName(name);
		testCaseMap.put(tci.getName(), tci);
		Element qiElem = tcElem.getChild("query-infos");
		if (qiElem != null) {
			List<?> rqiElems = qiElem.getChildren("request-query-info");
			for (Iterator<?> iter = rqiElems.iterator(); iter.hasNext();) {
				Element rqiElem = (Element) iter.next();
				parseQueryInfo(rqiElem, tci);
			}
		}
		Element rElem = tcElem.getChild("responses");
		if (rElem != null) {
			List<?> rsElems = rElem.getChildren("response");
			for (Iterator<?> iter = rsElems.iterator(); iter.hasNext();) {
				Element rsElem = (Element) iter.next();
				parseResponseInfo(rsElem, tci);
			}
		}
	}

	protected void parseQueryInfo(Element rciElem, TestCaseInfo tci) {
		QueryRequestInfo rqi = new QueryRequestInfo();
		rqi.setName(rciElem.getAttributeValue("name"));
		String prev = rciElem.getAttributeValue("prev");

		tci.addQueryRequestInfo(rqi, prev);
		rqi.setAssessmentName(rciElem.getAttributeValue("as-name"));
		rqi.setScoreName(rciElem.getAttributeValue("score-name"));
		rqi.setBrainRegionName(rciElem.getAttributeValue("region-name"));
		String operator = rciElem.getAttributeValue("op");
		if (operator != null) {
			String rhs = rciElem.getAttributeValue("rhs");
			rqi.setRelQueryRequest(new QueryRequestInfo.RelQueryRequest(
					toOpCode(operator), rhs));
		} else {
			String lowBound = rciElem.getAttributeValue("low-bound");
			String uppBound = rciElem.getAttributeValue("upp-bound");
			rqi
					.setBetweenQueryRequest(new QueryRequestInfo.BetweenQueryRequest(
							lowBound, uppBound));
		}
		String comb = rciElem.getAttributeValue("combinator");
		if (comb != null) {
			if (comb.equalsIgnoreCase("and"))
				rqi.setCombinator(QueryRequestInfo.AND);
			else if (comb.equalsIgnoreCase("or"))
				rqi.setCombinator(QueryRequestInfo.OR);
		}
	}

	protected void parseResponseInfo(Element resElem, TestCaseInfo tci) {
		String title = resElem.getAttributeValue("title");
		ResponseInfo ri = new ResponseInfo();
		ri.setTitle(title);
		Element expectedElem = resElem.getChild("expected");
		ri.setExpectedResult(expectedElem.getText());
		tci.addResponse(ri);
	}

	static int toOpCode(String operator) {
		if (operator.equalsIgnoreCase("equal"))
			return 1;
		if (operator.equalsIgnoreCase("greater_than"))
			return 2;
		if (operator.equalsIgnoreCase("less_than"))
			return 3;
		if (operator.equalsIgnoreCase("not_equal"))
			return 4;
		if (operator.equalsIgnoreCase("greater_or_equal"))
			return 5;
		if (operator.equalsIgnoreCase("less_or_equal"))
			return 6;

		if (operator.equalsIgnoreCase("starts_with"))
			return 100;
		if (operator.equalsIgnoreCase("ends_with"))
			return 101;
		if (operator.equalsIgnoreCase("any"))
			return 102;

		return -1;
	}
}
