package clinical.test;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import clinical.server.vo.Experiment;
import clinical.utils.BIRNURIException;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.web.common.UserInfo;
import clinical.web.download.DataNode;
import clinical.web.download.DownloadJob;
import clinical.web.download.FileBundleConfig;
import clinical.web.download.FileInfo;
import clinical.web.download.ObjectInfo;
import clinical.web.download.Packager;
import clinical.web.download.SubjectImageDataBundle;
import clinical.web.helpers.ShoppingCartHelper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ShoppingCartTests.java,v 1.1.2.3 2007/07/03 01:43:59 bozyurt
 *          Exp $
 */
public class ShoppingCartTests extends TestCase {

	public ShoppingCartTests(String testName) {
		super(testName);
	}

	public void testSubjectImageDataBundle() throws Exception {
		SubjectImageDataBundle sidb = prepTestSIDB2();

		String script = sidb.getJavascriptTree();
		System.out.println(script);
	}

	protected SubjectImageDataBundle prepTestSIDB() throws BIRNURIException {
		SubjectImageDataBundle sidb = new SubjectImageDataBundle(
				"000812345678", "0006", "a1");
		DataNode visit = sidb.addVisit("0001");
		// DataNode segment = sidb.addSegment("0001", visit);
		DataNode subDir = sidb.addSubDir("sirp1", visit);
		String rootPath = "000812345678/scanVisit__0006__0002/sirp1";
		FileInfo fi1 = new FileInfo(
				"000812345678/scanVisit__0006__0002/sirp1/sirp-hp65-stc-to7-gam+deriv-fsl-from-MBTS-preproc-0008-0001.feat",
				FileInfo.GZIPPED_NIFTI, FileInfo.LOCAL, rootPath, false);
		FileInfo fi2 = new FileInfo(
				"000812345678/scanVisit__0006__0002/sirp1/sirp-hp65-stc-to7-gam+deriv-fsl-from-MBTS-preproc-0008-0002.feat",
				FileInfo.GZIPPED_NIFTI, FileInfo.LOCAL, rootPath, false);
		List<FileInfo> fiList = new ArrayList<FileInfo>(2);
		fiList.add(fi1);
		fiList.add(fi2);

		sidb.addFiles(fiList, subDir, true);
		return sidb;
	}

	protected SubjectImageDataBundle prepTestSIDB2() throws BIRNURIException {
		SubjectImageDataBundle sidb = new SubjectImageDataBundle(
				"000602155404", "0006", "a1");

		DataNode exp = sidb.addObject(new ObjectInfo("download_test",
				"download_test", "experiment"), sidb.getRoot());

		DataNode visit = sidb.addObject(new ObjectInfo("0002", "Visit 2",
				"visit"), exp);

		String rootPath = "";

		DataNode asLabelNode = sidb.addObject(new ObjectInfo("Assessment",
				"Assessment", "label"), visit);
		sidb.addObject(new ObjectInfo("1", "quick mood scale", "assessment"),
				asLabelNode);

		DataNode segment = sidb.addObject(new ObjectInfo("0003", "Segment 3",
				"segment"), visit);

		FileInfo fi1 = new FileInfo(
				"scanVisit__0006__0002/MRI__0001/AudOdd3/Native/Original__0001/NIFTI",
				FileInfo.GZIPPED_NIFTI, FileInfo.LOCAL, rootPath, true);
		FileInfo fi2 = new FileInfo(
				"scanVisit__0006__0002/MRI__0001/AudOdd3/Native/Original__0001/DICOM",
				FileInfo.DICOM, FileInfo.LOCAL, rootPath, true);
		List<FileInfo> fiList = new ArrayList<FileInfo>(2);
		fiList.add(fi1);
		fiList.add(fi2);

		sidb.addFiles(fiList, segment, false);
		return sidb;
	}

	protected SubjectImageDataBundle prepTestSIDB3() throws BIRNURIException {
		SubjectImageDataBundle sidb = new SubjectImageDataBundle(
				"000602155404", "0006", "a1");

		DataNode exp = sidb.addObject(new ObjectInfo("download_test",
				"download_test", "experiment"), sidb.getRoot());

		DataNode visit = sidb.addObject(new ObjectInfo("0002", "Visit 2",
				"visit"), exp);
		DataNode segment = sidb.addObject(new ObjectInfo("0003", "Segment 3",
				"segment"), visit);

		String rootPath = "";

		FileInfo fi1 = new FileInfo(
				"scanVisit__0006__0002/MRI__0001/AudOdd3/Native/Original__0001/NIFTI",
				FileInfo.GZIPPED_NIFTI, FileInfo.SRB, rootPath, true);
		List<FileInfo> fiList = new ArrayList<FileInfo>(2);
		fiList.add(fi1);

		sidb.addFiles(fiList, segment, false);
		return sidb;
	}

	protected String prepTestSelectedItemsXMLStr() {
		String s = "<list>"
				+ "<ca>000602155404/download_test/Visit 2/Assessment/quick mood scale</ca>"
				+ "<item>000602155404/download_test/Visit 2/Segment 2</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 2/scanVisit__0006__0002/MRI__0001/sirp1/Native/Original__0001/NIFTI</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 2/scanVisit__0006__0002/MRI__0001/sirp1/Native/Original__0001/DICOM</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 3</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 3/scanVisit__0006__0002/MRI__0001/AudOdd3/Native/Original__0001/NIFTI</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 3/scanVisit__0006__0002/MRI__0001/AudOdd3/Native/Original__0001/DICOM</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 4</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 4/scanVisit__0006__0002/MRI__0001/sm1/Native/Original__0001/NIFTI</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 4/scanVisit__0006__0002/MRI__0001/sm1/Native/Original__0001/DICOM</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 5/scanVisit__0006__0002/MRI__0001/t1/Native/Original__0001/NIFTI</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 5/scanVisit__0006__0002/MRI__0001/t1/Native/Original__0001/DICOM</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 7/scanVisit__0006__0002/MRI__0001/bh1/Native/Original__0001/NIFTI</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 7/scanVisit__0006__0002/MRI__0001/bh1/Native/Original__0001/DICOM</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 8/scanVisit__0006__0002/MRI__0001/AudOdd4/Native/Original__0001/NIFTI</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 8/scanVisit__0006__0002/MRI__0001/AudOdd4/Native/Original__0001/DICOM</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 10/scanVisit__0006__0002/MRI__0001/t2/Native/Original__0001/NIFTI</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 10/scanVisit__0006__0002/MRI__0001/t2/Native/Original__0001/DICOM</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 11/scanVisit__0006__0002/MRI__0001/AudOdd1/Native/Original__0001/NIFTI</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 11/scanVisit__0006__0002/MRI__0001/AudOdd1/Native/Original__0001/DICOM</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 12/scanVisit__0006__0002/MRI__0001/AudOdd2/Native/Original__0001/NIFTI</item>"
				+ "<item>000602155404/download_test/Visit 2/Segment 12/scanVisit__0006__0002/MRI__0001/AudOdd2/Native/Original__0001/DICOM</item>"
				+ "</list>";
		return s;
	}

	public void testIsCollection() {
		String objectType = "3_SRB FILE Eprime";
		boolean isCol = ShoppingCartHelper.isCollection(objectType);
		assertFalse(isCol);
		objectType = "3_SRB COL A_7.5";
		isCol = ShoppingCartHelper.isCollection(objectType);
		assertTrue(isCol);
	}

	public void testExtractFileType() {
		String objectType = "3_SRB FILE Eprime";
		int ft = ShoppingCartHelper.extractFileType(objectType);
		assertEquals(ft, FileInfo.EPRIME);
		objectType = "2_NIFTI GZ";
		ft = ShoppingCartHelper.extractFileType(objectType);
		assertEquals(ft, FileInfo.GZIPPED_NIFTI);
		objectType = "1_SRB CHILD FILE";
		ft = ShoppingCartHelper.extractFileType(objectType);
		assertTrue(ft <= 0);
		objectType = "3_SRB COL A_7.5";
		ft = ShoppingCartHelper.extractFileType(objectType);
		assertEquals(ft, FileInfo.ANALYZE_7_5);
	}

	public void testPrepareFileBundleConfig() throws Exception {
		SubjectImageDataBundle sidb = prepTestSIDB2();
		List<SubjectImageDataBundle> sidbList = new ArrayList<SubjectImageDataBundle>(
				1);
		sidbList.add(sidb);
		String bundleName = "test_bundle";
		String cacheDir = "/home/bozyurt/download_cache";
		// String sourceRootDir = "/data/fBIRN/PhaseII_Data";
		String selectedItemsXML = prepTestSelectedItemsXMLStr();

		Map<String, Experiment> expMap = prepareExpMap();

		FileBundleConfig fbc = ShoppingCartHelper.prepareFileBundleConfig(
				sidbList, selectedItemsXML, bundleName, cacheDir, expMap);
		System.out.println(fbc.toString());

		DownloadJob dj = new DownloadJob("1", new UserInfo("bozyurt", null,
				null), "some description", fbc);

		dj.execute();
	}

	public void testAssessmentDownload() throws Exception {
		SubjectImageDataBundle sidb = prepTestSIDB2();
		List<SubjectImageDataBundle> sidbList = new ArrayList<SubjectImageDataBundle>(
				1);
		sidbList.add(sidb);
		// String bundleName = "test_bundle";
		// String cacheDir = "/home/bozyurt/download_cache";
		// String sourceRootDir = "/data/fBIRN/PhaseII_Data";
		String selectedItemsXML = prepTestSelectedItemsXMLStr();

		Map<String, String> asNameMap = new HashMap<String, String>();
		ShoppingCartHelper.prepareAssessmentBundle(sidbList,
				selectedItemsXML, asNameMap);

	}

	public void testSRBDownloadJob() throws Exception {
		SubjectImageDataBundle sidb = prepTestSIDB3();
		List<SubjectImageDataBundle> sidbList = new ArrayList<SubjectImageDataBundle>(
				1);
		sidbList.add(sidb);
		String bundleName = "srb_test_bundle";
		String cacheDir = "/home/bozyurt/download_cache";
		// String sourceRootDir = "/home/Projects/fBIRNPhaseII__0010/Data";
		String selectedItemsXML = prepTestSelectedItemsXMLStr();

		Map<String, Experiment> expMap = prepareExpMap();

		FileBundleConfig fbc = ShoppingCartHelper.prepareFileBundleConfig(
				sidbList, selectedItemsXML, bundleName, cacheDir, expMap);
		System.out.println(fbc.toString());

		DownloadJob dj = new DownloadJob("1", new UserInfo("bozyurt", null,
				null), "some description", fbc);

		dj.execute();
	}

	protected Map<String, Experiment> prepareExpMap() {
		Map<String, Experiment> expMap = new HashMap<String, Experiment>(3);
		Experiment exp = new Experiment();
		exp.setUniqueid(new BigDecimal("1"));
		exp.setName("fBIRNPhaseII__0010");
		exp.setBaseuri("/home/Projects/fBIRNPhaseII__0010/Data");
		expMap.put(exp.getName(), exp);
		return expMap;
	}

	public void testPackager() throws Exception {
		Packager packager = (Packager) GenUtils
				.deserialize("/tmp/packager.ser");

		System.out.println(packager.toString());
	}

	public void testPackagerCleanup() throws Exception {
		String rootDir = "/home/bozyurt/download_cache";
		String path = "/home/bozyurt/download_cache/1185823821750";
		FileUtils.deleteSubdirs(rootDir, path);
	}

	public static Test suite() {
		TestSuite suite = new TestSuite();
		// suite.addTest(new ShoppingCartTests("testSubjectImageDataBundle"));
		// suite.addTest(new ShoppingCartTests("testIsCollection"));
		// suite.addTest(new ShoppingCartTests("testExtractFileType"));
		// suite.addTest( new ShoppingCartTests("testPrepareFileBundleConfig")
		// );
		// suite.addTest( new ShoppingCartTests("testSRBDownloadJob"));
		// suite.addTest(new ShoppingCartTests("testAssessmentDownload"));

		// suite.addTest(new ShoppingCartTests("testPackager"));
		suite.addTest(new ShoppingCartTests("testPackagerCleanup"));
		return suite;
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}
}
