package clinical.test;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import junit.framework.TestSuite;
import clinical.server.vo.Brainsegmentdata;
import clinical.web.IDerivedDataService;
import clinical.web.ISubjectAssessmentManagement;
import clinical.web.ServiceFactory;
import clinical.web.vo.AssessmentInfo;
import clinical.web.vo.AssessmentScoreValues;
import clinical.web.vo.ScoreValue;
import clinical.web.vo.AssessmentInfo.ScoreInfo;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: SubjectAssessmentRetrievalTest.java,v 1.9 2007/11/27 02:16:34
 *          bozyurt Exp $
 */
public class SubjectAssessmentRetrievalTest extends MyTestCase {
	protected String owner;
	protected String modUser;
	protected String dbID;
	// private Log log = LogFactory.getLog("SubjectAssessmentRetrievalTest");

	public SubjectAssessmentRetrievalTest(String testName, String propsFile)
			throws IOException {
		super(testName, propsFile);
		dbID = getProperty("mbirn.dbid");
	}

	protected void setUp() throws Exception {
		super.setUp();
		owner = getProperty("mbirn.owner");
		modUser = getProperty("mbirn.moduser");
	}

	protected List<Object[]> getSubjectExperiment() throws Exception {
		Statement st = null;
		List<Object[]> list = new LinkedList<Object[]>();
		Connection con = null;
		try {
			con = getConnection();
			st = con.createStatement();
			ResultSet rs = st
					.executeQuery("select distinct subjectid, nc_experiment_uniqueid from nc_storedassessment");
			while (rs.next()) {
				Object[] row = new Object[2];
				row[0] = rs.getString(1);
				row[1] = rs.getBigDecimal(2);
				list.add(row);
			}
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
			if (con != null)
				releaseConnection(con);
		}
		return list;
	}

	public void testRetrieval() throws Exception {
		ISubjectAssessmentManagement isam = null;
		isam = ServiceFactory.getSubjectAssessmentManagement(this.dbID);
		List<SubjectAssessmentInfo> saiList = new LinkedList<SubjectAssessmentInfo>();
		List<Object[]> subjExps = getSubjectExperiment();
		Map<String, AssessmentInfo> totalAsiMap = new LinkedHashMap<String, AssessmentInfo>();
		int count = 0;

		for (Iterator<Object[]> iter = subjExps.iterator(); iter.hasNext();) {
			// if ( count > 5) break;
			Object[] row = iter.next();

			String subjectID = (String) row[0];
			System.out.println(">>SubjectID=" + subjectID);
			int experimentID = ((BigDecimal) row[1]).intValue();
			List<AssessmentInfo> asiList = isam.getAssessmentsForSubject(
					getUi(), subjectID, experimentID);

			if (asiList != null && !asiList.isEmpty()) {
				for (Iterator<AssessmentInfo> it = asiList.iterator(); it
						.hasNext();) {
					AssessmentInfo asi = it.next();
					if (totalAsiMap.get(asi.getName()) == null) {
						totalAsiMap.put(asi.getName(), asi);
					}
				}
				List<AssessmentScoreValues> valuesList = isam
						.getAssessmentValuesForSubject(getUi(), subjectID,
								experimentID, asiList, 1, false);

				SubjectAssessmentInfo sai = new SubjectAssessmentInfo(
						subjectID, asiList, valuesList);
				saiList.add(sai);
			}
			++count;
		}

		exportDerivedData(totalAsiMap, saiList, subjExps);
	}

	protected void exportDerivedData(Map<String, AssessmentInfo> totalAsiMap,
			List<SubjectAssessmentInfo> saiList, List<Object[]> subjExps)
			throws Exception {
		IDerivedDataService ids = null;

		ids = ServiceFactory.getDerivedDataService(this.dbID);

		List<Brainsegmentdata> bsds = ids.getAllSubCorticalVariables(getUi());

		Map<String, String> derivedVarMap = new LinkedHashMap<String, String>();

		for (Brainsegmentdata bsd : bsds) {
			String regionName = bsd.getBrainregionname();
			if (bsd.getLaterality() != null
					&& bsd.getLaterality().trim().length() > 0
					&& !bsd.getLaterality().equalsIgnoreCase("n/a")) {
				regionName = bsd.getLaterality() + "_" + regionName;
			}
			derivedVarMap.put(regionName, regionName);
		}

		int count = 0;
		List<Map<String, Float>> resultList = new LinkedList<Map<String, Float>>();
		for (Iterator<Object[]> iter = subjExps.iterator(); iter.hasNext();) {
			// if ( count > 5) break;
			Object[] row = iter.next();
			String subjectID = (String) row[0];
			System.out.println(">>SubjectID=" + subjectID);
			int experimentID = ((BigDecimal) row[1]).intValue();
			Map<String, Float> rowMap = ids
					.getAllSubcorticalRegionVolumesForSubject(getUi(),
							subjectID, experimentID);
			resultList.add(rowMap);

			++count;
		}

		PrintWriter out = null;
		// new PrintWriter( new OutputStreamWriter( System.out));
		try {
			out = new PrintWriter(new FileWriter(
					"/home/bozyurt/shared/ucsd_data_dump2.csv"));
			dumpCombinedHeader(out, totalAsiMap, derivedVarMap);
			Iterator<Map<String, Float>> it2 = resultList.iterator();
			for (Iterator<SubjectAssessmentInfo> iter = saiList.iterator(); iter
					.hasNext();) {
				SubjectAssessmentInfo sai = iter.next();
				Map<String, Float> rowMap = it2.next();
				List<ScoreValue> rsList = sai.getData(totalAsiMap);
				dumpRow(out, sai.subjectID, rsList, derivedVarMap, rowMap);
			}
		} catch (IOException iox) {
			iox.printStackTrace();
		} finally {
			if (out != null)
				try {
					out.close();
				} catch (Exception x) {
				}
		}

	}

	// for SAS/SPSS
	protected void dumpRow(PrintWriter out, String subjectID,
			List<ScoreValue> resultList, Map<String, String> derivedVarMap,
			Map<String, Float> rowMap) {
		out.print(subjectID + ",");
		for (Iterator<ScoreValue> iter = resultList.iterator(); iter.hasNext();) {
			ScoreValue sv = iter.next();
			if (sv != null) {
				out.print(sv.getValue());
			} else {
				out.print(".");
			}
			if (iter.hasNext())
				out.print(",");
		}
		out.print(",");
		for (Iterator<String> iter = derivedVarMap.values().iterator(); iter
				.hasNext();) {
			String varName = iter.next();
			if (rowMap.get(varName) != null) {
				out.print(rowMap.get(varName).toString());
			} else {
				out.print(".");
			}
			if (iter.hasNext())
				out.print(",");
		}
		out.println(";");
	}

	protected void dumpCombinedHeader(PrintWriter out,
			Map<String, AssessmentInfo> totalAsiMap,
			Map<String, String> derivedVarMap) {
		out.print("SubjectID,");
		for (Iterator<AssessmentInfo> iter = totalAsiMap.values().iterator(); iter
				.hasNext();) {
			AssessmentInfo asi = iter.next();
			Iterator<ScoreInfo> it = asi.getScores().iterator();
			while (it.hasNext()) {
				AssessmentInfo.ScoreInfo si = it.next();
				String header = asi.getName() + "_" + si.getName();
				header = header.replace(' ', '_');
				out.print(header);
				if (it.hasNext())
					out.print(",");
			}
			if (iter.hasNext())
				out.print(",");
		}
		out.print(",");

		for (Iterator<String> iter = derivedVarMap.values().iterator(); iter
				.hasNext();) {
			String varName = iter.next();
			out.print(varName);
			if (iter.hasNext())
				out.print(",");
		}
		out.println("");
	}

	protected void dumpDerivedDataHeader(Map<String,String> derivedVarMap) {
		for (Iterator<String> iter = derivedVarMap.values().iterator(); iter.hasNext();) {
			String varName = iter.next();
			System.out.print(varName);
			if (iter.hasNext())
				System.out.print(",");
		}
		System.out.println("");
	}

	protected void dumpDerivedData(Map<String,String> derivedVarMap, Map<String,Object> rowMap) {
		for (Iterator<String> iter = derivedVarMap.values().iterator(); iter.hasNext();) {
			String varName = iter.next();
			if (rowMap.get(varName) != null) {
				System.out.print(rowMap.get(varName).toString());
			}
			if (iter.hasNext())
				System.out.print(",");
		}
		System.out.println("");
	}

	public void dumpHeader(Map<String, AssessmentInfo> totalAsiMap) {
		System.out.print("SubjectID,");
		for (Iterator<AssessmentInfo> iter = totalAsiMap.values().iterator(); iter.hasNext();) {
			AssessmentInfo asi = iter.next();
			Iterator<ScoreInfo> it = asi.getScores().iterator();
			while (it.hasNext()) {
				AssessmentInfo.ScoreInfo si = it.next();
				String header = asi.getName() + "_" + si.getName();
				header = header.replace(' ', '_');
				System.out.print(header);
				if (it.hasNext())
					System.out.print(",");
			}
			if (iter.hasNext())
				System.out.print(",");
		}
		System.out.println("");
	}


	static public class SubjectAssessmentInfo {
		String subjectID;
		// List asiList;
		List<AssessmentScoreValues> valuesList;
		/**
		 * holds a list of <code>clinical.web.vo.AssessmentInfo</code> objects
		 * for the current subject
		 */
		protected List<AssessmentInfo> assessmentInfos = new LinkedList<AssessmentInfo>();
		/**
		 * holds a map of assessment name versus
		 * <code>clinical.web.vo.AssessmentScoreValues</code> objects for the
		 * current subject
		 */
		protected Map<String, AssessmentScoreValues> asScoreValuesMap;

		public SubjectAssessmentInfo(String subjectID,
				List<AssessmentInfo> asiList, List<AssessmentScoreValues> valuesList) {
			this.subjectID = subjectID;
			this.valuesList = valuesList;
			assessmentInfos = asiList;
			setAsScoreValuesMap(valuesList);
		}

		public void setAsScoreValuesMap(List<AssessmentScoreValues> newAsvList) {
			asScoreValuesMap = new HashMap<String, AssessmentScoreValues>(17);
			for (Iterator<AssessmentScoreValues> iter = newAsvList.iterator(); iter.hasNext();) {
				AssessmentScoreValues asv = iter.next();
				asScoreValuesMap.put(asv.getAssessmentName(), asv);
			}
		}

		public List<ScoreValue> getData(Map<String, AssessmentInfo> totalAsiMap) {
			List<ScoreValue> resultList = new LinkedList<ScoreValue>();
			for (Iterator<AssessmentInfo> iter = totalAsiMap.values()
					.iterator(); iter.hasNext();) {
				AssessmentInfo asi = iter.next();
				Iterator<ScoreInfo> it = asi.getScores().iterator();

				AssessmentScoreValues asv = asScoreValuesMap.get(asi.getName());

				while (it.hasNext()) {
					AssessmentInfo.ScoreInfo si = it
							.next();
					if (asv != null) {
						/**
						 * @todo need to implement logic for multiple score
						 *       values per score name (multiple answers)
						 */
						ScoreValue sv = (ScoreValue) asv.getScoreValue(si
								.getName(), 1);

						resultList.add(sv);
					} else {
						/**
						 * @todo need to implement logic for multiple score
						 *       values per score name (multiple answers)
						 */
						ScoreValue sv = new ScoreValue(si.getName(), "", 1);
						resultList.add(sv);
					}
				}
			}
			return resultList;
		}

	}

	public static TestSuite suite() throws IOException {
		TestSuite suite = new TestSuite();
		suite.addTest(new SubjectAssessmentRetrievalTest("testRetrieval",
				"test.properties"));
		return suite;
	}

	public static void main(String[] args) throws IOException {
		junit.textui.TestRunner.run(suite());
	}

}
