package clinical.utils;

import java.util.Properties;

import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * adapted from  Claude Duguay's mail client code.
 * 
 * @author I. Burak Ozyurt
 * @version $Id: EmailSender.java 88 2009-08-17 23:02:38Z bozyurt $
 */
public class EmailSender extends Authenticator {
	protected String from;
    protected Session session;
    protected PasswordAuthentication authentication;
    private Log log = LogFactory.getLog("EmailSender");
   
    
    public EmailSender(String user, String host, String fromUser, String pwd, boolean debug) {
    	this.from = fromUser;
    	
    	this.authentication = new PasswordAuthentication(user, pwd);
    	Properties props = new Properties();
    	props.put("mail.user", user);
    	
    	props.put("mail.host", host);
    	props.put("mail.debug", debug ? "true" : "false");
    	props.put("mail.store.protocol", "pop3");
    	props.put("mail.transport.protocol", "smtp");
    	this.session = Session.getInstance(props, this);
    }
    
    protected PasswordAuthentication getPasswordAuthentication() {
    	return authentication;
    }
    
    public void sendMessage(String to, String subject, String content)
    throws MessagingException {
        log.info("SENDING message from " + from + " to " + to);
        MimeMessage msg = new MimeMessage(session);
        msg.addRecipients(Message.RecipientType.TO, to);
        msg.setSubject(subject);
        msg.setText(content);
        Transport.send(msg);
    }
    
}
