package clinical.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Constructor;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: PluginManUtils.java 88 2009-08-17 23:02:38Z bozyurt $
 */
public class PluginManUtils {
	
	
	public static List<Class<?>> detectPluginImplClasses(String pluginsPackageName,
			Class<?> pluginInterfaceClazz) {
		ProtectionDomain pd = PluginManUtils.class.getProtectionDomain();
		CodeSource cs = pd.getCodeSource();
		String fileName = cs.getLocation().getFile();
		if (fileName.endsWith(".class")) {
			int idx = fileName.lastIndexOf("classes");
			if (idx != -1) {
				fileName = fileName.substring(0, idx + "classes".length() + 1);
			}
		}
		File packagePath = new File(fileName, pluginsPackageName.replace('.',
				File.separatorChar));
		File[] pluginClassFiles = packagePath.listFiles(new FilenameFilter() {
			public boolean accept(File dir, String name) {
				if (!name.endsWith(".class")) {
					return false;
				}
				if (name.indexOf('$') != -1) {
					return false;
				}
				return true;
			}
		});

		if (pluginClassFiles == null)
			return null;
		
		List<Class<?>> plugins = new ArrayList<Class<?>>(10);
		
		for (int i = 0; i < pluginClassFiles.length; i++) {
			String className = fromPath2FullyQualifiedClassName(
					pluginClassFiles[i].getAbsolutePath(), fileName);

			try {
				Class<?> clazz = Class.forName(className);
				if (pluginInterfaceClazz.isAssignableFrom(clazz)) {
					plugins.add(clazz);
					
				}
			}catch (Exception x) {
				x.printStackTrace();
			}
		}
		return plugins;
		
	}
	

	public static List<Object> detectPlugins(String pluginsPackageName,
			Class<?> pluginInterfaceClazz, Map<String, Object> paramMap) {
		ProtectionDomain pd = PluginManUtils.class.getProtectionDomain();
		CodeSource cs = pd.getCodeSource();
		String fileName = cs.getLocation().getFile();
		if (fileName.endsWith(".class")) {
			int idx = fileName.lastIndexOf("classes");
			if (idx != -1) {
				fileName = fileName.substring(0, idx + "classes".length() + 1);
			}
		}
		File packagePath = new File(fileName, pluginsPackageName.replace('.',
				File.separatorChar));
		File[] pluginClassFiles = packagePath.listFiles(new FilenameFilter() {
			public boolean accept(File dir, String name) {
				if (!name.endsWith(".class")) {
					return false;
				}
				if (name.indexOf('$') != -1) {
					return false;
				}
				return true;
			}
		});

		if (pluginClassFiles == null)
			return null;
		List<Object> plugins = new ArrayList<Object>(10);
		for (int i = 0; i < pluginClassFiles.length; i++) {
			String className = fromPath2FullyQualifiedClassName(
					pluginClassFiles[i].getAbsolutePath(), fileName);

			try {
				Class<?> clazz = Class.forName(className);
				if (pluginInterfaceClazz.isAssignableFrom(clazz)) {
					Constructor<?>[] constructors = clazz.getDeclaredConstructors();
					for (Constructor<?> cons : constructors) {
						Class<?>[] parameterTypes = cons.getParameterTypes();
						if (parameterTypes.length == 0) {
							Object plugin = clazz.newInstance();
							plugins.add(plugin);
						} else if (paramMap != null && parameterTypes.length == 1
								&& Map.class.isAssignableFrom(parameterTypes[0])) {
							Object plugin = cons
									.newInstance(new Object[] { paramMap });
							plugins.add(plugin);
						}
					}					
				}
			} catch (Exception x) {
				x.printStackTrace();
			}
		}
		return plugins;
	}

	public static String fromPath2FullyQualifiedClassName(String path,
			String pathRoot) {
		pathRoot = toPlatformIndependentPath(pathRoot);
		path = toPlatformIndependentPath(path);
		int idx = path.indexOf(pathRoot);
		if (idx != 0) {
			return null;
		}
		String part = path.substring(pathRoot.length());
		part = part.replace('/', '.');
		idx = part.lastIndexOf(".class");
		if (idx != -1) {
			part = part.substring(0, idx);
		}
		return part;
	}

	static String toPlatformIndependentPath(String aPath) {
		aPath = aPath.replace(File.separatorChar, '/');

		if (aPath.startsWith("/") && aPath.indexOf(':') != -1) {
			aPath = aPath.substring(1);
		}
		return aPath;
	}
}
