package clinical.web;

import clinical.server.dao.AnalysisDAO;
import clinical.server.dao.AnalysiscomponentDAO;
import clinical.server.dao.AnalysisflowDAO;
import clinical.server.dao.AnalysisresultDAO;
import clinical.server.dao.ArgumenttypeDAO;
import clinical.server.dao.ConfDatabaseDAO;
import clinical.server.dao.ConfDbuserDAO;
import clinical.server.dao.ConfParamsDAO;
import clinical.server.dao.ConfParamsGroupDAO;
import clinical.server.dao.ConfPrivilegeDAO;
import clinical.server.dao.ConfWebuserDAO;
import clinical.server.dao.ConfWebuserPrivDAO;
import clinical.server.dao.DataarchiveDAO;
import clinical.server.dao.ExecutedtransformflowDAO;
import clinical.server.dao.ExternaldataDAO;
import clinical.server.dao.JobsDAO;
import clinical.server.dao.SiteDAO;
import clinical.server.dao.TokenDAO;
import clinical.server.dao.TransforminputdataDAO;
import clinical.web.common.ISecurityService;
import clinical.web.common.security.DBConfig;
import clinical.web.exception.BaseException;
import clinical.web.services.SimpleSecurityService;

/**
 * Factory class to create appropriate data access objects for the given
 * database ID.
 * 
 * Initialized at the web container startup in <code>ServicesPlugin</code>
 * 
 * @see clinical.web.ServicesPlugin
 * 
 * @author I. Burak Ozyurt
 * @version $Id: DAOFactory.java 873 2015-01-07 20:55:20Z jinranc $
 */
public class DAOFactory {
	private static ISecurityService securityService;

	public synchronized static void initialize() throws BaseException {
		securityService = ServiceFactory.getSecurityService();
	}

	/**
	 * only to be used for integration tests, installation support code which
	 * can needs to work with minimal connection information for bootstrapping
	 * and can not rely on populated database (chicken-egg problem)
	 * 
	 * @throws BaseException
	 */
	public synchronized static void bootstrap() throws BaseException {
		securityService = SimpleSecurityService.getInstance();
	}

	public static clinical.server.dao.AnimalspeciesDAO createAnimalspeciesDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AnimalspeciesDAO();
		} else {
			return new clinical.server.dao.postgres.AnimalspeciesDAO();
		}
	}

	public static clinical.server.dao.AssessmentbooleanDAO createAssessmentbooleanDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentbooleanDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentbooleanDAO();
		}
	}

	public static clinical.server.dao.AssessmentDAO createAssessmentDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentDAO();
		}
	}

	public static clinical.server.dao.AssessmentdataDAO createAssessmentdataDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentdataDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentdataDAO();
		}
	}

	public static clinical.server.dao.AssessmentfloatDAO createAssessmentfloatDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentfloatDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentfloatDAO();
		}
	}

	public static clinical.server.dao.AssessmentinformantDAO createAssessmentinformantDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentinformantDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentinformantDAO();
		}
	}

	public static clinical.server.dao.AssessmentintegerDAO createAssessmentintegerDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentintegerDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentintegerDAO();
		}
	}

	public static clinical.server.dao.AssessmentitemDAO createAssessmentitemDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentitemDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentitemDAO();
		}
	}

	public static clinical.server.dao.AssessmentscorecodeDAO createAssessmentscorecodeDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentscorecodeDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentscorecodeDAO();
		}
	}

	public static clinical.server.dao.AssessmentscoreDAO createAssessmentscoreDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentscoreDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentscoreDAO();
		}
	}

	public static clinical.server.dao.AssessmentstatusDAO createAssessmentstatusDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentstatusDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentstatusDAO();
		}
	}

	public static clinical.server.dao.AssessmenttimestampDAO createAssessmenttimestampDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmenttimestampDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmenttimestampDAO();
		}
	}

	public static clinical.server.dao.AssessmentvarcharDAO createAssessmentvarcharDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AssessmentvarcharDAO();
		} else {
			return new clinical.server.dao.postgres.AssessmentvarcharDAO();
		}
	}

	public static clinical.server.dao.BrainsegmentdataDAO createBrainsegmentdataDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.BrainsegmentdataDAO();
		} else {
			return new clinical.server.dao.postgres.BrainsegmentdataDAO();
		}
	}

	public static clinical.server.dao.CollectionequipmentDAO createCollectionequipmentDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.CollectionequipmentDAO();
		} else {
			return new clinical.server.dao.postgres.CollectionequipmentDAO();
		}
	}

	public static clinical.server.dao.DatabasecolumnDAO createDatabasecolumnDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.DatabasecolumnDAO();
		} else {
			return new clinical.server.dao.postgres.DatabasecolumnDAO();
		}
	}

	public static clinical.server.dao.DatabaseuserDAO createDatabaseuserDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.DatabaseuserDAO();
		} else {
			return new clinical.server.dao.postgres.DatabaseuserDAO();
		}
	}

	public static clinical.server.dao.DataclassificationDAO createDataclassificationDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.DataclassificationDAO();
		} else {
			return new clinical.server.dao.postgres.DataclassificationDAO();
		}
	}

	public static clinical.server.dao.DataobjectDAO createDataobjectDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.DataobjectDAO();
		} else {
			return new clinical.server.dao.postgres.DataobjectDAO();
		}
	}

	public static clinical.server.dao.DataobjecttypeDAO createDataobjecttypeDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.DataobjecttypeDAO();
		} else {
			return new clinical.server.dao.postgres.DataobjecttypeDAO();
		}
	}

	public static clinical.server.dao.DbcolumnunitDAO createDbcolumnunitDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.DbcolumnunitDAO();
		} else {
			return new clinical.server.dao.postgres.DbcolumnunitDAO();
		}
	}

	public static clinical.server.dao.DefTupleAccessDAO createDefTupleAccessDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.DefTupleAccessDAO();
		} else {
			return new clinical.server.dao.postgres.DefTupleAccessDAO();
		}
	}

	public static clinical.server.dao.DeriveddataDAO createDeriveddataDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.DeriveddataDAO();
		} else {
			return new clinical.server.dao.postgres.DeriveddataDAO();
		}
	}

	public static clinical.server.dao.ExecutedtransformDAO createExecutedtransformDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExecutedtransformDAO();
		} else {
			return new clinical.server.dao.postgres.ExecutedtransformDAO();
		}
	}

	public static clinical.server.dao.ExpcomponentDAO createExpcomponentDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExpcomponentDAO();
		} else {
			return new clinical.server.dao.postgres.ExpcomponentDAO();
		}
	}

	public static clinical.server.dao.ExpcomponentViewDAO createExpcomponentViewDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExpcomponentViewDAO();
		} else {
			return new clinical.server.dao.postgres.ExpcomponentViewDAO();
		}
	}

	public static clinical.server.dao.ExpconditionDAO createExpconditionDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExpconditionDAO();
		} else {
			return new clinical.server.dao.postgres.ExpconditionDAO();
		}
	}

	public static clinical.server.dao.ExperimentDAO createExperimentDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExperimentDAO();
		} else {
			return new clinical.server.dao.postgres.ExperimentDAO();
		}
	}

	public static clinical.server.dao.ExpeventDAO createExpeventDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExpeventDAO();
		} else {
			return new clinical.server.dao.postgres.ExpeventDAO();
		}
	}

	public static clinical.server.dao.ExpmanipulationDAO createExpmanipulationDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExpmanipulationDAO();
		} else {
			return new clinical.server.dao.postgres.ExpmanipulationDAO();
		}
	}

	public static clinical.server.dao.ExpsegmentDAO createExpsegmentDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExpsegmentDAO();
		} else {
			return new clinical.server.dao.postgres.ExpsegmentDAO();
		}
	}

	public static clinical.server.dao.ExpstudyDAO createExpstudyDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExpstudyDAO();
		} else {
			return new clinical.server.dao.postgres.ExpstudyDAO();
		}
	}

	public static clinical.server.dao.ExtendedtupleDAO createExtendedtupleDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExtendedtupleDAO();
		} else {
			return new clinical.server.dao.postgres.ExtendedtupleDAO();
		}
	}

	public static clinical.server.dao.HumansubjectDAO createHumansubjectDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.HumansubjectDAO();
		} else {
			return new clinical.server.dao.postgres.HumansubjectDAO();
		}
	}

	public static clinical.server.dao.MachineDAO createMachineDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.MachineDAO();
		} else {
			return new clinical.server.dao.postgres.MachineDAO();
		}
	}

	public static clinical.server.dao.MaskvalidatorDAO createMaskvalidatorDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.MaskvalidatorDAO();
		} else {
			return new clinical.server.dao.postgres.MaskvalidatorDAO();
		}
	}

	public static clinical.server.dao.MeasurementsystemDAO createMeasurementsystemDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.MeasurementsystemDAO();
		} else {
			return new clinical.server.dao.postgres.MeasurementsystemDAO();
		}
	}

	public static clinical.server.dao.MeasurementtypeDAO createMeasurementtypeDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.MeasurementtypeDAO();
		} else {
			return new clinical.server.dao.postgres.MeasurementtypeDAO();
		}
	}

	public static clinical.server.dao.MeasurementunitDAO createMeasurementunitDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.MeasurementunitDAO();
		} else {
			return new clinical.server.dao.postgres.MeasurementunitDAO();
		}
	}

	public static clinical.server.dao.OntologyconceptDAO createOntologyconceptDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.OntologyconceptDAO();
		} else {
			return new clinical.server.dao.postgres.OntologyconceptDAO();
		}
	}

	public static clinical.server.dao.OntologysourceDAO createOntologysourceDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.OntologysourceDAO();
		} else {
			return new clinical.server.dao.postgres.OntologysourceDAO();
		}
	}

	public static clinical.server.dao.PersonDAO createPersonDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.PersonDAO();
		} else {
			return new clinical.server.dao.postgres.PersonDAO();
		}
	}

	public static clinical.server.dao.PrivilegesDAO createPrivilegesDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.PrivilegesDAO();
		} else {
			return new clinical.server.dao.postgres.PrivilegesDAO();
		}
	}

	public static clinical.server.dao.ProtocolDAO createProtocolDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ProtocolDAO();
		} else {
			return new clinical.server.dao.postgres.ProtocolDAO();
		}
	}

	public static clinical.server.dao.ProtocolmanipDAO createProtocolmanipDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ProtocolmanipDAO();
		} else {
			return new clinical.server.dao.postgres.ProtocolmanipDAO();
		}
	}

	public static clinical.server.dao.RangevalidatorDAO createRangevalidatorDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.RangevalidatorDAO();
		} else {
			return new clinical.server.dao.postgres.RangevalidatorDAO();
		}
	}

	public static clinical.server.dao.RawdataDAO createRawdataDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.RawdataDAO();
		} else {
			return new clinical.server.dao.postgres.RawdataDAO();
		}
	}

	//Jinran added for DICOM imaging uploading
	public static clinical.server.dao.ReceivedfilesDAO createReceivedfilesDAO(String dbID){
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ReceivedfilesDAO();
		} else {
			return new clinical.server.dao.postgres.ReceivedfilesDAO();
		}
	}

	//Jinran added for DICOM imaging uploading
	public static clinical.server.dao.ReceivedfilesdcmtagDAO createReceivedfilesdcmtagDAO(String dbID){
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ReceivedfilesdcmtagDAO();
		} else {
			return new clinical.server.dao.postgres.ReceivedfilesdcmtagDAO();
		}
	}
	
	public static clinical.server.dao.ResearchdataDAO createResearchdataDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ResearchdataDAO();
		} else {
			return new clinical.server.dao.postgres.ResearchdataDAO();
		}
	}

	public static clinical.server.dao.ResearchgroupDAO createResearchgroupDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ResearchgroupDAO();
		} else {
			return new clinical.server.dao.postgres.ResearchgroupDAO();
		}
	}

	public static clinical.server.dao.ResearchgrouptypeDAO createResearchgrouptypeDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ResearchgrouptypeDAO();
		} else {
			return new clinical.server.dao.postgres.ResearchgrouptypeDAO();
		}
	}

	public static clinical.server.dao.ResearchsubjectDAO createResearchsubjectDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ResearchsubjectDAO();
		} else {
			return new clinical.server.dao.postgres.ResearchsubjectDAO();
		}
	}

	public static clinical.server.dao.SchemaversionDAO createSchemaversionDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.SchemaversionDAO();
		} else {
			return new clinical.server.dao.postgres.SchemaversionDAO();
		}
	}

	public static clinical.server.dao.ScorevalidationDAO createScorevalidationDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ScorevalidationDAO();
		} else {
			return new clinical.server.dao.postgres.ScorevalidationDAO();
		}
	}

	public static clinical.server.dao.ScorevalidatorDAO createScorevalidatorDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ScorevalidatorDAO();
		} else {
			return new clinical.server.dao.postgres.ScorevalidatorDAO();
		}
	}

	public static clinical.server.dao.SecurityclassificationDAO createSecurityclassificationDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.SecurityclassificationDAO();
		} else {
			return new clinical.server.dao.postgres.SecurityclassificationDAO();
		}
	}

	public static clinical.server.dao.StoredassessmentDAO createStoredassessmentDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.StoredassessmentDAO();
		} else {
			return new clinical.server.dao.postgres.StoredassessmentDAO();
		}
	}

	public static clinical.server.dao.StoredqueryDAO createStoredqueryDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.StoredqueryDAO();
		} else {
			return new clinical.server.dao.postgres.StoredqueryDAO();
		}
	}

	public static clinical.server.dao.StoredtupleDAO createStoredtupleDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.StoredtupleDAO();
		} else {
			return new clinical.server.dao.postgres.StoredtupleDAO();
		}
	}

	public static clinical.server.dao.SubjexperimentDAO createSubjexperimentDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.SubjexperimentDAO();
		} else {
			return new clinical.server.dao.postgres.SubjexperimentDAO();
		}
	}

	public static clinical.server.dao.TableidDAO createTableidDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TableidDAO();
		} else {
			return new clinical.server.dao.postgres.TableidDAO();
		}
	}

	public static clinical.server.dao.TransformationargumentDAO createTransformationargumentDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TransformationargumentDAO();
		} else {
			return new clinical.server.dao.postgres.TransformationargumentDAO();
		}
	}

	public static clinical.server.dao.TransformationDAO createTransformationDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TransformationDAO();
		} else {
			return new clinical.server.dao.postgres.TransformationDAO();
		}
	}

	public static clinical.server.dao.TransformationlibraryDAO createTransformationlibraryDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TransformationlibraryDAO();
		} else {
			return new clinical.server.dao.postgres.TransformationlibraryDAO();
		}
	}

	public static clinical.server.dao.TransformeddataDAO createTransformeddataDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TransformeddataDAO();
		} else {
			return new clinical.server.dao.postgres.TransformeddataDAO();
		}
	}

	public static clinical.server.dao.TupleaccessDAO createTupleaccessDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TupleaccessDAO();
		} else {
			return new clinical.server.dao.postgres.TupleaccessDAO();
		}
	}

	public static clinical.server.dao.TuplebooleanDAO createTuplebooleanDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TuplebooleanDAO();
		} else {
			return new clinical.server.dao.postgres.TuplebooleanDAO();
		}
	}

	public static clinical.server.dao.TupleclassDAO createTupleclassDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TupleclassDAO();
		} else {
			return new clinical.server.dao.postgres.TupleclassDAO();
		}
	}

	public static clinical.server.dao.TuplecolumnsDAO createTuplecolumnsDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TuplecolumnsDAO();
		} else {
			return new clinical.server.dao.postgres.TuplecolumnsDAO();
		}
	}

	public static clinical.server.dao.TupledataDAO createTupledataDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TupledataDAO();
		} else {
			return new clinical.server.dao.postgres.TupledataDAO();
		}
	}

	public static clinical.server.dao.TuplefloatDAO createTuplefloatDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TuplefloatDAO();
		} else {
			return new clinical.server.dao.postgres.TuplefloatDAO();
		}
	}

	public static clinical.server.dao.TupleintegerDAO createTupleintegerDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TupleintegerDAO();
		} else {
			return new clinical.server.dao.postgres.TupleintegerDAO();
		}
	}

	public static clinical.server.dao.TuplesubclassDAO createTuplesubclassDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TuplesubclassDAO();
		} else {
			return new clinical.server.dao.postgres.TuplesubclassDAO();
		}
	}

	public static clinical.server.dao.TupletimestampDAO createTupletimestampDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TupletimestampDAO();
		} else {
			return new clinical.server.dao.postgres.TupletimestampDAO();
		}
	}

	public static clinical.server.dao.TuplevarcharDAO createTuplevarcharDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TuplevarcharDAO();
		} else {
			return new clinical.server.dao.postgres.TuplevarcharDAO();
		}
	}

	public static clinical.server.dao.UpdatelogDAO createUpdatelogDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.UpdatelogDAO();
		} else {
			return new clinical.server.dao.postgres.UpdatelogDAO();
		}
	}

	public static clinical.server.dao.UsedargumentDAO createUsedargumentDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.UsedargumentDAO();
		} else {
			return new clinical.server.dao.postgres.UsedargumentDAO();
		}
	}

	public static clinical.server.dao.UsedlibraryDAO createUsedlibraryDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.UsedlibraryDAO();
		} else {
			return new clinical.server.dao.postgres.UsedlibraryDAO();
		}
	}

	public static clinical.server.dao.UserclassDAO createUserclassDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.UserclassDAO();
		} else {
			return new clinical.server.dao.postgres.UserclassDAO();
		}
	}

	public static clinical.server.dao.UsergroupDAO createUsergroupDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.UsergroupDAO();
		} else {
			return new clinical.server.dao.postgres.UsergroupDAO();
		}
	}

	public static clinical.server.dao.UserPrivilegesDAO createUserPrivilegesDAO(
			String dbID) {
		throw new UnsupportedOperationException();
	}

	public static clinical.server.dao.UserstatusDAO createUserstatusDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.UserstatusDAO();
		} else {
			return new clinical.server.dao.postgres.UserstatusDAO();
		}
	}

	public static clinical.server.dao.ValidationmethodDAO createValidationmethodDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ValidationmethodDAO();
		} else {
			return new clinical.server.dao.postgres.ValidationmethodDAO();
		}
	}

	public static clinical.server.dao.VisittypeDAO createVisittypeDAO(
			String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.VisittypeDAO();
		} else {
			return new clinical.server.dao.postgres.VisittypeDAO();
		}
	}

	public static JobsDAO createJobsDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.JobsDAO();
		} else {
			return new clinical.server.dao.postgres.JobsDAO();
		}
	}

	public static DataarchiveDAO createDataarchiveDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.DataarchiveDAO();
		} else {
			return new clinical.server.dao.postgres.DataarchiveDAO();
		}
	}

	public static ConfPrivilegeDAO createConfPrivilegeDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ConfPrivilegeDAO();
		} else {
			return new clinical.server.dao.postgres.ConfPrivilegeDAO();
		}
	}

	public static ConfDatabaseDAO createConfDatabaseDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ConfDatabaseDAO();
		} else {
			return new clinical.server.dao.postgres.ConfDatabaseDAO();
		}
	}

	public static ConfDbuserDAO createConfDBuserDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ConfDbuserDAO();
		} else {
			return new clinical.server.dao.postgres.ConfDbuserDAO();
		}
	}

	public static ConfWebuserDAO createConfWebuserDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ConfWebuserDAO();
		} else {
			return new clinical.server.dao.postgres.ConfWebuserDAO();
		}
	}

	public static ConfWebuserPrivDAO createConfWebuserPrivDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ConfWebuserPrivDAO();
		} else {
			return new clinical.server.dao.postgres.ConfWebuserPrivDAO();
		}
	}

	public static ConfParamsGroupDAO createConfParamsGroupDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ConfParamsGroupDAO();
		} else {
			return new clinical.server.dao.postgres.ConfParamsGroupDAO();
		}
	}

	public static ConfParamsDAO createConfParamsDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ConfParamsDAO();
		} else {
			return new clinical.server.dao.postgres.ConfParamsDAO();
		}
	}

	public static SiteDAO createSiteDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.SiteDAO();
		} else {
			return new clinical.server.dao.postgres.SiteDAO();
		}
	}

	public static AnalysisresultDAO createAnalysisResultDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AnalysisresultDAO();
		} else {
			return new clinical.server.dao.postgres.AnalysisresultDAO();
		}
	}

	public static TokenDAO createTokenDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TokenDAO();
		} else {
			return new clinical.server.dao.postgres.TokenDAO();
		}
	}

	public static AnalysisDAO createAnalysisDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AnalysisDAO();
		} else {
		    return new clinical.server.dao.postgres.AnalysisDAO();
		}
	}

	public static ArgumenttypeDAO createArgumenttypeDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ArgumenttypeDAO();
		} else {
			return new clinical.server.dao.postgres.ArgumenttypeDAO();
		}
	}

	public static AnalysiscomponentDAO createAnalysiscomponentDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AnalysiscomponentDAO();
		} else {
			return new clinical.server.dao.postgres.AnalysiscomponentDAO();			
		}
	}

	public static TransforminputdataDAO createTransforminputData(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.TransforminputdataDAO();
		} else {
			return new clinical.server.dao.postgres.TransforminputdataDAO();
		}		
	}

	public static ExternaldataDAO createExternaldataDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExternaldataDAO();
		} else {
			return new clinical.server.dao.postgres.ExternaldataDAO();
		}
	}

	public static AnalysisflowDAO createAnalysisflowDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.AnalysisflowDAO();
		} else {
		   return new clinical.server.dao.postgres.AnalysisflowDAO();	
		}		
	}
	
	public static ExecutedtransformflowDAO createExecutedtransformflowDAO(String dbID) {
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.ExecutedtransformflowDAO();
		} else {
		   return new clinical.server.dao.postgres.ExecutedtransformflowDAO();	
		}
	}
	
//	//Jinran added for DICOM imaging uploading
//	public static clinical.server.dao.ProtocolDAO createImageProtocolsDAO(String dbID){
//		String dbType = securityService.getDBType(dbID);
//		if (dbType.equals(DBConfig.ORACLE)) {
//			return new clinical.server.dao.oracle.ProtocolDAO();
//		} else {
//			return new clinical.server.dao.postgres.ProtocolDAO();
//		}
//	}
	
	//Jinran added for e-signature
	public static clinical.server.dao.EsignatureDAO createEsignatureDAO(String dbID){
		String dbType = securityService.getDBType(dbID);
		if (dbType.equals(DBConfig.ORACLE)) {
			return new clinical.server.dao.oracle.EsignatureDAO();
		} else {
			return new clinical.server.dao.postgres.EsignatureDAO();
		}
	}

}
