package clinical.web;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;

import org.apache.struts.util.LabelValueBean;
import org.json.JSONArray;
import org.json.JSONException;

public class GeneticObjs {
	private Collection<GeneticSession> ssList;
	private BigDecimal selectedSS;
	private String selSessionName;
	
	private Collection<GeneticChip> geneChip;
	private BigDecimal selectedGeneChipId;
	private String selChipName;
	
	private Collection<LabelValueBean> uniqueGenomeRelease;
	private int selectedGenomeBuildId;
	private String selGenomeRel;
	
	private Collection<SnpList> snpListCols;
	private BigDecimal selectedSNPListId;	
	private String selSnpListName;
	private String selSnpListValue;
	
	private Collection<SnpList> allSnpListCols;
	private BigDecimal selectedAllSNPListId;	
	private String selAllSnpListName;
	private String selAllSnpListValue;
	
	private Collection<GeneticSession> snpSessionList;
	private BigDecimal selectedSnpSession;	
	private String selSnpSessionName;	
	
	private Collection<GeneList> allGeneListCols;
	private BigDecimal selectedAllGeneListId;	
	private String selAllGeneListName;
	private String selAllGeneListValue;
	
	private Collection<GeneList> geneListCols;
	private BigDecimal selectedGeneListId;	
	private String selGeneListName;
	private String selGeneListValue;

	private Collection<GeneticSession> geneSessionList;  // parameter for session drpdown in manage Gene List part.
	private BigDecimal selectedGeneSession;	
	private String selGeneSessionName;	
	
	private boolean chrom[];
	private String refSequence;
	private double gcScore;
	private String strPosition;
	
	public GeneticObjs(){
		this.ssList = new ArrayList<GeneticSession>();
		this.geneChip = new ArrayList<GeneticChip>();		
	}
	
	public GeneticObjs(String chipName, String genomeRelease, String refSeq, double gcScore, String sPosition){
		this.selChipName = chipName;
		this.selGenomeRel = genomeRelease;
		this.refSequence = refSeq;
		this.gcScore = gcScore;
		this.strPosition = sPosition;
	}
	
	public void setSsList(Collection<GeneticSession> ssList) {
		this.ssList = ssList;
	}

	public Collection<GeneticSession> getSsList() {
		return ssList;
	}

	public void setGeneChip(Collection<GeneticChip> geneChip) {
		this.geneChip = geneChip;
	}


	public Collection<GeneticChip> getGeneChip() {
		return geneChip;
	}

	public void setSelectedGenomeBuildId(int selectedGenomeBuildId) {
		this.selectedGenomeBuildId = selectedGenomeBuildId;
	}


	public int getSelectedGenomeBuildId() {
		return selectedGenomeBuildId;
	}


	public void setUniqueGenomeRelease(Collection<LabelValueBean> uniqueGenomeRelease) {
		this.uniqueGenomeRelease = uniqueGenomeRelease;
	}


	public Collection<LabelValueBean> getUniqueGenomeRelease() {
		return uniqueGenomeRelease;
	}


	public void setSelectedGeneChipId(BigDecimal selectedGeneChipId) {
		this.selectedGeneChipId = selectedGeneChipId;
	}


	public BigDecimal getSelectedGeneChipId() {
		return selectedGeneChipId;
	}

	public void setSelectedSS(BigDecimal selectedSS) {
		this.selectedSS = selectedSS;
	}

	public BigDecimal getSelectedSS() {
		return selectedSS;
	}

	public String getGeneSessionNamesJSONStr() {
		try {
			JSONArray jsArr = new JSONArray();
			for(GeneticSession gs : ssList){
				jsArr.put(gs.getSessionName());
			}
			return jsArr.toString(2);
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return "[]";
	}

	public void setSnpSessionList(Collection<GeneticSession> snpSessionList) {
		this.snpSessionList = snpSessionList;
	}

	public Collection<GeneticSession> getSnpSessionList() {
		return snpSessionList;
	}

	public void setSelectedSnpSession(BigDecimal selectedSnpSession) {
		this.selectedSnpSession = selectedSnpSession;
	}

	public BigDecimal getSelectedSnpSession() {
		return selectedSnpSession;
	}

	public void setChrom(boolean chrom[]) {
		this.chrom = chrom;
	}

	public boolean[] getChrom() {
		return chrom;
	}

	public void setRefSequence(String refSequence) {
		this.refSequence = refSequence;
	}

	public String getRefSequence() {
		return refSequence;
	}

	public void setGcScore(double gcScore) {
		this.gcScore = gcScore;
	}

	public double getGcScore() {
		return gcScore;
	}

	public void setStrPosition(String strPosition) {
		this.strPosition = strPosition;
	}

	public String getStrPosition() {
		return strPosition;
	}

	public void setSelChipName(String selChipName) {
		this.selChipName = selChipName;
	}

	public String getSelChipName() {
		if(this.geneChip!=null){
			for(GeneticChip gc : this.geneChip){
				if(gc.getChipId().equals(this.selectedGeneChipId)){
					selChipName = gc.getChipName();
				}
			}			
		}
		
		return selChipName;
	}

	public void setSelGenomeRel(String selGenomeRel) {
		this.selGenomeRel = selGenomeRel;
	}

	public String getSelGenomeRel() {
		if(this.uniqueGenomeRelease!=null){
			for(LabelValueBean lvb : this.uniqueGenomeRelease){
				if(Integer.valueOf(lvb.getValue()) == selectedGenomeBuildId){
					selGenomeRel =  lvb.getLabel();
				}
			}	
		}
		
		return selGenomeRel;
	}

	public void setSelSessionName(String selSessionName) {
		this.selSessionName = selSessionName;
	}

	public String getSelSessionName() {
		if(this.ssList!=null){
			for(GeneticSession gs : this.ssList){
				if(gs.getSessionId().equals(this.selectedSS)){
					selSessionName = gs.getSessionName();
				}
			}			
		}
		
		return selSessionName;
	}

	public void setSelSnpSessionName(String selSnpSessionName) {
		this.selSnpSessionName = selSnpSessionName;
	}

	public String getSelSnpSessionName() {
		if(this.snpSessionList!=null){
			for(GeneticSession gs : this.snpSessionList){
				if(gs.getSessionId().equals(this.selectedSnpSession)){
					selSnpSessionName = gs.getSessionName();
				}
			}	
		}
		
		return selSnpSessionName;
	}

	public void setSelSnpListName(String selSnpListName) {
		this.selSnpListName = selSnpListName;
	}

	public String getSelSnpListName() {
		if(this.snpListCols!=null){
			for(SnpList sl : this.snpListCols){
				if(sl.getUniqueId().equals(this.selectedSNPListId)){
					selSnpListName = sl.getName();
				}
			}			
		}
		
		return selSnpListName;
	}

	public void setSnpListCols(Collection<SnpList> snpListCols) {
		this.snpListCols = snpListCols;
	}

	public Collection<SnpList> getSnpListCols() {
		return snpListCols;
	}

	public void setSelectedSNPListId(BigDecimal selectedSNPListId) {
		this.selectedSNPListId = selectedSNPListId;
	}

	public BigDecimal getSelectedSNPListId() {
		return selectedSNPListId;
	}

	public void setSelSnpListValue(String selSnpListValue) {
		this.selSnpListValue = selSnpListValue;
	}

	public String getSelSnpListValue() {
		if(this.snpListCols!=null){
			for(SnpList sl : this.snpListCols){
				if(sl.getUniqueId().equals(this.selectedSNPListId)){
					selSnpListValue = sl.getList();
				}
			}	
		}
		
		return selSnpListValue;
	}

	public void setGeneListCols(Collection<GeneList> geneListCols) {
		this.geneListCols = geneListCols;
	}

	public Collection<GeneList> getGeneListCols() {
		return geneListCols;
	}

	public void setSelectedGeneListId(BigDecimal selectedGeneListId) {
		this.selectedGeneListId = selectedGeneListId;
	}

	public BigDecimal getSelectedGeneListId() {
		return selectedGeneListId;
	}

	public void setSelGeneListName(String selGeneListName) {
		this.selGeneListName = selGeneListName;
	}

	public String getSelGeneListName() {
		if(this.geneListCols!=null){
			for(GeneList gl : this.getGeneListCols()){
				if(gl.getUniqueId().equals(this.selectedGeneListId)){
					selGeneListName = gl.getName();
				}
			}	
		}
		
		return selGeneListName;
	}

	public void setSelGeneListValue(String selGeneListValue) {
		this.selGeneListValue = selGeneListValue;
	}

	public String getSelGeneListValue() {
		if(this.geneListCols!=null){
			for(GeneList gl : this.getGeneListCols()){
				if(gl.getUniqueId().equals(this.selectedGeneListId)){
					selGeneListValue = gl.getList();
				}
			}	
		}
		
		return selGeneListValue;
	}

	public void setGeneSessionList(Collection<GeneticSession> geneSessionList) {
		this.geneSessionList = geneSessionList;
	}

	public Collection<GeneticSession> getGeneSessionList() {
		return geneSessionList;
	}

	public void setSelectedGeneSession(BigDecimal selectedGeneSession) {
		this.selectedGeneSession = selectedGeneSession;
	}

	public BigDecimal getSelectedGeneSession() {
		return selectedGeneSession;
	}

	public void setSelGeneSessionName(String selGeneSessionName) {
		this.selGeneSessionName = selGeneSessionName;
	}

	public String getSelGeneSessionName() {				
		if(this.geneSessionList!=null){
			for(GeneticSession gs : this.geneSessionList){
				if(gs.getSessionId().equals(this.selectedGeneSession)){
					selGeneSessionName = gs.getSessionName();
				}
			}	
		}
		
		return selGeneSessionName;
	}

	public void setAllSnpListCols(Collection<SnpList> allSnpListCols) {
		this.allSnpListCols = allSnpListCols;
	}

	public Collection<SnpList> getAllSnpListCols() {
		return allSnpListCols;
	}

	public void setSelectedAllSNPListId(BigDecimal selectedAllSNPListId) {
		this.selectedAllSNPListId = selectedAllSNPListId;
	}

	public BigDecimal getSelectedAllSNPListId() {
		return selectedAllSNPListId;
	}

	public void setSelAllSnpListName(String selAllSnpListName) {
		this.selAllSnpListName = selAllSnpListName;
	}

	public String getSelAllSnpListName() {		
		if(this.allSnpListCols!=null){
			for(SnpList sl : this.allSnpListCols){
				if(sl.getUniqueId().equals(this.selectedAllSNPListId)){
					selAllSnpListName = sl.getName();
				}
			}			
		}		
		return selAllSnpListName;
	}

	public void setSelAllSnpListValue(String selAllSnpListValue) {
		this.selAllSnpListValue = selAllSnpListValue;
	}

	public String getSelAllSnpListValue() {
		if(this.allSnpListCols!=null){
			for(SnpList sl : this.allSnpListCols){
				if(sl.getUniqueId().equals(this.selectedAllSNPListId)){
					selAllSnpListValue = sl.getList();
				}
			}	
		}		
		return selAllSnpListValue;
	}

	public void setAllGeneListCols(Collection<GeneList> allGeneListCols) {
		this.allGeneListCols = allGeneListCols;
	}

	public Collection<GeneList> getAllGeneListCols() {
		return allGeneListCols;
	}

	public void setSelectedAllGeneListId(BigDecimal selectedAllGeneListId) {
		this.selectedAllGeneListId = selectedAllGeneListId;
	}

	public BigDecimal getSelectedAllGeneListId() {
		return selectedAllGeneListId;
	}

	public void setSelAllGeneListName(String selAllGeneListName) {
		this.selAllGeneListName = selAllGeneListName;
	}

	public String getSelAllGeneListName() {		
		if(this.allGeneListCols!=null){
			for(GeneList gl : this.getAllGeneListCols()){
				if(gl.getUniqueId().equals(this.selectedAllGeneListId)){
					selAllGeneListName = gl.getName();
				}
			}	
		}		
		return selAllGeneListName;
	}

	public void setSelAllGeneListValue(String selAllGeneListValue) {
		this.selAllGeneListValue = selAllGeneListValue;
	}

	public String getSelAllGeneListValue() {		
		if(this.allGeneListCols!=null){
			for(GeneList gl : this.getAllGeneListCols()){
				if(gl.getUniqueId().equals(this.selectedAllGeneListId)){
					selAllGeneListValue = gl.getList();
				}
			}	
		}		
		return selAllGeneListValue;
	}



}
