package clinical.web.actions;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import clinical.utils.Assertion;
import clinical.web.Constants;
import clinical.web.IAssessmentService;
import clinical.web.ServiceFactory;
import clinical.web.common.UserInfo;
import clinical.web.common.vo.AssessmentSelectionInfo;
import clinical.web.forms.AsQueryBuilderForm;
import clinical.web.forms.BatchQueryForm;
import clinical.web.helpers.BatchQueryHelper;
import clinical.web.scheduler.IJob;
import clinical.web.scheduler.JobException;
import clinical.web.scheduler.JobScheduler;
import clinical.web.services.BatchQueryResult;
import clinical.web.vo.QuerySummary;
import clinical.web.vo.SubjectAsScoreValueSummary;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: BatchQueryAction.java 873 2015-01-07 20:55:20Z jinranc $
 */
public class BatchQueryAction extends BaseLookupDispatchAction {
	protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(BatchQueryAction.class);

	public BatchQueryAction() {
		super();
	}

	protected Map<String, String> getKeyMethodMap() {
		map.put("button.batch.query", "doBatchQuery");
		return map;
	}

	public ActionForward doBatchQuery(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {
		IAssessmentService asService = null;
		try {
			log.info("in doBatchQuery");
			UserInfo ui = getUserInfo(request);
			BatchQueryForm bqForm = (BatchQueryForm) form;
			List<AssessmentSelectionInfo> bqAsiList = bqForm.getAsiList();
			List<AssessmentSelectionInfo> asiList = new ArrayList<AssessmentSelectionInfo>(
					10);
			for (AssessmentSelectionInfo asi : bqAsiList) {
				if (asi.isSelected()) {
					asiList.add(asi);
				}
			}
			
			//Jinran added
			String longFormat = bqForm.getLongFormat();
			String strValidated = bqForm.getIsValidated();

			HttpSession session = request.getSession(false);
			String dbID = (String) session
					.getAttribute(Constants.SESSION_DBID_KEY);

			asService = ServiceFactory.getAssessmentService(dbID);

			AsQueryBuilderForm queryForm = (AsQueryBuilderForm) session
					.getAttribute(Constants.ASQUERYFORM_KEY);
			List<QuerySummary> qsList = queryForm.getQsList();

			Assertion.assertNotNull(qsList);

			String id = String.valueOf(System.currentTimeMillis());
			File file = JobScheduler.getInstance().getResultsFileForJob(
					ui.getName(), id);

			AsBatchQueryJob job = new AsBatchQueryJob(id, ui, qsList,
					asiList, asService, bqForm.getQueryReminder(), file
							.getAbsolutePath(), dbID, longFormat, strValidated); //Jinran mod, added longFormat argument

			JobScheduler scheduler = JobScheduler.getInstance();
			scheduler.addJob(job);

			if(!bqForm.isBatchQueryAll()){
				return mapping.findForward(Constants.SUCCESS);
			}else
			{
				return mapping.findForward("results");
			}
		} catch (Exception x) {
			return processExceptions(request, response, mapping, form, x);
		}
	}

	public static class AsBatchQueryJob implements IJob {
		protected String id;
		protected UserInfo ui;
		protected List<QuerySummary> qsList;
		protected List<AssessmentSelectionInfo> asiList;
		protected IAssessmentService asService;
		protected BatchQueryResult bqr;
		protected String description;
		protected String resultsFile;
		protected boolean canceled = false;
		protected String dbID;
		protected String longFormat; //Jinran added
		protected String isValidated;

		public AsBatchQueryJob(String id, UserInfo ui,
				List<QuerySummary> qsList,
				List<AssessmentSelectionInfo> asiList,
				IAssessmentService asService, String description,
				String resultsFile, String dbID, String longFormat) {
			super();
			this.id = id;
			this.ui = ui;
			this.qsList = qsList;
			this.asiList = asiList;
			this.asService = asService;
			this.description = description;
			this.resultsFile = resultsFile;
			this.dbID = dbID;
			this.longFormat=longFormat; //Jinran added
		}
		
		public AsBatchQueryJob(String id, UserInfo ui,
				List<QuerySummary> qsList,
				List<AssessmentSelectionInfo> asiList,
				IAssessmentService asService, String description,
				String resultsFile, String dbID, String longFormat, String sValidated) {
			super();
			this.id = id;
			this.ui = ui;
			this.qsList = qsList;
			this.asiList = asiList;
			this.asService = asService;
			this.description = description;
			this.resultsFile = resultsFile;
			this.dbID = dbID;
			this.longFormat=longFormat; //Jinran added
			this.isValidated=sValidated; //Jinran added
		}

		protected void doBatchQuery() throws Exception {
			this.bqr = asService.doBatchQuery(ui, qsList, asiList, isValidated);
			this.qsList = null;
		}

		public String getID() {
			return id;
		}

		public String getUser() {
			return ui.getPerceivedName();
		}

		public void execute() throws JobException {
			try {
				doBatchQuery();
			} catch (Exception e) {
				throw new JobException(e);
			}
			if (isCanceled()) {
				// TODO cleanup
			}
		}

		public void saveResults(File file) throws JobException {
			try {
				BatchQueryHelper.prepareCSVFile(file, bqr, longFormat);
			} catch (Exception e) {
				e.printStackTrace();
				throw new JobException(e);
			}
		}

		public void dumpResults() {
			if (bqr == null) {
				return;
			}
			for (SubjectAsScoreValueSummary sasvs : bqr.getCombinedList()) {
				System.out.println(sasvs.toString());
			}
		}

		public synchronized void cancel() {
			canceled = true;
		}

		public synchronized boolean isCanceled() {
			return canceled;
		}

		public String getDbID() {
			return dbID;
		}

		public UserInfo getUserInfo() {
			return ui;
		}

		public String[] getResultsFiles() {
			return new String[] { resultsFile };
		}

		public String getType() {
			return "Batch Query";
		}

		public String getDescription() {
			return description;
		}

		@Override
		public String getFileType() {
			return null;
		}
	}
}
