package clinical.web.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;

import clinical.web.forms.FileUploadForm;

/**
 *
 * @author info@tutorials4u.net
 */
public class FileUploadAction extends BaseLookupDispatchAction {

    /* forward name="success" path="" */
    private final static String SUCCESS = "success";
    
    protected Map<String, String> map = new HashMap<String, String>(7);
	private Log log = LogFactory.getLog(ProcessFileAction.class);

	protected Map<String, String> getKeyMethodMap() {
		map.put("action.pef.show", "show");
		return map;
	}

    public ActionForward show(ActionMapping mapping, ActionForm form,
            HttpServletRequest request, HttpServletResponse response)
            throws Exception {
        FileUploadForm uploadForm = (FileUploadForm) form;
        FileOutputStream outputStream = null;
        FormFile formFile = null;
        try {
            formFile = uploadForm.getFile();
            String path = getServlet().getServletContext().getRealPath("")+"/"+ formFile.getFileName();
            outputStream = new FileOutputStream(new File(path));
            outputStream.write(formFile.getFileData());
        } finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        uploadForm.setMessage("The file "+formFile.getFileName()+" is uploaded successfully.");

        return mapping.findForward(SUCCESS);
    }
}
