package clinical.web.common.query;

import java.io.Serializable;


/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: BinaryOperator.java 91 2009-08-17 23:38:26Z bozyurt $
 */

public class BinaryOperator extends Operator implements Serializable {
	private static final long serialVersionUID = -7286617996166130012L;
	private Operator lhs;
	private Operator rhs;

	public BinaryOperator() {
	}

	public BinaryOperator(Operator lhs, Operator rhs, int logicalOp) {
		this.lhs = lhs;
		this.rhs = rhs;
		this.logicalOp = logicalOp;
	}

	public boolean isEmpty() {
		if (lhs == null && rhs == null)
			return true;
		if (lhs != null && lhs.isEmpty())
			return true;
		if (rhs != null && rhs.isEmpty())
			return true;
		return false;
	}

	public void accept(ISearchCriteriaVisitor visitor) throws Exception {
		visitor.visit(this);
	}

	// ---------------------- setters --------------
	public void setLhs(Operator newLhs) {
		this.lhs = newLhs;
	}

	public void setRhs(Operator newRhs) {
		this.rhs = newRhs;
	}

	// ---------------------- getters --------------
	public Operator getLhs() {
		return this.lhs;
	}

	public Operator getRhs() {
		return this.rhs;
	}

	public boolean isComposite() {
		return true;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("BinaryOperator::[");
		sb.append("lhs:").append(lhs.toString());
		sb.append("\nlogicalOp=").append(logicalOp);
		sb.append("\nrhs=").append(rhs.toString());
		sb.append(']');
		return sb.toString();
	}
}
